/*!
 * jodit - Jodit is an awesome and useful wysiwyg editor with filebrowser
 * Author: Chupurnov <chupurnov@gmail.com> (https://xdsoft.net/jodit/)
 * Version: v4.7.9
 * Url: https://xdsoft.net/jodit/
 * License(s): MIT
 */
	
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("{}"));
	else if(typeof define === 'function' && define.amd)
		define(["{}"], factory);
	else {
		var a = typeof exports === 'object' ? factory(require("{}")) : factory(root["{}"]);
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(self, function(__WEBPACK_EXTERNAL_MODULE__41324__) {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 421:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getClassName: function() { return /* binding */ getClassName; },
/* harmony export */   keepNames: function() { return /* binding */ keepNames; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91565);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 
const keepNames = new Map();
const getClassName = (obj)=>{
    var _obj_constructor;
    if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__.isFunction)(obj.className)) {
        return obj.className();
    }
    const constructor = ((_obj_constructor = obj.constructor) === null || _obj_constructor === void 0 ? void 0 : _obj_constructor.originalConstructor) || obj.constructor;
    if (keepNames.has(constructor)) {
        return keepNames.get(constructor);
    }
    if (constructor.name) {
        return constructor.name;
    }
    const regex = new RegExp(/^\s*function\s*(\S*)\s*\(/);
    const res = constructor.toString().match(regex);
    return res ? res[1] : '';
};


/***/ }),

/***/ 442:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    symbols: 'Símbolo'
};


/***/ }),

/***/ 466:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _img__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(75711);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/inline-popup
 */ 
/* harmony default export */ __webpack_exports__["default"] = ([
    {
        name: 'bin',
        tooltip: 'Delete',
        exec: (editor, image)=>{
            image && editor.s.removeNode(image);
        }
    },
    _img__WEBPACK_IMPORTED_MODULE_0__.align
]);


/***/ }),

/***/ 670:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   openImagePopup: function() { return /* binding */ openImagePopup; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17312);
/* harmony import */ var jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(23599);
/* harmony import */ var jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(51116);
/* harmony import */ var jodit_modules_widget_file_selector_file_selector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(18762);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 




/** @private */ function openImagePopup(j, dialog, state, button) {
    const popup = new jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_3__.Popup(dialog);
    const closePopup = ()=>{
        popup.close();
        popup.destruct();
    };
    popup.setContent((0,jodit_modules_widget_file_selector_file_selector__WEBPACK_IMPORTED_MODULE_4__.FileSelectorWidget)(j, {
        upload: (data)=>{
            if (data.files && data.files.length) {
                state.values.imageSrc = data.baseurl + data.files[0];
            }
            closePopup();
        },
        filebrowser: (data)=>(0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
                if (data && (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__.isArray)(data.files) && data.files.length) {
                    state.values.imageSrc = data.files[0];
                    closePopup();
                }
            })()
    }, state.image, closePopup)).open(()=>(0,jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_2__.position)(button));
}


/***/ }),

/***/ 928:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M621 1280h595v-595zm-45-45l595-595h-595v595zm1152 77v192q0 14-9 23t-23 9h-224v224q0 14-9 23t-23 9h-192q-14 0-23-9t-9-23v-224h-864q-14 0-23-9t-9-23v-864h-224q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h224v-224q0-14 9-23t23-9h192q14 0 23 9t9 23v224h851l246-247q10-9 23-9t23 9q9 10 9 23t-9 23l-247 246v851h224q14 0 23 9t9 23z\"/> </svg>"

/***/ }),

/***/ 1080:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LazyWalker: function() { return /* binding */ LazyWalker; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_event_emitter_eventify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(60216);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module dom
 */ 




class LazyWalker extends jodit_core_event_emitter_eventify__WEBPACK_IMPORTED_MODULE_4__.Eventify {
    setWork(root) {
        if (this.isWorked) {
            this.break();
        }
        this.workNodes = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.eachGen(root, !this.options.reverse);
        this.isFinished = false;
        this._requestStarting();
        return this;
    }
    _requestStarting() {
        this.__schedulerController = new AbortController();
        this.async.schedulerPostTask(this.__workPerform, {
            delay: this.options.timeout,
            signal: this.__schedulerController.signal
        }).catch(()=>null);
    }
    break(reason) {
        if (this.isWorked) {
            this.stop();
            this.emit('break', reason);
        }
    }
    end() {
        if (this.isWorked) {
            this.stop();
            this.emit('end', this.hadAffect);
            this.hadAffect = false;
        }
    }
    stop() {
        this.isWorked = false;
        this.isFinished = true;
        this.workNodes = null;
        this.async.cancelIdleCallback(this.idleId);
    }
    destruct() {
        super.destruct();
        this.stop();
    }
    __workPerform() {
        if (this.workNodes) {
            this.isWorked = true;
            let count = 0;
            var _this_options_timeoutChunkSize;
            const chunkSize = (_this_options_timeoutChunkSize = this.options.timeoutChunkSize) !== null && _this_options_timeoutChunkSize !== void 0 ? _this_options_timeoutChunkSize : 50;
            while(!this.isFinished && count <= chunkSize){
                const item = this.workNodes.next();
                count += 1;
                if (this.visitNode(item.value)) {
                    this.hadAffect = true;
                }
                if (item.done) {
                    this.end();
                    return;
                }
            }
        } else {
            this.end();
        }
        if (!this.isFinished) {
            this._requestStarting();
        }
    }
    visitNode(nodeElm) {
        if (!nodeElm || this.options.whatToShow !== undefined && nodeElm.nodeType !== this.options.whatToShow) {
            return false;
        }
        var _this_emit;
        return (_this_emit = this.emit('visit', nodeElm)) !== null && _this_emit !== void 0 ? _this_emit : false;
    }
    constructor(async, options = {}){
        super(), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "async", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "options", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "workNodes", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "hadAffect", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "isWorked", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "isFinished", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "idleId", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__schedulerController", void 0), this.async = async, this.options = options, this.workNodes = null, this.hadAffect = false, this.isWorked = false, this.isFinished = false, this.idleId = 0, this.__schedulerController = null;
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], LazyWalker.prototype, "__workPerform", null);


/***/ }),

/***/ 1277:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cleanFromWord: function() { return /* binding */ cleanFromWord; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88475);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4040);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/html
 */ 



/**
 * The method automatically cleans up content from Microsoft Word and other HTML sources to ensure clean, compliant
 * content that matches the look and feel of the site.
 */ function cleanFromWord(html) {
    if (html.indexOf('<html ') !== -1) {
        html = html.substring(html.indexOf('<html '), html.length);
        html = html.substring(0, html.lastIndexOf('</html>') + '</html>'.length);
    }
    let convertedString = '';
    try {
        const div = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('div');
        div.innerHTML = html;
        const marks = [];
        if (div.firstChild) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.each(div, (node)=>{
                if (!node) {
                    return;
                }
                switch(node.nodeType){
                    case Node.ELEMENT_NODE:
                        switch(node.nodeName){
                            case 'STYLE':
                            case 'LINK':
                            case 'META':
                                marks.push(node);
                                break;
                            case 'W:SDT':
                            case 'W:SDTPR':
                            case 'FONT':
                                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.unwrap(node);
                                break;
                            default:
                                (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_2__.toArray)(node.attributes).forEach((attr)=>{
                                    if ([
                                        'src',
                                        'href',
                                        'rel',
                                        'content'
                                    ].indexOf(attr.name.toLowerCase()) === -1) {
                                        node.removeAttribute(attr.name);
                                    }
                                });
                        }
                        break;
                    case Node.TEXT_NODE:
                        break;
                    default:
                        marks.push(node);
                }
            });
        }
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove.apply(null, marks);
        convertedString = div.innerHTML;
    } catch (e) {}
    if (convertedString) {
        html = convertedString;
    }
    html = html.split(/(\n)/).filter(jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__.trim).join('\n');
    return html.replace(/<(\/)?(html|colgroup|col|o:p)[^>]*>/g, '').replace(/<!--[^>]*>/g, '');
}


/***/ }),

/***/ 1305:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   deleteFile: function() { return /* binding */ deleteFile; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ /**
 * Removes a file from the server
 * @private
 */ function deleteFile(fb, name, source) {
    return fb.dataProvider.fileRemove(fb.state.currentPath, name, source).then((message)=>{
        fb.status(message || fb.i18n('File "%s" was deleted', name), true);
    }).catch(fb.status);
}


/***/ }),

/***/ 1488:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   loadItems: function() { return /* binding */ loadItems; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ /**
 * Loads a list of files and adds them to the state
 * @private
 */ function loadItems(fb) {
    fb.files.setMod('active', true);
    fb.files.setMod('loading', true);
    return fb.dataProvider.items(fb.state.currentPath, fb.state.currentSource, {
        sortBy: fb.state.sortBy,
        onlyImages: fb.state.onlyImages,
        filterWord: fb.state.filterWord
    }).then((resp)=>{
        if (resp) {
            fb.state.elements = resp;
            fb.state.activeElements = [];
        }
    }).catch(fb.status).finally(()=>fb.files.setMod('loading', false));
}


/***/ }),

/***/ 1496:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EventEmitter: function() { return /* reexport safe */ _event_emitter__WEBPACK_IMPORTED_MODULE_0__.EventEmitter; },
/* harmony export */   EventHandlersStore: function() { return /* reexport safe */ _store__WEBPACK_IMPORTED_MODULE_3__.EventHandlersStore; },
/* harmony export */   Eventify: function() { return /* reexport safe */ _eventify__WEBPACK_IMPORTED_MODULE_1__.Eventify; },
/* harmony export */   defaultNameSpace: function() { return /* reexport safe */ _store__WEBPACK_IMPORTED_MODULE_3__.defaultNameSpace; },
/* harmony export */   observable: function() { return /* reexport safe */ _observable__WEBPACK_IMPORTED_MODULE_2__.observable; }
/* harmony export */ });
/* harmony import */ var _event_emitter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(93747);
/* harmony import */ var _eventify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60216);
/* harmony import */ var _observable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(70535);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18869);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module event-emitter
 */ 





/***/ }),

/***/ 2222:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ViewWithToolbar: function() { return /* binding */ ViewWithToolbar; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69364);
/* harmony import */ var jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(49574);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(68616);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(45664);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(28723);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(4099);
/* harmony import */ var jodit_core_ui_helpers_buttons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(2496);
/* harmony import */ var jodit_core_view_view__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(35099);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(4274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module view
 */ 













class ViewWithToolbar extends jodit_core_view_view__WEBPACK_IMPORTED_MODULE_11__.View {
    /**
	 * Container for toolbar
	 */ get toolbarContainer() {
        if (!this.o.fullsize && ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_7__.isString)(this.o.toolbar) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_5__.Dom.isHTMLElement(this.o.toolbar))) {
            return (0,jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_8__.resolveElement)(this.o.toolbar, this.o.shadowRoot || this.od);
        }
        this.o.toolbar && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_5__.Dom.appendChildFirst(this.container, this.__defaultToolbarContainer);
        return this.__defaultToolbarContainer;
    }
    /**
	 * Change panel container
	 */ setPanel(element) {
        this.o.toolbar = element;
        this.buildToolbar();
    }
    /**
	 * Helper for appended toolbar in its place
	 */ buildToolbar() {
        var _this_toolbar;
        if (!this.o.toolbar) {
            return;
        }
        const buttons = this.o.buttons ? (0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_6__.splitArray)(this.o.buttons) : [];
        (_this_toolbar = this.toolbar) === null || _this_toolbar === void 0 ? void 0 : _this_toolbar.setRemoveButtons(this.o.removeButtons).build(buttons.concat(this.o.extraButtons || [])).appendTo(this.toolbarContainer);
    }
    getRegisteredButtonGroups() {
        return this.groupToButtons;
    }
    /**
	 * Register button for a group
	 */ registerButton(btn) {
        this.registeredButtons.add(btn);
        var _btn_group;
        const group = (_btn_group = btn.group) !== null && _btn_group !== void 0 ? _btn_group : 'other';
        if (!this.groupToButtons[group]) {
            this.groupToButtons[group] = [];
        }
        if (btn.position != null) {
            this.groupToButtons[group][btn.position] = btn.name;
        } else {
            this.groupToButtons[group].push(btn.name);
        }
        return this;
    }
    /**
	 * Remove button from a group
	 */ unregisterButton(btn) {
        this.registeredButtons.delete(btn);
        var _btn_group;
        const groupName = (_btn_group = btn.group) !== null && _btn_group !== void 0 ? _btn_group : 'other', group = this.groupToButtons[groupName];
        if (group) {
            const index = group.indexOf(btn.name);
            if (index !== -1) {
                group.splice(index, 1);
            }
            if (group.length === 0) {
                delete this.groupToButtons[groupName];
            }
        }
        return this;
    }
    /**
	 * Prepare toolbar items and append buttons in groups
	 */ beforeToolbarBuild(items) {
        if (Object.keys(this.groupToButtons).length) {
            return items.map((item)=>{
                if ((0,jodit_core_ui_helpers_buttons__WEBPACK_IMPORTED_MODULE_10__.isButtonGroup)(item) && item.group && this.groupToButtons[item.group]) {
                    return {
                        group: item.group,
                        buttons: [
                            ...item.buttons,
                            ...this.groupToButtons[item.group]
                        ]
                    };
                }
                return item;
            });
        }
    }
    destruct() {
        if (this.isDestructed) {
            return;
        }
        this.setStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_2__.STATUSES.beforeDestruct);
        this.e.off('beforeToolbarBuild', this.beforeToolbarBuild);
        this.__tooltip.destruct();
        this.toolbar.destruct();
        // @ts-ignore After destruct, we are not responsible for anything
        this.toolbar = undefined;
        super.destruct();
    }
    /** @override **/ constructor(options, isJodit = false){
        super(options, isJodit), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "toolbar", (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_12__.makeCollection)(this)), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__defaultToolbarContainer", this.c.div('jodit-toolbar__box')), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "registeredButtons", new Set()), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "groupToButtons", {}), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "isJodit", false), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__tooltip", new jodit_core_ui__WEBPACK_IMPORTED_MODULE_9__.UITooltip(this));
        this.isJodit = isJodit;
        this.e.on('beforeToolbarBuild', this.beforeToolbarBuild);
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)(':rebuildToolbar')
], ViewWithToolbar.prototype, "buildToolbar", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_3__.autobind
], ViewWithToolbar.prototype, "beforeToolbarBuild", null);


/***/ }),

/***/ 2409:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkRemoveEmptyParent: function() { return /* binding */ checkRemoveEmptyParent; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27795);
/* harmony import */ var _check_join_two_lists__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80951);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/backspace
 */ 


/**
 * Check if the current empty item can be removed
 *
 * @example
 * ```html
 * <p>first stop</p><p>|<br></p>
 * ```
 * result
 * ```html
 * <p>first stop|</p>
 * ```
 *
 * @private
 */ function checkRemoveEmptyParent(jodit, fakeNode, backspace) {
    let found = false;
    const { setCursorBefore, setCursorIn } = jodit.s;
    let prn = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.closest(fakeNode, jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isElement, jodit.editor);
    if (!prn || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isEmpty(prn)) {
        return false;
    }
    const neighbor = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.findNotEmptyNeighbor(fakeNode, backspace, jodit.editor);
    do {
        if (prn && jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isEmpty(prn) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isCell(prn)) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.after(prn, fakeNode);
            const tmp = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.closest(prn, (n)=>jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isElement(n) && n !== prn, jodit.editor);
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(prn);
            found = true;
            prn = tmp;
        } else {
            break;
        }
    }while (prn)
    if (found && (0,_check_join_two_lists__WEBPACK_IMPORTED_MODULE_2__.checkJoinTwoLists)(jodit, fakeNode, backspace)) {
        return true;
    }
    if (neighbor && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(neighbor) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(neighbor, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS)) {
        setCursorIn(neighbor, !backspace);
    } else {
        setCursorBefore(fakeNode);
    }
    return found;
}


/***/ }),

/***/ 2496:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   flatButtonsSet: function() { return /* binding */ flatButtonsSet; },
/* harmony export */   isButtonGroup: function() { return /* binding */ isButtonGroup; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17312);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui
 */ 
/**
 * @private
 */ const isButtonGroup = (item)=>{
    return (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__.isArray)(item.buttons);
};
/**
 * @private
 */ function flatButtonsSet(buttons, jodit) {
    const groups = jodit.getRegisteredButtonGroups();
    return new Set(buttons.reduce((acc, item)=>{
        if (isButtonGroup(item)) {
            var _groups_item_group;
            acc = acc.concat([
                ...item.buttons,
                ...(_groups_item_group = groups[item.group]) !== null && _groups_item_group !== void 0 ? _groups_item_group : []
            ]);
        } else {
            acc.push(item);
        }
        return acc;
    }, []));
}


/***/ }),

/***/ 2602:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UICheckbox: function() { return /* reexport safe */ _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_1__.UICheckbox; },
/* harmony export */   UIFileInput: function() { return /* reexport safe */ _file_file__WEBPACK_IMPORTED_MODULE_2__.UIFileInput; },
/* harmony export */   UIInput: function() { return /* reexport safe */ _input_input__WEBPACK_IMPORTED_MODULE_3__.UIInput; },
/* harmony export */   UISelect: function() { return /* reexport safe */ _select_select__WEBPACK_IMPORTED_MODULE_4__.UISelect; },
/* harmony export */   UITextArea: function() { return /* reexport safe */ _area_area__WEBPACK_IMPORTED_MODULE_0__.UITextArea; }
/* harmony export */ });
/* harmony import */ var _area_area__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(87329);
/* harmony import */ var _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(24641);
/* harmony import */ var _file_file__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75587);
/* harmony import */ var _input_input__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65273);
/* harmony import */ var _select_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(49999);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/form
 */ 






/***/ }),

/***/ 2756:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export selectCells */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(91206);
/* harmony import */ var jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(98803);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(69070);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/select-cells/README.md]]
 * @packageDocumentation
 * @module plugins/select-cells
 */ 









const key = 'table_processor_observer';
const MOUSE_MOVE_LABEL = 'onMoveTableSelectCell';
class selectCells extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_7__.Plugin {
    /**
	 * Shortcut for Jodit.modules.Table
	 */ get __tableModule() {
        return this.j.getInstance(jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_8__.Table, this.j.o);
    }
    afterInit(jodit) {
        if (!jodit.o.tableAllowCellSelection) {
            return;
        }
        jodit.e.on('keydown.select-cells', (event)=>{
            if (event.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.KEY_TAB) {
                this.unselectCells();
            }
        }).on('beforeCommand.select-cells', this.onExecCommand).on('afterCommand.select-cells', this.onAfterCommand)// see `plugins/select.ts`
        .on([
            'clickEditor',
            'mousedownTd',
            'mousedownTh',
            'touchstartTd',
            'touchstartTh'
        ].map((e)=>e + '.select-cells').join(' '), this.onStartSelection)// For `clickEditor` correct working. Because `mousedown` on first cell
        // and mouseup on another cell call `click` only for `TR` element.
        .on('clickTr clickTbody', ()=>{
            const cellsCount = this.__tableModule.getAllSelectedCells().length;
            if (cellsCount) {
                if (cellsCount > 1) {
                    var _this_j_s_sel;
                    (_this_j_s_sel = this.j.s.sel) === null || _this_j_s_sel === void 0 ? void 0 : _this_j_s_sel.removeAllRanges();
                }
                return false;
            }
        });
    }
    /**
	 * Mouse click inside the table
	 */ onStartSelection(cell) {
        if (this.j.o.readonly) {
            return;
        }
        this.unselectCells();
        if (cell === this.j.editor) {
            return;
        }
        const table = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.closest(cell, 'table', this.j.editor);
        if (!cell || !table) {
            return;
        }
        if (!cell.firstChild) {
            cell.appendChild(this.j.createInside.element('br'));
        }
        this.__isSelectionMode = true;
        this.__selectedCell = cell;
        this.__tableModule.addSelection(cell);
        this.j.e.on(table, 'mousemove.select-cells touchmove.select-cells', // Don't use decorator because need clear label on mouseup
        this.j.async.throttle(this.__onMove.bind(this, table), {
            label: MOUSE_MOVE_LABEL,
            timeout: this.j.defaultTimeout / 2
        })).on(table, 'mouseup.select-cells touchend.select-cells', this.__onStopSelection.bind(this, table));
        return false;
    }
    onOutsideClick() {
        this.__selectedCell = null;
        this.__onRemoveSelection();
    }
    onChange() {
        if (!this.j.isLocked && !this.__isSelectionMode) {
            this.__onRemoveSelection();
        }
    }
    /**
	 * Mouse move inside the table
	 */ __onMove(table, e) {
        if (this.j.o.readonly && !this.j.isLocked) {
            return;
        }
        if (this.j.isLockedNotBy(key)) {
            return;
        }
        const node = this.j.ed.elementFromPoint(e.clientX, e.clientY);
        if (!node) {
            return;
        }
        const cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.closest(node, [
            'td',
            'th'
        ], table);
        if (!cell || !this.__selectedCell) {
            return;
        }
        if (cell !== this.__selectedCell) {
            this.j.lock(key);
        }
        this.unselectCells();
        const bound = this.__tableModule.getSelectedBound(table, [
            cell,
            this.__selectedCell
        ]), box = this.__tableModule.formalMatrix(table);
        for(let i = bound[0][0]; i <= bound[1][0]; i += 1){
            for(let j = bound[0][1]; j <= bound[1][1]; j += 1){
                this.__tableModule.addSelection(box[i][j]);
            }
        }
        const cellsCount = this.__tableModule.getAllSelectedCells().length;
        if (cellsCount > 1) {
            var _this_j_s_sel;
            (_this_j_s_sel = this.j.s.sel) === null || _this_j_s_sel === void 0 ? void 0 : _this_j_s_sel.removeAllRanges();
        }
        this.j.e.fire('hidePopup');
        e.stopPropagation();
        // Hack for FireFox for force redraw selection
        (()=>{
            const n = this.j.createInside.fromHTML('<div style="color:rgba(0,0,0,0.01);width:0;height:0">&nbsp;</div>');
            cell.appendChild(n);
            this.j.async.setTimeout(()=>{
                var _n_parentNode;
                (_n_parentNode = n.parentNode) === null || _n_parentNode === void 0 ? void 0 : _n_parentNode.removeChild(n);
            }, this.j.defaultTimeout / 5);
        })();
    }
    /**
	 * On click in outside - remove selection
	 */ __onRemoveSelection(e) {
        var _e_buffer;
        if (!(e === null || e === void 0 ? void 0 : (_e_buffer = e.buffer) === null || _e_buffer === void 0 ? void 0 : _e_buffer.actionTrigger) && !this.__selectedCell && this.__tableModule.getAllSelectedCells().length) {
            this.j.unlock();
            this.unselectCells();
            this.j.e.fire('hidePopup', 'cells');
            return;
        }
        this.__isSelectionMode = false;
        this.__selectedCell = null;
    }
    /**
	 * Stop a selection process
	 */ __onStopSelection(table, e) {
        if (!this.__selectedCell) {
            return;
        }
        this.__isSelectionMode = false;
        this.j.unlock();
        const node = this.j.ed.elementFromPoint(e.clientX, e.clientY);
        if (!node) {
            return;
        }
        const cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.closest(node, [
            'td',
            'th'
        ], table);
        if (!cell) {
            return;
        }
        const ownTable = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.closest(cell, 'table', table);
        if (ownTable && ownTable !== table) {
            return; // Nested tables
        }
        const bound = this.__tableModule.getSelectedBound(table, [
            cell,
            this.__selectedCell
        ]), box = this.__tableModule.formalMatrix(table);
        const max = box[bound[1][0]][bound[1][1]], min = box[bound[0][0]][bound[0][1]];
        this.j.e.fire('showPopup', table, ()=>{
            const minOffset = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.position)(min, this.j), maxOffset = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.position)(max, this.j);
            return {
                left: minOffset.left,
                top: minOffset.top,
                width: maxOffset.left - minOffset.left + maxOffset.width,
                height: maxOffset.top - minOffset.top + maxOffset.height
            };
        }, 'cells');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.$$)('table', this.j.editor).forEach((table)=>{
            this.j.e.off(table, 'mousemove.select-cells touchmove.select-cells mouseup.select-cells touchend.select-cells');
        });
        this.j.async.clearTimeout(MOUSE_MOVE_LABEL);
    }
    /**
	 * Remove selection for all cells
	 */ unselectCells(currentCell) {
        const module = this.__tableModule;
        const cells = module.getAllSelectedCells();
        if (cells.length) {
            cells.forEach((cell)=>{
                if (!currentCell || currentCell !== cell) {
                    module.removeSelection(cell);
                }
            });
        }
    }
    /**
	 * Execute custom commands for table
	 */ onExecCommand(command) {
        if (/table(splitv|splitg|merge|empty|bin|binrow|bincolumn|addcolumn|addrow)/.test(command)) {
            command = command.replace('table', '');
            const cells = this.__tableModule.getAllSelectedCells();
            if (cells.length) {
                const [cell] = cells;
                if (!cell) {
                    return;
                }
                const table = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.closest(cell, 'table', this.j.editor);
                if (!table) {
                    return;
                }
                switch(command){
                    case 'splitv':
                        this.__tableModule.splitVertical(table);
                        break;
                    case 'splitg':
                        this.__tableModule.splitHorizontal(table);
                        break;
                    case 'merge':
                        this.__tableModule.mergeSelected(table);
                        break;
                    case 'empty':
                        cells.forEach((td)=>jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.detach(td));
                        break;
                    case 'bin':
                        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.safeRemove(table);
                        break;
                    case 'binrow':
                        new Set(cells.map((td)=>td.parentNode)).forEach((row)=>{
                            this.__tableModule.removeRow(table, row.rowIndex);
                        });
                        break;
                    case 'bincolumn':
                        {
                            const columnsSet = new Set(), columns = cells.reduce((acc, td)=>{
                                if (!columnsSet.has(td.cellIndex)) {
                                    acc.push(td);
                                    columnsSet.add(td.cellIndex);
                                }
                                return acc;
                            }, []);
                            columns.forEach((td)=>{
                                this.__tableModule.removeColumn(table, td.cellIndex);
                            });
                        }
                        break;
                    case 'addcolumnafter':
                    case 'addcolumnbefore':
                        this.__tableModule.appendColumn(table, cell, command === 'addcolumnafter');
                        break;
                    case 'addrowafter':
                    case 'addrowbefore':
                        this.__tableModule.appendRow(table, cell.parentNode, command === 'addrowafter');
                        break;
                }
            }
            return false;
        }
    }
    /**
	 * Add some align after native command
	 */ onAfterCommand(command) {
        if (/^justify/.test(command)) {
            this.__tableModule.getAllSelectedCells().forEach((elm)=>(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.alignElement)(command, elm));
        }
    }
    /** @override */ beforeDestruct(jodit) {
        this.__onRemoveSelection();
        jodit.e.off('.select-cells');
    }
    constructor(...args){
        super(...args), /**
	 * First selected cell
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__selectedCell", null), /**
	 * User is selecting cells now
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__isSelectionMode", false);
    }
}
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(selectCells, "requires", [
    'select'
]);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], selectCells.prototype, "onStartSelection", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)(':outsideClick')
], selectCells.prototype, "onOutsideClick", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)(':change')
], selectCells.prototype, "onChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], selectCells.prototype, "__onRemoveSelection", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], selectCells.prototype, "__onStopSelection", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], selectCells.prototype, "onExecCommand", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], selectCells.prototype, "onAfterCommand", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_5__.pluginSystem.add('selectCells', selectCells);


/***/ }),

/***/ 2923:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   onTabInsideLi: function() { return /* reexport safe */ _on_tab_inside_li__WEBPACK_IMPORTED_MODULE_0__.onTabInsideLi; }
/* harmony export */ });
/* harmony import */ var _on_tab_inside_li__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8837);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/tab
 */ 


/***/ }),

/***/ 2952:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export hr */
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5266);
/* harmony import */ var _hr_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(89097);
/* harmony import */ var _hr_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_hr_svg__WEBPACK_IMPORTED_MODULE_4__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/hr/README.md]]
 * @packageDocumentation
 * @module plugins/hr
 */ 




jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__.Icon.set('hr', (_hr_svg__WEBPACK_IMPORTED_MODULE_4___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_3__.Config.prototype.controls.hr = {
    command: 'insertHorizontalRule',
    tags: [
        'hr'
    ],
    tooltip: 'Insert Horizontal Line'
};
function hr(editor) {
    editor.registerButton({
        name: 'hr',
        group: 'insert'
    });
    editor.registerCommand('insertHorizontalRule', ()=>{
        const elm = editor.createInside.element('hr');
        editor.s.insertNode(elm, false, false);
        const block = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(elm.parentElement, jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock, editor.editor);
        if (block && jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isEmpty(block) && block !== editor.editor) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(block, elm);
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(block);
        }
        let p = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.next(elm, jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock, editor.editor, false);
        if (!p) {
            p = editor.createInside.element(editor.o.enter);
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(elm, p);
        }
        editor.s.setCursorIn(p);
        return false;
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__.pluginSystem.add('hr', hr);


/***/ }),

/***/ 3050:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   loadExtras: function() { return /* binding */ loadExtras; },
/* harmony export */   loadStyle: function() { return /* binding */ loadStyle; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(74264);
/* harmony import */ var jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(47760);
/* harmony import */ var jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86189);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugin
 */ 




const styles = new Set();
/**
 * @private
 */ function loadStyle(jodit, pluginName) {
    return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
        const url = getFullUrl(jodit, pluginName, false);
        if (styles.has(url)) {
            return;
        }
        styles.add(url);
        return (0,jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_3__.appendStyleAsync)(jodit, url);
    })();
}
/**
 * Call full url to the script or style file
 * @private
 */ function getFullUrl(jodit, name, js) {
    name = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_2__.kebabCase)(name);
    const min = jodit.minified ? '.min' : '';
    return jodit.basePath + 'plugins/' + name + '/' + name + min + '.' + (js ? 'js' : 'css');
}
/**
 * @private
 */ function loadExtras(items, jodit, extraList, callback) {
    try {
        const needLoadExtras = extraList.filter((extra)=>!items.has((0,jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.normalizeName)(extra.name)));
        if (needLoadExtras.length) {
            load(jodit, needLoadExtras, callback);
        }
    } catch (e) {
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
            throw e;
        }
    }
}
/**
 * Download plugins
 * @private
 */ function load(jodit, pluginList, callback) {
    pluginList.map((extra)=>{
        const url = extra.url || getFullUrl(jodit, extra.name, true);
        return (0,jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_3__.appendScriptAsync)(jodit, url).then(callback).catch(()=>null);
    });
}


/***/ }),

/***/ 3213:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isSet: function() { return /* binding */ isSet; }
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91565);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ 
/**
 * Check if element is set
 */ function isSet(elm) {
    return Boolean(elm) && (0,_is_function__WEBPACK_IMPORTED_MODULE_0__.isFunction)(elm.has) && (0,_is_function__WEBPACK_IMPORTED_MODULE_0__.isFunction)(elm.add) && (0,_is_function__WEBPACK_IMPORTED_MODULE_0__.isFunction)(elm.delete);
}


/***/ }),

/***/ 3244:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65946);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5266);
/* harmony import */ var jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42573);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/mobile
 */ 




jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.mobileTapTimeout = 300;
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.toolbarAdaptive = true;
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.buttonsMD = [
    {
        group: 'font-style',
        buttons: []
    },
    {
        group: 'list',
        buttons: []
    },
    {
        group: 'font',
        buttons: []
    },
    '---',
    {
        group: 'media',
        buttons: []
    },
    '\n',
    {
        group: 'state',
        buttons: []
    },
    {
        group: 'insert',
        buttons: []
    },
    {
        group: 'indent',
        buttons: []
    },
    {
        group: 'color',
        buttons: []
    },
    '---',
    {
        group: 'history',
        buttons: []
    },
    {
        group: 'other',
        buttons: []
    },
    '|',
    'dots'
];
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.buttonsSM = [
    {
        group: 'font-style',
        buttons: []
    },
    {
        group: 'list',
        buttons: []
    },
    '---',
    {
        group: 'font',
        buttons: []
    },
    '\n',
    {
        group: 'state',
        buttons: []
    },
    {
        group: 'indent',
        buttons: []
    },
    {
        group: 'color',
        buttons: []
    },
    '---',
    {
        group: 'history',
        buttons: []
    },
    '|',
    'dots'
];
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.buttonsXS = [
    {
        group: 'font-style',
        buttons: []
    },
    {
        group: 'list',
        buttons: []
    },
    '---',
    {
        group: 'font',
        buttons: []
    },
    {
        group: 'color',
        buttons: []
    },
    '---',
    'dots'
];
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.controls.dots = {
    mode: jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE + jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG,
    popup: (editor, current, close, button)=>{
        let store = button.control.data;
        if (store === undefined) {
            store = {
                toolbar: (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_4__.makeCollection)(editor),
                rebuild: ()=>{
                    if (button) {
                        const buttons = editor.e.fire('getDiffButtons.mobile', button.closest(jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_3__.ToolbarCollection));
                        if (buttons && store) {
                            var _editor_toolbar_firstButton, _editor_toolbar;
                            store.toolbar.build((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.splitArray)(buttons));
                            const w = ((_editor_toolbar = editor.toolbar) === null || _editor_toolbar === void 0 ? void 0 : (_editor_toolbar_firstButton = _editor_toolbar.firstButton) === null || _editor_toolbar_firstButton === void 0 ? void 0 : _editor_toolbar_firstButton.container.offsetWidth) || 36;
                            store.toolbar.container.style.width = (w + 4) * 3 + 'px';
                        }
                    }
                }
            };
            button.control.data = store;
        }
        store.rebuild();
        return store.toolbar;
    },
    tooltip: 'Show all'
};


/***/ }),

/***/ 3268:
/***/ (function(module) {

module.exports["default"] = ["Begin met typen..","Over Jodit","Jodit Editor","Jodit gebruikershandleiding","bevat gedetailleerde informatie voor gebruik.","Voor informatie over de licentie, ga naar onze website:","Volledige versie kopen","Copyright © XDSoft.net - Chupurnov Valeriy. Alle rechten voorbehouden.","Anker","Open in nieuwe tab","Editor in volledig scherm openen","Opmaak verwijderen","Vulkleur of tekstkleur aanpassen","Opnieuw","Ongedaan maken","Vet","Cursief","Geordende list invoegen","Ongeordende lijst invoegen","Centreren","Uitlijnen op volledige breedte","Links uitlijnen","Rechts uitlijnen","Horizontale lijn invoegen","Afbeelding invoegen","Bestand invoegen","Youtube/Vimeo video invoegen","Link toevoegen","Tekstgrootte","Lettertype","Format blok invoegen","Normaal","Koptekst 1","Koptekst 2","Koptekst 3","Koptekst 4","Citaat","Code","Invoegen","Tabel invoegen","Inspringing verkleinen","Inspringing vergroten","Symbool selecteren","Symbool invoegen","Opmaak kopieren","Modus veranderen","Marges","Boven","Rechts","Onder","Links","CSS styles","CSS classes","Uitlijning","Rechts","Gecentreerd","Links","--Leeg--","Src","Titel","Alternatieve tekst","Link","Link in nieuwe tab openen","Afbeelding","Bestand","Geavanceerd","Afbeeldingseigenschappen","Annuleren","OK","Bestandsbrowser","Fout bij het laden van de lijst","Fout bij het laden van de mappenlijst","Weet je het zeker?","Geef de map een naam","Map aanmaken","Type naam","Sleep hier een afbeelding naartoe","Sleep hier een bestand naartoe","of klik","Alternatieve tekst","Uploaden","Bladeren","Achtergrond","Tekst","Boven","Midden","Onder","Kolom invoegen (voor)","Kolom invoegen (na)","Rij invoegen (boven)","Rij invoegen (onder)","Tabel verwijderen","Rij verwijderen","Kolom verwijderen","Cel leegmaken","Tekens: %d","Woorden: %d","Doorstrepen","Onderstrepen","Superscript","Subscript","Selectie knippen","Selecteer alles","Enter","Zoek naar","Vervangen door","Vervangen","Plakken","Kies content om te plakken","Broncode","vet","cursief","kwast","link","ongedaan maken","opnieuw","tabel","afbeelding","gum","paragraaf","lettergrootte","video","lettertype","over","afdrukken","onderstreept","doorgestreept","inspringen","minder inspringen","volledige grootte","kleiner maken","horizontale lijn","lijst","genummerde lijst","knip","alles selecteren","Embed code","Link openen","Link aanpassen","Niet volgen","link verwijderen","Updaten","Om te bewerken","Recensie"," URL","Bewerken","Horizontaal uitlijnen","Filteren","Sorteren op wijzigingsdatum","Sorteren op naam","Sorteren op grootte","Map toevoegen","Herstellen","Opslaan","Opslaan als ...","Grootte aanpassen","Bijknippen","Breedte","Hoogte","Verhouding behouden","Ja","Nee","Verwijderen","Selecteren","Selecteer: %s","Verticaal uitlijnen","Splitsen","Samenvoegen","Kolom toevoegen","Rij toevoegen","Licentie: %s","Verwijderen","Verticaal splitsen","Horizontaal splitsen","Rand","Deze code lijkt op HTML. Als HTML behouden?","Invoegen als HTML","Origineel behouden","Als tekst invoegen","Als onopgemaakte tekst invoegen","Je kunt alleen je eigen afbeeldingen aanpassen. Deze afbeelding downloaden?","De afbeelding is succesvol geüploadet!","Palette","Er zijn geen bestanden in deze map.","Hernoemen","Voer een nieuwe naam in","Voorvertoning","Download","Plakken van klembord","Uw browser ondersteunt geen directe toegang tot het klembord.","Selectie kopiëren","kopiëren","Border radius","Toon alle","Toepassen","Vul dit veld in","Voer een webadres in","Standaard","Cirkel","Punt","Kwadraat","Zoeken","Vorige Zoeken","Volgende Zoeken","De geplakte tekst is afkomstig van een Microsoft Word/Excel document. Wil je de opmaak behouden of opschonen?","Word-tekst gedetecteerd","Opschonen","Voeg de klassenaam in","Druk op Alt voor aangepaste grootte",null,null,null,"Alles"]

/***/ }),

/***/ 3294:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    symbols: 'symbol'
};


/***/ }),

/***/ 3347:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringify: function() { return /* binding */ stringify; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/string
 */ /**
 * Safe stringify circular object
 */ function stringify(value, options = {}) {
    if (typeof value !== 'object') {
        return String(value);
    }
    const excludeKeys = new Set(options.excludeKeys);
    const map = new WeakMap();
    const r = (k, v)=>{
        if (excludeKeys.has(k)) {
            return;
        }
        if (typeof v === 'object' && v != null) {
            if (map.get(v)) {
                return '[refObject]';
            }
            map.set(v, true);
        }
        return v;
    };
    return JSON.stringify(value, r, options.prettify);
}


/***/ }),

/***/ 3513:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isWindow: function() { return /* binding */ isWindow; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ function isWindow(obj) {
    return obj != null && obj === obj.window;
}


/***/ }),

/***/ 3678:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export enter */
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22289);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(18855);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(10918);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/enter/README.md]]
 * @packageDocumentation
 * @module plugins/enter
 */ 








/**
 * One of most important core plugins. It is responsible for all the browsers to have the same effect when the Enter
 * button is pressed. By default, it should insert the <p>
 */ class enter extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_6__.Plugin {
    /** @override */ afterInit(editor) {
        // use 'enter' option if no set
        const defaultTag = editor.o.enter.toLowerCase();
        const brMode = defaultTag === jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.BR.toLowerCase();
        if (!editor.o.enterBlock) {
            editor.o.enterBlock = brMode ? jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.PARAGRAPH : defaultTag;
        }
        editor.registerCommand('enter', (command, value, event = {})=>this.onEnter(event));
    }
    onEnterKeyDown(event) {
        if (event.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_ENTER) {
            const editor = this.j;
            const beforeEnter = editor.e.fire('beforeEnter', event);
            if (beforeEnter !== undefined) {
                return beforeEnter;
            }
            if (!editor.s.isCollapsed()) {
                editor.execCommand('Delete');
            }
            editor.s.focus();
            this.onEnter(event);
            editor.e.fire('afterEnter', event);
            editor.synchronizeValues(); // fire change
            return false;
        }
    }
    onEnter(event) {
        const { jodit } = this;
        const fake = jodit.createInside.fake();
        try {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.safeInsertNode(jodit.s.range, fake);
            (0,_helpers__WEBPACK_IMPORTED_MODULE_7__.moveCursorOutFromSpecialTags)(jodit, fake, [
                'a'
            ]);
            let block = (0,_helpers__WEBPACK_IMPORTED_MODULE_7__.getBlockWrapper)(fake, jodit);
            const isLi = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.isLeaf(block);
            // if use <br> defaultTag for break line or when was entered SHIFt key or in <td> or <th> or <blockquote>
            if ((!isLi || (event === null || event === void 0 ? void 0 : event.shiftKey)) && (0,_helpers__WEBPACK_IMPORTED_MODULE_7__.checkBR)(fake, jodit, event === null || event === void 0 ? void 0 : event.shiftKey)) {
                return false;
            }
            // wrap no wrapped element
            if (!block && !(0,_helpers__WEBPACK_IMPORTED_MODULE_7__.hasPreviousBlock)(fake, jodit)) {
                block = (0,_helpers__WEBPACK_IMPORTED_MODULE_7__.wrapText)(fake, jodit);
            }
            if (!block) {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_7__.insertParagraph)(fake, jodit, isLi ? 'li' : jodit.o.enter);
                return false;
            }
            if (!(0,_helpers__WEBPACK_IMPORTED_MODULE_7__.checkUnsplittableBox)(fake, jodit, block)) {
                return false;
            }
            if (isLi && this.__isEmptyListLeaf(block)) {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_7__.processEmptyLILeaf)(fake, jodit, block);
                return false;
            }
            (0,_helpers__WEBPACK_IMPORTED_MODULE_7__.splitFragment)(fake, jodit, block);
        } finally{
            fake.isConnected && jodit.s.setCursorBefore(fake);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.safeRemove(fake);
        }
    }
    __isEmptyListLeaf(li) {
        const result = this.j.e.fire('enterIsEmptyListLeaf', li);
        return (0,jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_5__.isBoolean)(result) ? result : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.isEmpty(li);
    }
    /** @override */ beforeDestruct(editor) {
        editor.e.off('keydown.enter');
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_0__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)(':keydown.enter')
], enter.prototype, "onEnterKeyDown", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_4__.pluginSystem.add('enter', enter);


/***/ }),

/***/ 3787:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    'copy-format': 'Kopírovat formát'
};


/***/ }),

/***/ 3843:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 16 16\"> <path stroke-width=\"0\" d=\"M16 9v-6h-3v-1c0-0.55-0.45-1-1-1h-11c-0.55 0-1 0.45-1 1v3c0 0.55 0.45 1 1 1h11c0.55 0 1-0.45 1-1v-1h2v4h-9v2h-0.5c-0.276 0-0.5 0.224-0.5 0.5v5c0 0.276 0.224 0.5 0.5 0.5h2c0.276 0 0.5-0.224 0.5-0.5v-5c0-0.276-0.224-0.5-0.5-0.5h-0.5v-1h9zM12 3h-11v-1h11v1z\"/> </svg>"

/***/ }),

/***/ 3856:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertMediaUrlToVideoEmbed: function() { return /* binding */ convertMediaUrlToVideoEmbed; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers_checker_is_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91764);
/* harmony import */ var _parse_query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36310);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 


/**
 * Javascript url pattern converter replace youtube/vimeo url in embed code.
 */ const convertMediaUrlToVideoEmbed = (url, { width = 400, height = 345 } = {})=>{
    if (!(0,jodit_core_helpers_checker_is_url__WEBPACK_IMPORTED_MODULE_1__.isURL)(url)) {
        return url;
    }
    const parser = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('a');
    const pattern1 = /(?:http?s?:\/\/)?(?:www\.)?(?:vimeo\.com)\/?(.+)/g;
    parser.href = url;
    if (!width) {
        width = 400;
    }
    if (!height) {
        height = 345;
    }
    const protocol = parser.protocol || '';
    switch(parser.hostname){
        case 'www.vimeo.com':
        case 'vimeo.com':
            return pattern1.test(url) ? url.replace(pattern1, '<iframe width="' + width + '" height="' + height + '" src="' + protocol + '//player.vimeo.com/video/$1" frameborder="0" allowfullscreen></iframe>') : url;
        case 'youtube.com':
        case 'www.youtube.com':
        case 'youtu.be':
        case 'www.youtu.be':
            {
                const query = parser.search ? (0,_parse_query__WEBPACK_IMPORTED_MODULE_2__.parseQuery)(parser.search) : {
                    v: parser.pathname.substring(1)
                };
                if (/^embed\/.*/.test(query.v)) {
                    query.v = query.v.substring(6);
                }
                return query.v ? '<iframe width="' + width + '" height="' + height + '" src="' + protocol + '//www.youtube.com/embed/' + query.v + '" frameborder="0" allowfullscreen></iframe>' : url;
            }
    }
    return url;
};


/***/ }),

/***/ 4040:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   trim: function() { return /* binding */ trim; },
/* harmony export */   trimChars: function() { return /* binding */ trimChars; },
/* harmony export */   trimInv: function() { return /* binding */ trimInv; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/string
 */ 
/**
 * It clears the line of all auxiliary invisible characters , from the spaces and line breaks , tabs
 * from the beginning and end of the line
 */ function trim(value) {
    return value.replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.SPACE_REG_EXP_END)(), '').replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.SPACE_REG_EXP_START)(), '');
}
function trimChars(value, chars) {
    return value.replace(RegExp(`[${chars}]+$`), '').replace(RegExp(`^[${chars}]+`), '');
}
/**
 * Trim only invisible chars
 */ function trimInv(value) {
    return value.replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_END)(), '').replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_START)(), '');
}


/***/ }),

/***/ 4099:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Button: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.Button; },
/* harmony export */   Icon: function() { return /* reexport safe */ _icon__WEBPACK_IMPORTED_MODULE_4__.Icon; },
/* harmony export */   Popup: function() { return /* reexport safe */ _popup__WEBPACK_IMPORTED_MODULE_5__.Popup; },
/* harmony export */   ProgressBar: function() { return /* reexport safe */ _progress_bar_progress_bar__WEBPACK_IMPORTED_MODULE_6__.ProgressBar; },
/* harmony export */   UIBlock: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.UIBlock; },
/* harmony export */   UIButton: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.UIButton; },
/* harmony export */   UIButtonGroup: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.UIButtonGroup; },
/* harmony export */   UIButtonState: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.UIButtonState; },
/* harmony export */   UICheckbox: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.UICheckbox; },
/* harmony export */   UIElement: function() { return /* reexport safe */ _element__WEBPACK_IMPORTED_MODULE_1__.UIElement; },
/* harmony export */   UIFileInput: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.UIFileInput; },
/* harmony export */   UIForm: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.UIForm; },
/* harmony export */   UIGroup: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.UIGroup; },
/* harmony export */   UIInput: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.UIInput; },
/* harmony export */   UIList: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.UIList; },
/* harmony export */   UISelect: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.UISelect; },
/* harmony export */   UISeparator: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.UISeparator; },
/* harmony export */   UISpacer: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.UISpacer; },
/* harmony export */   UITextArea: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.UITextArea; },
/* harmony export */   UITooltip: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.UITooltip; }
/* harmony export */ });
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59400);
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(96007);
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5658);
/* harmony import */ var _group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(64847);
/* harmony import */ var _icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29434);
/* harmony import */ var _popup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(56490);
/* harmony import */ var _progress_bar_progress_bar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(34396);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/ui/README.md]]
 * @packageDocumentation
 * @module ui
 */ 








/***/ }),

/***/ 4274:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   makeButton: function() { return /* binding */ makeButton; },
/* harmony export */   makeCollection: function() { return /* binding */ makeCollection; },
/* harmony export */   makeSelect: function() { return /* binding */ makeSelect; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65946);
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22533);
/* harmony import */ var _button_content__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5772);
/* harmony import */ var _button_select_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61764);
/* harmony import */ var _collection_collection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(42573);
/* harmony import */ var _collection_editor_collection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6209);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/toolbar/README.md]]
 * @packageDocumentation
 * @module modules/toolbar
 */ 





/**
 * Collection factory
 */ function makeCollection(jodit, parentElement) {
    const collection = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isJoditObject)(jodit) ? new _collection_editor_collection__WEBPACK_IMPORTED_MODULE_5__.ToolbarEditorCollection(jodit) : new _collection_collection__WEBPACK_IMPORTED_MODULE_4__.ToolbarCollection(jodit);
    if (jodit.o.textIcons) {
        collection.container.classList.add('jodit_text_icons');
    }
    if (parentElement) {
        collection.parentElement = parentElement;
    }
    if (jodit.o.toolbarButtonSize) {
        collection.buttonSize = jodit.o.toolbarButtonSize;
    }
    return collection;
}
/**
 * Button factory
 */ function makeButton(jodit, control, target = null) {
    if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(control.getContent)) {
        return new _button_content__WEBPACK_IMPORTED_MODULE_2__.ToolbarContent(jodit, control, target);
    }
    const button = new _button_button__WEBPACK_IMPORTED_MODULE_1__.ToolbarButton(jodit, control, target);
    button.state.tabIndex = jodit.o.allowTabNavigation ? 0 : -1;
    return button;
}
function makeSelect(view, control, target = null) {
    return new _button_select_select__WEBPACK_IMPORTED_MODULE_3__.ToolbarSelect(view, control, target);
}


/***/ }),

/***/ 4561:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UIBlock: function() { return /* binding */ UIBlock; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(91672);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(93640);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63468);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/form
 */ 





class UIBlock extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_4__.UIGroup {
    /** @override */ className() {
        return 'UIBlock';
    }
    constructor(jodit, elements, options = {
        align: 'left'
    }){
        super(jodit, elements), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "options", void 0), this.options = options;
        this.setMod('align', this.options.align || 'left');
        this.setMod('width', this.options.width || '');
        this.options.mod && this.setMod(this.options.mod, true);
        this.options.className && this.container.classList.add(this.options.className);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'data-ref', options.ref);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'ref', options.ref);
    }
}
UIBlock = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__.component
], UIBlock);


/***/ }),

/***/ 5266:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Config: function() { return /* binding */ Config; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * Editor options. These can be configured upon the creation of the editor.
 * ```javascript
 * const editor = Jodit.make('#editor', {
 * 	 toolbar: true,
 * 	 buttons: ['bold', 'italic', 'underline']
 * 	 // other options
 * 	 // ...
 * });
 * ```
 * @packageDocumentation
 * @module config
 */ 


let ConfigPrototype = {};
/**
 * Default Editor's Configuration
 */ class Config {
    static get defaultOptions() {
        if (!Config.__defaultOptions) {
            Config.__defaultOptions = new Config();
        }
        return Config.__defaultOptions;
    }
    constructor(){
        /**
	 * Use cache for heavy methods
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "cache", true);
        /**
	 * Timeout of all asynchronous methods
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "defaultTimeout", 100);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "namespace", '');
        /**
	 * Editor loads completely without plugins. Useful when debugging your own plugin.
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "safeMode", false);
        /**
	 * Editor's width
	 *
	 * @example
	 * ```javascript
	 * Jodit.make('.editor', {
	 *    width: '100%',
	 * })
	 * ```
	 * @example
	 * ```javascript
	 * Jodit.make('.editor', {
	 *    width: 600, // equivalent for '600px'
	 * })
	 * ```
	 * @example
	 * ```javascript
	 * Jodit.make('.editor', {
	 *    width: 'auto', // autosize
	 * })
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "width", 'auto');
        /**
	 * Editor's height
	 *
	 * @example
	 * ```javascript
	 * Jodit.make('.editor', {
	 *    height: '100%',
	 * })
	 * ```
	 * @example
	 * ```javascript
	 * Jodit.make('.editor', {
	 *    height: 600, // equivalent for '600px'
	 * })
	 * ```
	 * @example
	 * ```javascript
	 * Jodit.make('.editor', {
	 *    height: 'auto', // default - autosize
	 * })
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "height", 'auto');
        /**
	 * List of plugins that will be initialized in safe mode.
	 *
	 * ```js
	 * Jodit.make('#editor', {
	 * 	safeMode: true,
	 * 	safePluginsList: ['about'],
	 * 	extraPlugins: ['yourPluginDev']
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "safePluginsList", [
            'about',
            'enter',
            'backspace',
            'size',
            'bold',
            'hotkeys'
        ]);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "commandToHotkeys", void 0);
        /**
	 * Reserved for the paid version of the editor
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "license", '');
        /**
	 * The name of the preset that will be used to initialize the editor.
	 * The list of available presets can be found here Jodit.defaultOptions.presets
	 * ```javascript
	 * Jodit.make('.editor', {
	 * 	preset: 'inline'
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "preset", 'custom');
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "presets", {
            inline: {
                inline: true,
                toolbar: false,
                toolbarInline: true,
                toolbarInlineForSelection: true,
                showXPathInStatusbar: false,
                showCharsCounter: false,
                showWordsCounter: false,
                showPlaceholder: false
            }
        });
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "ownerDocument", jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.globalDocument);
        /**
	 * Allows you to specify the window in which the editor will be created. Default - window
	 * This is necessary if you are creating the editor inside an iframe but the code is running in the parent window
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "ownerWindow", jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.globalWindow);
        /**
	 * Shadow root if Jodit was created in it
	 *
	 * ```html
	 * <div id="editor"></div>
	 * ```
	 *
	 * ```js
	 * const app = document.getElementById('editor');
	 * app.attachShadow({ mode: 'open' });
	 * const root = app.shadowRoot;
	 *
	 * root.innerHTML = `
	 * <link rel="stylesheet" href="./build/jodit.css"/>
	 * <h1>Jodit example in Shadow DOM</h1>
	 * <div id="edit"></div>
	 * `;
	 *
	 * const editor = Jodit.make(root.getElementById('edit'), {
	 * 	globalFullSize: false,
	 * 	shadowRoot: root
	 * });
	 * editor.value = '<p>start</p>';
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "shadowRoot", null);
        /**
	 * z-index For editor
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "zIndex", 0);
        /**
	 * Change the read-only state of the editor
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "readonly", false);
        /**
	 * Change the disabled state of the editor
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "disabled", false);
        /**
	 * In readOnly mode, some buttons can still be useful, for example, the button to view source code or print
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "activeButtonsInReadOnly", [
            'source',
            'fullsize',
            'print',
            'about',
            'dots',
            'selectall'
        ]);
        /**
	 * When the editor is in read-only mode, some commands can still be executed:
	 * ```javascript
	 * const editor = Jodit.make('.editor', {
	 * 	 allowCommandsInReadOnly: ['selectall', 'preview', 'print']
	 * 	 readonly: true
	 * });
	 * editor.execCommand('selectall');// will be selected all content
	 * editor.execCommand('delete');// but content will not be deleted
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "allowCommandsInReadOnly", [
            'selectall',
            'preview',
            'print'
        ]);
        /**
	 * Size of icons in the toolbar (can be "small", "middle", "large")
	 *
	 * @example
	 * ```javascript
	 * const editor = Jodit.make(".dark_editor", {
	 *      toolbarButtonSize: "small"
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "toolbarButtonSize", 'middle');
        /**
	 * Allow navigation in the toolbar of the editor by Tab key
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "allowTabNavigation", false);
        /**
	 * Inline editing mode
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "inline", false);
        /**
	 * Theme (can be "dark")
	 * @example
	 * ```javascript
	 * const editor = Jodit.make(".dark_editor", {
	 *      theme: "dark"
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "theme", 'default');
        /**
	 * if set true, then the current mode is saved in a cookie, and is restored after a reload of the page
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "saveModeInStorage", false);
        /**
	 * Class name that can be appended to the editable area
	 *
	 * @see [[Config.iframeCSSLinks]]
	 * @see [[Config.iframeStyle]]
	 *
	 * @example
	 * ```javascript
	 * Jodit.make('#editor', {
	 *    editorClassName: 'some_my_class'
	 * });
	 * ```
	 * ```html
	 * <style>
	 * .some_my_class p{
	 *    line-height: 16px;
	 * }
	 * </style>
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "editorClassName", false);
        /**
	 * Class name that can be appended to the main editor container
	 * @example
	 * ```javascript
	 * const jodit = Jodit.make('#editor', {
	 *    className: 'some_my_class'
	 * });
	 *
	 * console.log(jodit.container.classList.contains('some_my_class')); // true
	 * ```
	 * ```html
	 * <style>
	 * .some_my_class {
	 *    max-width: 600px;
	 *    margin: 0 auto;
	 * }
	 * </style>
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "className", false);
        /**
	 * The internal styles of the editable area. They are intended to change
	 * not the appearance of the editor, but to change the appearance of the content.
	 * @example
	 * ```javascript
	 * Jodit.make('#editor', {
	 * 		style: {
	 * 		 font: '12px Arial',
	 * 		 color: '#0c0c0c'
	 * 		}
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "style", false);
        /**
	 *
	 * @example
	 * ```javascript
	 * Jodit.make('#editor', {
	 * 		editorStyle: {
	 * 		 font: '12px Arial',
	 * 		 color: '#0c0c0c'
	 * 		}
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "containerStyle", false);
        /**
	 * Dictionary of variable values in css, a complete list can be found here
	 * https://github.com/xdan/jodit/blob/main/src/styles/variables.less#L25
	 *
	 * @example
	 * ```js
	 * const editor = Jodit.make('#editor', {
	 *   styleValues: {
	 *		'color-text': 'red',
	 *		colorBorder: 'black',
	 *		'color-panel': 'blue'
	 *   }
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "styleValues", {});
        /**
	 * After all, changes in editors for textarea will call change trigger
	 *
	 * @example
	 * ```javascript
	 * const editor = Jodit.make('#editor');
	 * document.getElementById('editor').addEventListener('change', function () {
	 *      console.log(this.value);
	 * })
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "triggerChangeEvent", true);
        /**
	 * The writing direction of the language which is used to create editor content. Allowed values are: ''
	 * (an empty string) – Indicates that content direction will be the same as either the editor UI direction or
	 * the page element direction. 'ltr' – Indicates a Left-To-Right text direction (like in English).
	 * 'rtl' – Indicates a Right-To-Left text direction (like in Arabic).
	 *
	 * @example
	 * ```javascript
	 * Jodit.make('.editor', {
	 *    direction: 'rtl'
	 * })
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "direction", '');
        /**
	 * Language by default. if `auto` language set by document.documentElement.lang ||
	 * (navigator.language && navigator.language.substr(0, 2)) ||
	 * (navigator.browserLanguage && navigator.browserLanguage.substr(0, 2)) || 'en'
	 *
	 * @example
	 * ```html
	 * <!-- include in you page lang file -->
	 * <script src="jodit/lang/de.js"></script>
	 * <script>
	 * var editor = Jodit.make('.editor', {
	 *    language: 'de'
	 * });
	 * </script>
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "language", 'auto');
        /**
	 * if true all Lang.i18n(key) return `{key}`
	 *
	 * @example
	 * ```html
	 * <script>
	 * var editor = Jodit.make('.editor', {
	 *    debugLanguage: true
	 * });
	 *
	 * console.log(editor.i18n("Test")); // {Test}
	 * </script>
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "debugLanguage", false);
        /**
	 * Collection of language pack data `{en: {'Type something': 'Type something', ...}}`
	 *
	 * @example
	 * ```javascript
	 * const editor = Jodit.make('#editor', {
	 *     language: 'ru',
	 *     i18n: {
	 *         ru: {
	 *            'Type something': 'Начните что-либо вводить'
	 *         }
	 *     }
	 * });
	 * console.log(editor.i18n('Type something')) //Начните что-либо вводить
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "i18n", false);
        /**
	 * The tabindex global attribute is an integer indicating if the element can take
	 * input focus (is focusable), if it should participate to sequential keyboard navigation,
	 * and if so, at what position. It can take several values
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "tabIndex", -1);
        /**
	 * Boolean, whether the toolbar should be shown.
	 * Alternatively, a valid css-selector-string to use an element as toolbar container.
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "toolbar", true);
        /**
	 * Boolean, whether the statusbar should be shown.
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "statusbar", true);
        /**
	 * Show tooltip after mouse enter on the button
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "showTooltip", true);
        /**
	 * Delay before show tooltip
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "showTooltipDelay", 200);
        /**
	 * Instead of create custop tooltip - use native title tooltips
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "useNativeTooltip", false);
        /**
	 * Default insert method
	 * @default insert_as_html
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "defaultActionOnPaste", jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.INSERT_AS_HTML);
        // TODO
        // autosave: false, // false or url
        // autosaveCallback: false, // function
        // interval: 60, // seconds
        // TODO
        /**
	 * Element that will be created when you press Enter
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "enter", jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.PARAGRAPH);
        /**
	 * When this option is enabled, the editor's content will be placed in an iframe and isolated from the rest of the page.
	 *
	 * @example
	 * ```javascript
	 * Jodit.make('#editor', {
	 *    iframe: true,
	 *    iframeStyle: 'html{margin: 0px;}body{padding:10px;background:transparent;color:#000;position:relative;z-index:2;\
	 *    user-select:auto;margin:0px;overflow:hidden;}body:after{content:"";clear:both;display:block}';
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "iframe", false);
        /**
	 * Allow editing the entire HTML document(html, head)
	 * \> Works together with the iframe option.
	 * @example
	 * ```js
	 * const editor = Jodit.make('#editor', {
	 *   iframe: true,
	 *   editHTMLDocumentMode: true
	 * });
	 * editor.value = '<!DOCTYPE html><html lang="en" style="overflow-y:hidden">' +
	 * 	'<head><title>Jodit Editor</title></head>' +
	 * 	'<body spellcheck="false"><p>Some text</p><p> a </p></body>' +
	 * 	'</html>';
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "editHTMLDocumentMode", false);
        /**
	 * Use when you need to insert new block element
	 * use enter option if not set
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "enterBlock", this.enter !== 'br' ? this.enter : jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.PARAGRAPH);
        /**
	 * Jodit.MODE_WYSIWYG The HTML editor allows you to write like MSWord,
	 * Jodit.MODE_SOURCE syntax highlighting source editor
	 * @example
	 * ```javascript
	 * var editor = Jodit.make('#editor', {
	 *     defaultMode: Jodit.MODE_SPLIT
	 * });
	 * console.log(editor.getRealMode())
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "defaultMode", jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.MODE_WYSIWYG);
        /**
	 * Use split mode
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "useSplitMode", false);
        /**
	 * The colors in HEX representation to select a color for the background and for the text in colorpicker
	 * @example
	 * ```javascript
	 *  Jodit.make('#editor', {
	 *     colors: ['#ff0000', '#00ff00', '#0000ff']
	 * })
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "colors", {
            greyscale: [
                '#000000',
                '#434343',
                '#666666',
                '#999999',
                '#B7B7B7',
                '#CCCCCC',
                '#D9D9D9',
                '#EFEFEF',
                '#F3F3F3',
                '#FFFFFF'
            ],
            palette: [
                '#980000',
                '#FF0000',
                '#FF9900',
                '#FFFF00',
                '#00F0F0',
                '#00FFFF',
                '#4A86E8',
                '#0000FF',
                '#9900FF',
                '#FF00FF'
            ],
            full: [
                '#E6B8AF',
                '#F4CCCC',
                '#FCE5CD',
                '#FFF2CC',
                '#D9EAD3',
                '#D0E0E3',
                '#C9DAF8',
                '#CFE2F3',
                '#D9D2E9',
                '#EAD1DC',
                '#DD7E6B',
                '#EA9999',
                '#F9CB9C',
                '#FFE599',
                '#B6D7A8',
                '#A2C4C9',
                '#A4C2F4',
                '#9FC5E8',
                '#B4A7D6',
                '#D5A6BD',
                '#CC4125',
                '#E06666',
                '#F6B26B',
                '#FFD966',
                '#93C47D',
                '#76A5AF',
                '#6D9EEB',
                '#6FA8DC',
                '#8E7CC3',
                '#C27BA0',
                '#A61C00',
                '#CC0000',
                '#E69138',
                '#F1C232',
                '#6AA84F',
                '#45818E',
                '#3C78D8',
                '#3D85C6',
                '#674EA7',
                '#A64D79',
                '#85200C',
                '#990000',
                '#B45F06',
                '#BF9000',
                '#38761D',
                '#134F5C',
                '#1155CC',
                '#0B5394',
                '#351C75',
                '#733554',
                '#5B0F00',
                '#660000',
                '#783F04',
                '#7F6000',
                '#274E13',
                '#0C343D',
                '#1C4587',
                '#073763',
                '#20124D',
                '#4C1130'
            ]
        });
        /**
	 * The default tab color picker
	 * @example
	 * ```javascript
	 * Jodit.make('#editor2', {
	 *     colorPickerDefaultTab: 'color'
	 * })
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "colorPickerDefaultTab", 'background');
        /**
	 * Image size defaults to a larger image
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "imageDefaultWidth", 300);
        /**
	 * Do not display these buttons that are on the list
	 * @example
	 * ```javascript
	 * Jodit.make('#editor2', {
	 *     removeButtons: ['hr', 'source']
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "removeButtons", []);
        /**
	 * Do not init these plugins
	 * @example
	 * ```typescript
	 * var editor = Jodit.make('.editor', {
	 *    disablePlugins: 'table,iframe'
	 * });
	 * //or
	 * var editor = Jodit.make('.editor', {
	 *    disablePlugins: ['table', 'iframe']
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "disablePlugins", []);
        /**
	 * Init and download extra plugins
	 * @example
	 * ```typescript
	 * var editor = Jodit.make('.editor', {
	 *    extraPlugins: ['emoji']
	 * });
	 * ```
	 * It will try load %SCRIPT_PATH%/plugins/emoji/emoji.js and after load will try init it
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "extraPlugins", []);
        /**
	 * Base path for download extra plugins
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "basePath", void 0);
        /**
	 * These buttons list will be added to the option. Buttons
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "extraButtons", []);
        /**
	 * By default, you can only install an icon from the Jodit suite.
	 * You can add your icon to the set using the `Jodit.modules.Icon.set (name, svg Code)` method.
	 * But for a declarative declaration, you can use this option.
	 *
	 * @example
	 * ```js
	 * Jodit.modules.Icon.set('someIcon', '<svg><path.../></svg>');
	 * const editor = Jodit.make({
	 *   extraButtons: [{
	 *     name: 'someButton',
	 *     icon: 'someIcon'
	 *   }]
	 * });
	 *
	 * @example
	 * const editor = Jodit.make({
	 *   extraIcons: {
	 *     someIcon: '<svg><path.../></svg>'
	 *   },
	 *   extraButtons: [{
	 *     name: 'someButton',
	 *     icon: 'someIcon'
	 *   }]
	 * });
	 * ```
	 * @example
	 * ```js
	 * const editor = Jodit.make({
	 *   extraButtons: [{
	 *     name: 'someButton',
	 *     icon: '<svg><path.../></svg>'
	 *   }]
	 * });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "extraIcons", {});
        /**
	 * Default attributes for created inside editor elements
	 * @example
	 * ```js
	 * const editor2 = Jodit.make('#editor', {
	 * 	createAttributes: {
	 * 		div: {
	 * 			class: 'test'
	 * 		},
	 * 		ul: function (ul) {
	 * 			ul.classList.add('ui-test');
	 * 		}
	 * 	}
	 * });
	 *
	 * const div2 = editor2.createInside.div();
	 * expect(div2.className).equals('test');
	 *
	 * const ul = editor2.createInside.element('ul');
	 * expect(ul.className).equals('ui-test');
	 * ```
	 * Or JSX in React
	 * @example
	 * ```jsx
	 * import React, {useState, useRef} from 'react';
	 * import JoditEditor from "jodit-react";
	 *
	 * const config = {
	 * 	createAttributes: {
	 * 		div: {
	 * 			class: 'align-center'
	 * 		}
	 * 	}
	 * };
	 *
	 * <JoditEditor config={config}/>
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "createAttributes", {
            table: {
                style: 'border-collapse:collapse;width: 100%;'
            }
        });
        /**
	 * The width of the editor, accepted as the biggest. Used to the responsive version of the editor
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "sizeLG", 900);
        /**
	 * The width of the editor, accepted as the medium. Used to the responsive version of the editor
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "sizeMD", 700);
        /**
	 * The width of the editor, accepted as the small. Used to the responsive version of the editor
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "sizeSM", 400);
        /**
	 * The list of buttons that appear in the editor's toolbar on large places (≥ options.sizeLG).
	 * Note - this is not the width of the device, the width of the editor
	 * @example
	 * ```javascript
	 * Jodit.make('#editor', {
	 *     buttons: ['bold', 'italic', 'source'],
	 *     buttonsMD: ['bold', 'italic'],
	 *     buttonsXS: ['bold', 'fullsize'],
	 * });
	 * ```
	 * @example
	 * ```javascript
	 * Jodit.make('#editor2', {
	 *     buttons: [{
	 *         name: 'empty',
	 *         icon: 'source',
	 *         exec: function (editor) {
	 *             const dialog = new Jodit.modules.Dialog({}),
	 *                 text = editor.c.element('textarea');
	 *
	 *             dialog.setHeader('Source code');
	 *             dialog.setContent(text);
	 *             dialog.setSize(400, 300);
	 *
	 *             Jodit.modules.Helpers.css(elm, {
	 *                 width: '100%',
	 *                 height: '100%'
	 *             })

	 *             dialog.open();
	 *         }
	 *     }]
	 * });
	 * ```
	 * @example
	 * ```javascript
	 * Jodit.make('#editor2', {
	 *     buttons: Jodit.defaultOptions.buttons.concat([{
	 *        name: 'listsss',
	 *        iconURL: 'stuf/dummy.png',
	 *        list: {
	 *            h1: 'insert Header 1',
	 *            h2: 'insert Header 2',
	 *            clear: 'Empty editor',
	 *        },
	 *        exec: ({originalEvent, control, btn}) => {
	 *             var key = control.args[0],
	 *                value = control.args[1];
	 *             if (key === 'clear') {
	 *                 this.val('');
	 *                 return;
	 *             }
	 *             this.s.insertNode(this.c.element(key, ''));
	 *             this.message.info('Was inserted ' + value);
	 *        },
	 *        template: function (key, value) {
	 *            return '<div>' + value + '</div>';
	 *        }
	 *  });
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "buttons", [
            {
                group: 'font-style',
                buttons: []
            },
            {
                group: 'list',
                buttons: []
            },
            {
                group: 'font',
                buttons: []
            },
            '---',
            {
                group: 'script',
                buttons: []
            },
            {
                group: 'media',
                buttons: []
            },
            '\n',
            {
                group: 'state',
                buttons: []
            },
            {
                group: 'clipboard',
                buttons: []
            },
            {
                group: 'insert',
                buttons: []
            },
            {
                group: 'indent',
                buttons: []
            },
            {
                group: 'color',
                buttons: []
            },
            {
                group: 'form',
                buttons: []
            },
            '---',
            {
                group: 'history',
                buttons: []
            },
            {
                group: 'search',
                buttons: []
            },
            {
                group: 'source',
                buttons: []
            },
            {
                group: 'other',
                buttons: []
            },
            {
                group: 'info',
                buttons: []
            }
        ]);
        /**
	 * Behavior for buttons
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "controls", void 0);
        /**
	 * Some events are called when the editor is initialized, for example, the `afterInit` event.
	 * So this code won't work:
	 * ```javascript
	 * const editor = Jodit.make('#editor');
	 * editor.events.on('afterInit', () => console.log('afterInit'));
	 * ```
	 * You need to do this:
	 * ```javascript
	 * Jodit.make('#editor', {
	 * 		events: {
	 * 	  	afterInit: () => console.log('afterInit')
	 * 		}
	 * });
	 * ```
	 * The option can use any Jodit events, for example:
	 * ```javascript
	 * const editor = Jodit.make('#editor', {
	 * 		events: {
	 * 			hello: (name) => console.log('Hello', name)
	 * 		}
	 * });
	 * editor.e.fire('hello', 'Mike');
	 * ```
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "events", {});
        /**
	 * Buttons in toolbat without SVG - only texts
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "textIcons", false);
        /**
	 * Element for dialog container
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "popupRoot", null);
        /**
	 * shows a INPUT[type=color] to open the browser color picker, on the right bottom of widget color picker
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "showBrowserColorPicker", true);
        Object.assign(this, ConfigPrototype);
    }
}
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(Config, "__defaultOptions", void 0);
ConfigPrototype = Config.prototype;
Config.prototype.controls = {};



/***/ }),

/***/ 5650:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getHash: function() { return /* binding */ getHash; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4040);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/clean-html
 */ 

/**
 * @private
 */ function getHash(tags) {
    const attributesReg = /([^[]*)\[([^\]]+)]/;
    const separator = /[\s]*,[\s]*/, attrReg = /^(.*)[\s]*=[\s]*(.*)$/;
    const tagsHash = {};
    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__.isString)(tags)) {
        tags.split(separator).map((elm)=>{
            elm = (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__.trim)(elm);
            const attr = attributesReg.exec(elm), allowAttributes = {}, attributeMap = (attrName)=>{
                attrName = (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__.trim)(attrName);
                const val = attrReg.exec(attrName);
                if (val) {
                    allowAttributes[val[1]] = val[2];
                } else {
                    allowAttributes[attrName] = true;
                }
            };
            if (attr) {
                const attr2 = attr[2].split(separator);
                if (attr[1]) {
                    attr2.forEach(attributeMap);
                    tagsHash[attr[1].toUpperCase()] = allowAttributes;
                }
            } else {
                tagsHash[elm.toUpperCase()] = true;
            }
        });
        return tagsHash;
    }
    if (tags) {
        Object.keys(tags).forEach((tagName)=>{
            tagsHash[tagName.toUpperCase()] = tags[tagName];
        });
        return tagsHash;
    }
    return false;
}


/***/ }),

/***/ 5658:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UIBlock: function() { return /* reexport safe */ _block_block__WEBPACK_IMPORTED_MODULE_0__.UIBlock; },
/* harmony export */   UICheckbox: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.UICheckbox; },
/* harmony export */   UIFileInput: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.UIFileInput; },
/* harmony export */   UIForm: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_1__.UIForm; },
/* harmony export */   UIInput: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.UIInput; },
/* harmony export */   UISelect: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.UISelect; },
/* harmony export */   UITextArea: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.UITextArea; }
/* harmony export */ });
/* harmony import */ var _block_block__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4561);
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98838);
/* harmony import */ var _inputs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2602);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/form
 */ 




/***/ }),

/***/ 5771:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkRemoveEmptyNeighbor: function() { return /* binding */ checkRemoveEmptyNeighbor; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/backspace
 */ 
/**
 * Check if it is possible to remove an empty adjacent element.
 *
 * @example
 * ```html
 * <p><br></p><p>|second stop</p>
 * ```
 * result
 * ```html
 * <p>|second stop</p>
 * ```
 * @private
 */ function checkRemoveEmptyNeighbor(jodit, fakeNode, backspace) {
    const parent = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(fakeNode, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement, jodit.editor);
    if (!parent) {
        return false;
    }
    const neighbor = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.findNotEmptySibling(parent, backspace);
    if (neighbor && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isEmpty(neighbor)) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(neighbor);
        jodit.s.setCursorBefore(fakeNode);
        return true;
    }
    return false;
}


/***/ }),

/***/ 5772:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToolbarContent: function() { return /* binding */ ToolbarContent; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(59400);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/toolbar/button
 */ 






class ToolbarContent extends jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_5__.UIButton {
    /** @override */ className() {
        return 'ToolbarContent';
    }
    /** @override */ update() {
        const content = this.control.getContent(this.j, this);
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isString)(content) || content.parentNode !== this.container) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.detach(this.container);
            this.container.appendChild((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isString)(content) ? this.j.create.fromHTML(content) : content);
        }
        super.update();
    }
    /** @override */ createContainer() {
        return this.j.c.span(this.componentName);
    }
    constructor(jodit, control, target = null){
        super(jodit), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "control", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "target", void 0), this.control = control, this.target = target;
        this.container.classList.add(`${this.componentName}_${this.clearName(control.name)}`);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(this.container, 'role', 'content');
    }
}
ToolbarContent = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.component
], ToolbarContent);


/***/ }),

/***/ 6209:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToolbarEditorCollection: function() { return /* binding */ ToolbarEditorCollection; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65946);
/* harmony import */ var _collection__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(42573);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/toolbar/collection
 */ 






class ToolbarEditorCollection extends _collection__WEBPACK_IMPORTED_MODULE_6__.ToolbarCollection {
    /** @override */ className() {
        return 'ToolbarEditorCollection';
    }
    /** @override */ shouldBeDisabled(button) {
        const disabled = super.shouldBeDisabled(button);
        if (disabled !== undefined) {
            return disabled;
        }
        const mode = button.control.mode === undefined ? jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.MODE_WYSIWYG : button.control.mode;
        return !(mode === jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.MODE_SPLIT || mode === this.j.getRealMode());
    }
    /** @override */ shouldBeActive(button) {
        const active = super.shouldBeActive(button);
        if (active !== undefined) {
            return active;
        }
        const element = this.j.selection ? this.j.s.current() : null;
        if (!element) {
            return false;
        }
        let elm;
        if (button.control.tags) {
            const tags = button.control.tags;
            elm = element;
            if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.up(elm, (node)=>{
                if (node && tags.indexOf(node.nodeName.toLowerCase()) !== -1) {
                    return true;
                }
            }, this.j.editor)) {
                return true;
            }
        }
        // activate by supposed css
        if (button.control.css) {
            const css = button.control.css;
            elm = element;
            if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.up(elm, (node)=>{
                if (node && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.isText(node) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.isComment(node)) {
                    return this.checkActiveStatus(css, node);
                }
            }, this.j.editor)) {
                return true;
            }
        }
        return false;
    }
    /** @override */ getTarget(button) {
        return button.target || this.j.s.current() || null;
    }
    /**
	 * Adds an invisible element to the container that can handle the
	 * situation when the editor is inside the <label>
	 *
	 * @see https://github.com/jodit/jodit-react/issues/138
	 */ prependInvisibleInput(container) {
        const input = this.j.create.element('input', {
            tabIndex: -1,
            disabled: true,
            style: 'width: 0; height:0; position: absolute; visibility: hidden;'
        });
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.appendChildFirst(container, input);
    }
    /**
	 * Show the inline toolbar inside WYSIWYG editor.
	 * @param bound - you can set the place for displaying the toolbar,
	 * or the place will be in the place of the cursor
	 */ showInline(bound) {
        this.jodit.e.fire('showInlineToolbar', bound);
    }
    hide() {
        this.jodit.e.fire('hidePopup');
        super.hide();
        this.jodit.e.fire('toggleToolbar');
    }
    show() {
        super.show();
        this.jodit.e.fire('toggleToolbar');
    }
    /** @override */ constructor(jodit){
        super(jodit), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "checkActiveStatus", (cssObject, node)=>{
            let matches = 0, total = 0;
            Object.keys(cssObject).forEach((cssProperty)=>{
                const cssValue = cssObject[cssProperty];
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isFunction)(cssValue)) {
                    if (cssValue(this.j, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(node, cssProperty).toString())) {
                        matches += 1;
                    }
                } else {
                    if (cssValue.indexOf((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(node, cssProperty).toString()) !== -1) {
                        matches += 1;
                    }
                }
                total += 1;
            });
            return total === matches;
        });
        this.prependInvisibleInput(this.container);
    }
}
ToolbarEditorCollection = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.component
], ToolbarEditorCollection);


/***/ }),

/***/ 6490:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   required: function() { return /* binding */ required; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4040);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/form
 */ 
/**
 * Select is required
 */ const required = function(select) {
    if (!(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__.trim)(select.value).length) {
        select.error = 'Please fill out this field';
        return false;
    }
    return true;
};


/***/ }),

/***/ 6609:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   htmlspecialchars: function() { return /* binding */ htmlspecialchars; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/html
 */ 
/**
 * Convert special characters to HTML entities
 */ function htmlspecialchars(html) {
    const tmp = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('div');
    tmp.textContent = html;
    return tmp.innerHTML;
}


/***/ }),

/***/ 7018:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   colorToHex: function() { return /* reexport safe */ _color_to_hex__WEBPACK_IMPORTED_MODULE_0__.colorToHex; }
/* harmony export */ });
/* harmony import */ var _color_to_hex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(93387);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/color
 */ 


/***/ }),

/***/ 7433:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41411);
/* harmony import */ var _swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(15366);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4040);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(80991);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(5266);
/* harmony import */ var _icons_font_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(48842);
/* harmony import */ var _icons_font_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_icons_font_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _icons_fontsize_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(25501);
/* harmony import */ var _icons_fontsize_svg__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_icons_fontsize_svg__WEBPACK_IMPORTED_MODULE_8__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/font
 */ 








/**
 * Default font-size points
 */ jodit_config__WEBPACK_IMPORTED_MODULE_6__.Config.prototype.defaultFontSizePoints = 'px';
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_5__.Icon.set('font', (_icons_font_svg__WEBPACK_IMPORTED_MODULE_7___default())).set('fontsize', (_icons_fontsize_svg__WEBPACK_IMPORTED_MODULE_8___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_6__.Config.prototype.controls.fontsize = {
    command: 'fontsize',
    data: {
        cssRule: 'font-size',
        normalise: (v, editor)=>{
            if (/pt$/i.test(v) && editor.o.defaultFontSizePoints === 'pt') {
                return v.replace(/pt$/i, '');
            }
            return v;
        }
    },
    list: [
        8,
        9,
        10,
        11,
        12,
        14,
        16,
        18,
        24,
        30,
        32,
        34,
        36,
        48,
        60,
        72,
        96
    ],
    textTemplate: (editor, value)=>{
        return value + editor.o.defaultFontSizePoints;
    },
    childTemplate: (editor, key, value)=>{
        return `${value}${editor.o.defaultFontSizePoints}`;
    },
    tooltip: 'Font size',
    value: (editor, button)=>{
        var _control_data;
        const current = editor.s.current();
        if (!current) {
            return;
        }
        const box = jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.closest(current, jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.isElement, editor.editor);
        if (!box) {
            return;
        }
        const control = button.control;
        const cssKey = ((_control_data = control.data) === null || _control_data === void 0 ? void 0 : _control_data.cssRule) || 'font-size';
        const value = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_4__.css)(box, cssKey);
        return value.toString();
    },
    isChildActive: (editor, button)=>{
        var _button_control_data;
        const value = button.state.value;
        var _button_control_data_normalize;
        const normalize = (_button_control_data_normalize = (_button_control_data = button.control.data) === null || _button_control_data === void 0 ? void 0 : _button_control_data.normalize) !== null && _button_control_data_normalize !== void 0 ? _button_control_data_normalize : (v)=>v;
        return Boolean(value && button.control.args && normalize(button.control.args[0].toString()) === normalize(value.toString()));
    },
    isActive: (editor, button)=>{
        var _button_control_data;
        const value = button.state.value;
        if (!value) {
            return false;
        }
        var _button_control_data_normalize;
        const normalize = (_button_control_data_normalize = (_button_control_data = button.control.data) === null || _button_control_data === void 0 ? void 0 : _button_control_data.normalize) !== null && _button_control_data_normalize !== void 0 ? _button_control_data_normalize : (v)=>v;
        let keySet = button.control.data.cacheListSet;
        if (!keySet) {
            const keys = Object.keys(button.control.list).map(normalize);
            keySet = new Set(keys);
            button.control.data.cacheListSet = keySet;
        }
        return keySet.has(normalize(value.toString()));
    }
};
jodit_config__WEBPACK_IMPORTED_MODULE_6__.Config.prototype.controls.font = (0,_swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_1__._)((0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_0__._)({}, jodit_config__WEBPACK_IMPORTED_MODULE_6__.Config.prototype.controls.fontsize), {
    command: 'fontname',
    textTemplate: (j, value)=>{
        const [first] = value.split(',');
        return (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__.trimChars)(first, '"\'');
    },
    list: {
        '': 'Default',
        'Arial, Helvetica, sans-serif': 'Arial',
        "'Courier New', Courier, monospace": 'Courier New',
        'Georgia, Palatino, serif': 'Georgia',
        "'Lucida Sans Unicode', 'Lucida Grande', sans-serif": 'Lucida Sans Unicode',
        'Tahoma, Geneva, sans-serif': 'Tahoma',
        "'Times New Roman', Times, serif": 'Times New Roman',
        "'Trebuchet MS', Helvetica, sans-serif": 'Trebuchet MS',
        'Helvetica, sans-serif': 'Helvetica',
        'Impact, Charcoal, sans-serif': 'Impact',
        'Verdana, Geneva, sans-serif': 'Verdana'
    },
    childTemplate: (editor, key, value)=>{
        let isAvailable = false;
        try {
            isAvailable = key.indexOf('dings') === -1 && document.fonts.check(`16px ${key}`, value);
        } catch (e) {}
        return `<span data-style="${key}" style="${isAvailable ? `font-family: ${key}!important;` : ''}">${value}</span>`;
    },
    data: {
        cssRule: 'font-family',
        normalize: (v)=>{
            return v.toLowerCase().replace(/['"]+/g, '').replace(/[^a-z0-9-]+/g, ',');
        }
    },
    tooltip: 'Font family'
});


/***/ }),

/***/ 7470:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   moveTheNodeAlongTheEdgeOutward: function() { return /* binding */ moveTheNodeAlongTheEdgeOutward; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module selection
 */ 
/**
 * Moves the fake node up until it encounters a non-empty sibling on the left(right)
 * @private
 */ function moveTheNodeAlongTheEdgeOutward(node, start, root) {
    let item = node;
    while(item && item !== root){
        const sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.findSibling(item, start);
        if (sibling) {
            return;
        }
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock(item.parentElement)) {
            break;
        }
        item = item.parentElement;
        if (item && item !== root) {
            start ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.before(item, node) : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(item, node);
        }
    }
    return;
}


/***/ }),

/***/ 7909:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   attr: function() { return /* binding */ attr; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28686);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(74264);
/* harmony import */ var _css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80991);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 


/**
 * Alias for `elm.getAttribute` but if set second argument `-{key}`
 * it will also check `data-{key}` attribute
 * if set `value` it is alias for setAttribute with the same logic
 */ function attr(elm, keyOrAttributes, value) {
    if (!elm || !(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__.isFunction)(elm.getAttribute)) {
        return null;
    }
    if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__.isString)(keyOrAttributes)) {
        Object.keys(keyOrAttributes).forEach((key)=>{
            const value = keyOrAttributes[key];
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(value) && key === 'style') {
                (0,_css__WEBPACK_IMPORTED_MODULE_2__.css)(elm, value);
            } else {
                if (key === 'className') {
                    key = 'class';
                }
                attr(elm, key, value);
            }
        });
        return null;
    }
    let key = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_1__.CamelCaseToKebabCase)(keyOrAttributes);
    if (/^-/.test(key)) {
        const res = attr(elm, `data${key}`);
        if (res) {
            return res;
        }
        key = key.substr(1);
    }
    if (value !== undefined) {
        if (value == null) {
            elm.hasAttribute(key) && elm.removeAttribute(key);
        } else {
            let replaceValue = value.toString();
            if (elm.nodeName === 'IMG' && (key === 'width' || key === 'height')) {
                replaceValue = replaceValue.replace('px', '');
            }
            elm.setAttribute(key, replaceValue);
            return replaceValue;
        }
    }
    return elm.getAttribute(key);
}


/***/ }),

/***/ 7994:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export table */
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28077);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48290);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/table/README.md]]
 * @packageDocumentation
 * @module plugins/table
 */ 


function table(editor) {
    editor.registerButton({
        name: 'table',
        group: 'insert'
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__.pluginSystem.add('table', table);


/***/ }),

/***/ 8071:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5266);
/* harmony import */ var jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(15753);
/* harmony import */ var _brush_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45674);
/* harmony import */ var _brush_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_brush_svg__WEBPACK_IMPORTED_MODULE_5__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/color
 */ 





jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__.Icon.set('brush', (_brush_svg__WEBPACK_IMPORTED_MODULE_5___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_3__.Config.prototype.controls.brushCell = {
    isVisible: (editor)=>{
        return !editor.o.disablePlugins.includes('color');
    },
    icon: 'brush',
    popup: (editor, _, close)=>{
        if (!(0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isJoditObject)(editor)) {
            return;
        }
        const tableModule = editor.getInstance('Table', editor.o), selected = tableModule.getAllSelectedCells();
        if (!selected.length) {
            return false;
        }
        const makeColorPicker = (key)=>(0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__.ColorPickerWidget)(editor, (value)=>{
                selected.forEach((cell)=>{
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(cell, key, value);
                });
                editor.lock();
                editor.synchronizeValues();
                close();
                editor.unlock();
            }, (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(selected[0], key));
        return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__.TabsWidget)(editor, [
            {
                name: 'Background',
                content: makeColorPicker('background-color')
            },
            {
                name: 'Text',
                content: makeColorPicker('color')
            },
            {
                name: 'Border',
                content: makeColorPicker('border-color')
            }
        ]);
    },
    tooltip: 'Background'
};
jodit_config__WEBPACK_IMPORTED_MODULE_3__.Config.prototype.controls.brush = {
    isVisible: (editor)=>{
        return !editor.o.disablePlugins.includes('color');
    },
    update (editor, button) {
        const color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color');
        const update = (key, value)=>{
            if (value && value !== (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(editor.editor, key).toString()) {
                button.state.icon.fill = value;
                return;
            }
        };
        if (color) {
            const mode = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color');
            update(mode === 'color' ? mode : 'background-color', color);
            return;
        }
        const current = editor.s.current();
        if (current && !button.state.disabled) {
            const currentBpx = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(current, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement, editor.editor) || editor.editor;
            update('color', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(currentBpx, 'color').toString());
            update('background-color', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(currentBpx, 'background-color').toString());
        }
        button.state.icon.fill = '';
        button.state.activated = false;
    },
    popup: (editor, current, close, button)=>{
        let colorHEX = '', bg_color = '', tabs = [], currentElement = null;
        if (current && current !== editor.editor && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isNode(current)) {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement(current) && editor.s.isCollapsed() && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(current, new Set([
                'br',
                'hr'
            ]))) {
                currentElement = current;
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.up(current, (node)=>{
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isHTMLElement(node)) {
                    const color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(node, 'color', true), background = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(node, 'background-color', true);
                    if (color) {
                        colorHEX = color.toString();
                        return true;
                    }
                    if (background) {
                        bg_color = background.toString();
                        return true;
                    }
                }
            }, editor.editor);
        }
        const backgroundTag = (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__.ColorPickerWidget)(editor, (value)=>{
            if (!currentElement) {
                editor.execCommand('background', false, value);
            } else {
                currentElement.style.backgroundColor = value;
            }
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color', value);
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color-mode', 'background');
            close();
        }, bg_color);
        const colorTab = (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__.ColorPickerWidget)(editor, (value)=>{
            if (!currentElement) {
                editor.execCommand('forecolor', false, value);
            } else {
                currentElement.style.color = value;
            }
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color', value);
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color-mode', 'color');
            close();
        }, colorHEX);
        tabs = [
            {
                name: 'Background',
                content: backgroundTag
            },
            {
                name: 'Text',
                content: colorTab
            }
        ];
        if (editor.o.colorPickerDefaultTab !== 'background') {
            tabs = tabs.reverse();
        }
        return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__.TabsWidget)(editor, tabs, currentElement);
    },
    exec (jodit, current, { button }) {
        const mode = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color-mode'), color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color');
        if (!mode) {
            return false;
        }
        if (current && current !== jodit.editor && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isNode(current) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement(current)) {
            switch(mode){
                case 'color':
                    current.style.color = color;
                    break;
                case 'background':
                    current.style.backgroundColor = color;
                    break;
            }
        } else {
            jodit.execCommand(mode === 'background' ? mode : 'forecolor', false, color);
        }
    },
    tooltip: 'Fill color or set the text color'
};


/***/ }),

/***/ 8105:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AceEditor: function() { return /* reexport safe */ _ace__WEBPACK_IMPORTED_MODULE_0__.AceEditor; },
/* harmony export */   TextAreaEditor: function() { return /* reexport safe */ _area__WEBPACK_IMPORTED_MODULE_1__.TextAreaEditor; }
/* harmony export */ });
/* harmony import */ var _ace__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94978);
/* harmony import */ var _area__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45844);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/source
 */ 
 // export * from "./custom"; // You can add here another source editor


/***/ }),

/***/ 8136:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1792 1344v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-1280q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1280q26 0 45 19t19 45zm256-384v128q0 26-19 45t-45 19h-1536q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1536q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-1152q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1152q26 0 45 19t19 45z\"/> </svg>"

/***/ }),

/***/ 8524:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkUnsplittableBox: function() { return /* binding */ checkUnsplittableBox; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/enter
 */ 
/**
 * Inside quote/tables cell, etc. you can't split so just add br
 * @private
 */ function checkUnsplittableBox(fake, jodit, currentBox) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.canSplitBlock(currentBox)) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.before(fake, jodit.createInside.element('br'));
        return false;
    }
    return true;
}


/***/ }),

/***/ 8837:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   onTabInsideLi: function() { return /* binding */ onTabInsideLi; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/tab
 */ 

/**
 * Checks if the cursor is at the beginning of the LI element when tabbed.
 * If so then add an internal list
 * @private
 */ function onTabInsideLi(jodit, shift = false) {
    if (!jodit.o.tab.tabInsideLiInsertNewList) {
        return false;
    }
    const [fake, fake2] = fakeCursors(jodit);
    try {
        const li = getParentLeaf(jodit, fake, shift);
        if (!li) {
            return false;
        }
        if (!isSameLeftCursorPosition(li, jodit, fake)) {
            return false;
        }
        const list = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(li, [
            'ol',
            'ul'
        ], jodit.editor);
        if (!list || shift && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(list, 'li', jodit.editor)) {
            return false;
        }
        if (!shift) {
            appendNestedList(jodit, list, li);
        } else {
            removeNestedList(jodit, list, li);
        }
        return true;
    } finally{
        const range = jodit.s.createRange();
        range.setStartAfter(fake);
        range.setEndBefore(fake2);
        jodit.s.selectRange(range);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(fake);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(fake2);
    }
    // removed by dead control flow

}
function fakeCursors(jodit) {
    const fake = jodit.createInside.fake();
    const fake2 = jodit.createInside.fake();
    const r = jodit.s.range.cloneRange();
    r.collapse(true);
    r.insertNode(fake);
    const r2 = jodit.s.range.cloneRange();
    r2.collapse(false);
    r2.insertNode(fake2);
    return [
        fake,
        fake2
    ];
}
function getParentLeaf(jodit, fake, shift) {
    const li = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(fake, 'li', jodit.editor);
    if (!li) {
        return false;
    }
    if (!shift && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isLeaf(li.previousElementSibling)) {
        return false;
    }
    if (shift && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(li, 'li', jodit.editor)) {
        return false;
    }
    return li;
}
function isSameLeftCursorPosition(li, jodit, fake) {
    const li2 = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(fake, 'li', jodit.editor);
    return !(!li2 || li2 !== li && !li.contains(li2));
}
function appendNestedList(jodit, list, li) {
    const previousLi = li.previousElementSibling;
    (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__.assert)(previousLi, 'tab previousElementSibling is null');
    const lastElm = previousLi.lastElementChild;
    const newList = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(lastElm, list.tagName) ? lastElm : jodit.createInside.element(list.tagName, Array.from(list.attributes).reduce((acc, attr)=>{
        acc[attr.name] = attr.value;
        return acc;
    }, {}));
    newList.appendChild(li);
    lastElm !== newList && previousLi.appendChild(newList);
}
function removeNestedList(jodit, list, li) {
    const parentLi = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(list, 'li', jodit.editor);
    (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__.assert)(parentLi, 'tab parent li is null');
    const items = Array.from(list.children).filter((t)=>jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isLeaf(t));
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(parentLi, li);
    const index = items.indexOf(li);
    if (index === 0 || items.length === 1) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(list);
    }
    if (index !== items.length - 1) {
        const clone = list.cloneNode();
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.append(li, clone);
        for(let i = index + 1; i < items.length; i += 1){
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.append(clone, items[i]);
        }
    }
}


/***/ }),

/***/ 8838:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Command: function() { return /* binding */ Command; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/history
 */ 
class Command {
    undo() {
        this.history.snapshot.restore(this.oldValue);
    }
    redo() {
        this.history.snapshot.restore(this.newValue);
    }
    constructor(oldValue, newValue, history, tick){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "oldValue", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "newValue", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "history", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "tick", void 0);
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.history = history;
        this.tick = tick;
    }
}


/***/ }),

/***/ 8908:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   form: function() { return /* binding */ form; }
/* harmony export */ });
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4099);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/image-editor
 */ 
const jie = 'jodit-image-editor';
const gi = jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__.Icon.get.bind(jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__.Icon);
const act = (el, className = 'jodti-image-editor_active')=>el ? className : '';
const form = (editor, o)=>{
    const i = editor.i18n.bind(editor);
    const switcher = (label, ref, active = true)=>`<div class="jodit-form__group">
			<label class="jodit-switcher-wrapper">
				<span class='jodit-switcher'>
					<input ${act(active, 'checked')} data-ref="${ref}" type="checkbox"/>
					<span class="jodit-switcher__slider"></span>
				</span>
				<span>${i(label)}</span>
			</label>
	</div>`;
    return editor.create.fromHTML(`<form class="${jie} jodit-properties">
		<div class="jodit-grid jodit-grid_xs-column">
			<div class="jodit_col-lg-3-4 jodit_col-sm-5-5">
			${o.resize ? `<div class="${jie}__area ${jie}__area_resize ${jie}_active">
							<div data-ref="resizeBox" class="${jie}__box"></div>
							<div class="${jie}__resizer">
								<i class="jodit_bottomright"></i>
							</div>
						</div>` : ''}
			${o.crop ? `<div class="${jie}__area ${jie}__area_crop ${act(!o.resize)}">
							<div data-ref="cropBox" class="${jie}__box">
								<div class="${jie}__croper">
									<i class="jodit_bottomright"></i>
									<i class="${jie}__sizes"></i>
								</div>
							</div>
						</div>` : ''}
			</div>
			<div class="jodit_col-lg-1-4 jodit_col-sm-5-5">
			${o.resize ? `<div data-area="resize" class="${jie}__slider ${jie}_active">
							<div class="${jie}__slider-title">
								${gi('resize')}
								${i('Resize')}
							</div>
							<div class="${jie}__slider-content">
								<div class="jodit-form__group">
									<label>
										${i('Width')}
									</label>
									<input type="number" data-ref="widthInput" class="jodit-input"/>
								</div>
								<div class="jodit-form__group">
									<label>
										${i('Height')}
									</label>
									<input type="number" data-ref="heightInput" class="jodit-input"/>
								</div>
								${switcher('Keep Aspect Ratio', 'keepAspectRatioResize')}
							</div>
						</div>` : ''}
			${o.crop ? `<div data-area="crop" class="${jie}__slider ${act(!o.resize)}'">
							<div class="${jie}__slider-title">
								${gi('crop')}
								${i('Crop')}
							</div>
							<div class="${jie}__slider-content">
								${switcher('Keep Aspect Ratio', 'keepAspectRatioCrop')}
							</div>
						</div>` : ''}
			</div>
		</div>
	</form>`);
};


/***/ }),

/***/ 9103:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M553 1399l-50 50q-10 10-23 10t-23-10l-466-466q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l50 50q10 10 10 23t-10 23l-393 393 393 393q10 10 10 23t-10 23zm591-1067l-373 1291q-4 13-15.5 19.5t-23.5 2.5l-62-17q-13-4-19.5-15.5t-2.5-24.5l373-1291q4-13 15.5-19.5t23.5-2.5l62 17q13 4 19.5 15.5t2.5 24.5zm657 651l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23t-10 23z\"/> </svg>"

/***/ }),

/***/ 9505:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MemoryStorageProvider: function() { return /* binding */ MemoryStorageProvider; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module storage
 */ 
class MemoryStorageProvider {
    set(key, value) {
        this.data.set(key, value);
        return this;
    }
    delete(key) {
        this.data.delete(key);
        return this;
    }
    get(key) {
        return this.data.get(key);
    }
    exists(key) {
        return this.data.has(key);
    }
    clear() {
        this.data.clear();
        return this;
    }
    constructor(){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "data", new Map());
    }
}


/***/ }),

/***/ 9703:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasSameStyle: function() { return /* binding */ hasSameStyle; },
/* harmony export */   hasSameStyleKeys: function() { return /* binding */ hasSameStyleKeys; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18303);
/* harmony import */ var jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19147);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(80991);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 





/**
 * Element has the same styles as in the commit
 * @private
 */ function hasSameStyle(elm, rules) {
    return Boolean(!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(elm, 'font') && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isHTMLElement(elm) && Object.keys(rules).every((property)=>{
        const value = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_5__.css)(elm, property, true);
        if (value === '' && (rules[property] === '' || rules[property] == null)) {
            return true;
        }
        return !(0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_2__.isVoid)(value) && value !== '' && !(0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_2__.isVoid)(rules[property]) && (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_3__.normalizeCssValue)(property, rules[property]).toString().toLowerCase() === value.toString().toLowerCase();
    }));
}
if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument) {
    const elm = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('div');
    elm.style.color = 'red';
    (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__.assert)(hasSameStyle(elm, {
        color: 'red'
    }), 'Style test');
    (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__.assert)(hasSameStyle(elm, {
        fontSize: null
    }), 'Style test');
    (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__.assert)(hasSameStyle(elm, {
        fontSize: ''
    }), 'Style test');
}
/**
 * Element has the similar styles keys
 */ function hasSameStyleKeys(elm, rules) {
    return Boolean(!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(elm, 'font') && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isHTMLElement(elm) && Object.keys(rules).every((property)=>{
        const value = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_5__.css)(elm, property, true);
        return value !== '';
    }));
}
if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument) {
    const elm2 = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('div');
    elm2.style.color = 'red';
    (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__.assert)(hasSameStyleKeys(elm2, {
        color: 'red'
    }), 'Style test');
    (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__.assert)(!hasSameStyleKeys(elm2, {
        font: 'Arial',
        color: 'red'
    }), 'Style test');
    (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__.assert)(!hasSameStyleKeys(elm2, {
        border: '1px solid #ccc'
    }), 'Style test');
}


/***/ }),

/***/ 10081:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UIMessages: function() { return /* binding */ UIMessages; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(91672);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80991);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63468);
/* harmony import */ var jodit_modules_messages_message__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61466);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/messages/README.md]]
 * @packageDocumentation
 * @module modules/messages
 */ 






class UIMessages extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_4__.UIGroup {
    className() {
        return 'UIMessages';
    }
    /**
	 * Show popup info message in the lower right corner of the container
	 * ```js
	 * const jodit = Jodit.make('#editor');
	 * jodit.info('Hello world', 3000);
	 * ```
	 */ info(text, timeout) {
        this.__message(text, 'info', timeout);
    }
    /**
	 * Show popup success message in the lower right corner of the container
	 * ```js
	 * const jodit = Jodit.make('#editor');
	 * jodit.success('Hello world', 3000);
	 * ```
	 */ success(text, timeout) {
        this.__message(text, 'success', timeout);
    }
    /**
	 * Show popup error message in the lower right corner of the container
	 * ```js
	 * const jodit = Jodit.make('#editor');
	 * jodit.error('Hello world', 3000);
	 * ```
	 */ error(text, timeout) {
        this.__message(text, 'error', timeout);
    }
    /**
	 * Show popup message in the lower right corner of the container
	 * ```js
	 * const jodit = Jodit.make('#editor');
	 * jodit.message('Hello world', 'info', 3000);
	 * ```
	 */ message(text, variant, timeout) {
        this.__message(text, variant, timeout);
    }
    __message(text, variant = 'info', timeout) {
        const key = text + ':' + variant;
        if (this.__messages.has(key)) {
            this.async.updateTimeout(key, timeout || this.options.defaultTimeout);
            return;
        }
        if (!this.__box) {
            throw new Error('Container is not defined: ' + key);
        }
        this.__box.appendChild(this.container);
        const msg = new jodit_modules_messages_message__WEBPACK_IMPORTED_MODULE_5__.UIMessage(this.j, {
            text,
            variant
        });
        this.append(msg);
        this.__calcOffsets();
        this.__messages.add(key);
        const remove = this.__getRemoveCallback(msg, key);
        this.j.e.on(msg.container, 'pointerdown', remove);
        this.async.setTimeout(remove, {
            label: key,
            timeout: timeout || this.options.defaultTimeout
        });
    }
    __getRemoveCallback(msg, key) {
        const remove = (e)=>{
            e && e.preventDefault();
            if (msg.isInDestruct) {
                return;
            }
            this.async.clearTimeout(key);
            this.j.e.off(msg.container, 'pointerdown', remove);
            this.__messages.delete(key);
            msg.setMod('active', false);
            this.async.setTimeout(()=>{
                this.remove(msg);
                msg.destruct();
                this.__calcOffsets();
            }, 300);
        };
        return remove;
    }
    __calcOffsets() {
        let height = 5;
        this.elements.forEach((elm)=>{
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__.css)(elm.container, 'bottom', height + 'px');
            height += elm.container.offsetHeight + this.options.defaultOffset;
        });
    }
    constructor(jodit, __box, options = {
        defaultTimeout: 3000,
        defaultOffset: 5
    }){
        super(jodit), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__box", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "options", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__messages", void 0), this.__box = __box, this.options = options, this.__messages = new Set();
    }
}
UIMessages = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__.component
], UIMessages);


/***/ }),

/***/ 10099:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    symbols: 'symbol'
};


/***/ }),

/***/ 10157:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkUnwrapFirstListItem: function() { return /* binding */ checkUnwrapFirstListItem; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93640);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/backspace
 */ 

/**
 * For the first item in a list on backspace, try to move his content in new P
 *
 * @example
 * ```html
 * <ul><li>|first</li><li>second</li></ul>
 * ```
 * Result
 * ```html
 * <p>|first</p><ul><li>second</li></ul>
 * ```
 *
 * @private
 */ function checkUnwrapFirstListItem(jodit, fakeNode, backspace) {
    var _li_parentElement;
    const li = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(fakeNode, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement, jodit.editor);
    const { s } = jodit;
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isLeaf(li) && (li === null || li === void 0 ? void 0 : (_li_parentElement = li.parentElement) === null || _li_parentElement === void 0 ? void 0 : _li_parentElement[backspace ? 'firstElementChild' : 'lastElementChild']) === li && s.cursorInTheEdge(backspace, li)) {
        const ul = li.parentElement;
        const p = jodit.createInside.element(jodit.o.enterBlock);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.call)(backspace ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.before : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after, ul, p);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.moveContent(li, p);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(li);
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isEmpty(ul)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(ul);
        }
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.call)(backspace ? s.setCursorBefore : s.setCursorAfter, fakeNode);
        return true;
    }
    return false;
}


/***/ }),

/***/ 10171:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getSuitChild: function() { return /* binding */ getSuitChild; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var _is_normal_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83653);
/* harmony import */ var _is_suit_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(73019);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 


/**
 * Checks if child elements are suitable for applying styles.
 * An element is suitable for us only if it is the only significant child.
 * If the child matches then returns it.
 * @example
 * `<font><strong>selected</strong></font>`
 * @private
 */ function getSuitChild(style, font) {
    let { firstChild: child } = font;
    while(child && !(0,_is_normal_node__WEBPACK_IMPORTED_MODULE_1__.isNormalNode)(child)){
        child = child.nextSibling;
        if (!child) {
            return null;
        }
    }
    if (child && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.next(child, _is_normal_node__WEBPACK_IMPORTED_MODULE_1__.isNormalNode, font) && (0,_is_suit_element__WEBPACK_IMPORTED_MODULE_2__.isSuitElement)(style, child, false)) {
        return child;
    }
    return null;
}


/***/ }),

/***/ 10685:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5266);
/* harmony import */ var _enter_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86634);
/* harmony import */ var _enter_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_enter_svg__WEBPACK_IMPORTED_MODULE_2__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/add-new-line
 */ 


jodit_config__WEBPACK_IMPORTED_MODULE_1__.Config.prototype.addNewLine = true;
jodit_config__WEBPACK_IMPORTED_MODULE_1__.Config.prototype.addNewLineOnDBLClick = true;
jodit_config__WEBPACK_IMPORTED_MODULE_1__.Config.prototype.addNewLineTagsTriggers = [
    'table',
    'iframe',
    'img',
    'hr',
    'pre',
    'jodit'
];
jodit_config__WEBPACK_IMPORTED_MODULE_1__.Config.prototype.addNewLineDeltaShow = 20;
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__.Icon.set('enter', (_enter_svg__WEBPACK_IMPORTED_MODULE_2___default()));


/***/ }),

/***/ 10808:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalSizeFromString: function() { return /* binding */ normalSizeFromString; },
/* harmony export */   normalSizeToString: function() { return /* binding */ normalSizeToString; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_number__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(72412);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4040);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 

/** @private */ const normalSizeFromString = (value)=>{
    return /^[-+]?[0-9.]+(px)?$/.test(value.toString()) ? parseFloat(value.toString()) : value;
};
/** @private */ const normalSizeToString = (value)=>{
    if ((0,jodit_core_helpers_checker_is_number__WEBPACK_IMPORTED_MODULE_0__.isNumber)(value)) {
        return value ? value + 'px' : value.toString();
    }
    value = (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__.trim)(value);
    return /^[0-9]+$/.test(value) ? value + 'px' : value;
};


/***/ }),

/***/ 10918:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkBR: function() { return /* reexport safe */ _check_br__WEBPACK_IMPORTED_MODULE_0__.checkBR; },
/* harmony export */   checkUnsplittableBox: function() { return /* reexport safe */ _check_unsplittable_box__WEBPACK_IMPORTED_MODULE_1__.checkUnsplittableBox; },
/* harmony export */   getBlockWrapper: function() { return /* reexport safe */ _get_block_wrapper__WEBPACK_IMPORTED_MODULE_2__.getBlockWrapper; },
/* harmony export */   hasPreviousBlock: function() { return /* reexport safe */ _has_previous_block__WEBPACK_IMPORTED_MODULE_3__.hasPreviousBlock; },
/* harmony export */   insertParagraph: function() { return /* reexport safe */ _insert_paragraph__WEBPACK_IMPORTED_MODULE_4__.insertParagraph; },
/* harmony export */   moveCursorOutFromSpecialTags: function() { return /* reexport safe */ _move_cursor_out_from_specal_tags__WEBPACK_IMPORTED_MODULE_5__.moveCursorOutFromSpecialTags; },
/* harmony export */   processEmptyLILeaf: function() { return /* reexport safe */ _process_empty_li_leaf__WEBPACK_IMPORTED_MODULE_6__.processEmptyLILeaf; },
/* harmony export */   splitFragment: function() { return /* reexport safe */ _split_fragment__WEBPACK_IMPORTED_MODULE_7__.splitFragment; },
/* harmony export */   wrapText: function() { return /* reexport safe */ _wrap_text__WEBPACK_IMPORTED_MODULE_8__.wrapText; }
/* harmony export */ });
/* harmony import */ var _check_br__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34287);
/* harmony import */ var _check_unsplittable_box__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8524);
/* harmony import */ var _get_block_wrapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83376);
/* harmony import */ var _has_previous_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66862);
/* harmony import */ var _insert_paragraph__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65710);
/* harmony import */ var _move_cursor_out_from_specal_tags__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(47919);
/* harmony import */ var _process_empty_li_leaf__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(34672);
/* harmony import */ var _split_fragment__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(46303);
/* harmony import */ var _wrap_text__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(52938);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/enter
 */ 










/***/ }),

/***/ 11018:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export cleanHtml */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_dom_lazy_walker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1080);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers_html_safe_html__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(48155);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(18855);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(11173);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(54053);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/clean-html/README.md]]
 * @packageDocumentation
 * @module plugins/clean-html
 */ 









/**
 * Clean HTML after removeFormat and insertHorizontalRule command
 */ class cleanHtml extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_7__.Plugin {
    /** @override */ afterInit(jodit) {}
    get isEditMode() {
        return !(this.j.isInDestruct || !this.j.isEditorMode() || this.j.getReadOnly());
    }
    /**
	 * Clean HTML code on every change
	 */ onChangeCleanHTML() {
        if (!this.isEditMode) {
            return;
        }
        const editor = this.j;
        this.walker.setWork(editor.editor);
        this.currentSelectionNode = editor.s.current();
    }
    startWalker() {
        const { jodit } = this;
        const allow = (0,_helpers__WEBPACK_IMPORTED_MODULE_9__.getHash)(this.j.o.cleanHTML.allowTags);
        const deny = (0,_helpers__WEBPACK_IMPORTED_MODULE_9__.getHash)(this.j.o.cleanHTML.denyTags);
        this.walker.on('visit', (node)=>(0,_helpers__WEBPACK_IMPORTED_MODULE_9__.visitNodeWalker)(jodit, node, allow, deny, this.currentSelectionNode)).on('end', (affected)=>{
            this.j.e.fire(affected ? 'internalChange finishedCleanHTMLWorker' : 'finishedCleanHTMLWorker');
        });
    }
    beforeCommand(command) {
        if (command.toLowerCase() === 'removeformat') {
            if (this.j.s.isCollapsed()) {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_9__.removeFormatForCollapsedSelection)(this.j);
            } else {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_9__.removeFormatForSelection)(this.j);
            }
            return false;
        }
    }
    /**
	 * Event handler when manually assigning a value to the HTML editor.
	 */ onBeforeSetNativeEditorValue(data) {
        const [sandBox, iframe] = this.j.o.cleanHTML.useIframeSandbox ? this.j.createInside.sandbox() : [
            this.j.createInside.div()
        ];
        sandBox.innerHTML = data.value;
        this.onSafeHTML(sandBox);
        data.value = sandBox.innerHTML;
        (0,jodit_core_helpers_html_safe_html__WEBPACK_IMPORTED_MODULE_6__.safeHTML)(sandBox, {
            safeJavaScriptLink: true,
            removeOnError: true
        });
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.safeRemove(iframe);
        return false;
    }
    onSafeHTML(sandBox) {
        (0,jodit_core_helpers_html_safe_html__WEBPACK_IMPORTED_MODULE_6__.safeHTML)(sandBox, this.j.o.cleanHTML);
    }
    /** @override */ beforeDestruct() {
        this.walker.destruct();
    }
    constructor(...args){
        super(...args), /** @override */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "buttons", [
            {
                name: 'eraser',
                group: 'font-style'
            }
        ]), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "currentSelectionNode", null), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "walker", new jodit_core_dom_lazy_walker__WEBPACK_IMPORTED_MODULE_4__.LazyWalker(this.j.async, {
            timeout: this.j.o.cleanHTML.timeout
        }));
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)([
        ':change',
        ':afterSetMode',
        ':afterInit',
        ':mousedown',
        ':keydown'
    ])
], cleanHtml.prototype, "onChangeCleanHTML", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.hook)('ready')
], cleanHtml.prototype, "startWalker", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)(':beforeCommand')
], cleanHtml.prototype, "beforeCommand", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)(':beforeSetNativeEditorValue')
], cleanHtml.prototype, "onBeforeSetNativeEditorValue", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)(':safeHTML')
], cleanHtml.prototype, "onSafeHTML", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_5__.pluginSystem.add('cleanHtml', cleanHtml);


/***/ }),

/***/ 11080:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OptionsError: function() { return /* binding */ OptionsError; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ class OptionsError extends TypeError {
    constructor(m){
        super(m);
        Object.setPrototypeOf(this, OptionsError.prototype);
    }
}


/***/ }),

/***/ 11173:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5266);
/* harmony import */ var _eraser_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71948);
/* harmony import */ var _eraser_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_eraser_svg__WEBPACK_IMPORTED_MODULE_2__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/clean-html
 */ 


jodit_config__WEBPACK_IMPORTED_MODULE_1__.Config.prototype.cleanHTML = {
    timeout: 300,
    removeEmptyElements: true,
    fillEmptyParagraph: true,
    replaceNBSP: true,
    replaceOldTags: {
        i: 'em',
        b: 'strong'
    },
    allowTags: false,
    denyTags: 'script',
    useIframeSandbox: false,
    removeOnError: true,
    safeJavaScriptLink: true,
    disableCleanFilter: null
};
jodit_config__WEBPACK_IMPORTED_MODULE_1__.Config.prototype.controls.eraser = {
    command: 'removeFormat',
    tooltip: 'Clear Formatting'
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__.Icon.set('eraser', (_eraser_svg__WEBPACK_IMPORTED_MODULE_2___default()));


/***/ }),

/***/ 11774:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export symbols */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(93640);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(18855);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(18993);
/* harmony import */ var _langs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(91017);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/symbols/README.md]]
 * @packageDocumentation
 * @module plugins/symbols
 */ 








/**
 * The plugin inserts characters that are not part of the standard keyboard.
 */ class symbols extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__.Plugin {
    afterInit(jodit) {
        jodit.e.on('generateSpecialCharactersTable.symbols', ()=>{
            const container = jodit.c.fromHTML(`<div class="jodit-symbols__container">
						<div class="jodit-symbols__container_table">
							<table class="jodit-symbols__table"><tbody></tbody></table>
						</div>
						<div class="jodit-symbols__container_preview">
							<div class="jodit-symbols__preview"></div>
						</div>
					</div>`);
            const preview = container.querySelector('.jodit-symbols__preview');
            const table = container.querySelector('table');
            const body = table.tBodies[0];
            const chars = [];
            for(let i = 0; i < jodit.o.specialCharacters.length;){
                const tr = jodit.c.element('tr');
                for(let j = 0; j < this.__countInRow && i < jodit.o.specialCharacters.length; j += 1, i += 1){
                    const td = jodit.c.element('td'), a = jodit.c.fromHTML(`<a
									data-index="${i}"
									data-index-j="${j}"
									role="option"
									tabindex="-1"
							>${jodit.o.specialCharacters[i]}</a>`);
                    chars.push(a);
                    td.appendChild(a);
                    tr.appendChild(td);
                }
                body.appendChild(tr);
            }
            const self = this;
            jodit.e.on(chars, 'focus', function() {
                preview.innerHTML = this.innerHTML;
            }).on(chars, 'mousedown', function(e) {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.isTag(this, 'a')) {
                    jodit.s.focus();
                    jodit.s.insertHTML(this.innerHTML);
                    if (!(e === null || e === void 0 ? void 0 : e.shiftKey)) {
                        jodit.e.fire(this, 'close_dialog');
                    }
                    e && e.preventDefault();
                    e && e.stopImmediatePropagation();
                }
            }).on(chars, 'mouseenter', function() {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.isTag(this, 'a')) {
                    this.focus();
                }
            }).on(chars, 'keydown', (e)=>{
                const target = e.target;
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.isTag(target, 'a')) {
                    const index = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(target, '-index') || '0', 10), jIndex = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(target, 'data-index-j') || '0', 10);
                    let newIndex;
                    switch(e.key){
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_UP:
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_DOWN:
                            newIndex = e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_UP ? index - self.__countInRow : index + self.__countInRow;
                            if (chars[newIndex] === undefined) {
                                newIndex = e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_UP ? Math.floor(chars.length / self.__countInRow) * self.__countInRow + jIndex : jIndex;
                                if (newIndex > chars.length - 1) {
                                    newIndex -= self.__countInRow;
                                }
                            }
                            chars[newIndex] && chars[newIndex].focus();
                            break;
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_RIGHT:
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_LEFT:
                            newIndex = e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_LEFT ? index - 1 : index + 1;
                            if (chars[newIndex] === undefined) {
                                newIndex = e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_LEFT ? chars.length - 1 : 0;
                            }
                            chars[newIndex] && chars[newIndex].focus();
                            break;
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_ENTER:
                            jodit.e.fire(target, 'mousedown');
                            e.stopImmediatePropagation();
                            e.preventDefault();
                            break;
                    }
                }
            });
            return container;
        });
    }
    /** @override */ beforeDestruct(jodit) {
        jodit.e.off('generateSpecialCharactersTable.symbols');
    }
    constructor(jodit){
        super(jodit), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "buttons", [
            {
                name: 'symbols',
                group: 'insert'
            }
        ]), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__countInRow", 17);
        (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_3__.extendLang)(_langs__WEBPACK_IMPORTED_MODULE_7__);
    }
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_3__.pluginSystem.add('symbols', symbols);


/***/ }),

/***/ 11917:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getKey: function() { return /* binding */ getKey; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/indent
 */ 
/**
 * Get style rule key for current direction
 * @internal
 */ const getKey = (direction, box)=>`${jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isCell(box) ? 'padding' : 'margin'}${direction === 'rtl' ? 'Right' : 'Left'}`;


/***/ }),

/***/ 11981:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ajaxInstances: function() { return /* reexport safe */ _send__WEBPACK_IMPORTED_MODULE_2__.ajaxInstances; },
/* harmony export */   hasFiles: function() { return /* binding */ hasFiles; },
/* harmony export */   hasItems: function() { return /* binding */ hasItems; },
/* harmony export */   processOldBrowserDrag: function() { return /* reexport safe */ _process_old_browser_drag__WEBPACK_IMPORTED_MODULE_1__.processOldBrowserDrag; },
/* harmony export */   send: function() { return /* reexport safe */ _send__WEBPACK_IMPORTED_MODULE_2__.send; },
/* harmony export */   sendFiles: function() { return /* reexport safe */ _send_files__WEBPACK_IMPORTED_MODULE_3__.sendFiles; }
/* harmony export */ });
/* harmony import */ var _build_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(89446);
/* harmony import */ var _process_old_browser_drag__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(95436);
/* harmony import */ var _send__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(77911);
/* harmony import */ var _send_files__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46533);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/uploader
 */ 




function hasFiles(data) {
    return Boolean(data && data.files && data.files.length > 0);
}
function hasItems(data) {
    return Boolean(data && data.items && data.items.length > 0);
}


/***/ }),

/***/ 12443:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkTableCell: function() { return /* binding */ checkTableCell; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/backspace
 */ 
/**
 * Inside the CELL table - nothing to do
 *
 * @example
 * ```html
 * <table><tr><td>|test</td></tr></table>
 * ```
 * result
 * ```html
 * <table><tr><td>|test</td></tr></table>
 * ```
 *
 * @private
 */ function checkTableCell(jodit, fakeNode) {
    const cell = fakeNode.parentElement;
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isCell(cell)) {
        return true;
    }
    return false;
}


/***/ }),

/***/ 13564:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   angle_down: function() { return /* reexport default from dynamic */ _angle_down_svg__WEBPACK_IMPORTED_MODULE_0___default.a; },
/* harmony export */   angle_left: function() { return /* reexport default from dynamic */ _angle_left_svg__WEBPACK_IMPORTED_MODULE_1___default.a; },
/* harmony export */   angle_right: function() { return /* reexport default from dynamic */ _angle_right_svg__WEBPACK_IMPORTED_MODULE_2___default.a; },
/* harmony export */   angle_up: function() { return /* reexport default from dynamic */ _angle_up_svg__WEBPACK_IMPORTED_MODULE_3___default.a; },
/* harmony export */   bin: function() { return /* reexport default from dynamic */ _bin_svg__WEBPACK_IMPORTED_MODULE_4___default.a; },
/* harmony export */   cancel: function() { return /* reexport default from dynamic */ _cancel_svg__WEBPACK_IMPORTED_MODULE_5___default.a; },
/* harmony export */   center: function() { return /* reexport default from dynamic */ _center_svg__WEBPACK_IMPORTED_MODULE_6___default.a; },
/* harmony export */   check: function() { return /* reexport default from dynamic */ _check_svg__WEBPACK_IMPORTED_MODULE_7___default.a; },
/* harmony export */   chevron: function() { return /* reexport default from dynamic */ _chevron_svg__WEBPACK_IMPORTED_MODULE_8___default.a; },
/* harmony export */   dots: function() { return /* reexport default from dynamic */ _dots_svg__WEBPACK_IMPORTED_MODULE_9___default.a; },
/* harmony export */   eye: function() { return /* reexport default from dynamic */ _eye_svg__WEBPACK_IMPORTED_MODULE_10___default.a; },
/* harmony export */   file: function() { return /* reexport default from dynamic */ _file_svg__WEBPACK_IMPORTED_MODULE_11___default.a; },
/* harmony export */   folder: function() { return /* reexport default from dynamic */ _folder_svg__WEBPACK_IMPORTED_MODULE_12___default.a; },
/* harmony export */   info_circle: function() { return /* reexport default from dynamic */ _info_circle_svg__WEBPACK_IMPORTED_MODULE_13___default.a; },
/* harmony export */   left: function() { return /* reexport default from dynamic */ _left_svg__WEBPACK_IMPORTED_MODULE_14___default.a; },
/* harmony export */   lock: function() { return /* reexport default from dynamic */ _lock_svg__WEBPACK_IMPORTED_MODULE_15___default.a; },
/* harmony export */   ok: function() { return /* reexport default from dynamic */ _ok_svg__WEBPACK_IMPORTED_MODULE_16___default.a; },
/* harmony export */   pencil: function() { return /* reexport default from dynamic */ _pencil_svg__WEBPACK_IMPORTED_MODULE_17___default.a; },
/* harmony export */   plus: function() { return /* reexport default from dynamic */ _plus_svg__WEBPACK_IMPORTED_MODULE_18___default.a; },
/* harmony export */   resize_handler: function() { return /* reexport default from dynamic */ _resize_handler_svg__WEBPACK_IMPORTED_MODULE_19___default.a; },
/* harmony export */   right: function() { return /* reexport default from dynamic */ _right_svg__WEBPACK_IMPORTED_MODULE_20___default.a; },
/* harmony export */   save: function() { return /* reexport default from dynamic */ _save_svg__WEBPACK_IMPORTED_MODULE_21___default.a; },
/* harmony export */   settings: function() { return /* reexport default from dynamic */ _settings_svg__WEBPACK_IMPORTED_MODULE_22___default.a; },
/* harmony export */   unlock: function() { return /* reexport default from dynamic */ _unlock_svg__WEBPACK_IMPORTED_MODULE_23___default.a; },
/* harmony export */   update: function() { return /* reexport default from dynamic */ _update_svg__WEBPACK_IMPORTED_MODULE_24___default.a; },
/* harmony export */   upload: function() { return /* reexport default from dynamic */ _upload_svg__WEBPACK_IMPORTED_MODULE_25___default.a; },
/* harmony export */   valign: function() { return /* reexport default from dynamic */ _valign_svg__WEBPACK_IMPORTED_MODULE_26___default.a; }
/* harmony export */ });
/* harmony import */ var _angle_down_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(88497);
/* harmony import */ var _angle_down_svg__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_angle_down_svg__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _angle_left_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91882);
/* harmony import */ var _angle_left_svg__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_angle_left_svg__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angle_right_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14305);
/* harmony import */ var _angle_right_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_angle_right_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angle_up_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(58446);
/* harmony import */ var _angle_up_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_angle_up_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _bin_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39858);
/* harmony import */ var _bin_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_bin_svg__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _cancel_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(70881);
/* harmony import */ var _cancel_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_cancel_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _center_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(60636);
/* harmony import */ var _center_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_center_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _check_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(32013);
/* harmony import */ var _check_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_check_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _chevron_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(45512);
/* harmony import */ var _chevron_svg__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_chevron_svg__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _dots_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(80347);
/* harmony import */ var _dots_svg__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_dots_svg__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _eye_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(95134);
/* harmony import */ var _eye_svg__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_eye_svg__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _file_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(70697);
/* harmony import */ var _file_svg__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_file_svg__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _folder_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(49983);
/* harmony import */ var _folder_svg__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_folder_svg__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _info_circle_svg__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(98964);
/* harmony import */ var _info_circle_svg__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_info_circle_svg__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _left_svg__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(8136);
/* harmony import */ var _left_svg__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_left_svg__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _lock_svg__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(94806);
/* harmony import */ var _lock_svg__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_lock_svg__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _ok_svg__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(31365);
/* harmony import */ var _ok_svg__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_ok_svg__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _pencil_svg__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(44636);
/* harmony import */ var _pencil_svg__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_pencil_svg__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _plus_svg__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(36327);
/* harmony import */ var _plus_svg__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(_plus_svg__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _resize_handler_svg__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(53328);
/* harmony import */ var _resize_handler_svg__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(_resize_handler_svg__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _right_svg__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(98711);
/* harmony import */ var _right_svg__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(_right_svg__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _save_svg__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(53808);
/* harmony import */ var _save_svg__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(_save_svg__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var _settings_svg__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(20784);
/* harmony import */ var _settings_svg__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(_settings_svg__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var _unlock_svg__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(70999);
/* harmony import */ var _unlock_svg__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(_unlock_svg__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var _update_svg__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(45244);
/* harmony import */ var _update_svg__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(_update_svg__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var _upload_svg__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(99876);
/* harmony import */ var _upload_svg__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(_upload_svg__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var _valign_svg__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(14006);
/* harmony import */ var _valign_svg__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(_valign_svg__WEBPACK_IMPORTED_MODULE_26__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:styles/icons/README.md]]
 * @packageDocumentation
 * @module icons
 */ 





























/***/ }),

/***/ 13810:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export source */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(91206);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(18929);
/* harmony import */ var _editor_factory__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(82495);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/source/README.md]]
 * @packageDocumentation
 * @module plugins/source
 */ 











/**
 * Plug-in change simple textarea on CodeMirror editor in Source code mode
 */ class source extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_7__.Plugin {
    onInsertHTML(html) {
        if (!this.j.o.readonly && !this.j.isEditorMode()) {
            var _this_sourceEditor;
            (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.insertRaw(html);
            this.toWYSIWYG();
            return false;
        }
    }
    /**
	 * Update source editor from WYSIWYG area
	 */ fromWYSIWYG(force = false) {
        if (!this.__lock || force === true) {
            this.__lock = true;
            const new_value = this.j.getEditorValue(false, jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.SOURCE_CONSUMER);
            if (new_value !== this.getMirrorValue()) {
                this.setMirrorValue(new_value);
            }
            this.__lock = false;
        }
    }
    /**
	 * Update WYSIWYG area from source editor
	 */ toWYSIWYG() {
        if (this.__lock) {
            return;
        }
        const value = this.getMirrorValue();
        if (value === this.__oldMirrorValue) {
            return;
        }
        this.__lock = true;
        this.j.value = value;
        this.__lock = false;
        this.__oldMirrorValue = value;
    }
    getNormalPosition(pos, str) {
        str = str.replace(/<(script|style|iframe)[^>]*>[^]*?<\/\1>/im, (m)=>{
            let res = '';
            for(let i = 0; i < m.length; i += 1){
                res += jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.INVISIBLE_SPACE;
            }
            return res;
        });
        while(pos > 0 && str[pos] === jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.INVISIBLE_SPACE){
            pos--;
        }
        let start = pos;
        while(start > 0){
            start--;
            if (str[start] === '<' && str[start + 1] !== undefined && str[start + 1].match(/[\w/]+/i)) {
                return start;
            }
            if (str[start] === '>') {
                return pos;
            }
        }
        return pos;
    }
    clnInv(str) {
        return str.replace(jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.INVISIBLE_SPACE_REG_EXP(), '');
    }
    onSelectAll(command) {
        if (command.toLowerCase() === 'selectall' && this.j.getRealMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.MODE_SOURCE) {
            var _this_sourceEditor;
            (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.selectAll();
            return false;
        }
    }
    getMirrorValue() {
        var _this_sourceEditor;
        return ((_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.getValue()) || '';
    }
    setMirrorValue(value) {
        var _this_sourceEditor;
        (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.setValue(value);
    }
    setFocusToMirror() {
        var _this_sourceEditor;
        (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.focus();
    }
    saveSelection() {
        if (this.j.getRealMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.MODE_WYSIWYG) {
            this.j.s.save();
            this.j.synchronizeValues();
            this.fromWYSIWYG(true);
        } else {
            if (this.j.o.editHTMLDocumentMode) {
                return;
            }
            const value = this.getMirrorValue();
            if (this.getSelectionStart() === this.getSelectionEnd()) {
                const marker = this.j.s.marker(true);
                const selectionStart = this.getNormalPosition(this.getSelectionStart(), this.getMirrorValue());
                this.setMirrorValue(value.substring(0, selectionStart) + this.clnInv(marker.outerHTML) + value.substring(selectionStart));
            } else {
                const markerStart = this.j.s.marker(true);
                const markerEnd = this.j.s.marker(false);
                const selectionStart = this.getNormalPosition(this.getSelectionStart(), value);
                const selectionEnd = this.getNormalPosition(this.getSelectionEnd(), value);
                this.setMirrorValue(value.slice(0, selectionStart) + this.clnInv(markerStart.outerHTML) + value.slice(selectionStart, selectionEnd) + this.clnInv(markerEnd.outerHTML) + value.slice(selectionEnd));
            }
            this.toWYSIWYG();
        }
    }
    removeSelection() {
        if (this.j.getRealMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.MODE_WYSIWYG) {
            this.__lock = true;
            this.j.s.restore();
            this.__lock = false;
            return;
        }
        let value = this.getMirrorValue();
        let selectionStart = 0, selectionEnd = 0;
        try {
            value = value.replace(/<span[^>]+data-jodit-selection_marker=(["'])start\1[^>]*>[<>]*?<\/span>/gim, this.tempMarkerStart).replace(/<span[^>]+data-jodit-selection_marker=(["'])end\1[^>]*>[<>]*?<\/span>/gim, this.tempMarkerEnd);
            if (!this.j.o.editHTMLDocumentMode && this.j.o.beautifyHTML) {
                const html = this.j.e.fire('beautifyHTML', value);
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.isString)(html)) {
                    value = html;
                }
            }
            selectionStart = value.indexOf(this.tempMarkerStart);
            selectionEnd = selectionStart;
            value = value.replace(this.tempMarkerStartReg, '');
            if (selectionStart !== -1) {
                const selectionEndCursor = value.indexOf(this.tempMarkerEnd);
                if (selectionEndCursor !== -1) {
                    selectionEnd = selectionEndCursor;
                }
            }
            value = value.replace(this.tempMarkerEndReg, '');
        } finally{
            value = value.replace(this.tempMarkerEndReg, '').replace(this.tempMarkerStartReg, '');
        }
        this.setMirrorValue(value);
        this.setMirrorSelectionRange(selectionStart, selectionEnd);
        this.toWYSIWYG();
        this.setFocusToMirror(); // need for setting focus after change mode
    }
    setMirrorSelectionRange(start, end) {
        var _this_sourceEditor;
        (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.setSelectionRange(start, end);
    }
    onReadonlyReact() {
        var _this_sourceEditor;
        (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.setReadOnly(this.j.o.readonly);
    }
    /** @override */ afterInit(editor) {
        this.mirrorContainer = editor.c.div('jodit-source');
        editor.workplace.appendChild(this.mirrorContainer);
        editor.e.on('afterAddPlace changePlace afterInit', ()=>{
            editor.workplace.appendChild(this.mirrorContainer);
        });
        this.sourceEditor = (0,_editor_factory__WEBPACK_IMPORTED_MODULE_9__.createSourceEditor)('area', editor, this.mirrorContainer, this.toWYSIWYG, this.fromWYSIWYG);
        editor.e.on(editor.ow, 'keydown', (e)=>{
            var _this_sourceEditor;
            if (e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.KEY_ESC && ((_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.isFocused)) {
                this.sourceEditor.blur();
            }
        });
        this.onReadonlyReact();
        editor.e.on('placeholder.source', (text)=>{
            var _this_sourceEditor;
            (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.setPlaceHolder(text);
        }).on('change.source', this.syncValueFromWYSIWYG).on('beautifyHTML', (html)=>html);
        if (editor.o.beautifyHTML) {
            const addEventListener = ()=>{
                if (editor.isInDestruct) {
                    return false;
                }
                const html_beautify = editor.ow.html_beautify;
                if (html_beautify && !editor.isInDestruct) {
                    var _editor_events;
                    (_editor_events = editor.events) === null || _editor_events === void 0 ? void 0 : _editor_events.off('beautifyHTML').on('beautifyHTML', (html)=>html_beautify(html));
                    return true;
                }
                return false;
            };
            if (!addEventListener()) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.loadNext)(editor, editor.o.beautifyHTMLCDNUrlsJS).then(addEventListener, ()=>null);
            }
        }
        this.syncValueFromWYSIWYG(true);
        this.initSourceEditor(editor);
    }
    syncValueFromWYSIWYG(force = false) {
        const editor = this.j;
        if (editor.getMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.MODE_SPLIT || editor.getMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.MODE_SOURCE) {
            this.fromWYSIWYG(force);
        }
    }
    initSourceEditor(editor) {
        if (editor.o.sourceEditor !== 'area') {
            const sourceEditor = (0,_editor_factory__WEBPACK_IMPORTED_MODULE_9__.createSourceEditor)(editor.o.sourceEditor, editor, this.mirrorContainer, this.toWYSIWYG, this.fromWYSIWYG);
            sourceEditor.onReadyAlways(()=>{
                var _this_sourceEditor, _editor_events;
                (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.destruct();
                this.sourceEditor = sourceEditor;
                this.syncValueFromWYSIWYG(true);
                (_editor_events = editor.events) === null || _editor_events === void 0 ? void 0 : _editor_events.fire('sourceEditorReady', editor);
            });
        } else {
            var _this_sourceEditor;
            (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.onReadyAlways(()=>{
                var _editor_events;
                this.syncValueFromWYSIWYG(true);
                (_editor_events = editor.events) === null || _editor_events === void 0 ? void 0 : _editor_events.fire('sourceEditorReady', editor);
            });
        }
    }
    /** @override */ beforeDestruct() {
        if (this.sourceEditor) {
            this.sourceEditor.destruct();
            delete this.sourceEditor;
        }
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.safeRemove(this.mirrorContainer);
    }
    constructor(...args){
        super(...args), /** @override */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "buttons", [
            {
                name: 'source',
                group: 'source'
            }
        ]), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "sourceEditor", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "mirrorContainer", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__lock", false), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__oldMirrorValue", ''), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "tempMarkerStart", '{start-jodit-selection}'), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "tempMarkerStartReg", /{start-jodit-selection}/g), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "tempMarkerEnd", '{end-jodit-selection}'), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "tempMarkerEndReg", /{end-jodit-selection}/g), // override it for ace editors
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "getSelectionStart", ()=>{
            var _this_sourceEditor;
            var _this_sourceEditor_getSelectionStart;
            return (_this_sourceEditor_getSelectionStart = (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.getSelectionStart()) !== null && _this_sourceEditor_getSelectionStart !== void 0 ? _this_sourceEditor_getSelectionStart : 0;
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "getSelectionEnd", ()=>{
            var _this_sourceEditor;
            var _this_sourceEditor_getSelectionEnd;
            return (_this_sourceEditor_getSelectionEnd = (_this_sourceEditor = this.sourceEditor) === null || _this_sourceEditor === void 0 ? void 0 : _this_sourceEditor.getSelectionEnd()) !== null && _this_sourceEditor_getSelectionEnd !== void 0 ? _this_sourceEditor_getSelectionEnd : 0;
        });
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)(':insertHTML.source')
], source.prototype, "onInsertHTML", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], source.prototype, "fromWYSIWYG", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], source.prototype, "toWYSIWYG", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], source.prototype, "getNormalPosition", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)(':beforeCommand.source')
], source.prototype, "onSelectAll", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)(':beforeSetMode.source')
], source.prototype, "saveSelection", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)(':afterSetMode.source')
], source.prototype, "removeSelection", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], source.prototype, "setMirrorSelectionRange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)(':readonly.source')
], source.prototype, "onReadonlyReact", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], source.prototype, "syncValueFromWYSIWYG", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_5__.pluginSystem.add('source', source);


/***/ }),

/***/ 14006:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1216 320q0 26-19 45t-45 19h-128v1024h128q26 0 45 19t19 45-19 45l-256 256q-19 19-45 19t-45-19l-256-256q-19-19-19-45t19-45 45-19h128v-1024h-128q-26 0-45-19t-19-45 19-45l256-256q19-19 45-19t45 19l256 256q19 19 19 45z\"/> </svg>"

/***/ }),

/***/ 14017:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M384 544v576q0 13-9.5 22.5t-22.5 9.5q-14 0-23-9l-288-288q-9-9-9-23t9-23l288-288q9-9 23-9 13 0 22.5 9.5t9.5 22.5zm1408 768v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5z\"/> </svg>"

/***/ }),

/***/ 14099:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    symbols: 'Símbolo'
};


/***/ }),

/***/ 14228:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   abort: function() { return /* binding */ abort; },
/* harmony export */   isAbort: function() { return /* binding */ isAbort; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(72068);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 
function abort(message = 'Aborted') {
    return new DOMException(message, 'AbortError');
}
/**
 * @deprecated use `isAbortError` instead
 */ const isAbort = jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_0__.isAbortError;


/***/ }),

/***/ 14248:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export resizeCells */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65946);
/* harmony import */ var jodit_modules__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(60936);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(51822);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/resize-cells/README.md]]
 * @packageDocumentation
 * @module plugins/resize-cells
 */ 









const key = 'table_processor_observer-resize';
/**
 * Process tables in editor
 */ class resizeCells extends jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Plugin {
    /**
	 * Shortcut for Table module
	 */ get module() {
        return this.j.getInstance('Table', this.j.o);
    }
    /**
	 * Now editor has rtl direction
	 */ get isRTL() {
        return this.j.o.direction === 'rtl';
    }
    showResizeHandle() {
        this.j.async.clearTimeout(this.hideTimeout);
        this.j.workplace.appendChild(this.resizeHandler);
    }
    hideResizeHandle() {
        this.hideTimeout = this.j.async.setTimeout(()=>{
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.safeRemove(this.resizeHandler);
        }, {
            timeout: this.j.defaultTimeout,
            label: 'hideResizer'
        });
    }
    /**
	 * Click on resize handle
	 */ onHandleMouseDown(event) {
        if (this.j.isLocked) {
            return;
        }
        this.drag = true;
        this.j.e.on(this.j.ow, 'mouseup.resize-cells touchend.resize-cells', this.onMouseUp).on(this.j.ew, 'mousemove.table touchmove.table', this.onMouseMove);
        this.startX = event.clientX;
        this.j.lock(key);
        this.resizeHandler.classList.add('jodit-table-resizer_moved');
        let box, tableBox = this.workTable.getBoundingClientRect();
        this.minX = 0;
        this.maxX = 1000000;
        if (this.wholeTable != null) {
            tableBox = this.workTable.parentNode.getBoundingClientRect();
            this.minX = tableBox.left;
            this.maxX = this.minX + tableBox.width;
        } else {
            // find maximum columns
            const coordinate = this.module.formalCoordinate(this.workTable, this.workCell, true);
            this.module.formalMatrix(this.workTable, (td, i, j)=>{
                if (coordinate[1] === j) {
                    box = td.getBoundingClientRect();
                    this.minX = Math.max(box.left + jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.NEARBY / 2, this.minX);
                }
                if (coordinate[1] + (this.isRTL ? -1 : 1) === j) {
                    box = td.getBoundingClientRect();
                    this.maxX = Math.min(box.left + box.width - jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.NEARBY / 2, this.maxX);
                }
            });
        }
        return false;
    }
    /**
	 * Mouse move after click on resize handle
	 */ onMouseMove(event) {
        if (!this.drag) {
            return;
        }
        this.j.e.fire('closeAllPopups');
        let x = event.clientX;
        const workplacePosition = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.offset)(this.resizeHandler.parentNode || this.j.od.documentElement, this.j, this.j.od, true);
        if (x < this.minX) {
            x = this.minX;
        }
        if (x > this.maxX) {
            x = this.maxX;
        }
        this.resizeDelta = x - this.startX + (!this.j.o.iframe ? 0 : workplacePosition.left);
        this.resizeHandler.style.left = x - (this.j.o.iframe ? 0 : workplacePosition.left) + 'px';
        const sel = this.j.s.sel;
        sel && sel.removeAllRanges();
    }
    /**
	 * Mouse up every where after move and click
	 */ onMouseUp(e) {
        if (this.selectMode || this.drag) {
            this.selectMode = false;
            this.j.unlock();
        }
        if (!this.resizeHandler || !this.drag) {
            return;
        }
        this.drag = false;
        this.j.e.off(this.j.ew, 'mousemove.table touchmove.table', this.onMouseMove);
        this.resizeHandler.classList.remove('jodit-table-resizer_moved');
        if (this.startX !== e.clientX) {
            // resize column
            if (this.wholeTable == null) {
                this.resizeColumns();
            } else {
                this.resizeTable();
            }
        }
        this.j.synchronizeValues();
        this.j.s.focus();
    }
    /**
	 * Resize only one column
	 */ resizeColumns() {
        const delta = this.resizeDelta;
        const marked = [];
        const tableModule = this.module;
        tableModule.setColumnWidthByDelta(this.workTable, tableModule.formalCoordinate(this.workTable, this.workCell, true)[1], delta, true, marked);
        const nextTD = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.call)(this.isRTL ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.prev : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.next, this.workCell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.isCell, this.workCell.parentNode);
        tableModule.setColumnWidthByDelta(this.workTable, tableModule.formalCoordinate(this.workTable, nextTD)[1], -delta, false, marked);
    }
    /**
	 * Resize whole table
	 */ resizeTable() {
        const delta = this.resizeDelta * (this.isRTL ? -1 : 1);
        const width = this.workTable.offsetWidth, parentWidth = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.getContentWidth)(this.workTable.parentNode, this.j.ew);
        // for RTL use mirror logic
        const rightSide = !this.wholeTable;
        const needChangeWidth = this.isRTL ? !rightSide : rightSide;
        // right side
        if (needChangeWidth) {
            this.workTable.style.width = (width + delta) / parentWidth * 100 + '%';
        } else {
            const side = this.isRTL ? 'marginRight' : 'marginLeft';
            const margin = parseInt(this.j.ew.getComputedStyle(this.workTable)[side] || '0', 10);
            this.workTable.style.width = (width - delta) / parentWidth * 100 + '%';
            this.workTable.style[side] = (margin + delta) / parentWidth * 100 + '%';
        }
    }
    /**
	 * Memoize current cell
	 *
	 * @param wholeTable - resize whole table by left side,
	 * false - resize whole table by right side, null - resize column
	 */ setWorkCell(cell, wholeTable = null) {
        this.wholeTable = wholeTable;
        this.workCell = cell;
        this.workTable = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.up(cell, (elm)=>jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.isTag(elm, 'table'), this.j.editor);
    }
    /**
	 * Calc helper resize handle position
	 */ calcHandlePosition(table, cell, offsetX = 0, delta = 0) {
        const box = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.offset)(cell, this.j, this.j.ed);
        if (offsetX > jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.NEARBY && offsetX < box.width - jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.NEARBY) {
            this.hideResizeHandle();
            return;
        }
        const workplacePosition = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.offset)(this.j.workplace, this.j, this.j.od, true), parentBox = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.offset)(table, this.j, this.j.ed);
        this.resizeHandler.style.left = (offsetX <= jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.NEARBY ? box.left : box.left + box.width) - workplacePosition.left + delta + 'px';
        Object.assign(this.resizeHandler.style, {
            height: parentBox.height + 'px',
            top: parentBox.top - workplacePosition.top + 'px'
        });
        this.showResizeHandle();
        if (offsetX <= jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.NEARBY) {
            const prevTD = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.call)(this.isRTL ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.next : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.prev, cell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.isCell, cell.parentNode);
            this.setWorkCell(prevTD || cell, prevTD ? null : true);
        } else {
            const nextTD = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.call)(!this.isRTL ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.next : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.prev, cell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.isCell, cell.parentNode);
            this.setWorkCell(cell, !nextTD ? false : null);
        }
    }
    /** @override */ afterInit(editor) {
        if (!editor.o.tableAllowCellResize) {
            return;
        }
        editor.e.off(this.j.ow, '.resize-cells').off('.resize-cells').on('change.resize-cells afterCommand.resize-cells afterSetMode.resize-cells', ()=>{
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.$$)('table', editor.editor).forEach(this.observe);
        }).on(this.j.ow, 'scroll.resize-cells', ()=>{
            if (!this.drag) {
                return;
            }
            const parent = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.up(this.workCell, (elm)=>jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.isTag(elm, 'table'), editor.editor);
            if (parent) {
                const parentBox = parent.getBoundingClientRect();
                this.resizeHandler.style.top = parentBox.top + 'px';
            }
        }).on('beforeSetMode.resize-cells', ()=>{
            const tableModule = this.module;
            tableModule.getAllSelectedCells().forEach((td)=>{
                tableModule.removeSelection(td);
                tableModule.normalizeTable(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.closest(td, 'table', editor.editor));
            });
        });
    }
    /**
	 * Add to every Table listeners
	 */ observe(table) {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.dataBind)(table, key)) {
            return;
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.dataBind)(table, key, true);
        this.j.e.on(table, 'mouseleave.resize-cells', (e)=>{
            if (this.resizeHandler && this.resizeHandler !== e.relatedTarget) {
                this.hideResizeHandle();
            }
        }).on(table, 'mousemove.resize-cells touchmove.resize-cells', this.j.async.throttle((event)=>{
            if (this.j.isLocked) {
                return;
            }
            const cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.up(event.target, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.isCell, table);
            if (!cell) {
                return;
            }
            this.calcHandlePosition(table, cell, event.offsetX);
        }, {
            timeout: this.j.defaultTimeout
        }));
        this.createResizeHandle();
    }
    beforeDestruct(jodit) {
        if (jodit.events) {
            jodit.e.off(this.j.ow, '.resize-cells');
            jodit.e.off('.resize-cells');
        }
    }
    constructor(...args){
        super(...args), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "selectMode", false), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "resizeDelta", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "resizeHandler", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "createResizeHandle", ()=>{
            if (!this.resizeHandler) {
                this.resizeHandler = this.j.c.div('jodit-table-resizer');
                this.j.e.on(this.resizeHandler, 'mousedown.table touchstart.table', this.onHandleMouseDown).on(this.resizeHandler, 'mouseenter.table', ()=>{
                    this.j.async.clearTimeout(this.hideTimeout);
                });
            }
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "hideTimeout", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "drag", false), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "wholeTable", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "workCell", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "workTable", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "minX", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "maxX", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "startX", 0);
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], resizeCells.prototype, "onHandleMouseDown", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], resizeCells.prototype, "onMouseMove", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], resizeCells.prototype, "onMouseUp", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], resizeCells.prototype, "observe", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_5__.pluginSystem.add('resizeCells', resizeCells);


/***/ }),

/***/ 14305:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1171 960q0 13-10 23l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23z\"/> </svg>"

/***/ }),

/***/ 14907:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/hotkeys
 */ 
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.commandToHotkeys = {
    removeFormat: [
        'ctrl+shift+m',
        'cmd+shift+m'
    ],
    insertOrderedList: [
        'ctrl+shift+7',
        'cmd+shift+7'
    ],
    insertUnorderedList: [
        'ctrl+shift+8, cmd+shift+8'
    ],
    selectall: [
        'ctrl+a',
        'cmd+a'
    ]
};


/***/ }),

/***/ 15200:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   findMostNestedNeighbor: function() { return /* binding */ findMostNestedNeighbor; },
/* harmony export */   getMoveFilter: function() { return /* binding */ getMoveFilter; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27795);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/backspace
 */ 
/**
 * Finds the nearest neighbor that would be in the maximum nesting depth.
 * Ie if neighbor `<DIV><SPAN>Text` then return Text node.
 * @private
 */ function findMostNestedNeighbor(node, right, root, onlyInlide = false) {
    const nextChild = (node)=>right ? node.firstChild : node.lastChild;
    let next = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.findNotEmptyNeighbor(node, !right, root);
    if (onlyInlide && jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement(next) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isInlineBlock(next)) {
        return null;
    }
    if (next) {
        do {
            if (nextChild(next)) {
                next = nextChild(next);
            } else {
                return next;
            }
        }while (next)
    }
    return null;
}
/**
 * @private
 */ function getMoveFilter(jodit) {
    return (node)=>jodit.e.fire('backSpaceIsMovedIgnore', node) !== true;
}


/***/ }),

/***/ 15223:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    'copy-format': '複製格式'
};


/***/ }),

/***/ 15366:
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ _object_spread_props; }
/* harmony export */ });
function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);
        if (enumerableOnly) {
            symbols = symbols.filter(function(sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            });
        }
        keys.push.apply(keys, symbols);
    }
    return keys;
}
function _object_spread_props(target, source) {
    source = source != null ? source : {};
    if (Object.getOwnPropertyDescriptors) Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    else {
        ownKeys(Object(source)).forEach(function(key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
    }
    return target;
}



/***/ }),

/***/ 15367:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UIButtonGroup: function() { return /* binding */ UIButtonGroup; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(91672);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53681);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(63468);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/button
 */ 






class UIButtonGroup extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_5__.UIGroup {
    /** @override */ className() {
        return 'UIButtonGroup';
    }
    /** @override */ render(options) {
        return `<div>
			<div class="&__label">~${options.label}~</div>
			<div class="&__options"></div>
		</div>`;
    }
    /** @override */ appendChildToContainer(childContainer) {
        const options = this.getElm('options');
        (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__.assert)(options != null, 'Options does not exist');
        options.appendChild(childContainer);
    }
    select(indexOrValue) {
        var _this_options_onChange, _this_options;
        this.elements.forEach((elm, index)=>{
            if (index === indexOrValue || elm.state.value === indexOrValue) {
                elm.state.activated = true;
            } else if (this.options.radio) {
                elm.state.activated = false;
            }
        });
        const result = this.elements.filter((elm)=>elm.state.activated).map((elm)=>({
                text: elm.state.text,
                value: elm.state.value
            }));
        this.jodit.e.fire(this, 'select', result);
        (_this_options_onChange = (_this_options = this.options).onChange) === null || _this_options_onChange === void 0 ? void 0 : _this_options_onChange.call(_this_options, result);
    }
    constructor(jodit, options = {
        radio: true
    }){
        var _options_options;
        super(jodit, (_options_options = options.options) === null || _options_options === void 0 ? void 0 : _options_options.map((opt)=>{
            const btn = new jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_4__.UIButton(jodit, {
                text: opt.text,
                value: opt.value,
                variant: 'primary'
            });
            btn.onAction(()=>{
                this.select(opt.value);
            });
            return btn;
        }), options), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "options", void 0), this.options = options;
        var _options_value;
        this.select((_options_value = options.value) !== null && _options_value !== void 0 ? _options_value : 0);
    }
}
UIButtonGroup = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__.component
], UIButtonGroup);


/***/ }),

/***/ 15753:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ColorPickerWidget: function() { return /* reexport safe */ _color_picker_color_picker__WEBPACK_IMPORTED_MODULE_0__.ColorPickerWidget; },
/* harmony export */   FileSelectorWidget: function() { return /* reexport safe */ _file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__.FileSelectorWidget; },
/* harmony export */   TabsWidget: function() { return /* reexport safe */ _tabs_tabs__WEBPACK_IMPORTED_MODULE_2__.TabsWidget; }
/* harmony export */ });
/* harmony import */ var _color_picker_color_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(72348);
/* harmony import */ var _file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18762);
/* harmony import */ var _tabs_tabs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(89636);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/widget/README.md]]
 * @packageDocumentation
 * @module modules/widget
 */ 




/***/ }),

/***/ 15982:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   findControlType: function() { return /* binding */ findControlType; },
/* harmony export */   getControlType: function() { return /* binding */ getControlType; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41411);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65946);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui
 */ 


/**
 * Get control for button name
 * @private
 */ function getControlType(button, controls) {
    let buttonControl;
    if (!controls) {
        controls = jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.defaultOptions.controls;
    }
    if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isString)(button)) {
        buttonControl = (0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_0__._)({
            name: 'empty'
        }, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.ConfigFlatten)(button));
        if (controls[buttonControl.name] !== undefined) {
            buttonControl = (0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_0__._)({}, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.ConfigFlatten)(controls[buttonControl.name]), (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.ConfigFlatten)(buttonControl));
        }
    } else {
        buttonControl = findControlType(button, controls) || {
            name: button,
            command: button,
            tooltip: button
        };
    }
    return buttonControl;
}
/**
 * @private
 */ function findControlType(path, controls) {
    // eslint-disable-next-line prefer-const
    let [namespaceOrKey, key] = path.split(/\./);
    let store = controls;
    if (key != null) {
        if (controls[namespaceOrKey] !== undefined) {
            store = controls[namespaceOrKey];
        }
    } else {
        key = namespaceOrKey;
    }
    // const list = store[key]?.list;
    return store[key] ? (0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_0__._)({
        name: key
    }, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.ConfigFlatten)(store[key])) : undefined;
}


/***/ }),

/***/ 16849:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   alignElement: function() { return /* binding */ alignElement; },
/* harmony export */   clearAlign: function() { return /* binding */ clearAlign; },
/* harmony export */   hAlignElement: function() { return /* binding */ hAlignElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80991);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 

/**
 * Align image
 */ function hAlignElement(image, align) {
    if (align && align !== 'normal') {
        if (align !== 'center') {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__.css)(image, 'float', align);
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__.clearCenterAlign)(image);
        } else {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__.css)(image, {
                float: '',
                display: 'block',
                marginLeft: 'auto',
                marginRight: 'auto'
            });
        }
    } else {
        if ((0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__.css)(image, 'float') && [
            'right',
            'left'
        ].indexOf((0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__.css)(image, 'float').toString().toLowerCase()) !== -1) {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__.css)(image, 'float', '');
        }
        (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__.clearCenterAlign)(image);
    }
}
/**
 * Remove text-align style for all selected children
 */ function clearAlign(node) {
    jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.each(node, (elm)=>{
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isHTMLElement(elm)) {
            if (elm.style.textAlign) {
                elm.style.textAlign = '';
                if (!elm.style.cssText.trim().length) {
                    elm.removeAttribute('style');
                }
            }
        }
    });
}
/**
 * Apply align for element
 */ function alignElement(command, box) {
    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isNode(box) && jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement(box)) {
        clearAlign(box);
        switch(command.toLowerCase()){
            case 'justifyfull':
                box.style.textAlign = 'justify';
                break;
            case 'justifyright':
                box.style.textAlign = 'right';
                break;
            case 'justifyleft':
                box.style.textAlign = 'left';
                break;
            case 'justifycenter':
                box.style.textAlign = 'center';
                break;
        }
    }
}


/***/ }),

/***/ 16964:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Component: function() { return /* reexport safe */ _component__WEBPACK_IMPORTED_MODULE_0__.Component; },
/* harmony export */   STATUSES: function() { return /* reexport safe */ _statuses__WEBPACK_IMPORTED_MODULE_1__.STATUSES; },
/* harmony export */   ViewComponent: function() { return /* reexport safe */ _view_component__WEBPACK_IMPORTED_MODULE_2__.ViewComponent; }
/* harmony export */ });
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80251);
/* harmony import */ var _statuses__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69364);
/* harmony import */ var _view_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59609);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module component
 */ 




/***/ }),

/***/ 17306:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UIImagePositionTab: function() { return /* binding */ UIImagePositionTab; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(91672);
/* harmony import */ var jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29200);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(68616);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(7909);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(96007);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(29434);
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(10808);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 










class UIImagePositionTab extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_8__.UIElement {
    className() {
        return 'UIImagePositionTab';
    }
    render({ availableClasses }) {
        return `<div class="jodit-form__group &__editMargins">
			<label>~Margins~</label>
			<div class="jodit-grid jodit_vertical_middle">
				<input class="jodit_col-lg-1-5 jodit-input &__marginTop" type="text" placeholder="~top~"/>
				<a style="text-align: center;" class="jodit-properties__lock jodit_col-lg-1-5 &__lockMargin">*lock*</a>
				<input disabled="disabled" class="jodit_col-lg-1-5 jodit-input &__marginRight" type="text" placeholder="~right~"/>
				<input disabled="disabled" class="jodit_col-lg-1-5 jodit-input &__marginBottom" type="text" placeholder="~bottom~"/>
				<input disabled="disabled" class="jodit_col-lg-1-5 jodit-input &__marginLeft" type="text" placeholder="~left~"/>
			</div>
		</div>
		<div class="jodit-form__group &__editAlign">
			<label>~Align~</label>
			<select class="jodit-select &__align">
				<option value="">~--Not Set--~</option>
				<option value="left">~Left~</option>
				<option value="center">~Center~</option>
				<option value="right">~Right~</option>
			</select>
		</div>
		<div class="jodit-form__group &__editStyle">
			<label>~Styles~</label>
			<input type="text" class="jodit-input &__style"/>
		</div>
		<div class="jodit-form__group &__editClass">
			<label>~Classes~</label>
			${(()=>{
            const classInput = [];
            if (availableClasses && availableClasses.length > 0) {
                classInput.push('<select class="jodit-input jodit-select &__classes">');
                availableClasses.forEach((item)=>{
                    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_6__.isString)(item)) {
                        classInput.push(`<option value="${item}">${item}</option>`);
                    } else {
                        classInput.push(`<option value="${item[0]}">${item[1]}</option>`);
                    }
                });
                classInput.push('</select>');
            } else {
                classInput.push('<input type="text" class="jodit-input &__classes"/>');
            }
            return classInput.join('');
        })()}
		</div>
		<div class="jodit-form__group &__editId">
			<label>Id</label>
			<input type="text" class="jodit-input &__id"/>
		</div>
		<div
			class="jodit-form__group &__editBorderRadius"
		>
			<label>~Border radius~</label>
			<input type="number" class="jodit-input &__borderRadius"/>
		</div>`;
    }
    onStateAlignChange() {
        const align = this.getElm('align');
        align.value = this.state.values.align;
    }
    onChangeAlign() {
        const align = this.getElm('align');
        this.state.values.align = align.value;
    }
    onStateValuesBorderRadiusChange() {
        const borderRadius = this.getElm('borderRadius');
        borderRadius.value = this.state.values.borderRadius.toString();
    }
    onChangeBorderRadius() {
        const borderRadius = this.getElm('borderRadius');
        this.state.values.borderRadius = parseFloat(borderRadius.value);
    }
    onStateValuesIdChange() {
        const id = this.getElm('id');
        id.value = this.state.values.id;
    }
    onChangeId() {
        const id = this.getElm('id');
        this.state.values.id = id.value;
    }
    onStateValuesStyleChange() {
        const style = this.getElm('style');
        style.value = this.state.values.style;
    }
    onChangeStyle() {
        const style = this.getElm('style');
        this.state.values.style = style.value;
    }
    onStateValuesClassesChange() {
        const classes = this.getElm('classes');
        classes.value = this.state.values.classes;
    }
    onChangClasses() {
        const classes = this.getElm('classes');
        this.state.values.classes = classes.value;
    }
    onLockMarginClick(e) {
        this.state.marginIsLocked = !this.state.marginIsLocked;
        e.preventDefault();
    }
    onChangeMarginIsLocked() {
        const marginBottom = this.getElm('marginBottom');
        const marginRight = this.getElm('marginRight');
        const marginLeft = this.getElm('marginLeft');
        const lockMargin = this.getElm('lockMargin');
        [
            marginRight,
            marginBottom,
            marginLeft
        ].forEach((elm)=>{
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_7__.attr)(elm, 'disabled', this.state.marginIsLocked || null);
        });
        lockMargin.innerHTML = jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_9__.Icon.get(this.state.marginIsLocked ? 'lock' : 'unlock');
        if (this.state.marginIsLocked) {
            const marginTop = this.state.values.marginTop;
            this.state.values.marginRight = marginTop;
            this.state.values.marginBottom = marginTop;
            this.state.values.marginLeft = marginTop;
        }
    }
    onStateValuesMarginChange() {
        const marginTop = this.getElm('marginTop');
        const marginRight = this.getElm('marginRight');
        const marginBottom = this.getElm('marginBottom');
        const marginLeft = this.getElm('marginLeft');
        marginTop.value = this.state.values.marginTop.toString();
        marginRight.value = this.state.values.marginRight.toString();
        marginBottom.value = this.state.values.marginBottom.toString();
        marginLeft.value = this.state.values.marginLeft.toString();
    }
    onChangeMargin() {
        const marginTop = this.getElm('marginTop');
        const marginRight = this.getElm('marginRight');
        const marginBottom = this.getElm('marginBottom');
        const marginLeft = this.getElm('marginLeft');
        this.state.values.marginTop = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_10__.normalSizeFromString)(marginTop.value);
        if (this.state.marginIsLocked) {
            this.state.values.marginRight = this.state.values.marginTop;
            this.state.values.marginBottom = this.state.values.marginTop;
            this.state.values.marginLeft = this.state.values.marginTop;
        } else {
            this.state.values.marginRight = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_10__.normalSizeFromString)(marginRight.value);
            this.state.values.marginBottom = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_10__.normalSizeFromString)(marginBottom.value);
            this.state.values.marginLeft = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_10__.normalSizeFromString)(marginLeft.value);
        }
    }
    hideFieldByOptions() {
        const opt = this.j.o.image;
        [
            [
                'editMargins',
                'editMargins'
            ],
            [
                'editAlign',
                'editAlign'
            ],
            [
                'editStyle',
                'editStyle'
            ],
            [
                'editClass',
                'editClass'
            ],
            [
                'editId',
                'editId'
            ],
            [
                'editBorderRadius',
                'editBorderRadius'
            ]
        ].forEach(([optKey, elmKey])=>{
            const elm = this.getElm(elmKey);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(elm, 'display', opt[optKey] ? null : 'none');
        });
    }
    constructor(jodit, state, handlers){
        super(jodit, {
            availableClasses: jodit.o.image.availableClasses
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "state", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "handlers", void 0), this.state = state, this.handlers = handlers;
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_3__.hook)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('state.values.align')
], UIImagePositionTab.prototype, "onStateAlignChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('align:change')
], UIImagePositionTab.prototype, "onChangeAlign", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_3__.hook)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('state.values.borderRadius')
], UIImagePositionTab.prototype, "onStateValuesBorderRadiusChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('borderRadius:change')
], UIImagePositionTab.prototype, "onChangeBorderRadius", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_3__.hook)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('state.values.id')
], UIImagePositionTab.prototype, "onStateValuesIdChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('id:change')
], UIImagePositionTab.prototype, "onChangeId", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_3__.hook)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('state.values.style')
], UIImagePositionTab.prototype, "onStateValuesStyleChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('style:change')
], UIImagePositionTab.prototype, "onChangeStyle", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_3__.hook)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('state.values.classes')
], UIImagePositionTab.prototype, "onStateValuesClassesChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('classes:change')
], UIImagePositionTab.prototype, "onChangClasses", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('lockMargin:click')
], UIImagePositionTab.prototype, "onLockMarginClick", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_3__.hook)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)('state.marginIsLocked')
], UIImagePositionTab.prototype, "onChangeMarginIsLocked", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_3__.hook)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)([
        'state.values.marginTop',
        'state.values.marginRight',
        'state.values.marginBottom',
        'state.values.marginLeft'
    ])
], UIImagePositionTab.prototype, "onStateValuesMarginChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_4__.watch)([
        'marginTop:change',
        'marginRight:change',
        'marginBottom:change',
        'marginLeft:change'
    ])
], UIImagePositionTab.prototype, "onChangeMargin", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_3__.hook)('ready')
], UIImagePositionTab.prototype, "hideFieldByOptions", null);
UIImagePositionTab = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__.component
], UIImagePositionTab);


/***/ }),

/***/ 17312:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isArray: function() { return /* binding */ isArray; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ /**
 * Check if element is array
 */ function isArray(elm) {
    return Array.isArray(elm);
}


/***/ }),

/***/ 17338:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ajax: function() { return /* binding */ Ajax; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41411);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_async__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91231);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49574);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(33201);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(5266);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(37102);
/* harmony import */ var _response__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(32855);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/request/README.md]]
 * @packageDocumentation
 * @module request
 */ 











class Ajax {
    className() {
        return 'Ajax';
    }
    __buildParams(obj, prefix) {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isPlainObject)(obj) && this.options.contentType && this.options.contentType.includes('application/json')) {
            return JSON.stringify(obj);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isFunction)(this.o.queryBuild)) {
            return this.o.queryBuild.call(this, obj, prefix);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isString)(obj) || obj instanceof jodit_core_constants__WEBPACK_IMPORTED_MODULE_5__.globalWindow.FormData || typeof obj === 'object' && obj != null && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isFunction)(obj.append)) {
            return obj;
        }
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.buildQuery)(obj);
    }
    get o() {
        return this.options;
    }
    abort() {
        if (this.__isFulfilled) {
            return this;
        }
        try {
            this.__isFulfilled = true;
            this.xhr.abort();
        } catch (e) {}
        return this;
    }
    send() {
        this.__activated = true;
        const { xhr, o } = this;
        const request = this.prepareRequest();
        return this.__async.promise((resolve, reject)=>(0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
                const onReject = ()=>{
                    this.__isFulfilled = true;
                    reject(jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_8__.connection('Connection error'));
                };
                const onResolve = ()=>{
                    this.__isFulfilled = true;
                    resolve(new _response__WEBPACK_IMPORTED_MODULE_11__.Response(request, xhr.status, xhr.statusText, !xhr.responseType ? xhr.responseText : xhr.response));
                };
                xhr.onload = onResolve;
                xhr.onabort = ()=>{
                    this.__isFulfilled = true;
                    reject(jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_8__.abort('Abort connection'));
                };
                xhr.onerror = onReject;
                xhr.ontimeout = onReject;
                if (o.responseType) {
                    xhr.responseType = o.responseType;
                }
                xhr.onprogress = (e)=>{
                    var _this_options_onProgress, _this_options;
                    let percentComplete = 0;
                    if (e.lengthComputable) {
                        percentComplete = e.loaded / e.total * 100;
                    }
                    (_this_options_onProgress = (_this_options = this.options).onProgress) === null || _this_options_onProgress === void 0 ? void 0 : _this_options_onProgress.call(_this_options, percentComplete);
                };
                xhr.onreadystatechange = ()=>{
                    var _this_options_onProgress, _this_options;
                    (_this_options_onProgress = (_this_options = this.options).onProgress) === null || _this_options_onProgress === void 0 ? void 0 : _this_options_onProgress.call(_this_options, 10);
                    if (xhr.readyState === XMLHttpRequest.DONE) {
                        if (o.successStatuses.includes(xhr.status)) {
                            onResolve();
                        } else if (xhr.statusText) {
                            this.__isFulfilled = true;
                            reject(jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_8__.connection(xhr.statusText));
                        }
                    }
                };
                var _o_withCredentials;
                xhr.withCredentials = (_o_withCredentials = o.withCredentials) !== null && _o_withCredentials !== void 0 ? _o_withCredentials : false;
                const { url, data, method } = request;
                xhr.open(method, url, true);
                if (o.contentType && xhr.setRequestHeader) {
                    xhr.setRequestHeader('Content-type', o.contentType);
                }
                let { headers } = o;
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isFunction)(headers)) {
                    headers = yield headers.call(this);
                }
                if (headers && xhr.setRequestHeader) {
                    Object.keys(headers).forEach((key)=>{
                        xhr.setRequestHeader(key, headers[key]);
                    });
                }
                // IE
                this.__async.setTimeout(()=>{
                    xhr.send(data ? this.__buildParams(data) : undefined);
                }, 0);
            }).call(this));
    }
    prepareRequest() {
        if (!this.o.url) {
            throw jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_8__.error('Need URL for AJAX request');
        }
        let url = this.o.url;
        const data = this.o.data;
        const method = (this.o.method || 'get').toLowerCase();
        if (method === 'get' && data && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isPlainObject)(data)) {
            const qIndex = url.indexOf('?');
            if (qIndex !== -1) {
                const urlData = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.parseQuery)(url);
                url = url.substring(0, qIndex) + '?' + (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.buildQuery)((0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_2__._)({}, urlData, data));
            } else {
                url += '?' + (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.buildQuery)(this.o.data);
            }
        }
        const request = {
            url,
            method,
            data
        };
        Ajax.log.splice(100);
        Ajax.log.push(request);
        return request;
    }
    destruct() {
        if (!this.__isDestructed) {
            this.__isDestructed = true;
            if (this.__activated && !this.__isFulfilled) {
                this.abort();
                this.__isFulfilled = true;
            }
            this.__async.destruct();
        }
    }
    constructor(options, defaultAjaxOptions = jodit_config__WEBPACK_IMPORTED_MODULE_9__.Config.prototype.defaultAjaxOptions){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "__async", new jodit_core_async__WEBPACK_IMPORTED_MODULE_4__.Async());
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "xhr", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "options", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "__isFulfilled", false);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "__activated", false);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "__isDestructed", false);
        this.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.ConfigProto)(options || {}, defaultAjaxOptions);
        this.xhr = this.o.xhr ? this.o.xhr() : new XMLHttpRequest();
    }
}
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(Ajax, "log", []);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_6__.autobind
], Ajax.prototype, "destruct", null);


/***/ }),

/***/ 17481:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   extractSelectedPart: function() { return /* binding */ extractSelectedPart; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23175);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4040);
/* harmony import */ var jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71125);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 



/**
 * If the selection area is inside an element that matches the commit (suitable relative),
 * but does not completely fill it.
 * Then the method cuts the parent and leaves itself in a copy of the parent (suitable relative) in the middle.
 *
 * @example
 * Apply strong to
 * ```html
 * 	<strong><span>some<font>SELECTED</font>text</span></strong>
 * ```
 * Should extract selection from parent `strong`
 * ```html
 * `<strong><span>some</span></strong><strong><span><font>SELECTED</font></span></strong><strong><span>test</span></strong>
 * ```
 * @private
 */ function extractSelectedPart(wrapper, font, jodit) {
    const range = jodit.s.createRange();
    // Left part
    const leftEdge = (0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__.isMarker)(font.previousSibling) ? font.previousSibling : font;
    range.setStartBefore(wrapper);
    range.setEndBefore(leftEdge);
    extractAndMove(wrapper, range, true);
    // Right part
    const rightEdge = (0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__.isMarker)(font.nextSibling) ? font.nextSibling : font;
    range.setStartAfter(rightEdge);
    range.setEndAfter(wrapper);
    extractAndMove(wrapper, range, false);
}
/**
 * Retrieves content before after the selected area, clears it if it is empty, and inserts before after the framed selection
 * @private
 */ function extractAndMove(wrapper, range, left) {
    const fragment = range.extractContents();
    if ((!fragment.textContent || !(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__.trim)(fragment.textContent).length) && fragment.firstChild) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.unwrap(fragment.firstChild);
    }
    if (wrapper.parentNode) {
        (0,jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_3__.call)(left ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.before : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after, wrapper, fragment);
    }
}


/***/ }),

/***/ 17523:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cases: function() { return /* binding */ cases; }
/* harmony export */ });
/* harmony import */ var _check_join_neighbors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26106);
/* harmony import */ var _check_join_two_lists__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80951);
/* harmony import */ var _check_remove_char__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58881);
/* harmony import */ var _check_remove_content_not_editable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(68709);
/* harmony import */ var _check_remove_empty_neighbor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5771);
/* harmony import */ var _check_remove_empty_parent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2409);
/* harmony import */ var _check_remove_unbreakable_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(93890);
/* harmony import */ var _check_table_cell__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(12443);
/* harmony import */ var _check_unwrap_first_list_item__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(10157);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/backspace
 */ 








/**
 * @private
 */ const cases = [
    _check_remove_unbreakable_element__WEBPACK_IMPORTED_MODULE_6__.checkRemoveUnbreakableElement,
    _check_remove_content_not_editable__WEBPACK_IMPORTED_MODULE_3__.checkRemoveContentNotEditable,
    _check_remove_char__WEBPACK_IMPORTED_MODULE_2__.checkRemoveChar,
    _check_table_cell__WEBPACK_IMPORTED_MODULE_7__.checkTableCell,
    _check_remove_empty_parent__WEBPACK_IMPORTED_MODULE_5__.checkRemoveEmptyParent,
    _check_remove_empty_neighbor__WEBPACK_IMPORTED_MODULE_4__.checkRemoveEmptyNeighbor,
    _check_join_two_lists__WEBPACK_IMPORTED_MODULE_1__.checkJoinTwoLists,
    _check_join_neighbors__WEBPACK_IMPORTED_MODULE_0__.checkJoinNeighbors,
    _check_unwrap_first_list_item__WEBPACK_IMPORTED_MODULE_8__.checkUnwrapFirstListItem
];


/***/ }),

/***/ 17610:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileBrowser: function() { return /* reexport safe */ _file_browser__WEBPACK_IMPORTED_MODULE_0__.FileBrowser; }
/* harmony export */ });
/* harmony import */ var _file_browser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62623);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/file-browser/README.md]]
 * @packageDocumentation
 * @module modules/file-browser
 */ 


/***/ }),

/***/ 17780:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DEFAULT_SOURCE_NAME: function() { return /* binding */ DEFAULT_SOURCE_NAME; },
/* harmony export */   "default": function() { return /* binding */ DataProvider; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41411);
/* harmony import */ var _swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15366);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(73714);
/* harmony import */ var jodit_modules_file_browser_builders_item__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(58664);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ 







const DEFAULT_SOURCE_NAME = 'default';
const possibleRules = new Set([
    'allowFiles',
    'allowFileMove',
    'allowFileUpload',
    'allowFileUploadRemote',
    'allowFileRemove',
    'allowFileRename',
    'allowFolders',
    'allowFolderMove',
    'allowFolderCreate',
    'allowFolderRemove',
    'allowFolderRename',
    'allowImageResize',
    'allowImageCrop'
]);
class DataProvider {
    /**
	 * Alias for options
	 */ get o() {
        return this.options;
    }
    get(name) {
        const instances = this.__ajaxInstances;
        if (instances.has(name)) {
            const ajax = instances.get(name);
            ajax === null || ajax === void 0 ? void 0 : ajax.abort();
            instances.delete(name);
        }
        const opts = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)(this.options[name] !== undefined ? this.options[name] : {}, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)({
            onProgress: this.progressHandler
        }, this.o.ajax));
        if (opts.prepareData) {
            opts.data = opts.prepareData.call(this, opts.data);
        }
        const ajax = new jodit_core_request__WEBPACK_IMPORTED_MODULE_6__.Ajax(opts);
        instances.set(name, ajax);
        const promise = ajax.send();
        promise.finally(()=>{
            ajax.destruct();
            instances.delete(name);
            this.progressHandler(100);
        }).catch(()=>null);
        return promise.then((resp)=>resp.json()).then((resp)=>{
            if (resp && !this.isSuccess(resp)) {
                throw new Error(this.getMessage(resp));
            }
            return resp;
        });
    }
    onProgress(callback) {
        this.progressHandler = callback;
    }
    /**
	 * Load permissions for path and source
	 */ permissions(path, source) {
        return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
            if (!this.o.permissions) {
                return null;
            }
            this.o.permissions.data.path = path;
            this.o.permissions.data.source = source;
            if (this.o.permissions.url) {
                return this.get('permissions').then((resp)=>{
                    if (this.parent.isInDestruct) {
                        throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.abort)();
                    }
                    let process = this.o.permissions.process;
                    if (!process) {
                        process = this.o.ajax.process;
                    }
                    if (process) {
                        const respData = process.call(self, resp);
                        if (respData.data.permissions) {
                            this.parent.events.fire(this, 'changePermissions', this.__currentPermissions, respData.data.permissions);
                            this.__currentPermissions = respData.data.permissions;
                        }
                    }
                    return this.__currentPermissions;
                });
            }
            return null;
        }).call(this);
    }
    canI(action) {
        const rule = 'allow' + action;
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_4__.IS_PROD) {
            if (!possibleRules.has(rule)) {
                throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)('Wrong action ' + action);
            }
        }
        const presetValue = this.o.permissionsPresets[rule];
        if (presetValue !== undefined) {
            return presetValue;
        }
        return this.__currentPermissions == null || this.__currentPermissions[rule] === undefined || this.__currentPermissions[rule];
    }
    __items(path, source, mods, onResult) {
        const opt = this.options;
        if (!opt.items) {
            return Promise.reject(Error('Set Items api options'));
        }
        opt.items.data.path = path;
        opt.items.data.source = source;
        opt.items.data.mods = mods;
        return this.get('items').then((resp)=>{
            let process = this.o.items.process;
            if (!process) {
                process = this.o.ajax.process;
            }
            if (process) {
                resp = process.call(self, resp);
            }
            return onResult(resp);
        });
    }
    /**
	 * Load items list by path and source
	 */ items(path, source, mods = {}) {
        return this.__items(path, source, mods, (resp)=>this.generateItemsList(resp.data.sources, mods));
    }
    /**
	 * Load items list by path and source
	 */ itemsEx(path, source, mods = {}) {
        const calcTotal = (sources)=>sources.reduce((acc, source)=>acc + source.files.length, 0);
        return this.__items(path, source, mods, (resp)=>({
                items: this.generateItemsList(resp.data.sources, mods),
                loadedTotal: calcTotal(resp.data.sources)
            }));
    }
    generateItemsList(sources, mods = {}) {
        const elements = [];
        const canBeFile = (item)=>item.type === 'folder' || !mods.onlyImages || item.isImage === undefined || item.isImage;
        const inFilter = (item)=>{
            var _mods_filterWord;
            return !((_mods_filterWord = mods.filterWord) === null || _mods_filterWord === void 0 ? void 0 : _mods_filterWord.length) || this.o.filter === undefined || this.o.filter(item, mods.filterWord);
        };
        sources.forEach((source)=>{
            if (source.files && source.files.length) {
                const { sort } = this.o;
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isFunction)(sort) && mods.sortBy) {
                    source.files.sort((a, b)=>sort(a, b, mods.sortBy));
                }
                source.files.forEach((item)=>{
                    if (inFilter(item) && canBeFile(item)) {
                        elements.push(jodit_modules_file_browser_builders_item__WEBPACK_IMPORTED_MODULE_7__.FileBrowserItem.create((0,_swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_3__._)((0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_2__._)({}, item), {
                            sourceName: source.name,
                            source
                        })));
                    }
                });
            }
        });
        return elements;
    }
    tree(path, source) {
        return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
            path = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.normalizeRelativePath)(path);
            if (!this.o.folder) {
                return Promise.reject(Error('Set Folder Api options'));
            }
            yield this.permissions(path, source);
            this.o.folder.data.path = path;
            this.o.folder.data.source = source;
            return this.get('folder').then((resp)=>{
                let process = this.o.folder.process;
                if (!process) {
                    process = this.o.ajax.process;
                }
                if (process) {
                    resp = process.call(self, resp);
                }
                return resp.data.sources;
            });
        }).call(this);
    }
    /**
	 * Get path by url. You can use this method in another modules
	 */ getPathByUrl(url) {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.set)('options.getLocalFileByUrl.data.url', url, this);
        return this.get('getLocalFileByUrl').then((resp)=>{
            if (this.isSuccess(resp)) {
                return resp.data;
            }
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)(this.getMessage(resp));
        });
    }
    /**
	 * Create a directory on the server
	 *
	 * @param name - Name the new folder
	 * @param path - Relative directory in which you want create a folder
	 * @param source - Server source key
	 */ createFolder(name, path, source) {
        const { create } = this.o;
        if (!create) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)('Set Create api options');
        }
        create.data.source = source;
        create.data.path = path;
        create.data.name = name;
        return this.get('create').then((resp)=>{
            if (this.isSuccess(resp)) {
                return true;
            }
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)(this.getMessage(resp));
        });
    }
    /**
	 * Move a file / directory on the server
	 *
	 * @param filepath - The relative path to the file / folder source
	 * @param path - Relative to the directory where you want to move the file / folder
	 */ move(filepath, path, source, isFile) {
        const mode = isFile ? 'fileMove' : 'folderMove';
        const option = this.options[mode];
        if (!option) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)('Set Move api options');
        }
        option.data.from = filepath;
        option.data.path = path;
        option.data.source = source;
        return this.get(mode).then((resp)=>{
            if (this.isSuccess(resp)) {
                return true;
            }
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)(this.getMessage(resp));
        });
    }
    /**
	 * Deleting item
	 *
	 * @param path - Relative path
	 * @param file - The filename
	 * @param source - Source
	 */ remove(action, path, file, source) {
        const fr = this.o[action];
        if (!fr) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)(`Set "${action}" api options`);
        }
        fr.data.path = path;
        fr.data.name = file;
        fr.data.source = source;
        return this.get(action).then((resp)=>{
            if (fr.process) {
                resp = fr.process.call(this, resp);
            }
            return this.getMessage(resp);
        });
    }
    /**
	 * Deleting a file
	 *
	 * @param path - Relative path
	 * @param file - The filename
	 * @param source - Source
	 */ fileRemove(path, file, source) {
        return this.remove('fileRemove', path, file, source);
    }
    /**
	 * Deleting a folder
	 *
	 * @param path - Relative path
	 * @param file - The filename
	 * @param source - Source
	 */ folderRemove(path, file, source) {
        return this.remove('folderRemove', path, file, source);
    }
    /**
	 * Rename action
	 *
	 * @param path - Relative path
	 * @param name - Old name
	 * @param newname - New name
	 * @param source - Source
	 */ rename(action, path, name, newname, source) {
        const fr = this.o[action];
        if (!fr) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)(`Set "${action}" api options`);
        }
        fr.data.path = path;
        fr.data.name = name;
        fr.data.newname = newname;
        fr.data.source = source;
        return this.get(action).then((resp)=>{
            if (fr.process) {
                resp = fr.process.call(self, resp);
            }
            return this.getMessage(resp);
        });
    }
    /**
	 * Rename folder
	 */ folderRename(path, name, newname, source) {
        return this.rename('folderRename', path, name, newname, source);
    }
    /**
	 * Rename file
	 */ fileRename(path, name, newname, source) {
        return this.rename('fileRename', path, name, newname, source);
    }
    changeImage(type, path, source, name, newname, box) {
        if (!this.o[type]) {
            this.o[type] = {
                data: {}
            };
        }
        const query = this.o[type];
        if (query.data === undefined) {
            query.data = {
                action: type
            };
        }
        query.data.newname = newname || name;
        if (box) {
            query.data.box = box;
        }
        query.data.path = path;
        query.data.name = name;
        query.data.source = source;
        return this.get(type).then(()=>{
            return true;
        });
    }
    /**
	 * Send command to server to crop image
	 */ crop(path, source, name, newname, box) {
        return this.changeImage('crop', path, source, name, newname, box);
    }
    /**
	 * Send command to server to resize image
	 */ resize(path, source, name, newname, box) {
        return this.changeImage('resize', path, source, name, newname, box);
    }
    getMessage(resp) {
        return this.options.getMessage(resp);
    }
    isSuccess(resp) {
        return this.options.isSuccess(resp);
    }
    destruct() {
        this.__ajaxInstances.forEach((a)=>a.destruct());
        this.__ajaxInstances.clear();
    }
    constructor(parent, options){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "parent", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "options", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "__currentPermissions", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "__ajaxInstances", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "progressHandler", void 0);
        this.parent = parent;
        this.options = options;
        this.__currentPermissions = null;
        this.__ajaxInstances = new Map();
        this.progressHandler = (ignore)=>{};
    }
}



/***/ }),

/***/ 17849:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28686);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80991);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/inline-popup
 */ 

const cmd = (control)=>control.args && (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__.isString)(control.args[0]) ? control.args[0].toLowerCase() : '';
/* harmony default export */ __webpack_exports__["default"] = ([
    'brushCell',
    {
        name: 'valign',
        list: [
            'Top',
            'Middle',
            'Bottom',
            'Normal'
        ],
        childTemplate: (_, __, value)=>value,
        exec: (editor, table, { control })=>{
            const command = cmd(control);
            editor.getInstance('Table', editor.o).getAllSelectedCells().forEach((cell)=>{
                (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__.css)(cell, 'vertical-align', command === 'normal' ? '' : command);
            });
        },
        tooltip: 'Vertical align'
    },
    {
        name: 'splitv',
        list: {
            tablesplitv: 'Split vertical',
            tablesplitg: 'Split horizontal'
        },
        tooltip: 'Split'
    },
    {
        name: 'align',
        icon: 'left'
    },
    '\n',
    {
        name: 'merge',
        command: 'tablemerge',
        tooltip: 'Merge'
    },
    {
        name: 'addcolumn',
        list: {
            tableaddcolumnbefore: 'Insert column before',
            tableaddcolumnafter: 'Insert column after'
        },
        exec: (editor, table, { control })=>{
            if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__.isJoditObject)(editor)) {
                return;
            }
            if (!control.args) {
                return false;
            }
            const command = cmd(control);
            editor.execCommand(command, false, table);
        },
        tooltip: 'Add column'
    },
    {
        name: 'addrow',
        list: {
            tableaddrowbefore: 'Insert row above',
            tableaddrowafter: 'Insert row below'
        },
        exec: (editor, table, { control })=>{
            if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__.isJoditObject)(editor)) {
                return;
            }
            if (!control.args) {
                return false;
            }
            const command = cmd(control);
            editor.execCommand(command, false, table);
        },
        tooltip: 'Add row'
    },
    {
        name: 'delete',
        icon: 'bin',
        list: {
            tablebin: 'Delete table',
            tablebinrow: 'Delete row',
            tablebincolumn: 'Delete column',
            tableempty: 'Empty cell'
        },
        exec: (editor, table, { control })=>{
            if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__.isJoditObject)(editor)) {
                return;
            }
            if (!control.args) {
                return false;
            }
            const command = cmd(control);
            editor.execCommand(command, false, table);
            editor.e.fire('hidePopup');
        },
        tooltip: 'Delete'
    }
]);


/***/ }),

/***/ 18073:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   size: function() { return /* binding */ size; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28686);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/size
 */ 
function size(subject) {
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__.isString)(subject) || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__.isArray)(subject)) {
        return subject.length;
    }
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(subject)) {
        return Object.keys(subject).length;
    }
    return 0;
}


/***/ }),

/***/ 18080:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   i18n: function() { return /* binding */ i18n; },
/* harmony export */   sprintf: function() { return /* binding */ sprintf; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_string_ucfirst__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(99436);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(93640);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/string
 */ 




/**
 * Simple variant sprintf function
 */ const sprintf = (str, args)=>{
    if (!args || !args.length) {
        return str;
    }
    const reg = /%([sd])/g;
    let fnd = reg.exec(str);
    let res = str, i = 0;
    while(fnd && args[i] !== undefined){
        res = res.replace(fnd[0], args[i].toString());
        i += 1;
        fnd = reg.exec(str);
    }
    return res;
};
/**
 * Internationalization method. Uses Jodit.lang object
 * @example
 * ```javascript
 * var editor = Jodit.make("#redactor", {
 *      language: 'ru'
 * });
 * console.log(editor.i18n('Cancel')) //Отмена;
 *
 * Jodit.defaultOptions.language = 'ru';
 * console.log(Jodit.prototype.i18n('Cancel')) //Отмена
 *
 * Jodit.lang.cs = {
 *    Cancel: 'Zrušit'
 * };
 * Jodit.defaultOptions.language = 'cs';
 * console.log(Jodit.prototype.i18n('Cancel')) //Zrušit
 *
 * Jodit.lang.cs = {
 *    'Hello world': 'Hello \s Good \s'
 * };
 * Jodit.defaultOptions.language = 'cs';
 * console.log(Jodit.prototype.i18n('Hello world', 'mr.Perkins', 'day')) //Hello mr.Perkins Good day
 * ```
 */ function i18n(key, params, options) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__.isString)(key)) {
        throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.error)('i18n: Need string in first argument');
    }
    if (!key.length) {
        return key;
    }
    const debug = Boolean(options === null || options === void 0 ? void 0 : options.debugLanguage);
    let store = {};
    const parse = (value)=>params && params.length ? sprintf(value, params) : value, defaultLanguage = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.defaultLanguage)(jodit_config__WEBPACK_IMPORTED_MODULE_4__.Config.defaultOptions.language, jodit_config__WEBPACK_IMPORTED_MODULE_4__.Config.defaultOptions.language), language = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.defaultLanguage)(options === null || options === void 0 ? void 0 : options.language, defaultLanguage), tryGet = (store)=>{
        if (!store) {
            return;
        }
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__.isString)(store[key])) {
            return parse(store[key]);
        }
        const lcKey = key.toLowerCase();
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__.isString)(store[lcKey])) {
            return parse(store[lcKey]);
        }
        const ucfKey = (0,jodit_core_helpers_string_ucfirst__WEBPACK_IMPORTED_MODULE_2__.ucfirst)(key);
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__.isString)(store[ucfKey])) {
            return parse(store[ucfKey]);
        }
        return;
    };
    if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang[language] !== undefined) {
        store = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang[language];
    } else if (!debug) {
        if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang[defaultLanguage] !== undefined) {
            store = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang[defaultLanguage];
        } else {
            store = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang.en;
        }
    }
    const i18nOvr = options === null || options === void 0 ? void 0 : options.i18n;
    if (i18nOvr && i18nOvr[language]) {
        const result = tryGet(i18nOvr[language]);
        if (result) {
            return result;
        }
    }
    const result = tryGet(store);
    if (result) {
        return result;
    }
    if (!debug && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang.en && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__.isString)(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang.en[key]) && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang.en[key]) {
        return parse(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang.en[key]);
    }
    if (debug) {
        return '{' + key + '}';
    }
    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && language !== 'en') {
        console.warn(`i18n need "${key}" in "${language}"`);
    }
    return parse(key);
}


/***/ }),

/***/ 18272:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   makeContextMenu: function() { return /* binding */ makeContextMenu; },
/* harmony export */   makeDataProvider: function() { return /* binding */ makeDataProvider; }
/* harmony export */ });
/* harmony import */ var jodit_modules_context_menu_context_menu__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67399);
/* harmony import */ var _data_provider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ 

function makeDataProvider(parent, options) {
    return new _data_provider__WEBPACK_IMPORTED_MODULE_1__["default"](parent, options);
}
function makeContextMenu(parent) {
    return new jodit_modules_context_menu_context_menu__WEBPACK_IMPORTED_MODULE_0__.ContextMenu(parent);
}


/***/ }),

/***/ 18303:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isVoid: function() { return /* binding */ isVoid; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ /**
 * Check value is undefined or null
 */ function isVoid(value) {
    // eslint-disable-next-line eqeqeq
    return value === undefined || value === null;
}


/***/ }),

/***/ 18377:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalizePath: function() { return /* binding */ normalizePath; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4040);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/normalize
 */ 
/**
 * Replaces back slashes and correctly concatenates several parts of the path.
 */ const normalizePath = (...path)=>{
    return path.filter((part)=>(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__.trim)(part).length).map((part, index)=>{
        part = part.replace(/([^:])[\\/]+/g, '$1/');
        if (index) {
            part = part.replace(/^\//, '');
        }
        if (index !== path.length - 1) {
            part = part.replace(/\/$/, '');
        }
        return part;
    }).join('/');
};


/***/ }),

/***/ 18380:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   readMargins: function() { return /* binding */ readMargins; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(74264);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 
/** @private */ function readMargins(image, values, state) {
    // Margins
    let equal = true, wasEmptyField = false;
    [
        'marginTop',
        'marginRight',
        'marginBottom',
        'marginLeft'
    ].forEach((id)=>{
        let value = image.style.getPropertyValue((0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_0__.kebabCase)(id));
        if (!value) {
            wasEmptyField = true;
            values[id] = 0;
            return;
        }
        if (/^[0-9]+(px)?$/.test(value)) {
            value = parseInt(value, 10);
        }
        values[id] = value;
        if (wasEmptyField && values[id] || equal && id !== 'marginTop' && values[id] !== values.marginTop) {
            equal = false;
        }
    });
    state.marginIsLocked = equal;
}


/***/ }),

/***/ 18605:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1025 1369v167h-248l-159-252-24-42q-8-9-11-21h-3l-9 21q-10 20-25 44l-155 250h-258v-167h128l197-291-185-272h-137v-168h276l139 228q2 4 23 42 8 9 11 21h3q3-9 11-21l25-42 140-228h257v168h-125l-184 267 204 296h109zm637-679v206h-514l-3-27q-4-28-4-46 0-64 26-117t65-86.5 84-65 84-54.5 65-54 26-64q0-38-29.5-62.5t-70.5-24.5q-51 0-97 39-14 11-36 38l-105-92q26-37 63-66 83-65 188-65 110 0 178 59.5t68 158.5q0 56-24.5 103t-62 76.5-81.5 58.5-82 50.5-65.5 51.5-30.5 63h232v-80h126z\"/> </svg>"

/***/ }),

/***/ 18762:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileSelectorWidget: function() { return /* binding */ FileSelectorWidget; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4099);
/* harmony import */ var jodit_modules_widget_tabs_tabs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(89636);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/widget/file-selector/README.md]]
 * @packageDocumentation
 * @module modules/widget/file-selector
 */ 



/**
 * Generate 3 tabs
 * upload - Use Drag and Drop
 * url - By specifying the image url
 * filebrowser - After opening the file browser. In the absence of one of the parameters will be less tabs
 *
 * @param callbacks - Object with keys `url`, `upload` and `filebrowser`, values which are callback
 * functions with different parameters
 */ const FileSelectorWidget = (editor, callbacks, elm, close, isImage = true)=>{
    let currentImage;
    const tabs = [];
    const options = editor.o.uploader;
    if (callbacks.upload && (options.url || options.insertImageAsBase64URI || options.customUploadFunction)) {
        const dragBox = editor.c.fromHTML('<div class="jodit-drag-and-drop__file-box">' + `<strong>${editor.i18n(isImage ? 'Drop image' : 'Drop file')}</strong>` + `<span><br>${editor.i18n('or click')}</span>` + `<input type="file" accept="${isImage ? 'image/*' : '*'}" tabindex="-1" dir="auto" multiple=""/>` + '</div>');
        editor.uploader.bind(dragBox, (resp)=>{
            const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(callbacks.upload) ? callbacks.upload : options.defaultHandlerSuccess;
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(handler)) {
                handler.call(editor, resp);
            }
            editor.e.fire('closeAllPopups');
        }, (error)=>{
            editor.message.error(error.message);
            editor.e.fire('closeAllPopups');
        });
        tabs.push({
            icon: 'upload',
            name: 'Upload',
            content: dragBox
        });
    }
    if (callbacks.filebrowser) {
        if (editor.o.filebrowser.ajax.url || editor.o.filebrowser.items.url) {
            tabs.push({
                icon: 'folder',
                name: 'Browse',
                content: ()=>{
                    close && close();
                    if (callbacks.filebrowser) {
                        editor.filebrowser.open(callbacks.filebrowser, isImage);
                    }
                }
            });
        }
    }
    if (callbacks.url) {
        const button = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__.UIButton(editor, {
            type: 'submit',
            variant: 'primary',
            text: 'Insert'
        }), form = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__.UIForm(editor, [
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__.UIInput(editor, {
                required: true,
                label: 'URL',
                name: 'url',
                type: 'text',
                placeholder: 'https://'
            }),
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__.UIInput(editor, {
                name: 'text',
                label: 'Alternative text'
            }),
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__.UIBlock(editor, [
                button
            ])
        ]);
        currentImage = null;
        if (elm && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isText(elm) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isComment(elm) && (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(elm, 'img') || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.$$)('img', elm).length)) {
            currentImage = elm.tagName === 'IMG' ? elm : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.$$)('img', elm)[0];
            val(form.container, 'input[name=url]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(currentImage, 'src'));
            val(form.container, 'input[name=text]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(currentImage, 'alt'));
            button.state.text = 'Update';
        }
        if (elm && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(elm, 'a')) {
            val(form.container, 'input[name=url]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'href'));
            val(form.container, 'input[name=text]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'title'));
            button.state.text = 'Update';
        }
        form.onSubmit((data)=>{
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(callbacks.url)) {
                callbacks.url.call(editor, data.url, data.text);
            }
        });
        tabs.push({
            icon: 'link',
            name: 'URL',
            content: form.container
        });
    }
    return (0,jodit_modules_widget_tabs_tabs__WEBPACK_IMPORTED_MODULE_3__.TabsWidget)(editor, tabs);
};
function val(elm, selector, value) {
    const child = elm.querySelector(selector);
    if (!child) {
        return '';
    }
    if (value) {
        child.value = value;
    }
    return child.value;
}


/***/ }),

/***/ 18855:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Plugin: function() { return /* binding */ Plugin; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16964);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24497);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/plugin/README.md]]
 * @packageDocumentation
 * @module plugin
 */ 




class Plugin extends jodit_core_component__WEBPACK_IMPORTED_MODULE_2__.ViewComponent {
    /** @override */ className() {
        return 'Plugin';
    }
    __afterPluginSystemInit() {
        const { j, buttons } = this;
        if (buttons && (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_4__.isJoditObject)(j)) {
            buttons.forEach((btn)=>{
                j.registerButton(btn);
            });
        }
    }
    __afterInit() {
        this.__inited = true;
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_2__.STATUSES.ready);
        this.afterInit(this.jodit);
    }
    init(jodit) {
        if (this.jodit.isReady) {
            this.afterInit(this.jodit);
            this.__afterPluginSystemInit();
            this.jodit.e.fire('rebuildToolbar');
        }
    }
    __beforeDestruct() {
        if (this.isInDestruct) {
            return;
        }
        const { j } = this;
        j.e.off('afterPluginSystemInit', this.__afterPluginSystemInit).off('afterInit', this.__afterInit).off('beforeDestruct', this.destruct);
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_2__.STATUSES.beforeDestruct);
        if (!this.__inited) {
            return super.destruct();
        }
        if ((0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_4__.isJoditObject)(j)) {
            var _this_buttons;
            (_this_buttons = this.buttons) === null || _this_buttons === void 0 ? void 0 : _this_buttons.forEach((btn)=>{
                j === null || j === void 0 ? void 0 : j.unregisterButton(btn);
            });
        }
        this.beforeDestruct(this.j);
        super.destruct();
    }
    constructor(jodit){
        super(jodit), /** @override */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "buttons", []), /**
	 * Plugin have CSS style and it should be loaded
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "hasStyle", false), /**
	 * Additional plugin styles can be written simply as inline styles
	 * ```js
	 * class A extends Jodit.modules.Plugin {
	 *   styles = 'h1{color: red}';
	 * }
	 * ```
	 * Will only be applied if the plugin is activated
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "styles", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__inited", false);
        jodit.e.on('afterPluginSystemInit', this.__afterPluginSystemInit).on('afterInit', this.__afterInit).on('beforeDestruct', this.__beforeDestruct);
    }
}
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(Plugin, "requires", []);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], Plugin.prototype, "__afterPluginSystemInit", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], Plugin.prototype, "__afterInit", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], Plugin.prototype, "__beforeDestruct", null);


/***/ }),

/***/ 18869:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EventHandlersStore: function() { return /* binding */ EventHandlersStore; },
/* harmony export */   defaultNameSpace: function() { return /* binding */ defaultNameSpace; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88475);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module event-emitter
 */ 


const defaultNameSpace = 'JoditEventDefaultNamespace';
class EventHandlersStore {
    get(event, namespace) {
        if (this.__store.has(namespace)) {
            const ns = this.__store.get(namespace);
            (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__.assert)(ns, '-');
            return ns[event];
        }
    }
    indexOf(event, namespace, originalCallback) {
        const blocks = this.get(event, namespace);
        if (blocks) {
            for(let i = 0; i < blocks.length; i += 1){
                if (blocks[i].originalCallback === originalCallback) {
                    return i;
                }
            }
        }
        return false;
    }
    namespaces(withoutDefault = false) {
        const nss = (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__.toArray)(this.__store.keys());
        return withoutDefault ? nss.filter((ns)=>ns !== defaultNameSpace) : nss;
    }
    events(namespace) {
        const ns = this.__store.get(namespace);
        return ns ? Object.keys(ns) : [];
    }
    set(event, namespace, data, onTop = false) {
        let ns = this.__store.get(namespace);
        if (!ns) {
            ns = {};
            this.__store.set(namespace, ns);
        }
        if (ns[event] === undefined) {
            ns[event] = [];
        }
        if (!onTop) {
            ns[event].push(data);
        } else {
            ns[event].unshift(data);
        }
    }
    clear() {
        this.__store.clear();
    }
    clearEvents(namespace, event) {
        const ns = this.__store.get(namespace);
        if (ns && ns[event]) {
            delete ns[event];
            if (!Object.keys(ns).length) {
                this.__store.delete(namespace);
            }
        }
    }
    isEmpty() {
        return this.__store.size === 0;
    }
    constructor(){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__store", new Map());
    }
}


/***/ }),

/***/ 18929:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5266);
/* harmony import */ var _source_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9103);
/* harmony import */ var _source_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_source_svg__WEBPACK_IMPORTED_MODULE_3__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/source
 */ 



jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.beautifyHTML = !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_IE;
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.sourceEditor = 'ace';
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.sourceEditorNativeOptions = {
    /**
	 * Show gutter
	 */ showGutter: true,
    /**
	 * Default theme
	 */ theme: 'ace/theme/idle_fingers',
    /**
	 * Default mode
	 */ mode: 'ace/mode/html',
    /**
	 * Wrap lines. Possible values - "off", 80-100..., true, "free"
	 */ wrap: true,
    /**
	 * Highlight active line
	 */ highlightActiveLine: true
};
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.sourceEditorCDNUrlsJS = [
    'https://cdnjs.cloudflare.com/ajax/libs/ace/1.4.2/ace.js'
];
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.beautifyHTMLCDNUrlsJS = [
    'https://cdnjs.cloudflare.com/ajax/libs/js-beautify/1.14.4/beautify.min.js',
    'https://cdnjs.cloudflare.com/ajax/libs/js-beautify/1.14.4/beautify-html.min.js'
];
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__.Icon.set('source', (_source_svg__WEBPACK_IMPORTED_MODULE_3___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.controls.source = {
    mode: jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT,
    exec: (editor)=>{
        editor.toggleMode();
    },
    isActive: (editor)=>{
        return editor.getRealMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE;
    },
    tooltip: 'Change mode'
};


/***/ }),

/***/ 18993:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5266);
/* harmony import */ var _symbols_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81875);
/* harmony import */ var _symbols_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_symbols_svg__WEBPACK_IMPORTED_MODULE_2__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/symbols
 */ 


jodit_config__WEBPACK_IMPORTED_MODULE_1__.Config.prototype.usePopupForSpecialCharacters = false;
jodit_config__WEBPACK_IMPORTED_MODULE_1__.Config.prototype.specialCharacters = [
    '!',
    '&quot;',
    '#',
    '$',
    '%',
    '&amp;',
    "'",
    '(',
    ')',
    '*',
    '+',
    '-',
    '.',
    '/',
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    ':',
    ';',
    '&lt;',
    '=',
    '&gt;',
    '?',
    '@',
    'A',
    'B',
    'C',
    'D',
    'E',
    'F',
    'G',
    'H',
    'I',
    'J',
    'K',
    'L',
    'M',
    'N',
    'O',
    'P',
    'Q',
    'R',
    'S',
    'T',
    'U',
    'V',
    'W',
    'X',
    'Y',
    'Z',
    '[',
    ']',
    '^',
    '_',
    '`',
    'a',
    'b',
    'c',
    'd',
    'e',
    'f',
    'g',
    'h',
    'i',
    'j',
    'k',
    'l',
    'm',
    'n',
    'o',
    'p',
    'q',
    'r',
    's',
    't',
    'u',
    'v',
    'w',
    'x',
    'y',
    'z',
    '{',
    '|',
    '}',
    '~',
    '&euro;',
    '&lsquo;',
    '&rsquo;',
    '&ldquo;',
    '&rdquo;',
    '&ndash;',
    '&mdash;',
    '&iexcl;',
    '&cent;',
    '&pound;',
    '&curren;',
    '&yen;',
    '&brvbar;',
    '&sect;',
    '&uml;',
    '&copy;',
    '&ordf;',
    '&laquo;',
    '&raquo;',
    '&not;',
    '&reg;',
    '&macr;',
    '&deg;',
    '&sup2;',
    '&sup3;',
    '&acute;',
    '&micro;',
    '&para;',
    '&middot;',
    '&cedil;',
    '&sup1;',
    '&ordm;',
    '&frac14;',
    '&frac12;',
    '&frac34;',
    '&iquest;',
    '&Agrave;',
    '&Aacute;',
    '&Acirc;',
    '&Atilde;',
    '&Auml;',
    '&Aring;',
    '&AElig;',
    '&Ccedil;',
    '&Egrave;',
    '&Eacute;',
    '&Ecirc;',
    '&Euml;',
    '&Igrave;',
    '&Iacute;',
    '&Icirc;',
    '&Iuml;',
    '&ETH;',
    '&Ntilde;',
    '&Ograve;',
    '&Oacute;',
    '&Ocirc;',
    '&Otilde;',
    '&Ouml;',
    '&times;',
    '&Oslash;',
    '&Ugrave;',
    '&Uacute;',
    '&Ucirc;',
    '&Uuml;',
    '&Yacute;',
    '&THORN;',
    '&szlig;',
    '&agrave;',
    '&aacute;',
    '&acirc;',
    '&atilde;',
    '&auml;',
    '&aring;',
    '&aelig;',
    '&ccedil;',
    '&egrave;',
    '&eacute;',
    '&ecirc;',
    '&euml;',
    '&igrave;',
    '&iacute;',
    '&icirc;',
    '&iuml;',
    '&eth;',
    '&ntilde;',
    '&ograve;',
    '&oacute;',
    '&ocirc;',
    '&otilde;',
    '&ouml;',
    '&divide;',
    '&oslash;',
    '&ugrave;',
    '&uacute;',
    '&ucirc;',
    '&uuml;',
    '&yacute;',
    '&thorn;',
    '&yuml;',
    '&OElig;',
    '&oelig;',
    '&#372;',
    '&#374',
    '&#373',
    '&#375;',
    '&sbquo;',
    '&#8219;',
    '&bdquo;',
    '&hellip;',
    '&trade;',
    '&#9658;',
    '&bull;',
    '&rarr;',
    '&rArr;',
    '&hArr;',
    '&diams;',
    '&asymp;'
];
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__.Icon.set('symbols', (_symbols_svg__WEBPACK_IMPORTED_MODULE_2___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_1__.Config.prototype.controls.symbols = {
    hotkeys: [
        'ctrl+shift+i',
        'cmd+shift+i'
    ],
    tooltip: 'Insert Special Character',
    popup: (editor, current, close)=>{
        const container = editor.e.fire('generateSpecialCharactersTable.symbols');
        if (container) {
            if (editor.o.usePopupForSpecialCharacters) {
                const box = editor.c.div();
                box.classList.add('jodit-symbols');
                box.appendChild(container);
                editor.e.on(container, 'close_dialog', close);
                return box;
            }
            editor.alert(container, 'Select Special Character', undefined, 'jodit-symbols').bindDestruct(editor);
            const a = container.querySelector('a');
            a && a.focus();
        }
        return;
    }
};


/***/ }),

/***/ 19147:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NUMBER_FIELDS_REG: function() { return /* binding */ NUMBER_FIELDS_REG; },
/* harmony export */   normalizeCssNumericValue: function() { return /* binding */ normalizeCssNumericValue; },
/* harmony export */   normalizeCssValue: function() { return /* binding */ normalizeCssValue; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(70222);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18303);
/* harmony import */ var jodit_core_helpers_color_color_to_hex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(93387);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74264);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/normalize
 */ 



const NUMBER_FIELDS_REG = /^(left|top|bottom|right|width|min|max|height|margin|padding|fontsize|font-size)/i;
function normalizeCssNumericValue(key, value) {
    if (!(0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_1__.isVoid)(value) && NUMBER_FIELDS_REG.test(key) && (0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_0__.isNumeric)(value.toString())) {
        return parseInt(value.toString(), 10) + 'px';
    }
    return value;
}
function normalizeCssValue(key, value) {
    switch((0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_3__.kebabCase)(key)){
        case 'font-weight':
            switch(value.toString().toLowerCase()){
                case '700':
                case 'bold':
                    return 700;
                case '400':
                case 'normal':
                    return 400;
                case '900':
                case 'heavy':
                    return 900;
            }
            return (0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_0__.isNumeric)(value) ? Number(value) : value;
    }
    if (/color/i.test(key) && /^rgb/i.test(value.toString())) {
        return (0,jodit_core_helpers_color_color_to_hex__WEBPACK_IMPORTED_MODULE_2__.colorToHex)(value.toString()) || value;
    }
    return value;
}


/***/ }),

/***/ 19549:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getSuitParent: function() { return /* binding */ getSuitParent; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var _is_normal_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83653);
/* harmony import */ var _is_suit_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(73019);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 


/**
 * Checks if the parent of an element is suitable for applying styles, if applicable, then returns the parent *
 *
 * @param style - styles to be applied
 * @param node - checked item
 * @param root - editor root
 * @private
 */ function getSuitParent(style, node, root) {
    const { parentNode } = node;
    if (parentNode === root || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isHTMLElement(parentNode) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.next(node, _is_normal_node__WEBPACK_IMPORTED_MODULE_1__.isNormalNode, parentNode) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.prev(node, _is_normal_node__WEBPACK_IMPORTED_MODULE_1__.isNormalNode, parentNode)) {
        return null;
    }
    // <h3><span style="color:red">|test|</span></h3> => apply <h2>
    if (style.isElementCommit && style.elementIsBlock && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock(parentNode)) {
        return getSuitParent(style, parentNode, root);
    }
    if ((0,_is_suit_element__WEBPACK_IMPORTED_MODULE_2__.isSuitElement)(style, parentNode, false) && (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock(parentNode) || style.elementIsBlock)) {
        return parentNode;
    }
    // <strong style="color:red"><em>|test|</em></strong> => apply <strong>
    if (style.isElementCommit && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock(parentNode)) {
        return getSuitParent(style, parentNode, root);
    }
    return null;
}


/***/ }),

/***/ 20784:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 48 48\" xmlns=\"http://www.w3.org/2000/svg\"> <path stroke=\"null\" d=\"m42.276011,26.302547c0.098397,-0.76605 0.172194,-1.54407 0.172194,-2.33406s-0.073797,-1.56801 -0.172194,-2.33406l5.202718,-3.961917c0.467384,-0.359086 0.602679,-1.005441 0.29519,-1.532101l-4.919828,-8.29489c-0.307489,-0.51469 -0.947067,-0.730142 -1.500548,-0.51469l-6.125186,2.405877c-1.266856,-0.945594 -2.656707,-1.747553 -4.157255,-2.357999l-0.922468,-6.343855c-0.110696,-0.562568 -0.614979,-1.005441 -1.229957,-1.005441l-9.839656,0c-0.614979,0 -1.119261,0.442873 -1.217657,1.005441l-0.922468,6.343855c-1.500548,0.610446 -2.890399,1.400436 -4.157255,2.357999l-6.125186,-2.405877c-0.553481,-0.203482 -1.193058,0 -1.500548,0.51469l-4.919828,8.29489c-0.307489,0.51469 -0.172194,1.161045 0.29519,1.532101l5.190419,3.961917c-0.098397,0.76605 -0.172194,1.54407 -0.172194,2.33406s0.073797,1.56801 0.172194,2.33406l-5.190419,3.961917c-0.467384,0.359086 -0.602679,1.005441 -0.29519,1.532101l4.919828,8.29489c0.307489,0.51469 0.947067,0.730142 1.500548,0.51469l6.125186,-2.405877c1.266856,0.945594 2.656707,1.747553 4.157255,2.357999l0.922468,6.343855c0.098397,0.562568 0.602679,1.005441 1.217657,1.005441l9.839656,0c0.614979,0 1.119261,-0.442873 1.217657,-1.005441l0.922468,-6.343855c1.500548,-0.610446 2.890399,-1.400436 4.157255,-2.357999l6.125186,2.405877c0.553481,0.203482 1.193058,0 1.500548,-0.51469l4.919828,-8.29489c0.307489,-0.51469 0.172194,-1.161045 -0.29519,-1.532101l-5.190419,-3.961917zm-18.277162,6.044617c-4.759934,0 -8.609699,-3.746465 -8.609699,-8.378677s3.849766,-8.378677 8.609699,-8.378677s8.609699,3.746465 8.609699,8.378677s-3.849766,8.378677 -8.609699,8.378677z\"/> </svg>"

/***/ }),

/***/ 21132:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyMargin: function() { return /* binding */ applyMargin; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80991);
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10808);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 

/** @private */ function applyMargin(j, marginTop, marginRight, marginBottom, marginLeft, image, marginIsLocked) {
    const margins = [
        marginTop,
        marginRight,
        marginBottom,
        marginLeft
    ];
    const applyMargin = (key, value)=>{
        const oldValue = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_0__.css)(image, key);
        const v = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__.normalSizeToString)(value);
        if (oldValue.toString() !== v.toString()) {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_0__.css)(image, key, v);
        }
    };
    if (!marginIsLocked) {
        const sides = [
            'margin-top',
            'margin-right',
            'margin-bottom',
            'margin-left'
        ];
        margins.forEach((margin, index)=>{
            const side = sides[index];
            applyMargin(side, margin);
        });
    } else {
        applyMargin('margin', marginTop);
    }
}


/***/ }),

/***/ 21195:
/***/ (function(module) {

module.exports["default"] = ["なにかタイプしてください","Joditについて","Jodit Editor","Jodit ユーザーズ・ガイド","詳しい使い方","ライセンス詳細についてはJodit Webサイトを確認ください：","フルバージョンを購入","Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.","Anchor","新しいタブで開く","エディターのサイズ（フル/ノーマル）","書式をクリア","テキストの色","やり直し","元に戻す","太字","斜体","箇条書き","番号付きリスト","中央揃え","両端揃え","左揃え","右揃え","区切り線を挿入","画像を挿入","ファイルを挿入","Youtube/Vimeo 動画","リンクを挿入","フォントサイズ","フォント","テキストのスタイル","指定なし","タイトル1","タイトル2","タイトル3","タイトル4","引用","コード","挿入","表を挿入","インデント減","インデント増","特殊文字を選択","特殊文字を挿入","書式を貼付け","編集モード切替え","マージン","上","右","下","左","スタイル","クラス","配置","右寄せ","中央寄せ","左寄せ","指定なし","ソース","タイトル","代替テキスト","リンク","新しいタブで開く","画像","ファイル","高度な設定","画像のプロパティー","キャンセル","確定","File Browser","Error on load list","Error on load folders","Are you sure?","Enter Directory name","Create directory","type name","ここに画像をドロップ","ここにファイルをドロップ","or クリック","代替テキスト","アップロード","ブラウズ","背景","文字","上","中央","下","左に列を挿入","右に列を挿入","上に行を挿入","下に行を挿入","表を削除","行を削除","列を削除","セルを空にする","文字数: %d","単語数: %d","取り消し線","下線","上付き文字","下付き文字","切り取り","すべて選択","Pause","検索","置換","交換","貼付け","選択した内容を貼付け","source","bold","italic","brush","link","undo","redo","table","image","eraser","paragraph","fontsize","video","font","about","print","underline","strikethrough","indent","outdent","fullsize","shrink","分割線","箇条書き","番号付きリスト","切り取り","すべて選択","埋め込みコード","リンクを開く","リンクを編集","No follow","リンク解除","更新","鉛筆","サイトを確認","URL","編集","水平方向の配置","Filter","Sort by changed","Sort by name","Sort by size","Add folder","リセット","保存","Save as ...","リサイズ","Crop","幅","高さ","縦横比を保持","はい","いいえ","移除","選択","選択: %s","垂直方向の配置","分割","セルの結合","列を追加","行を追加","ライセンス: %s","削除","セルの分割（垂直方向）","セルの分割（水平方向）","境界線","HTMLコードを保持しますか？","HTMLで貼付け","HTMLを保持","HTMLをテキストにする","テキストだけ","You can only edit your own images. Download this image on the host?","The image has been successfully uploaded to the host!","パレット","There are no files","Rename","Enter new name","プレビュー","ダウンロード","貼り付け","お使いのブラウザはクリップボードを使用できません","コピー","copy","角の丸み","全て表示","適用","まだこの分野","を入力してくださいウェブアドレス","デフォルト","白丸","黒丸","四角","見","探前","由来","The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?","Word Paste Detected","Clean","クラス名を挿入","カスタムサイズ変更のためのAltキーを押します",null,null,null,"全部"]

/***/ }),

/***/ 21513:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    'copy-format': 'Format de copie'
};


/***/ }),

/***/ 22289:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isBoolean: function() { return /* binding */ isBoolean; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ function isBoolean(elm) {
    return typeof elm === 'boolean';
}


/***/ }),

/***/ 22380:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    'copy-format': 'Copiar formato'
};


/***/ }),

/***/ 22533:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToolbarButton: function() { return /* binding */ ToolbarButton; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41411);
/* harmony import */ var _swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15366);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(69364);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(59400);
/* harmony import */ var jodit_core_ui_helpers_get_control_type__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(15982);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(29434);
/* harmony import */ var jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(51116);
/* harmony import */ var jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(42573);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(4274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/toolbar/button/README.md]]
 * @packageDocumentation
 * @module modules/toolbar/button
 */ 














class ToolbarButton extends jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_8__.UIButton {
    /** @override */ className() {
        return 'ToolbarButton';
    }
    /**
	 * Get parent toolbar
	 */ get toolbar() {
        return this.closest(jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_12__.ToolbarCollection);
    }
    /** @override **/ update() {
        var _control_value, _control_update;
        const { control, state } = this, tc = this.closest(jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_12__.ToolbarCollection);
        if (!tc) {
            return;
        }
        const value = (_control_value = control.value) === null || _control_value === void 0 ? void 0 : _control_value.call(control, tc.jodit, this);
        if (value !== undefined) {
            state.value = value;
        }
        state.disabled = this.__calculateDisabledStatus(tc);
        state.activated = this.__calculateActivatedStatus(tc);
        (_control_update = control.update) === null || _control_update === void 0 ? void 0 : _control_update.call(control, tc.jodit, this);
    }
    /**
	 * Calculates whether the button is active
	 */ __calculateActivatedStatus(tc) {
        var _this_control_isActive, _this_control;
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isJoditObject)(this.j) && !this.j.editorIsActive) {
            return false;
        }
        if ((_this_control_isActive = (_this_control = this.control).isActive) === null || _this_control_isActive === void 0 ? void 0 : _this_control_isActive.call(_this_control, this.j, this)) {
            return true;
        }
        return Boolean(tc && tc.shouldBeActive(this));
    }
    /**
	 * Calculates whether an element is blocked for the user
	 */ __calculateDisabledStatus(tc) {
        var _this_control_isDisabled, _this_control;
        if (this.j.o.disabled) {
            return true;
        }
        if (this.j.o.readonly && (!this.j.o.activeButtonsInReadOnly || !this.j.o.activeButtonsInReadOnly.includes(this.control.name))) {
            return true;
        }
        if ((_this_control_isDisabled = (_this_control = this.control).isDisabled) === null || _this_control_isDisabled === void 0 ? void 0 : _this_control_isDisabled.call(_this_control, this.j, this)) {
            return true;
        }
        return Boolean(tc && tc.shouldBeDisabled(this));
    }
    /** @override */ onChangeActivated() {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.attr)(this.button, 'aria-pressed', this.state.activated);
        super.onChangeActivated();
    }
    /** @override */ onChangeText() {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isFunction)(this.control.template)) {
            this.text.innerHTML = this.control.template(this.j, this.control.name, this.j.i18n(this.state.text));
        } else {
            super.onChangeText();
        }
        this.setMod('text-icons', Boolean(this.text.innerText.trim().length));
    }
    /** @override */ onChangeTabIndex() {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.attr)(this.button, 'tabindex', this.state.tabIndex);
    }
    createContainer() {
        const cn = this.componentName;
        const container = this.j.c.span(cn);
        const button = super.createContainer();
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.attr)(container, 'role', 'listitem');
        button.classList.remove(cn);
        button.classList.add(cn + '__button');
        Object.defineProperty(button, 'component', {
            value: this
        });
        container.appendChild(button);
        const trigger = this.j.c.fromHTML(`<span role="trigger" class="${cn}__trigger">${jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_10__.Icon.get('chevron')}</span>`);
        // For caching
        button.appendChild(trigger);
        return container;
    }
    /** @override */ focus() {
        var _this_container_querySelector;
        (_this_container_querySelector = this.container.querySelector('button')) === null || _this_container_querySelector === void 0 ? void 0 : _this_container_querySelector.focus();
    }
    onChangeHasTrigger() {
        if (this.state.hasTrigger) {
            this.container.appendChild(this.trigger);
        } else {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_6__.Dom.safeRemove(this.trigger);
        }
        this.setMod('with-trigger', this.state.hasTrigger || null);
    }
    /** @override */ onChangeDisabled() {
        const disabled = this.state.disabled ? 'disabled' : null;
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.attr)(this.trigger, 'disabled', disabled);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.attr)(this.button, 'disabled', disabled);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.attr)(this.container, 'disabled', disabled);
    }
    /**
	 * Init constant data from control
	 */ __initFromControl() {
        const { control: ctr, state } = this;
        this.updateSize();
        state.name = ctr.name;
        const { textIcons } = this.j.o;
        if (textIcons === true || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isFunction)(textIcons) && textIcons(ctr.name) || ctr.template) {
            state.icon = (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_8__.UIButtonState)().icon;
            state.text = ctr.text || ctr.name;
        } else {
            if (ctr.iconURL) {
                state.icon.iconURL = ctr.iconURL;
            } else {
                var _this_j_o_extraIcons;
                const name = ctr.icon || ctr.name;
                state.icon.name = jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_10__.Icon.exists(name) || ((_this_j_o_extraIcons = this.j.o.extraIcons) === null || _this_j_o_extraIcons === void 0 ? void 0 : _this_j_o_extraIcons[name]) ? name : '';
            }
            if (!ctr.iconURL && !state.icon.name) {
                state.text = ctr.text || ctr.name;
            }
        }
        if (ctr.tooltip) {
            state.tooltip = this.j.i18n((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isFunction)(ctr.tooltip) ? ctr.tooltip(this.j, ctr, this) : ctr.tooltip);
        }
        state.hasTrigger = Boolean(ctr.list || ctr.popup && ctr.exec);
    }
    /**
	 * Click on trigger button
	 */ onTriggerClick(e) {
        if (this.openedPopup) {
            this.__closePopup();
            return;
        }
        const { control: ctr } = this;
        e.buffer = {
            actionTrigger: this
        };
        if (ctr.list) {
            return this.__openControlList(ctr);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isFunction)(ctr.popup)) {
            const popup = this.openPopup();
            popup.parentElement = this;
            try {
                if (this.j.e.fire((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.camelCase)(`before-${ctr.name}-open-popup`), this.target, ctr, popup) !== false) {
                    var _this_toolbar;
                    var _this_toolbar_getTarget, _ref;
                    const target = (_ref = (_this_toolbar_getTarget = (_this_toolbar = this.toolbar) === null || _this_toolbar === void 0 ? void 0 : _this_toolbar.getTarget(this)) !== null && _this_toolbar_getTarget !== void 0 ? _this_toolbar_getTarget : this.target) !== null && _ref !== void 0 ? _ref : null;
                    const elm = ctr.popup(this.j, target, this.__closePopup, this);
                    if (elm) {
                        popup.setContent((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isString)(elm) ? this.j.c.fromHTML(elm) : elm).open(()=>(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.position)(this.container), false, this.j.o.allowTabNavigation ? this.container : undefined);
                    } else {
                        this.__closePopup();
                    }
                }
            } catch (e) {
                this.__closePopup();
                throw e;
            }
            /**
			 * Fired after the popup was opened for some control button
			 */ /**
			 * Close all opened popups
			 */ this.j.e.fire((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.camelCase)(`after-${ctr.name}-open-popup`), popup.container);
        }
    }
    /**
	 * Create an open popup list
	 */ __openControlList(control) {
        var _this_jodit_options_controls;
        const controls = (_this_jodit_options_controls = this.jodit.options.controls) !== null && _this_jodit_options_controls !== void 0 ? _this_jodit_options_controls : {}, getControl = (key)=>(0,jodit_core_ui_helpers_get_control_type__WEBPACK_IMPORTED_MODULE_9__.findControlType)(key, controls);
        const list = control.list, menu = this.openPopup(), toolbar = (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_13__.makeCollection)(this.j);
        menu.parentElement = this;
        toolbar.parentElement = menu;
        toolbar.mode = 'vertical';
        const isListItem = (key)=>(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isPlainObject)(key) && 'title' in key && 'value' in key;
        const getButton = (key, value)=>{
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isString)(value) && getControl(value)) {
                return (0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({
                    name: value.toString()
                }, getControl(value));
            }
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isString)(key) && getControl(key)) {
                return (0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({
                    name: key.toString()
                }, getControl(key), typeof value === 'object' ? value : {});
            }
            if (isListItem(key)) {
                value = key.value;
                key = key.title;
            }
            const { childTemplate } = control;
            const childControl = {
                name: key.toString(),
                template: childTemplate && ((j, k, v)=>childTemplate(j, k, v, this)),
                exec: control.childExec ? (view, current, options)=>{
                    var _control_childExec;
                    return (_control_childExec = control.childExec) === null || _control_childExec === void 0 ? void 0 : _control_childExec.call(control, view, current, (0,_swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__._)((0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({}, options), {
                        parentControl: control
                    }));
                } : control.exec,
                data: control.data,
                command: control.command,
                isActive: control.isChildActive,
                value: control.value,
                isDisabled: control.isChildDisabled,
                mode: control.mode,
                args: [
                    ...control.args ? control.args : [],
                    key,
                    value
                ]
            };
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isString)(value)) {
                childControl.text = value;
            }
            return childControl;
        };
        toolbar.build((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isArray)(list) ? list.map(getButton) : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.keys)(list, false).map((key)=>getButton(key, list[key])), this.target);
        menu.setContent(toolbar).open(()=>(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.position)(this.container), false, this.j.o.allowTabNavigation ? this.container : undefined);
        this.state.activated = true;
    }
    onOutsideClick(e) {
        if (!this.openedPopup) {
            return;
        }
        if (!e || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_6__.Dom.isNode(e.target) || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_6__.Dom.isOrContains(this.container, e.target) && !this.openedPopup.isOwnClick(e)) {
            this.__closePopup();
        }
    }
    openPopup() {
        this.__closePopup();
        this.openedPopup = new jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_11__.Popup(this.j, false);
        this.j.e.on(this.ow, 'mousedown touchstart', this.onOutsideClick).on('escape closeAllPopups', this.onOutsideClick);
        return this.openedPopup;
    }
    __closePopup() {
        if (this.openedPopup) {
            this.j.e.off(this.ow, 'mousedown touchstart', this.onOutsideClick).off('escape closeAllPopups', this.onOutsideClick);
            this.state.activated = false;
            this.openedPopup.close();
            this.openedPopup.destruct();
            this.openedPopup = null;
        }
    }
    /**
	 * Click handler
	 */ onClick(originalEvent) {
        const { control: ctr } = this;
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isFunction)(ctr.exec)) {
            var _this_toolbar;
            var _this_toolbar_getTarget, _ref;
            const target = (_ref = (_this_toolbar_getTarget = (_this_toolbar = this.toolbar) === null || _this_toolbar === void 0 ? void 0 : _this_toolbar.getTarget(this)) !== null && _this_toolbar_getTarget !== void 0 ? _this_toolbar_getTarget : this.target) !== null && _ref !== void 0 ? _ref : null;
            const result = ctr.exec(this.j, target, {
                control: ctr,
                originalEvent,
                button: this
            });
            // For memorise exec
            if (result !== false && result !== true) {
                var _this_j_e, _this_j, /**
				 * Fired after calling `button.exec` function
				 */ _this_j_e1, _this_j1;
                (_this_j = this.j) === null || _this_j === void 0 ? void 0 : (_this_j_e = _this_j.e) === null || _this_j_e === void 0 ? void 0 : _this_j_e.fire('synchro');
                if (this.parentElement) {
                    this.parentElement.update();
                }
                (_this_j1 = this.j) === null || _this_j1 === void 0 ? void 0 : (_this_j_e1 = _this_j1.e) === null || _this_j_e1 === void 0 ? void 0 : _this_j_e1.fire('closeAllPopups afterExec');
            }
            if (result !== false) {
                return;
            }
        }
        if (ctr.list) {
            return this.__openControlList(ctr);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isFunction)(ctr.popup)) {
            return this.onTriggerClick(originalEvent);
        }
        if (ctr.command || ctr.name) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.call)((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isJoditObject)(this.j) ? this.j.execCommand.bind(this.j) : this.j.od.execCommand.bind(this.j.od), ctr.command || ctr.name, false, ctr.args && ctr.args[0]);
            this.j.e.fire('closeAllPopups');
        }
    }
    destruct() {
        this.__closePopup();
        return super.destruct();
    }
    constructor(jodit, control, target = null){
        super(jodit), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "control", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "target", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "state", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "trigger", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "openedPopup", void 0), this.control = control, this.target = target, this.state = (0,_swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__._)((0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({}, (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_8__.UIButtonState)()), {
            theme: 'toolbar',
            currentValue: '',
            hasTrigger: false
        }), this.openedPopup = null;
        const button = this.getElm('button');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.assert)(button, 'Element button should exists');
        this.button = button;
        Object.defineProperty(button, 'component', {
            value: this,
            configurable: true
        });
        const trigger = this.getElm('trigger');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.assert)(trigger, 'Element trigger should exists');
        this.trigger = trigger;
        trigger.remove();
        // Prevent lost focus
        jodit.e.on([
            this.button,
            this.trigger
        ], 'mousedown', (e)=>e.preventDefault());
        this.onAction(this.onClick);
        this.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_4__.STATUSES.ready, ()=>{
            this.__initFromControl();
            this.update();
        });
        if (control.mods) {
            Object.keys(control.mods).forEach((mod)=>{
                control.mods && this.setMod(mod, control.mods[mod]);
            });
        }
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.cacheHTML
], ToolbarButton.prototype, "createContainer", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.watch)('state.hasTrigger', {
        immediately: false
    })
], ToolbarButton.prototype, "onChangeHasTrigger", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.watch)('trigger:click')
], ToolbarButton.prototype, "onTriggerClick", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.autobind
], ToolbarButton.prototype, "onOutsideClick", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.autobind
], ToolbarButton.prototype, "__closePopup", null);
ToolbarButton = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.component
], ToolbarButton);


/***/ }),

/***/ 22852:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stripTags: function() { return /* binding */ stripTags; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4040);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(93640);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/html
 */ 



const NEW_LINE_TAGS = new Set([
    'div',
    'p',
    'br',
    'h1',
    'h2',
    'h3',
    'h4',
    'h5',
    'h6',
    'hr'
]);
const INVISIBLE_TAGS = new Set([
    'script',
    'style'
]);
const ALONE_TAGS = new Set([
    'br',
    'hr',
    'input'
]);
/**
 * Extract plain text from HTML text
 */ function stripTags(html, doc = document, exclude = null) {
    const tmp = doc.createElement('div');
    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__.isString)(html)) {
        tmp.innerHTML = html;
    } else {
        tmp.appendChild(html);
    }
    (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.$$)('*', tmp).forEach((p)=>{
        const pr = p.parentNode;
        if (!pr) {
            return;
        }
        if (exclude && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(p, exclude)) {
            const tag = p.nodeName.toLowerCase();
            const text = !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(p, ALONE_TAGS) ? `%%%jodit-${tag}%%%${stripTags(p.innerHTML, doc, exclude)}%%%/jodit-${tag}%%%` : `%%%jodit-single-${tag}%%%`;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.before(p, doc.createTextNode(text));
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(p);
            return;
        }
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(p, INVISIBLE_TAGS)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(p);
            return;
        }
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(p, NEW_LINE_TAGS)) {
            return;
        }
        const nx = p.nextSibling;
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isText(nx) && /^\s/.test(nx.nodeValue || '')) {
            return;
        }
        if (nx) {
            pr.insertBefore(doc.createTextNode(' '), nx);
        }
    });
    return restoreTags((0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__.trim)(tmp.innerText));
}
function restoreTags(content) {
    return content.replace(/%%%(\/)?jodit(-single)?-([\w\n]+)%%%/g, (_, isClosed, isSingle, tag)=>`<${isClosed ? '/' : ''}${tag}>`);
}


/***/ }),

/***/ 22998:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    'copy-format': 'Formátum másolás'
};


/***/ }),

/***/ 23112:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dataURItoBlob: function() { return /* binding */ dataURItoBlob; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/uploader
 */ /**
 * Convert dataURI to Blob
 */ function dataURItoBlob(dataURI) {
    // convert base64 to raw binary data held in a string
    // doesn't handle URLEncoded DataURIs - see SO answer #6850276 for code that does this
    const byteString = atob(dataURI.split(',')[1]), // separate out the mime component
    mimeString = dataURI.split(',')[0].split(':')[1].split(';')[0], // write the bytes of the string to an ArrayBuffer
    ab = new ArrayBuffer(byteString.length), ia = new Uint8Array(ab);
    for(let i = 0; i < byteString.length; i += 1){
        ia[i] = byteString.charCodeAt(i);
    }
    return new Blob([
        ia.buffer
    ], {
        type: mimeString
    });
}


/***/ }),

/***/ 23175:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isMarker: function() { return /* binding */ isMarker; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ 

/**
 * Define element is selection helper
 */ function isMarker(elm) {
    return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isNode(elm) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(elm, 'span') && elm.hasAttribute('data-' + jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MARKER_CLASS);
}


/***/ }),

/***/ 23183:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Elms: function() { return /* binding */ Elms; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(88475);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module traits
 */ 
class Elms {
    /**
	 * Return element with BEM class name
	 */ getElm(elementName) {
        return this.container.querySelector(`.${this.getFullElName(elementName)}`);
    }
    /**
	 * Return elements with BEM class name
	 */ getElms(elementName) {
        return (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__.toArray)(this.container.querySelectorAll(`.${this.getFullElName(elementName)}`));
    }
}


/***/ }),

/***/ 23211:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Dom: function() { return /* binding */ Dom; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88475);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28686);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4040);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(93640);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/dom/README.md]]
 * @packageDocumentation
 * @module dom
 */ 





/**
 * Module for working with DOM
 */ class Dom {
    /**
	 * Remove all content from element
	 */ static detach(node) {
        while(node && node.firstChild){
            node.removeChild(node.firstChild);
        }
    }
    /**
	 * Wrap all inline next siblings
	 */ static wrapNextInline(current, tag, editor) {
        let tmp;
        const first = current;
        let last = current;
        editor.s.save();
        let needFindNext = false;
        do {
            needFindNext = false;
            tmp = last.nextSibling;
            if (tmp && !Dom.isBlock(tmp) && !Dom.isTag(tmp, 'br')) {
                needFindNext = true;
                last = tmp;
            }
        }while (needFindNext)
        return Dom.__wrapElements(tag, editor, first, last);
    }
    static __wrapElements(tag, editor, first, last) {
        const wrapper = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isString)(tag) ? editor.createInside.element(tag) : tag;
        if (first.parentNode) {
            first.parentNode.insertBefore(wrapper, first);
        }
        let next = first;
        while(next){
            next = first.nextSibling;
            wrapper.appendChild(first);
            if (first === last || !next) {
                break;
            }
            first = next;
        }
        editor.s.restore();
        return wrapper;
    }
    /**
	 * Wrap all inline siblings
	 */ static wrapInline(current, tag, editor) {
        let tmp;
        let first = current;
        let last = current;
        editor.s.save();
        let needFindNext = false;
        do {
            needFindNext = false;
            tmp = first.previousSibling;
            if (tmp && !Dom.isBlock(tmp)) {
                needFindNext = true;
                first = tmp;
            }
        }while (needFindNext)
        do {
            needFindNext = false;
            tmp = last.nextSibling;
            if (tmp && !Dom.isBlock(tmp)) {
                needFindNext = true;
                last = tmp;
            }
        }while (needFindNext)
        return Dom.__wrapElements(tag, editor, first, last);
    }
    /**
	 * Wrap node inside another node
	 */ static wrap(current, tag, create) {
        const wrapper = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isString)(tag) ? create.element(tag) : tag;
        if (Dom.isNode(current)) {
            if (!current.parentNode) {
                throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.error)('Element should be in DOM');
            }
            current.parentNode.insertBefore(wrapper, current);
            wrapper.appendChild(current);
        } else {
            const fragment = current.extractContents();
            current.insertNode(wrapper);
            wrapper.appendChild(fragment);
        }
        return wrapper;
    }
    /**
	 * Remove parent of node and insert this node instead that parent
	 */ static unwrap(node) {
        const parent = node.parentNode;
        if (parent) {
            while(node.firstChild){
                parent.insertBefore(node.firstChild, node);
            }
            Dom.safeRemove(node);
        }
    }
    /**
	 * Call functions for all nodes between `start` and `end`
	 */ static between(start, end, callback) {
        let next = start;
        while(next && next !== end){
            if (start !== next && callback(next)) {
                break;
            }
            let step = next.firstChild || next.nextSibling;
            if (!step) {
                while(next && !next.nextSibling){
                    next = next.parentNode;
                }
                step = next === null || next === void 0 ? void 0 : next.nextSibling;
            }
            next = step;
        }
    }
    static replace(elm, newTagName, create, withAttributes = false, notMoveContent = false) {
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isHTML)(newTagName)) {
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.assert)(create, 'Need create instance for new tag');
            newTagName = create.fromHTML(newTagName);
        }
        let tag;
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isString)(newTagName)) {
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.assert)(create, 'Need create instance for new tag');
            tag = create.element(newTagName);
        } else {
            tag = newTagName;
        }
        if (!notMoveContent) {
            while(elm.firstChild){
                tag.appendChild(elm.firstChild);
            }
        }
        if (withAttributes && Dom.isElement(elm) && Dom.isElement(tag)) {
            (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__.toArray)(elm.attributes).forEach((attr)=>{
                tag.setAttribute(attr.name, attr.value);
            });
        }
        if (elm.parentNode) {
            elm.parentNode.replaceChild(tag, elm);
        }
        return tag;
    }
    /**
	 * Checks whether the Node text and blank (in this case it may contain invisible auxiliary characters ,
	 * it is also empty )
	 *
	 * @param node - The element of wood to be checked
	 */ static isEmptyTextNode(node) {
        return Dom.isText(node) && (!node.nodeValue || node.nodeValue.replace(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP(), '').trim().length === 0);
    }
    static isEmptyContent(node) {
        return Dom.each(node, (elm)=>Dom.isEmptyTextNode(elm));
    }
    /**
	 * The node is editable
	 */ static isContentEditable(node, root) {
        return Dom.isNode(node) && !Dom.closest(node, (elm)=>Dom.isElement(elm) && elm.getAttribute('contenteditable') === 'false', root);
    }
    static isEmpty(node, condNoEmptyElement = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NO_EMPTY_TAGS) {
        if (!node) {
            return true;
        }
        let cond;
        if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isFunction)(condNoEmptyElement)) {
            cond = (elm)=>condNoEmptyElement.has(elm.nodeName.toLowerCase());
        } else {
            cond = condNoEmptyElement;
        }
        const emptyText = (node)=>node.nodeValue == null || (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__.trim)(node.nodeValue).length === 0;
        if (Dom.isText(node)) {
            return emptyText(node);
        }
        return !(Dom.isElement(node) && cond(node)) && Dom.each(node, (elm)=>{
            if (Dom.isText(elm) && !emptyText(elm) || Dom.isElement(elm) && cond(elm)) {
                return false;
            }
        });
    }
    /**
	 * Returns true if it is a DOM node
	 */ static isNode(object) {
        // Duck-typing
        return Boolean(object && (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isString)(object.nodeName) && typeof object.nodeType === 'number' && object.childNodes && (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isFunction)(object.appendChild));
    }
    /**
	 *  Check if element is table cell
	 */ static isCell(elm) {
        return Dom.isNode(elm) && (elm.nodeName === 'TD' || elm.nodeName === 'TH');
    }
    /**
	 * Check if element is a list	element UL or OL
	 */ static isList(elm) {
        return Dom.isTag(elm, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS);
    }
    /**
	 * Check if element is a part of list	element LI
	 */ static isLeaf(elm) {
        return Dom.isTag(elm, 'li');
    }
    /**
	 * Check is element is Image element
	 */ static isImage(elm) {
        return Dom.isNode(elm) && /^(img|svg|picture|canvas)$/i.test(elm.nodeName);
    }
    /**
	 * Check the `node` is a block element
	 * @param node - Object to check
	 */ static isBlock(node) {
        return !(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isVoid)(node) && typeof node === 'object' && Dom.isNode(node) && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_BLOCK.test(node.nodeName);
    }
    /**
	 * Check if element is text node
	 */ static isText(node) {
        return Boolean(node && node.nodeType === Node.TEXT_NODE);
    }
    /**
	 * Check if element is comment node
	 */ static isComment(node) {
        return Boolean(node && node.nodeType === Node.COMMENT_NODE);
    }
    /**
	 * Check if element is element node
	 */ static isElement(node) {
        var _node_ownerDocument;
        if (!Dom.isNode(node)) {
            return false;
        }
        const win = (_node_ownerDocument = node.ownerDocument) === null || _node_ownerDocument === void 0 ? void 0 : _node_ownerDocument.defaultView;
        return Boolean(win && node.nodeType === Node.ELEMENT_NODE);
    }
    /**
	 * Check if element is document fragment
	 */ static isFragment(node) {
        var _node_ownerDocument;
        if (!Dom.isNode(node)) {
            return false;
        }
        const win = (_node_ownerDocument = node.ownerDocument) === null || _node_ownerDocument === void 0 ? void 0 : _node_ownerDocument.defaultView;
        return Boolean(win && node.nodeType === Node.DOCUMENT_FRAGMENT_NODE);
    }
    /**
	 * Check if element is HTMLElement node
	 */ static isHTMLElement(node) {
        var _node_ownerDocument;
        if (!Dom.isNode(node)) {
            return false;
        }
        const win = (_node_ownerDocument = node.ownerDocument) === null || _node_ownerDocument === void 0 ? void 0 : _node_ownerDocument.defaultView;
        return Boolean(win && node instanceof win.HTMLElement);
    }
    /**
	 * Check element is inline block
	 */ static isInlineBlock(node) {
        return Dom.isElement(node) && !/^(BR|HR)$/i.test(node.tagName) && [
            'inline',
            'inline-block'
        ].indexOf((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.css)(node, 'display').toString()) !== -1;
    }
    /**
	 * It's block and it can be split
	 */ static canSplitBlock(node) {
        return !(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isVoid)(node) && Dom.isHTMLElement(node) && Dom.isBlock(node) && !/^(TD|TH|CAPTION|FORM)$/.test(node.nodeName) && node.style !== undefined && !/^(fixed|absolute)/i.test(node.style.position);
    }
    /**
	 * Get last matched node inside root
	 */ static last(root, condition) {
        let last = root === null || root === void 0 ? void 0 : root.lastChild;
        if (!last) {
            return null;
        }
        do {
            if (condition(last)) {
                return last;
            }
            let next = last.lastChild;
            if (!next) {
                next = last.previousSibling;
            }
            if (!next && last.parentNode !== root) {
                do {
                    last = last.parentNode;
                }while (last && !(last === null || last === void 0 ? void 0 : last.previousSibling) && last.parentNode !== root)
                next = last === null || last === void 0 ? void 0 : last.previousSibling;
            }
            last = next;
        }while (last)
        return null;
    }
    /**
	 * Find previous node
	 */ static prev(node, condition, root, withChild = true) {
        return Dom.find(node, condition, root, false, withChild);
    }
    /**
	 * Find next node what `condition(next) === true`
	 */ static next(node, condition, root, withChild = true) {
        return Dom.find(node, condition, root, true, withChild);
    }
    static prevWithClass(node, className) {
        return Dom.prev(node, (node)=>{
            return Dom.isElement(node) && node.classList.contains(className);
        }, node.parentNode);
    }
    static nextWithClass(node, className) {
        return Dom.next(node, (elm)=>Dom.isElement(elm) && elm.classList.contains(className), node.parentNode);
    }
    /**
	 * Find next/prev node what `condition(next) === true`
	 */ static find(node, condition, root, leftToRight = true, withChild = true) {
        const gen = this.nextGen(node, root, leftToRight, withChild);
        let item = gen.next();
        while(!item.done){
            if (condition(item.value)) {
                return item.value;
            }
            item = gen.next();
        }
        return null;
    }
    /**
	 * Find next/prev node what `condition(next) === true`
	 */ static *nextGen(start, root, leftToRight = true, withChild = true) {
        const stack = [];
        let currentNode = start;
        do {
            let next = leftToRight ? currentNode.nextSibling : currentNode.previousSibling;
            while(next){
                stack.unshift(next);
                next = leftToRight ? next.nextSibling : next.previousSibling;
            }
            yield* this.runInStack(start, stack, leftToRight, withChild);
            currentNode = currentNode.parentNode;
        }while (currentNode && currentNode !== root)
        return null;
    }
    /**
	 * It goes through all the internal elements of the node, causing a callback function
	 *
	 * @param elm - the element whose children and descendants you want to iterate over
	 * @param callback - It called for each item found
	 * @example
	 * ```javascript
	 * Jodit.modules.Dom.each(editor.s.current(), function (node) {
	 *  if (node.nodeType === Node.TEXT_NODE) {
	 *      node.nodeValue = node.nodeValue.replace(Jodit.INVISIBLE_SPACE_REG_EX, '') // remove all of the text element codes invisible character
	 *  }
	 * });
	 * ```
	 */ static each(elm, callback, leftToRight = true) {
        const gen = this.eachGen(elm, leftToRight);
        let item = gen.next();
        while(!item.done){
            if (callback(item.value) === false) {
                return false;
            }
            item = gen.next();
        }
        return true;
    }
    static eachGen(root, leftToRight = true) {
        return this.runInStack(root, [
            root
        ], leftToRight);
    }
    static *runInStack(start, stack, leftToRight, withChild = true) {
        while(stack.length){
            const item = stack.pop();
            if (withChild) {
                let child = leftToRight ? item.lastChild : item.firstChild;
                while(child){
                    stack.push(child);
                    child = leftToRight ? child.previousSibling : child.nextSibling;
                }
            }
            if (start !== item) {
                yield item;
            }
        }
    }
    /**
	 * Find next/prev node what `condition(next) === true`
	 */ static findWithCurrent(node, condition, root, sibling = 'nextSibling', child = 'firstChild') {
        let next = node;
        do {
            if (condition(next)) {
                return next || null;
            }
            if (child && next && next[child]) {
                const nextOne = Dom.findWithCurrent(next[child], condition, next, sibling, child);
                if (nextOne) {
                    return nextOne;
                }
            }
            while(next && !next[sibling] && next !== root){
                next = next.parentNode;
            }
            if (next && next[sibling] && next !== root) {
                next = next[sibling];
            }
        }while (next && next !== root)
        return null;
    }
    /**
	 * Get not empty sibling
	 */ static findSibling(node, left = true, cond = (n)=>!Dom.isEmptyTextNode(n)) {
        let sibling = Dom.sibling(node, left);
        while(sibling && !cond(sibling)){
            sibling = Dom.sibling(sibling, left);
        }
        return sibling && cond(sibling) ? sibling : null;
    }
    /**
	 * Returns the nearest non-empty sibling
	 */ static findNotEmptySibling(node, left) {
        return Dom.findSibling(node, left, (n)=>{
            var _n_nodeValue;
            return !Dom.isEmptyTextNode(n) && Boolean(!Dom.isText(n) || ((_n_nodeValue = n.nodeValue) === null || _n_nodeValue === void 0 ? void 0 : _n_nodeValue.length) && (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__.trim)(n.nodeValue));
        });
    }
    /**
	 * Returns the nearest non-empty neighbor
	 */ static findNotEmptyNeighbor(node, left, root) {
        return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.call)(left ? Dom.prev : Dom.next, node, (n)=>Boolean(n && (!(Dom.isText(n) || Dom.isComment(n)) || (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__.trim)((n === null || n === void 0 ? void 0 : n.nodeValue) || '').length)), root);
    }
    static sibling(node, left) {
        return left ? node.previousSibling : node.nextSibling;
    }
    /**
	 * It goes through all the elements in ascending order, and checks to see if they meet the predetermined condition
	 */ static up(node, condition, root, checkRoot = false) {
        let start = node;
        if (!start) {
            return null;
        }
        do {
            if (condition(start)) {
                return start;
            }
            if (start === root || !start.parentNode) {
                break;
            }
            start = start.parentNode;
        }while (start && start !== root)
        if (start === root && checkRoot && condition(start)) {
            return start;
        }
        return null;
    }
    static closest(node, tagsOrCondition, root) {
        let condition;
        const lc = (s)=>s.toLowerCase();
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isFunction)(tagsOrCondition)) {
            condition = tagsOrCondition;
        } else if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isArray)(tagsOrCondition) || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isSet)(tagsOrCondition)) {
            const set = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isSet)(tagsOrCondition) ? tagsOrCondition : new Set(tagsOrCondition.map(lc));
            condition = (tag)=>Boolean(tag && set.has(lc(tag.nodeName)));
        } else {
            condition = (tag)=>Boolean(tag && lc(tagsOrCondition) === lc(tag.nodeName));
        }
        return Dom.up(node, condition, root);
    }
    /**
	 * Furthest parent node matching condition
	 */ static furthest(node, condition, root) {
        let matchedParent = null, current = node === null || node === void 0 ? void 0 : node.parentElement;
        while(current && current !== root){
            if (condition(current)) {
                matchedParent = current;
            }
            current = current === null || current === void 0 ? void 0 : current.parentElement;
        }
        return matchedParent;
    }
    /**
	 * Append new element in the start of root
	 */ static appendChildFirst(root, newElement) {
        const child = root.firstChild;
        if (child) {
            if (child !== newElement) {
                root.insertBefore(newElement, child);
            }
        } else {
            root.appendChild(newElement);
        }
    }
    /**
	 * Insert newElement after element
	 */ static after(elm, newElement) {
        const { parentNode } = elm;
        if (!parentNode) {
            return;
        }
        if (parentNode.lastChild === elm) {
            parentNode.appendChild(newElement);
        } else {
            parentNode.insertBefore(newElement, elm.nextSibling);
        }
    }
    /**
	 * Insert newElement before element
	 */ static before(elm, newElement) {
        const { parentNode } = elm;
        if (!parentNode) {
            return;
        }
        parentNode.insertBefore(newElement, elm);
    }
    /**
	 * Insert newElement as first child inside element
	 */ static prepend(root, newElement) {
        root.insertBefore(newElement, root.firstChild);
    }
    static append(root, newElement) {
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isArray)(newElement)) {
            newElement.forEach((node)=>{
                this.append(root, node);
            });
        } else {
            root.appendChild(newElement);
        }
    }
    /**
	 * Move all content to another element
	 */ static moveContent(from, to, inStart = false, filter = ()=>true) {
        const fragment = (from.ownerDocument || jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument).createDocumentFragment();
        (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__.toArray)(from.childNodes).filter((elm)=>{
            if (filter(elm)) {
                return true;
            }
            Dom.safeRemove(elm);
            return false;
        }).forEach((node)=>{
            fragment.appendChild(node);
        });
        if (!inStart || !to.firstChild) {
            to.appendChild(fragment);
        } else {
            to.insertBefore(fragment, to.firstChild);
        }
    }
    /**
	 * Check root contains child or equal child
	 */ static isOrContains(root, child, onlyContains = false) {
        if (root === child) {
            return !onlyContains;
        }
        return Boolean(child && root && this.up(child, (nd)=>nd === root, root, true));
    }
    /**
	 * Safe remove element from DOM
	 */ static safeRemove(...nodes) {
        nodes.forEach((node)=>Dom.isNode(node) && node.parentNode && node.parentNode.removeChild(node));
    }
    static safeInsertNode(range, node) {
        range.collapsed || range.deleteContents();
        const child = Dom.isFragment(node) ? node.lastChild : node;
        if (range.startContainer === range.endContainer && range.collapsed && Dom.isTag(range.startContainer, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS)) {
            Dom.after(range.startContainer, node);
        } else {
            range.insertNode(node);
            child && range.setStartBefore(child);
        }
        range.collapse(true);
        // https://developer.mozilla.org/en-US/docs/Web/API/Range/insertNode
        // if the new node is to be added to a text Node, that Node is split at the
        // insertion point, and the insertion occurs between the two text nodes.
        [
            node.nextSibling,
            node.previousSibling
        ].forEach((n)=>Dom.isText(n) && !n.nodeValue && Dom.safeRemove(n));
    }
    /**
	 * Hide element
	 */ static hide(node) {
        if (!node) {
            return;
        }
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.dataBind)(node, '__old_display', node.style.display);
        node.style.display = 'none';
    }
    /**
	 * Show element
	 */ static show(node) {
        if (!node) {
            return;
        }
        const display = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.dataBind)(node, '__old_display');
        if (node.style.display === 'none') {
            node.style.display = display || '';
        }
    }
    static isTag(node, tagNames) {
        if (!this.isElement(node)) {
            return false;
        }
        const nameL = node.tagName.toLowerCase();
        const nameU = node.tagName.toUpperCase();
        if (tagNames instanceof Set) {
            return tagNames.has(nameL) || tagNames.has(nameU);
        }
        if (Array.isArray(tagNames)) {
            throw new TypeError('Dom.isTag does not support array');
        }
        const tags = tagNames;
        if (nameL === tags || nameU === tags) {
            return true;
        }
        return false;
    }
    /**
	 * Marks an item as temporary
	 */ static markTemporary(element, attributes) {
        attributes && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(element, attributes);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(element, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEMP_ATTR, true);
        return element;
    }
    /**
	 * Check if element is temporary
	 */ static isTemporary(element) {
        if (!Dom.isElement(element)) {
            return false;
        }
        return (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isMarker)(element) || (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(element, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEMP_ATTR) === 'true';
    }
    /**
	 * Replace temporary elements from string
	 */ static replaceTemporaryFromString(value) {
        return value.replace(/<([a-z]+)[^>]+data-jodit-temp[^>]+>(.+?)<\/\1>/gi, '$2');
    }
    /**
	 * Get temporary list
	 */ static temporaryList(root) {
        return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.$$)(`[${jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEMP_ATTR}]`, root);
    }
    constructor(){
        throw new Error('Dom is static module');
    }
}


/***/ }),

/***/ 23283:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isNativeFunction: function() { return /* binding */ isNativeFunction; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ /**
 * Check if function or method was not replaced on some custom implementation
 */ function isNativeFunction(f) {
    return Boolean(f) && (typeof f).toLowerCase() === 'function' && (f === Function.prototype || /^\s*function\s*(\b[a-z$_][a-z0-9$_]*\b)*\s*\((|([a-z$_][a-z0-9$_]*)(\s*,[a-z$_][a-z0-9$_]*)*)\)\s*{\s*\[native code]\s*}\s*$/i.test(String(f)));
}


/***/ }),

/***/ 23422:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export paste */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(18855);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(38187);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(54308);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/paste/README.md]]
 * @packageDocumentation
 * @module plugins/paste
 */ 









/**
 * Ask before paste HTML source
 */ class paste extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_7__.Plugin {
    /** @override **/ afterInit(jodit) {
        jodit.e.on('paste.paste', this.onPaste).on('pasteStack.paste', (item)=>this.pasteStack.push(item));
        if (jodit.o.nl2brInPlainText) {
            this.j.e.on('processPaste.paste', this.onProcessPasteReplaceNl2Br);
        }
    }
    /** @override **/ beforeDestruct(jodit) {
        jodit.e.off('paste.paste', this.onPaste).off('processPaste.paste', this.onProcessPasteReplaceNl2Br).off('.paste');
    }
    /**
	 * Paste event handler
	 */ onPaste(e) {
        try {
            if (this.customPasteProcess(e) === false || this.j.e.fire('beforePaste', e) === false) {
                e.preventDefault();
                return false;
            }
            this.defaultPasteProcess(e);
        } finally{
            this.j.e.fire('afterPaste', e);
        }
    }
    /**
	 * Process before paste
	 */ customPasteProcess(e) {
        if (!this.j.o.processPasteHTML) {
            return;
        }
        const dt = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.getDataTransfer)(e), texts = [
            dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.TEXT_PLAIN),
            dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.TEXT_HTML),
            dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.TEXT_RTF)
        ];
        for (const value of texts){
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.isHTML)(value) && (this.j.e.fire('processHTML', e, value, {
                plain: texts[0],
                html: texts[1],
                rtf: texts[2]
            }) || this.processHTML(e, value))) {
                return false;
            }
        }
    }
    /**
	 * Default paster process
	 */ defaultPasteProcess(e) {
        const dt = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.getDataTransfer)(e);
        let text = (dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.TEXT_HTML)) || (dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.TEXT_PLAIN));
        if (dt && text && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.trim)(text) !== '') {
            const result = this.j.e.fire('processPaste', e, text, (0,_helpers__WEBPACK_IMPORTED_MODULE_9__.getAllTypes)(dt));
            if (result !== undefined) {
                text = result;
            }
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.isString)(text) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.isNode(text)) {
                this.__insertByType(e, text, this.j.o.defaultActionOnPaste);
            }
            e.preventDefault();
            e.stopPropagation();
        }
    }
    /**
	 * Process usual HTML text fragment
	 */ processHTML(e, html) {
        if (!this.j.o.askBeforePasteHTML) {
            return false;
        }
        if (this.j.o.memorizeChoiceWhenPasteFragment) {
            const cached = this.pasteStack.find((cachedItem)=>cachedItem.html === html);
            if (cached) {
                this.__insertByType(e, html, cached.action || this.j.o.defaultActionOnPaste);
                return true;
            }
        }
        if (this._isDialogOpened) {
            return true;
        }
        const dialog = (0,_helpers__WEBPACK_IMPORTED_MODULE_9__.askInsertTypeDialog)(this.j, 'Your code is similar to HTML. Keep as HTML?', 'Paste as HTML', (insertType)=>{
            this._isDialogOpened = false;
            this.__insertByType(e, html, insertType);
        }, this.j.o.pasteHTMLActionList);
        if (dialog) {
            this._isDialogOpened = true;
            dialog.e.on('beforeClose', ()=>{
                this._isDialogOpened = false;
            });
        }
        return true;
    }
    /**
	 * Insert HTML by option type
	 */ __insertByType(e, html, action) {
        this.pasteStack.push({
            html,
            action
        });
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.isString)(html)) {
            this.j.buffer.set(jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.CLIPBOARD_ID, html);
            switch(action){
                case jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.INSERT_CLEAR_HTML:
                    html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.cleanFromWord)(html);
                    break;
                case jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.INSERT_ONLY_TEXT:
                    html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.stripTags)(html, this.j.ed, new Set(this.j.o.pasteExcludeStripTags));
                    break;
                case jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.INSERT_AS_TEXT:
                    html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.htmlspecialchars)(html);
                    break;
                default:
                    {
                        const newHTML = this.j.e.fire('onCustomPasteHTMLOption', action, html, e);
                        if (typeof newHTML === 'string') {
                            html = newHTML;
                        }
                    }
            }
        }
        (0,_helpers__WEBPACK_IMPORTED_MODULE_9__.pasteInsertHtml)(e, this.j, html);
    }
    /**
	 * Replace all \\n chars in plain text to br
	 */ onProcessPasteReplaceNl2Br(ignore, text, type) {
        if (type === jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.TEXT_PLAIN + ';' && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.isHTML)(text)) {
            return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.nl2br)(text);
        }
    }
    constructor(...args){
        super(...args), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "pasteStack", new jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.LimitedStack(20)), /**
	 * The dialog box was already open
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "_isDialogOpened", false);
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], paste.prototype, "onPaste", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], paste.prototype, "onProcessPasteReplaceNl2Br", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_5__.pluginSystem.add('paste', paste);


/***/ }),

/***/ 23599:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   position: function() { return /* binding */ position; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(24497);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/size
 */ 
/**
 * Calculate screen element position
 */ function position(elm, jodit, recurse = false) {
    const rect = elm.getBoundingClientRect();
    let xPos = rect.left, yPos = rect.top;
    if ((0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_0__.isJoditObject)(jodit) && jodit.iframe && jodit.ed.body.contains(elm) && !recurse) {
        const { left, top } = position(jodit.iframe, jodit, true);
        xPos += left;
        yPos += top;
    }
    var _elm_offsetWidth, _elm_offsetHeight;
    return {
        left: Math.round(xPos),
        top: Math.round(yPos),
        width: Math.round((_elm_offsetWidth = elm.offsetWidth) !== null && _elm_offsetWidth !== void 0 ? _elm_offsetWidth : rect.width),
        height: Math.round((_elm_offsetHeight = elm.offsetHeight) !== null && _elm_offsetHeight !== void 0 ? _elm_offsetHeight : rect.height)
    };
}


/***/ }),

/***/ 24475:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Storage: function() { return /* binding */ Storage; }
/* harmony export */ });
/* unused harmony export StorageKey */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(57821);
/* harmony import */ var _engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59807);
/* harmony import */ var _engines_memory_storage_provider__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9505);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/storage/README.md]]
 * @packageDocumentation
 * @module storage
 */ 



const StorageKey = 'Jodit_';
class Storage {
    set(key, value) {
        this.provider.set((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__.camelCase)(this.prefix + key), value);
        return this;
    }
    delete(key) {
        this.provider.delete((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__.camelCase)(this.prefix + key));
        return this;
    }
    get(key) {
        return this.provider.get((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__.camelCase)(this.prefix + key));
    }
    exists(key) {
        return this.provider.exists((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__.camelCase)(this.prefix + key));
    }
    clear() {
        this.provider.clear();
        return this;
    }
    static makeStorage(persistent = false, suffix) {
        let provider;
        if (persistent && (0,_engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_2__.canUsePersistentStorage)()) {
            provider = new _engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_2__.LocalStorageProvider(StorageKey + suffix);
        }
        if (!provider) {
            provider = new _engines_memory_storage_provider__WEBPACK_IMPORTED_MODULE_3__.MemoryStorageProvider();
        }
        return new Storage(provider, suffix);
    }
    constructor(provider, suffix){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "provider", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "prefix", void 0);
        this.provider = provider;
        this.prefix = StorageKey;
        if (suffix) {
            this.prefix += suffix;
        }
    }
}


/***/ }),

/***/ 24497:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isJoditObject: function() { return /* binding */ isJoditObject; }
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91565);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ 
/**
 * Check if element is instance of Jodit
 */ function isJoditObject(jodit) {
    return Boolean(jodit && jodit instanceof Object && (0,_is_function__WEBPACK_IMPORTED_MODULE_0__.isFunction)(jodit.constructor) && // @ts-ignore
    (typeof Jodit !== 'undefined' && jodit instanceof Jodit || jodit.isJodit));
}


/***/ }),

/***/ 24641:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UICheckbox: function() { return /* binding */ UICheckbox; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41411);
/* harmony import */ var _swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15366);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65273);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/form
 */ 







class UICheckbox extends jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_6__.UIInput {
    /** @override */ className() {
        return 'UICheckbox';
    }
    /** @override */ render() {
        return this.j.c.element('label', {
            className: this.componentName
        });
    }
    onChangeChecked() {
        this.value = this.state.checked.toString();
        this.nativeInput.checked = this.state.checked;
        this.setMod('checked', this.state.checked);
    }
    onChangeNativeCheckBox() {
        this.state.checked = this.nativeInput.checked;
    }
    onChangeSwitch() {
        this.setMod('switch', this.state.switch);
        let slider = this.getElm('switch-slider');
        if (this.state.switch) {
            if (!slider) {
                slider = this.j.c.div(this.getFullElName('switch-slider'));
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_5__.Dom.after(this.nativeInput, slider);
        } else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_5__.Dom.safeRemove(slider);
        }
    }
    /** @override **/ constructor(jodit, options){
        super(jodit, (0,_swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__._)((0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({}, options), {
            type: 'checkbox'
        })), /** @override */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "state", (0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({}, UICheckbox.defaultState));
        Object.assign(this.state, options);
    }
}
/** @override */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(UICheckbox, "defaultState", (0,_swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__._)((0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_6__.UIInput.defaultState), {
    checked: false,
    switch: false
}));
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.watch)('state.checked'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.hook)('ready')
], UICheckbox.prototype, "onChangeChecked", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.watch)('nativeInput:change')
], UICheckbox.prototype, "onChangeNativeCheckBox", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.watch)('state.switch'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.hook)('ready')
], UICheckbox.prototype, "onChangeSwitch", null);
UICheckbox = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.component
], UICheckbox);


/***/ }),

/***/ 24735:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Async: function() { return /* binding */ Async; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41411);
/* harmony import */ var _swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15366);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(61077);
/* harmony import */ var jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(72068);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(91565);
/* harmony import */ var jodit_core_helpers_checker_is_number__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(72412);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(62101);
/* harmony import */ var jodit_core_helpers_checker_is_promise__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(52100);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(18303);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var jodit_core_helpers_utils_error_errors_abort_error__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(14228);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/async/README.md]]
 * @packageDocumentation
 * @module async
 */ 













class Async {
    delay(timeout) {
        return this.promise((resolve)=>this.setTimeout(resolve, timeout));
    }
    setTimeout(callback, timeout, ...args) {
        if (this.isDestructed) {
            return 0;
        }
        let options = {};
        if ((0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_11__.isVoid)(timeout)) {
            timeout = 0;
        }
        if (!(0,jodit_core_helpers_checker_is_number__WEBPACK_IMPORTED_MODULE_7__.isNumber)(timeout)) {
            options = timeout;
            timeout = options.timeout || 0;
        }
        if (options.label) {
            this.clearLabel(options.label);
        }
        const timer = (0,jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__.setTimeout)(callback, timeout, ...args);
        const key = options.label || timer;
        this.timers.set(key, timer);
        this.__callbacks.set(key, callback);
        return timer;
    }
    updateTimeout(label, timeout) {
        (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_12__.assert)(label && this.timers.has(label), 'Label does not exist');
        if (!label || !this.timers.has(label)) {
            return null;
        }
        const callback = this.__callbacks.get(label);
        (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_12__.assert)((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_6__.isFunction)(callback), 'Callback is not a function');
        return this.setTimeout(callback, {
            label,
            timeout
        });
    }
    clearLabel(label) {
        if (label && this.timers.has(label)) {
            (0,jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__.clearTimeout)(this.timers.get(label));
            this.timers.delete(label);
            this.__callbacks.delete(label);
        }
    }
    clearTimeout(timerOrLabel) {
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_10__.isString)(timerOrLabel)) {
            return this.clearLabel(timerOrLabel);
        }
        (0,jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__.clearTimeout)(timerOrLabel);
        this.timers.delete(timerOrLabel);
        this.__callbacks.delete(timerOrLabel);
    }
    /**
	 * Debouncing enforces that a function not be called again until a certain amount of time has passed without
	 * it being called. As in "execute this function only if 100 milliseconds have passed without it being called."
	 *
	 * @example
	 * ```javascript
	 * var jodit = Jodit.make('.editor');
	 * jodit.e.on('mousemove', jodit.async.debounce(() => {
	 * 	// Do expensive things
	 * }, 100));
	 * ```
	 */ debounce(fn, timeout, firstCallImmediately = false) {
        let timer = 0, fired = false;
        const promises = [];
        const callFn = (...args)=>{
            if (!fired) {
                timer = 0;
                const res = fn(...args);
                fired = true;
                if (promises.length) {
                    const runPromises = ()=>{
                        promises.forEach((res)=>res());
                        promises.length = 0;
                    };
                    (0,jodit_core_helpers_checker_is_promise__WEBPACK_IMPORTED_MODULE_9__.isPromise)(res) ? res.finally(runPromises) : runPromises();
                }
            }
        };
        const onFire = (...args)=>{
            fired = false;
            if (!timeout) {
                callFn(...args);
            } else {
                if (!timer && firstCallImmediately) {
                    callFn(...args);
                }
                (0,jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__.clearTimeout)(timer);
                timer = this.setTimeout(()=>callFn(...args), (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_6__.isFunction)(timeout) ? timeout() : timeout);
                this.timers.set(fn, timer);
            }
        };
        return (0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_8__.isPlainObject)(timeout) && timeout.promisify ? (...args)=>{
            const promise = this.promise((res)=>{
                promises.push(res);
            }).catch((e)=>{
                if ((0,jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_5__.isAbortError)(e)) {
                    return null;
                }
                throw e;
            });
            onFire(...args);
            return promise;
        } : onFire;
    }
    microDebounce(fn, firstCallImmediately = false) {
        let scheduled = false;
        let needCall = true;
        let savedArgs;
        return (...args)=>{
            savedArgs = args;
            if (scheduled) {
                needCall = true;
                return;
            }
            needCall = true;
            if (firstCallImmediately) {
                needCall = false;
                fn(...savedArgs);
            }
            scheduled = true;
            this.__queueMicrotaskNative(()=>{
                scheduled = false;
                if (this.isDestructed) {
                    return;
                }
                needCall && fn(...savedArgs);
            });
        };
    }
    /**
	 * Throttling enforces a maximum number of times a function can be called over time.
	 * As in "execute this function at most once every 100 milliseconds."
	 *
	 * @example
	 * ```javascript
	 * var jodit = Jodit.make('.editor');
	 * jodit.e.on(document.body, 'scroll', jodit.async.throttle(function() {
	 * 	// Do expensive things
	 * }, 100));
	 * ```
	 */ throttle(fn, timeout, ignore = false) {
        let timer = null, needInvoke, callee, lastArgs;
        return (...args)=>{
            needInvoke = true;
            lastArgs = args;
            if (!timeout) {
                fn(...lastArgs);
                return;
            }
            if (!timer) {
                callee = ()=>{
                    if (needInvoke) {
                        fn(...lastArgs);
                        needInvoke = false;
                        timer = this.setTimeout(callee, (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_6__.isFunction)(timeout) ? timeout() : timeout);
                        this.timers.set(callee, timer);
                    } else {
                        timer = null;
                    }
                };
                callee();
            }
        };
    }
    promise(executor) {
        let rejectCallback = ()=>{};
        const promise = new Promise((resolve, reject)=>{
            rejectCallback = ()=>reject((0,jodit_core_helpers_utils_error_errors_abort_error__WEBPACK_IMPORTED_MODULE_13__.abort)('Abort async'));
            this.promisesRejections.add(rejectCallback);
            executor(resolve, reject);
        });
        if (!promise.finally && typeof process !== 'undefined' && !jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__.IS_ES_NEXT) {
            promise.finally = (onfinally)=>{
                promise.then(onfinally).catch(onfinally);
                return promise;
            };
        }
        promise.finally(()=>{
            this.promisesRejections.delete(rejectCallback);
        }).catch(()=>null);
        promise.rejectCallback = rejectCallback;
        return promise;
    }
    /**
	 * Get Promise status
	 */ promiseState(p) {
        if (p.status) {
            return p.status;
        }
        // Hi IE11
        if (!Promise.race) {
            return new Promise((resolve)=>{
                p.then((v)=>{
                    resolve('fulfilled');
                    return v;
                }, (e)=>{
                    resolve('rejected');
                    throw e;
                });
                this.setTimeout(()=>{
                    resolve('pending');
                }, 100);
            });
        }
        const t = {};
        return Promise.race([
            p,
            t
        ]).then((v)=>v === t ? 'pending' : 'fulfilled', ()=>'rejected');
    }
    requestIdleCallback(callback, options = {
        timeout: 100
    }) {
        const request = this.__requestIdleCallbackNative(callback, options);
        this.__requestsIdle.add(request);
        return request;
    }
    requestIdlePromise(options) {
        return this.promise((res)=>{
            const request = this.requestIdleCallback(()=>res(request), options);
        });
    }
    /**
	 * Try to use scheduler.postTask if it is available https://wicg.github.io/scheduling-apis/
	 */ schedulerPostTask(task, options = {
        delay: 0,
        priority: 'user-visible'
    }) {
        const controller = new AbortController();
        if (options.signal) {
            options.signal.addEventListener('abort', ()=>controller.abort());
        }
        this.__controllers.add(controller);
        // @ts-ignore
        if (typeof globalThis.scheduler !== 'undefined') {
            const scheduler = globalThis.scheduler;
            const promise = scheduler.postTask(task, (0,_swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__._)((0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({}, options), {
                signal: controller.signal
            }));
            promise.finally(()=>{
                this.__controllers.delete(controller);
            }).catch(()=>null);
            return promise;
        }
        return this.promise((resolve, reject)=>{
            const timeout = this.setTimeout(()=>{
                try {
                    resolve(task());
                } catch (e) {
                    reject(e);
                }
                this.__controllers.delete(controller);
            }, options.delay || 1);
            controller.signal.addEventListener('abort', ()=>{
                this.clearTimeout(timeout);
                this.__controllers.delete(controller);
                reject((0,jodit_core_helpers_utils_error_errors_abort_error__WEBPACK_IMPORTED_MODULE_13__.abort)());
            });
        });
    }
    schedulerYield() {
        return this.schedulerPostTask(()=>{}, {
            priority: 'user-visible'
        });
    }
    cancelIdleCallback(request) {
        this.__requestsIdle.delete(request);
        return this.__cancelIdleCallbackNative(request);
    }
    requestAnimationFrame(callback) {
        const request = requestAnimationFrame(callback);
        this.__requestsRaf.add(request);
        return request;
    }
    cancelAnimationFrame(request) {
        this.__requestsRaf.delete(request);
        cancelAnimationFrame(request);
    }
    clear() {
        this.__requestsIdle.forEach((key)=>this.cancelIdleCallback(key));
        this.__requestsRaf.forEach((key)=>this.cancelAnimationFrame(key));
        this.__controllers.forEach((controller)=>controller.abort());
        this.timers.forEach((key)=>(0,jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__.clearTimeout)(this.timers.get(key)));
        this.timers.clear();
        this.promisesRejections.forEach((reject)=>reject());
        this.promisesRejections.clear();
    }
    destruct() {
        this.clear();
        this.isDestructed = true;
    }
    constructor(){
        var _queueMicrotask, _window_requestIdleCallback, _window_cancelIdleCallback;
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "timers", new Map());
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__callbacks", new Map());
        var _queueMicrotask_bind;
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__queueMicrotaskNative", (_queueMicrotask_bind = (_queueMicrotask = queueMicrotask) === null || _queueMicrotask === void 0 ? void 0 : _queueMicrotask.bind(window)) !== null && _queueMicrotask_bind !== void 0 ? _queueMicrotask_bind : Promise.resolve().then.bind(Promise.resolve()));
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "promisesRejections", new Set());
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__requestsIdle", new Set());
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__controllers", new Set());
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__requestsRaf", new Set());
        var _window_requestIdleCallback_bind;
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__requestIdleCallbackNative", (_window_requestIdleCallback_bind = (_window_requestIdleCallback = window['requestIdleCallback']) === null || _window_requestIdleCallback === void 0 ? void 0 : _window_requestIdleCallback.bind(window)) !== null && _window_requestIdleCallback_bind !== void 0 ? _window_requestIdleCallback_bind : (callback, options)=>{
            const start = Date.now();
            var _options_timeout;
            return this.setTimeout(()=>{
                callback({
                    didTimeout: false,
                    timeRemaining: ()=>Math.max(0, 50 - (Date.now() - start))
                });
            }, (_options_timeout = options === null || options === void 0 ? void 0 : options.timeout) !== null && _options_timeout !== void 0 ? _options_timeout : 1);
        });
        var _window_cancelIdleCallback_bind;
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__cancelIdleCallbackNative", (_window_cancelIdleCallback_bind = (_window_cancelIdleCallback = window['cancelIdleCallback']) === null || _window_cancelIdleCallback === void 0 ? void 0 : _window_cancelIdleCallback.bind(window)) !== null && _window_cancelIdleCallback_bind !== void 0 ? _window_cancelIdleCallback_bind : (request)=>{
            this.clearTimeout(request);
        });
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "isDestructed", false);
    }
}


/***/ }),

/***/ 24772:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 24 24\"> <path stroke-width=\"0\" d=\"M22,20.6L3.4,2H8V0H0v8h2V3.4L20.6,22H16v2h8v-8h-2V20.6z M16,0v2h4.7l-6.3,6.3l1.4,1.4L22,3.5V8h2V0H16z M8.3,14.3L2,20.6V16H0v8h8v-2H3.5l6.3-6.3L8.3,14.3z\"/> </svg>"

/***/ }),

/***/ 24968:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   derive: function() { return /* binding */ derive; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91565);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/decorators/derive/README.md]]
 * @packageDocumentation
 * @module decorators/derive
 */ 
function derive(...traits) {
    return (target)=>{
        const origin = target.prototype;
        for(let i = 0; i < traits.length; i++){
            const trait = traits[i];
            const keys = Object.getOwnPropertyNames(trait.prototype);
            for(let j = 0; j < keys.length; j++){
                const key = keys[j], method = Object.getOwnPropertyDescriptor(trait.prototype, key);
                const canDerive = method != null && (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__.isFunction)(method.value) && !(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__.isFunction)(origin[key]);
                if (canDerive) {
                    Object.defineProperty(origin, key, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: function(...args) {
                            return method.value.call(this, ...args);
                        }
                    });
                }
            }
        }
    };
}


/***/ }),

/***/ 25045:
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ _define_property; }
/* harmony export */ });
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else obj[key] = value;
    return obj;
}



/***/ }),

/***/ 25090:
/***/ (function(module) {

module.exports["default"] = ["Ecrivez ici","A propos de Jodit","Editeur Jodit","Guide de l'utilisateur","Aide détaillée à l'utilisation","Consulter la licence sur notre site web:","Acheter la version complète","Copyright © XDSoft.net - Chupurnov Valeriy. Tous droits réservés.","Ancre","Ouvrir dans un nouvel onglet","Ouvrir l'éditeur en pleine page","Supprimer le formattage","Modifier la couleur du fond ou du texte","Refaire","Défaire","Gras","Italique","Liste non ordonnée","Liste ordonnée","Centrer","Justifier","Aligner à gauche ","Aligner à droite","Insérer une ligne horizontale","Insérer une image","Insérer un fichier","Insérer une vidéo","Insérer un lien","Taille des caractères","Famille des caractères","Bloc formatté","Normal","Titre 1","Titre 2","Titre 3","Titre 4","Citation","Code","Insérer","Insérer un tableau","Diminuer le retrait","Retrait plus","Sélectionnez un caractère spécial","Insérer un caractère spécial","Cloner le format","Mode wysiwyg <-> code html","Marges","haut","droite","Bas","gauche","Styles","Classes","Alignement","Droite","Centre","Gauche","--Non disponible--","Source","Titre","Alternative","Lien","Ouvrir le lien dans un nouvel onglet","Image","fichier","Avancé","Propriétés de l'image","Annuler","OK","Explorateur de fichiers","Erreur de liste de chargement","Erreur de dossier de chargement","Etes-vous sûrs ?","Entrer le nom de dossier","Créer un dossier","type de fichier","Coller une image","Déposer un fichier","ou cliquer","Texte de remplacemement","Charger","Chercher","Arrière-plan","Texte","Haut","Milieu","Bas","Insérer une colonne avant","Insérer une colonne après","Insérer une ligne au dessus","Insérer une ligne en dessous","Supprimer le tableau","Supprimer la ligne","Supprimer la colonne","Vider la cellule","Symboles: %d","Mots: %d","Barrer","Souligner","exposant","indice","Couper la sélection","Tout sélectionner","Pause","Rechercher","Remplacer par","Remplacer","Coller","Choisissez le contenu à coller","la source","gras","italique","pinceau","lien","annuler","refaire","tableau","image","gomme","clause","taille de police","Video","police","à propos de l'éditeur","impression","souligné","barré","indentation","retrait","taille réelle","taille conventionnelle","la ligne","Liste","Liste numérotée","Couper","Sélectionner tout","Code d'intégration","Ouvrir le lien","Modifier le lien","Attribut Nofollow","Supprimer le lien","Mettre à jour","Pour éditer","Voir","URL","Modifier","Alignement horizontal","Filtre","Trier par modification","Trier par nom","Trier par taille","Créer le dossier","Restaurer","Sauvegarder","Enregistrer sous","Changer la taille","Taille de garniture","Largeur","Hauteur","Garder les proportions","Oui","Non","Supprimer","Mettre en évidence","Mettre en évidence: %s","Alignement vertical","Split","aller","Ajouter une colonne","Ajouter une rangée","Licence: %s","Effacer","Split vertical","Split horizontal","Bordure","Votre texte que vous essayez de coller est similaire au HTML. Collez-le en HTML?","Coller en HTML?","Sauvegarder l'original","Coller en tant que texte","Coller le texte seulement","Vous ne pouvez éditer que vos propres images. Téléchargez cette image sur l'hôte?","L'image a été téléchargée avec succès sur le serveur!","Palette","Il n'y a aucun fichier dans ce répertoire.","renommer","Entrez un nouveau nom","Aperçu","Télécharger","Coller à partir du presse-papiers","Votre navigateur ne prend pas en charge l'accès direct au presse-papiers.","Copier la sélection","copie","Rayon des bordures","Afficher tous","Appliquer","Veuillez remplir ce champ","Veuillez entrer une adresse web","Par défaut","Cercle","Point","Quadratique","Trouver","Précédent","Suivant","Le contenu que vous insérez provient d'un document Microsoft Word / Excel. Voulez-vous enregistrer le format ou l'effacer?","C'est peut-être un fragment de Word ou Excel","Nettoyer","Insérer un nom de classe","Appuyez sur Alt pour un redimensionnement personnalisé",null,null,null,"Tout sélectionner"]

/***/ }),

/***/ 25182:
/***/ (function(module) {

module.exports["default"] = ["输入一些内容","关于Jodit","Jodit Editor","开发者指南","使用帮助","有关许可证的信息，请访问我们的网站：","购买完整版本","Copyright © XDSoft.net - Chupurnov Valeriy. 版权所有","Anchor","在新窗口打开","全屏编辑","清除样式","颜色","重做","撤销","粗体","斜体","符号列表","编号","居中","对齐文本","左对齐","右对齐","分割线","图片","文件","视频","链接","字号","字体","格式块","默认","标题1","标题2","标题3","标题4","引用","代码","插入","表格","减少缩进","增加缩进","选择特殊符号","特殊符号","格式复制","改变模式","外边距（Margins）","top","right","bottom","left","样式","Classes","对齐方式","居右","居中","居左","无","Src","Title","Alternative","Link","在新窗口打开链接","图片","file","高级","图片属性","取消","确定","文件管理","加载list错误","加载folders错误","你确定吗？","输入路径","创建路径","type name","拖动图片到此","拖动文件到此","或点击","Alternative text","上传","浏览","背景色","文字","顶部","中间","底部","在之前插入列","在之后插入列","在之前插入行","在之后插入行","删除表格","删除行","删除列","清除内容","字符数: %d","单词数: %d","删除线","下划线","上标","下标","剪切","全选","Break","查找","替换为","替换","粘贴","选择内容并粘贴","源码","粗体","斜体","颜色","链接","撤销","重做","表格","图片","橡皮擦","段落","字号","视频","字体","关于","打印","下划线","上出现","增加缩进","减少缩进","全屏","收缩","分割线","无序列表","顺序列表","剪切","全选","嵌入代码","打开链接","编辑链接","No follow","取消链接","更新","铅笔","预览","URL","编辑","水平对齐","筛选","修改时间排序","名称排序","大小排序","新建文件夹","重置","保存","保存为","调整大小","剪切","宽","高","保持长宽比","是","不","移除","选择","选择: %s","垂直对齐","拆分","合并","添加列","添加行","许可证: %s","删除","垂直拆分","水平拆分","边框","你粘贴的文本是一段html代码，是否保留源格式","html粘贴","保留源格式","把html代码视为普通文本","只保留文本","你只能编辑你自己的图片。Download this image on the host?","图片上传成功","调色板","此目录中沒有文件。","重命名","输入新名称","预览","下载","粘贴从剪贴板","你浏览器不支持直接访问的剪贴板。","复制选中内容","复制","边界半径","显示所有","应用","请填写这个字段","请输入一个网址","默认","圆圈","点","方形","搜索","查找上一个","查找下一个","正在粘贴 Word/Excel 的文本，是否保留源格式？","文本粘贴","匹配目标格式","插入班级名称","按Alt自定义调整大小",null,null,null,"全部"]

/***/ }),

/***/ 25222:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Storage: function() { return /* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_1__.Storage; }
/* harmony export */ });
/* harmony import */ var _engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59807);
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(24475);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module storage
 */ 




/***/ }),

/***/ 25501:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1744 1408q33 0 42 18.5t-11 44.5l-126 162q-20 26-49 26t-49-26l-126-162q-20-26-11-44.5t42-18.5h80v-1024h-80q-33 0-42-18.5t11-44.5l126-162q20-26 49-26t49 26l126 162q20 26 11 44.5t-42 18.5h-80v1024h80zm-1663-1279l54 27q12 5 211 5 44 0 132-2t132-2q36 0 107.5.5t107.5.5h293q6 0 21 .5t20.5 0 16-3 17.5-9 15-17.5l42-1q4 0 14 .5t14 .5q2 112 2 336 0 80-5 109-39 14-68 18-25-44-54-128-3-9-11-48t-14.5-73.5-7.5-35.5q-6-8-12-12.5t-15.5-6-13-2.5-18-.5-16.5.5q-17 0-66.5-.5t-74.5-.5-64 2-71 6q-9 81-8 136 0 94 2 388t2 455q0 16-2.5 71.5t0 91.5 12.5 69q40 21 124 42.5t120 37.5q5 40 5 50 0 14-3 29l-34 1q-76 2-218-8t-207-10q-50 0-151 9t-152 9q-3-51-3-52v-9q17-27 61.5-43t98.5-29 78-27q19-42 19-383 0-101-3-303t-3-303v-117q0-2 .5-15.5t.5-25-1-25.5-3-24-5-14q-11-12-162-12-33 0-93 12t-80 26q-19 13-34 72.5t-31.5 111-42.5 53.5q-42-26-56-44v-383z\"/> </svg>"

/***/ }),

/***/ 25974:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   makeInstance: function() { return /* binding */ makeInstance; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91565);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugin
 */ 

/**
 * Create instance of plugin
 * @private
 */ function makeInstance(jodit, plugin) {
    try {
        try {
            // @ts-ignore
            return (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__.isFunction)(plugin) ? new plugin(jodit) : plugin;
        } catch (e) {
            if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__.isFunction)(plugin) && !plugin.prototype) {
                return plugin(jodit);
            }
        }
    } catch (e) {
        console.error(e);
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
            throw e;
        }
    }
    return null;
}


/***/ }),

/***/ 26106:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkJoinNeighbors: function() { return /* binding */ checkJoinNeighbors; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_plugins_backspace_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15200);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/backspace
 */ 


/**
 * Check if two separate elements can be connected
 * @private
 */ function checkJoinNeighbors(jodit, fakeNode, backspace) {
    let nextBox = fakeNode, mainClosestBox = nextBox;
    // Find the main big closest element
    while(nextBox && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.findNotEmptySibling(nextBox, backspace) && nextBox.parentElement !== jodit.editor){
        nextBox = nextBox.parentElement;
        mainClosestBox = nextBox;
    }
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isElement(mainClosestBox) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isContentEditable(mainClosestBox, jodit.editor)) {
        const sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.findNotEmptySibling(mainClosestBox, backspace);
        if (sibling && (checkMoveListContent(jodit, mainClosestBox, sibling, backspace) || moveContentAndRemoveEmpty(jodit, mainClosestBox, sibling, backspace))) {
            jodit.s.setCursorBefore(fakeNode);
            return true;
        }
    }
    return false;
}
function checkMoveListContent(jodit, mainClosestBox, sibling, backspace) {
    // Process UL/LI/OL cases
    const siblingIsList = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(sibling, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS);
    const boxIsList = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(mainClosestBox, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS);
    const elementChild = (elm, side)=>side ? elm.firstElementChild : elm.lastElementChild;
    if (boxIsList) {
        sibling = jodit.createInside.element(jodit.o.enterBlock);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.before(mainClosestBox, sibling);
        return moveContentAndRemoveEmpty(jodit, elementChild(mainClosestBox, backspace), sibling, backspace);
    }
    if (sibling && siblingIsList && !boxIsList) {
        return moveContentAndRemoveEmpty(jodit, mainClosestBox, elementChild(sibling, !backspace), backspace);
    }
    return false;
}
function moveContentAndRemoveEmpty(jodit, mainClosestBox, sibling, backspace) {
    // Move content and remove empty nodes
    if (mainClosestBox && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isElement(sibling)) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.moveContent(mainClosestBox, sibling, !backspace, (0,jodit_plugins_backspace_helpers__WEBPACK_IMPORTED_MODULE_2__.getMoveFilter)(jodit));
        let remove = mainClosestBox;
        while(remove && remove !== jodit.editor && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isEmpty(remove)){
            const parent = remove.parentElement;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(remove);
            remove = parent;
        }
        return true;
    }
    return false;
}


/***/ }),

/***/ 26136:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   browser: function() { return /* binding */ browser; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ /**
 * Module returns method that is used to determine the browser
 * @example
 * ```javascript
 * console.log(Jodit.modules.Helpers.browser('mse'));
 * console.log(Jodit.modules.Helpers.browser('chrome'));
 * console.log($Jodit.modules.Helpers.browser('opera'));
 * console.log(Jodit.modules.Helpers.browser('firefox'));
 * console.log(Jodit.modules.Helpers.browser('mse') && Jodit.modules.Helpers.browser('version') > 10);
 * ```
 */ const browser = (browser)=>{
    const ua = navigator.userAgent.toLowerCase(), match = /(firefox)[\s/]([\w.]+)/.exec(ua) || /(chrome)[\s/]([\w.]+)/.exec(ua) || /(webkit)[\s/]([\w.]+)/.exec(ua) || /(opera)(?:.*version)[\s/]([\w.]+)/.exec(ua) || /(msie)[\s]([\w.]+)/.exec(ua) || /(trident)\/([\w.]+)/.exec(ua) || ua.indexOf('compatible') < 0 || [];
    if (browser === 'version') {
        return match[2];
    }
    if (browser === 'webkit') {
        return match[1] === 'chrome' || match[1] === 'webkit';
    }
    if (browser === 'ff') {
        return match[1] === 'firefox';
    }
    if (browser === 'msie') {
        return match[1] === 'trident' || match[1] === 'msie';
    }
    return match[1] === browser;
};


/***/ }),

/***/ 26633:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   readAlign: function() { return /* binding */ readAlign; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80991);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 
/**
 * @private
 */ function readAlign(image, values) {
    // Align
    if (image.style.cssFloat && [
        'left',
        'right'
    ].indexOf(image.style.cssFloat.toLowerCase()) !== -1) {
        values.align = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_0__.css)(image, 'float');
    } else {
        if ((0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_0__.css)(image, 'display') === 'block' && image.style.marginLeft === 'auto' && image.style.marginRight === 'auto') {
            values.align = 'center';
        } else {
            values.align = '';
        }
    }
}


/***/ }),

/***/ 27137:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UIImagePropertiesForm: function() { return /* binding */ UIImagePropertiesForm; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(91672);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(63468);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(29434);
/* harmony import */ var jodit_modules_widget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(15753);
/* harmony import */ var _ui_image_main_tab__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29596);
/* harmony import */ var _ui_image_position_tab__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(17306);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 










class UIImagePropertiesForm extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_5__.UIGroup {
    className() {
        return 'UIImagePropertiesForm';
    }
    appendChildToContainer() {}
    getElm(elementName) {
        const selfElm = super.getElm(elementName);
        if (selfElm) {
            return selfElm;
        }
        for (const child of this.elements){
            const elm = child.getElm(elementName);
            if (elm) {
                return elm;
            }
        }
        return null;
    }
    render() {
        return `<form>
		<div class="jodit-grid jodit-grid_xs-column">
			<div class="jodit_col-lg-2-5 jodit_col-xs-5-5">
				<div class="&__view-box">
					<div class="&__imageView">
						<img class="&__imageViewSrc" src="" alt=""/>
					</div>
					<div class="jodit-form__group &__imageSizes">
						<input type="text" class="jodit-input &__imageWidth"/>
						<a class="&__lockSize">${jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__.Icon.get('lock')}</a>
						<input type="text" class="&__imageHeight jodit-input"/>
					</div>
				</div>
			</div>
			<div class="jodit_col-lg-3-5 jodit_col-xs-5-5 &__tabsBox"></div>
		</div>
	</form>`;
    }
    onChangeSizeIsLocked() {
        const lockSize = this.getElm('lockSize');
        const imageWidth = this.getElm('imageWidth');
        lockSize.innerHTML = jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__.Icon.get(this.state.sizeIsLocked ? 'lock' : 'unlock');
        this.setMod('lock-size', this.state.sizeIsLocked);
        this.j.e.fire(imageWidth, 'change');
    }
    onLockSizeClick() {
        this.state.sizeIsLocked = !this.state.sizeIsLocked;
    }
    onStateValuesSizeChange() {
        const imageWidth = this.getElm('imageWidth');
        const imageHeight = this.getElm('imageHeight');
        if (imageWidth !== this.j.od.activeElement) {
            imageWidth.value = this.state.values.imageWidth.toString();
        }
        if (imageHeight !== this.j.od.activeElement) {
            imageHeight.value = this.state.values.imageHeight.toString();
        }
    }
    onImageWidthChange(e) {
        const imageWidth = this.getElm('imageWidth');
        const imageHeight = this.getElm('imageHeight');
        if (!this.state.sizeIsLocked || !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isNumeric)(imageWidth.value) || !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isNumeric)(imageHeight.value)) {
            this.state.values.imageWidth = imageWidth.value;
            this.state.values.imageHeight = imageHeight.value;
            return;
        }
        const w = parseFloat(imageWidth.value), h = parseFloat(imageHeight.value);
        if (e.target === imageWidth) {
            this.state.values.imageWidth = w;
            this.state.values.imageHeight = Math.round(w / this.state.ratio);
        } else {
            this.state.values.imageWidth = Math.round(h * this.state.ratio);
            this.state.values.imageHeight = h;
        }
    }
    onStateValuesImageSrcChange() {
        const { imageSrc } = this.state.values;
        if (!imageSrc) {
            return;
        }
        const imageViewSrc = this.getElm('imageViewSrc');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(imageViewSrc, 'src', imageSrc);
        const image = new Image();
        image.src = imageSrc;
        this.state.image = image;
    }
    hideFieldByOptions() {
        const opt = this.j.o.image;
        [
            [
                'editSize',
                'imageSizes'
            ],
            [
                'showPreview',
                'imageView'
            ]
        ].forEach(([optKey, elmKey])=>{
            const elm = this.getElm(elmKey);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(elm, 'display', opt[optKey] ? null : 'none');
        });
    }
    constructor(jodit, state, activeTabState, handlers){
        super(jodit), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "state", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "handlers", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__mainTab", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__positionTab", void 0), this.state = state, this.handlers = handlers, this.__mainTab = new _ui_image_main_tab__WEBPACK_IMPORTED_MODULE_8__.UIImageMainTab(this.jodit, this.state, this.handlers), this.__positionTab = new _ui_image_position_tab__WEBPACK_IMPORTED_MODULE_9__.UIImagePositionTab(this.jodit, this.state, this.handlers);
        this.getElm('tabsBox').appendChild((0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_7__.TabsWidget)(jodit, [
            {
                name: 'Image',
                content: this.__mainTab
            },
            {
                name: 'Advanced',
                content: this.__positionTab
            }
        ], activeTabState));
        this.setMod('lock-size', this.state.sizeIsLocked);
        this.append(this.__mainTab).append(this.__positionTab);
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.hook)('ready'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)('state.sizeIsLocked')
], UIImagePropertiesForm.prototype, "onChangeSizeIsLocked", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)('lockSize:click')
], UIImagePropertiesForm.prototype, "onLockSizeClick", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.hook)('ready'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)([
        'state.values.imageWidth',
        'state.values.imageHeight'
    ])
], UIImagePropertiesForm.prototype, "onStateValuesSizeChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)([
        'imageWidth:change',
        'imageHeight:change',
        'imageWidth:keydown',
        'imageHeight:keydown',
        'imageWidth:mousedown',
        'imageHeight:mousedown',
        'imageWidth:paste',
        'imageHeight:paste'
    ]),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.debounce)()
], UIImagePropertiesForm.prototype, "onImageWidthChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.hook)('ready'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)('state.values.imageSrc')
], UIImagePropertiesForm.prototype, "onStateValuesImageSrcChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.hook)('ready')
], UIImagePropertiesForm.prototype, "hideFieldByOptions", null);
UIImagePropertiesForm = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__.component
], UIImagePropertiesForm);


/***/ }),

/***/ 27611:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   tryRemoveNode: function() { return /* binding */ tryRemoveNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4040);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/clean-html
 */ 


/**
 * @private
 */ function tryRemoveNode(jodit, nodeElm, hadEffect, allowTags, denyTags, currentSelectionNode) {
    if (isRemovableNode(jodit, nodeElm, currentSelectionNode, allowTags, denyTags)) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(nodeElm);
        return true;
    }
    return hadEffect;
}
/**
 * @private
 */ function isRemovableNode(jodit, node, current, allow, deny) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(node)) {
        if (allow && !allow[node.nodeName]) {
            return true;
        }
        if (!allow && deny && deny[node.nodeName]) {
            return true;
        }
    }
    if (!jodit.o.cleanHTML.removeEmptyElements) {
        return false;
    }
    return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isElement(node) && node.nodeName.match(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_INLINE) != null && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTemporary(node) && (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__.trimInv)(node.innerHTML).length === 0 && (current == null || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isOrContains(node, current));
}


/***/ }),

/***/ 27795:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Dom: function() { return /* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_0__.Dom; },
/* harmony export */   LazyWalker: function() { return /* reexport safe */ _lazy_walker__WEBPACK_IMPORTED_MODULE_1__.LazyWalker; }
/* harmony export */ });
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var _lazy_walker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1080);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module dom
 */ 



/***/ }),

/***/ 27978:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalizeKeyAliases: function() { return /* binding */ normalizeKeyAliases; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4040);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/normalize
 */ 

/**
 * Normalize keys to some standard name
 */ function normalizeKeyAliases(keys) {
    const memory = {};
    const order = {
        meta: 1,
        ctrl: 2,
        control: 2,
        alt: 3,
        shift: 4,
        space: 5
    };
    return keys.replace(/\+\+/g, '+add').split(/[\s]*\+[\s]*/).map((key)=>(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__.trim)(key.toLowerCase())).map((key)=>jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_ALIASES[key] || key).sort((a, b)=>{
        if (order[a] && !order[b]) {
            return -1;
        }
        if (!order[a] && order[b]) {
            return 1;
        }
        if (order[a] && order[b]) {
            return order[a] - order[b];
        }
        return a > b ? 1 : -1;
    }).filter((key)=>!memory[key] && key !== '' && (memory[key] = true)).join('+');
}


/***/ }),

/***/ 27987:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UISpacer: function() { return /* binding */ UISpacer; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91672);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(96007);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/group
 */ 


class UISpacer extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_2__.UIElement {
    className() {
        return 'UISpacer';
    }
}
UISpacer = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_0__.__decorate)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_1__.component
], UISpacer);


/***/ }),

/***/ 28077:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   eventEmitter: function() { return /* binding */ eventEmitter; },
/* harmony export */   extendLang: function() { return /* binding */ extendLang; },
/* harmony export */   getContainer: function() { return /* binding */ getContainer; },
/* harmony export */   getPopupViewRoot: function() { return /* binding */ getPopupViewRoot; },
/* harmony export */   instances: function() { return /* binding */ instances; },
/* harmony export */   modules: function() { return /* binding */ modules; },
/* harmony export */   pluginSystem: function() { return /* binding */ pluginSystem; },
/* harmony export */   uniqueUid: function() { return /* binding */ uniqueUid; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(24497);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31534);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74264);
/* harmony import */ var jodit_core_helpers_utils_get_class_name__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(421);
/* harmony import */ var jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85305);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(81937);
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(27795);
/* harmony import */ var _event_emitter__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(1496);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module global
 */ 









const instances = {};
let counter = 1;
const uuids = new Set();
/**
 * Generate global unique uid
 */ function uniqueUid() {
    function gen() {
        counter += 10 * (Math.random() + 1);
        return Math.round(counter).toString(16);
    }
    let uid = gen();
    while(uuids.has(uid)){
        uid = gen();
    }
    uuids.add(uid);
    return uid;
}
const pluginSystem = new jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_6__.PluginSystem();
const modules = {};
const extendLang = (langs)=>{
    Object.keys(langs).forEach((key)=>{
        if (_constants__WEBPACK_IMPORTED_MODULE_7__.lang[key]) {
            Object.assign(_constants__WEBPACK_IMPORTED_MODULE_7__.lang[key], langs[key]);
        } else {
            _constants__WEBPACK_IMPORTED_MODULE_7__.lang[key] = langs[key];
        }
    });
};
const boxes = new WeakMap();
/**
 * Create unique box(HTMLCotainer) and remove it after destroy
 */ function getContainer(jodit, classFunc, tag = 'div', createInsideEditor = false) {
    const name = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__.isString)(classFunc) ? classFunc : classFunc ? (0,jodit_core_helpers_utils_get_class_name__WEBPACK_IMPORTED_MODULE_5__.getClassName)(classFunc.prototype) : 'jodit-utils';
    const data = boxes.get(jodit) || {}, key = name + tag;
    const view = (0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_3__.isViewObject)(jodit) ? jodit : jodit.j;
    let body = null;
    if (!data[key]) {
        let c = view.c;
        body = getPopupViewRoot(view.o, view.container, jodit.od.body);
        if (createInsideEditor && (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_1__.isJoditObject)(jodit) && jodit.od !== jodit.ed) {
            c = jodit.createInside;
            const place = tag === 'style' ? jodit.ed.head : jodit.ed.body;
            body = (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_1__.isJoditObject)(jodit) && jodit.o.shadowRoot ? jodit.o.shadowRoot : place;
        }
        const box = c.element(tag, {
            className: `jodit jodit-${(0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_4__.kebabCase)(name)}-container jodit-box`
        });
        box.classList.add(`jodit_theme_${view.o.theme || 'default'}`);
        body.appendChild(box);
        data[key] = box;
        jodit.hookStatus('beforeDestruct', ()=>{
            view.events.off(box);
            _dom__WEBPACK_IMPORTED_MODULE_8__.Dom.safeRemove(box);
            delete data[key];
            if (Object.keys(data).length) {
                boxes.delete(jodit);
            }
        });
        boxes.set(jodit, data);
        view.events.fire('getContainer', box);
    }
    data[key].classList.remove('jodit_theme_default', 'jodit_theme_dark');
    data[key].classList.add(`jodit_theme_${view.o.theme || 'default'}`);
    return data[key];
}
/**
 * Get root element for view
 * @internal
 */ function getPopupViewRoot(o, container, defaultRoot) {
    var _o_popupRoot, _ref, _ref1;
    return (_ref1 = (_ref = (_o_popupRoot = o.popupRoot) !== null && _o_popupRoot !== void 0 ? _o_popupRoot : o.shadowRoot) !== null && _ref !== void 0 ? _ref : _dom__WEBPACK_IMPORTED_MODULE_8__.Dom.closest(container, (parentElement)=>_dom__WEBPACK_IMPORTED_MODULE_8__.Dom.isHTMLElement(parentElement) && (_dom__WEBPACK_IMPORTED_MODULE_8__.Dom.isTag(parentElement, 'dialog') || [
            'fixed',
            'absolute'
        ].includes((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.css)(parentElement, 'position'))), defaultRoot)) !== null && _ref1 !== void 0 ? _ref1 : defaultRoot;
}
/**
 * Global event emitter
 */ const eventEmitter = new _event_emitter__WEBPACK_IMPORTED_MODULE_9__.EventEmitter();


/***/ }),

/***/ 28286:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export backspace */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91565);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91206);
/* harmony import */ var jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(42259);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(33831);
/* harmony import */ var _cases_check_not_collapsed__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(89827);
/* harmony import */ var _cases__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(17523);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/backspace/README.md]]
 * @packageDocumentation
 * @module plugins/backspace
 */ 









class backspace extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_5__.Plugin {
    afterInit(jodit) {
        jodit.registerCommand('deleteButton', {
            exec: ()=>this.onDelete(false),
            hotkeys: jodit.o.delete.hotkeys.delete
        }, {
            stopPropagation: false
        }).registerCommand('backspaceButton', {
            exec: ()=>this.onDelete(true),
            hotkeys: jodit.o.delete.hotkeys.backspace
        }, {
            stopPropagation: false
        }).registerCommand('deleteWordButton', {
            exec: ()=>this.onDelete(false, 'word'),
            hotkeys: jodit.o.delete.hotkeys.deleteWord
        }).registerCommand('backspaceWordButton', {
            exec: ()=>this.onDelete(true, 'word'),
            hotkeys: jodit.o.delete.hotkeys.backspaceWord
        }).registerCommand('deleteSentenceButton', {
            exec: ()=>this.onDelete(false, 'sentence'),
            hotkeys: jodit.o.delete.hotkeys.deleteSentence
        }).registerCommand('backspaceSentenceButton', {
            exec: ()=>this.onDelete(true, 'sentence'),
            hotkeys: jodit.o.delete.hotkeys.backspaceSentence
        });
    }
    beforeDestruct(jodit) {
        jodit.e.off('afterCommand.delete');
    }
    /**
	 * Listener BackSpace or Delete button
	 */ onDelete(backspace, mode = 'char') {
        const jodit = this.j;
        const sel = jodit.selection;
        if (!sel.isFocused()) {
            sel.focus();
        }
        if ((0,_cases_check_not_collapsed__WEBPACK_IMPORTED_MODULE_8__.checkNotCollapsed)(jodit)) {
            return false;
        }
        const range = sel.range;
        const fakeNode = jodit.createInside.text(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.INVISIBLE_SPACE);
        try {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.safeInsertNode(range, fakeNode);
            if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.isOrContains(jodit.editor, fakeNode)) {
                return;
            }
            if (jodit.e.fire('backSpaceBeforeCases', backspace, fakeNode)) {
                return false;
            }
            (0,jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_6__.moveNodeInsideStart)(jodit, fakeNode, backspace);
            if (_cases__WEBPACK_IMPORTED_MODULE_9__.cases.some((func)=>{
                if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__.isFunction)(func) && func(jodit, fakeNode, backspace, mode)) {
                    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                        console.info('Remove case:', func.name);
                    }
                    return true;
                }
            })) {
                return false;
            }
        } catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                console.error(e);
            }
            throw e;
        } finally{
            jodit.e.fire('backSpaceAfterDelete', backspace, fakeNode);
            this.safeRemoveEmptyNode(fakeNode);
        }
        return false;
    }
    /**
	 * Remove node and replace cursor position out of it
	 */ safeRemoveEmptyNode(fakeNode) {
        const { range } = this.j.s;
        if (range.startContainer === fakeNode) {
            if (fakeNode.previousSibling) {
                if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.isText(fakeNode.previousSibling)) {
                    var _fakeNode_previousSibling_nodeValue;
                    var _fakeNode_previousSibling_nodeValue_length;
                    range.setStart(fakeNode.previousSibling, (_fakeNode_previousSibling_nodeValue_length = (_fakeNode_previousSibling_nodeValue = fakeNode.previousSibling.nodeValue) === null || _fakeNode_previousSibling_nodeValue === void 0 ? void 0 : _fakeNode_previousSibling_nodeValue.length) !== null && _fakeNode_previousSibling_nodeValue_length !== void 0 ? _fakeNode_previousSibling_nodeValue_length : 0);
                } else {
                    range.setStartAfter(fakeNode.previousSibling);
                }
            } else if (fakeNode.nextSibling) {
                if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.isText(fakeNode.nextSibling)) {
                    range.setStart(fakeNode.nextSibling, 0);
                } else {
                    range.setStartBefore(fakeNode.nextSibling);
                }
            }
            range.collapse(true);
            this.j.s.selectRange(range);
        }
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.safeRemove(fakeNode);
    }
}
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(backspace, "requires", [
    'hotkeys'
]);
jodit_core_global__WEBPACK_IMPORTED_MODULE_3__.pluginSystem.add('backspace', backspace);


/***/ }),

/***/ 28686:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasBrowserColorPicker: function() { return /* reexport safe */ _has_browser_color_picker__WEBPACK_IMPORTED_MODULE_0__.hasBrowserColorPicker; },
/* harmony export */   hasContainer: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.hasContainer; },
/* harmony export */   isAbortError: function() { return /* reexport safe */ _is_abort_error__WEBPACK_IMPORTED_MODULE_1__.isAbortError; },
/* harmony export */   isArray: function() { return /* reexport safe */ _is_array__WEBPACK_IMPORTED_MODULE_2__.isArray; },
/* harmony export */   isBoolean: function() { return /* reexport safe */ _is_boolean__WEBPACK_IMPORTED_MODULE_3__.isBoolean; },
/* harmony export */   isDestructable: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.isDestructable; },
/* harmony export */   isEqual: function() { return /* reexport safe */ _is_equal__WEBPACK_IMPORTED_MODULE_4__.isEqual; },
/* harmony export */   isFastEqual: function() { return /* reexport safe */ _is_equal__WEBPACK_IMPORTED_MODULE_4__.isFastEqual; },
/* harmony export */   isFunction: function() { return /* reexport safe */ _is_function__WEBPACK_IMPORTED_MODULE_5__.isFunction; },
/* harmony export */   isHTML: function() { return /* reexport safe */ _is_html__WEBPACK_IMPORTED_MODULE_6__.isHTML; },
/* harmony export */   isHtmlFromWord: function() { return /* reexport safe */ _is_html_from_word__WEBPACK_IMPORTED_MODULE_7__.isHtmlFromWord; },
/* harmony export */   isInitable: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.isInitable; },
/* harmony export */   isInt: function() { return /* reexport safe */ _is_int__WEBPACK_IMPORTED_MODULE_9__.isInt; },
/* harmony export */   isJoditObject: function() { return /* reexport safe */ _is_jodit_object__WEBPACK_IMPORTED_MODULE_10__.isJoditObject; },
/* harmony export */   isLicense: function() { return /* reexport safe */ _is_license__WEBPACK_IMPORTED_MODULE_11__.isLicense; },
/* harmony export */   isMarker: function() { return /* reexport safe */ _is_marker__WEBPACK_IMPORTED_MODULE_12__.isMarker; },
/* harmony export */   isNativeFunction: function() { return /* reexport safe */ _is_native_function__WEBPACK_IMPORTED_MODULE_13__.isNativeFunction; },
/* harmony export */   isNumber: function() { return /* reexport safe */ _is_number__WEBPACK_IMPORTED_MODULE_14__.isNumber; },
/* harmony export */   isNumeric: function() { return /* reexport safe */ _is_numeric__WEBPACK_IMPORTED_MODULE_15__.isNumeric; },
/* harmony export */   isPlainObject: function() { return /* reexport safe */ _is_plain_object__WEBPACK_IMPORTED_MODULE_16__.isPlainObject; },
/* harmony export */   isPromise: function() { return /* reexport safe */ _is_promise__WEBPACK_IMPORTED_MODULE_17__.isPromise; },
/* harmony export */   isSet: function() { return /* reexport safe */ _is_set__WEBPACK_IMPORTED_MODULE_18__.isSet; },
/* harmony export */   isString: function() { return /* reexport safe */ _is_string__WEBPACK_IMPORTED_MODULE_19__.isString; },
/* harmony export */   isStringArray: function() { return /* reexport safe */ _is_string__WEBPACK_IMPORTED_MODULE_19__.isStringArray; },
/* harmony export */   isURL: function() { return /* reexport safe */ _is_url__WEBPACK_IMPORTED_MODULE_20__.isURL; },
/* harmony export */   isValidName: function() { return /* reexport safe */ _is_valid_name__WEBPACK_IMPORTED_MODULE_21__.isValidName; },
/* harmony export */   isViewObject: function() { return /* reexport safe */ _is_view_object__WEBPACK_IMPORTED_MODULE_22__.isViewObject; },
/* harmony export */   isVoid: function() { return /* reexport safe */ _is_void__WEBPACK_IMPORTED_MODULE_23__.isVoid; },
/* harmony export */   isWindow: function() { return /* reexport safe */ _is_window__WEBPACK_IMPORTED_MODULE_24__.isWindow; }
/* harmony export */ });
/* harmony import */ var _has_browser_color_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98740);
/* harmony import */ var _is_abort_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(72068);
/* harmony import */ var _is_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17312);
/* harmony import */ var _is_boolean__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22289);
/* harmony import */ var _is_equal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(94013);
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91565);
/* harmony import */ var _is_html__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(46248);
/* harmony import */ var _is_html_from_word__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(82166);
/* harmony import */ var _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(52433);
/* harmony import */ var _is_int__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(99732);
/* harmony import */ var _is_jodit_object__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(24497);
/* harmony import */ var _is_license__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(44998);
/* harmony import */ var _is_marker__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(23175);
/* harmony import */ var _is_native_function__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(23283);
/* harmony import */ var _is_number__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(72412);
/* harmony import */ var _is_numeric__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(70222);
/* harmony import */ var _is_plain_object__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(62101);
/* harmony import */ var _is_promise__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(52100);
/* harmony import */ var _is_set__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(3213);
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(85932);
/* harmony import */ var _is_url__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(91764);
/* harmony import */ var _is_valid_name__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(50083);
/* harmony import */ var _is_view_object__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(31534);
/* harmony import */ var _is_void__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(18303);
/* harmony import */ var _is_window__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(3513);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ 


























/***/ }),

/***/ 28712:
/***/ (function(module) {

"use strict";
module.exports = {assert(){}};;

/***/ }),

/***/ 28723:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $$: function() { return /* binding */ $$; },
/* harmony export */   cssPath: function() { return /* binding */ cssPath; },
/* harmony export */   getXPathByElement: function() { return /* binding */ getXPathByElement; },
/* harmony export */   refs: function() { return /* binding */ refs; },
/* harmony export */   resolveElement: function() { return /* binding */ resolveElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88475);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(57821);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(93640);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 





let temp = 1;
const $$temp = ()=>{
    temp++;
    return temp;
};
/**
 * @deprecated Do not use it in new code
 */ function $$(selector, root) {
    let result;
    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_ES_NEXT && /:scope/.test(selector) && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_IE && !(root && root.nodeType === Node.DOCUMENT_NODE)) {
        const id = root.id, temp_id = id || '_selector_id_' + String(Math.random()).slice(2) + $$temp();
        selector = selector.replace(/:scope/g, '#' + temp_id);
        !id && root.setAttribute('id', temp_id);
        result = root.parentNode.querySelectorAll(selector);
        if (!id) {
            root.removeAttribute('id');
        }
    } else {
        result = root.querySelectorAll(selector);
    }
    return [].slice.call(result);
}
/**
 * Calculate XPath selector
 */ const getXPathByElement = (element, root)=>{
    if (!element || element.nodeType !== Node.ELEMENT_NODE) {
        return '';
    }
    if (!element.parentNode || root === element) {
        return '';
    }
    if (element.id) {
        return "//*[@id='" + element.id + "']";
    }
    const sames = [].filter.call(element.parentNode.childNodes, (x)=>x.nodeName === element.nodeName);
    return getXPathByElement(element.parentNode, root) + '/' + element.nodeName.toLowerCase() + (sames.length > 1 ? '[' + ((0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_2__.toArray)(sames).indexOf(element) + 1) + ']' : '');
};
/**
 * Find all `ref` or `data-ref` elements inside HTMLElement
 */ const refs = (root)=>{
    if ('container' in root) {
        root = root.container;
    }
    return $$('[ref],[data-ref]', root).reduce((def, child)=>{
        const key = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(child, '-ref');
        if (key && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__.isString)(key)) {
            def[(0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_4__.camelCase)(key)] = child;
            def[key] = child;
        }
        return def;
    }, {});
};
/**
 * Calculate full CSS selector
 */ const cssPath = (el)=>{
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isElement(el)) {
        return null;
    }
    const path = [];
    let start = el;
    while(start && start.nodeType === Node.ELEMENT_NODE){
        let selector = start.nodeName.toLowerCase();
        if (start.id) {
            selector += '#' + start.id;
            path.unshift(selector);
            break;
        } else {
            let sib = start, nth = 1;
            do {
                sib = sib.previousElementSibling;
                if (sib && sib.nodeName.toLowerCase() === selector) {
                    nth++;
                }
            }while (sib)
            selector += ':nth-of-type(' + nth + ')';
        }
        path.unshift(selector);
        start = start.parentNode;
    }
    return path.join(' > ');
};
/**
 * Try to find element by selector
 */ function resolveElement(element, od) {
    let resolved = element;
    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__.isString)(element)) {
        try {
            resolved = od.querySelector(element);
        } catch (e) {
            throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.error)('String "' + element + '" should be valid HTML selector');
        }
    }
    // Duck checking
    if (!resolved || typeof resolved !== 'object' || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isElement(resolved) || !resolved.cloneNode) {
        throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.error)('Element "' + element + '" should be string or HTMLElement instance');
    }
    return resolved;
}


/***/ }),

/***/ 28771:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   openImageEditorDialog: function() { return /* binding */ openImageEditorDialog; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7909);
/* harmony import */ var jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43271);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 


/**
 * Open image editor dialog
 * @private
 */ function openImageEditorDialog(j, state) {
    const url = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(state.image, 'src') || '', a = j.c.element('a'), loadExternal = ()=>{
        if (a.host !== location.host) {
            j.confirm('You can only edit your own images. Download this image on the host?', (yes)=>{
                if (yes && j.uploader) {
                    j.uploader.uploadRemoteImage(a.href.toString(), (resp)=>{
                        j.alert('The image has been successfully uploaded to the host!', ()=>{
                            if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__.isString)(resp.newfilename)) {
                                state.values.imageSrc = resp.baseurl + resp.newfilename;
                            }
                        });
                    }, (error)=>{
                        j.alert('There was an error loading %s', error.message);
                    });
                }
            });
            return;
        }
    };
    a.href = url;
    j.filebrowser.dataProvider.getPathByUrl(a.href.toString()).then((resp)=>{
        jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_2__.openImageEditor.call(j.filebrowser, a.href, resp.name, resp.path, resp.source, ()=>{
            const timestamp = new Date().getTime();
            state.values.imageSrc = url + (url.indexOf('?') !== -1 ? '' : '?') + '&_tmp=' + timestamp.toString();
        }, (error)=>{
            j.alert(error.message);
        });
    }).catch((error)=>{
        j.alert(error.message, loadExternal);
    });
}


/***/ }),

/***/ 29200:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hook: function() { return /* binding */ hook; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91565);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33201);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/decorators/hook/README.md]]
 * @packageDocumentation
 * @module decorators/hook
 */ 

/**
 * Call on some component status
 */ function hook(status) {
    return (target, propertyKey)=>{
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__.isFunction)(target[propertyKey])) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__.error)('Handler must be a Function');
        }
        target.hookStatus(status, (component)=>{
            component[propertyKey].call(component);
        });
    };
}


/***/ }),

/***/ 29348:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"><path d=\"M1534 189v73q0 29-18.5 61t-42.5 32q-50 0-54 1-26 6-32 31-3 11-3 64v1152q0 25-18 43t-43 18h-108q-25 0-43-18t-18-43v-1218h-143v1218q0 25-17.5 43t-43.5 18h-108q-26 0-43.5-18t-17.5-43v-496q-147-12-245-59-126-58-192-179-64-117-64-259 0-166 88-286 88-118 209-159 111-37 417-37h479q25 0 43 18t18 43z\"/></svg>"

/***/ }),

/***/ 29433:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StatusBar: function() { return /* binding */ StatusBar; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16964);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(23183);
/* harmony import */ var jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(81987);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/status-bar/README.md]]
 * @packageDocumentation
 * @module modules/status-bar
 */ 







class StatusBar extends jodit_core_component__WEBPACK_IMPORTED_MODULE_2__.ViewComponent {
    className() {
        return 'StatusBar';
    }
    /**
	 * Hide statusbar
	 */ hide() {
        this.container.classList.add('jodit_hidden');
    }
    /**
	 * Show statusbar
	 */ show() {
        this.container.classList.remove('jodit_hidden');
    }
    /**
	 * Status bar is shown
	 */ get isShown() {
        return !this.container.classList.contains('jodit_hidden');
    }
    /**
	 * Height of statusbar
	 */ getHeight() {
        var _this_container;
        var _this_container_offsetHeight;
        return (_this_container_offsetHeight = (_this_container = this.container) === null || _this_container === void 0 ? void 0 : _this_container.offsetHeight) !== null && _this_container_offsetHeight !== void 0 ? _this_container_offsetHeight : 0;
    }
    findEmpty(inTheRight = false) {
        const items = this.getElms(inTheRight ? 'item-right' : 'item');
        for(let i = 0; i < items.length; i += 1){
            if (!items[i].innerHTML.trim().length) {
                return items[i];
            }
        }
        return;
    }
    /**
	 * Add element in statusbar
	 */ append(child, inTheRight = false) {
        var _this_container;
        const wrapper = this.findEmpty(inTheRight) || this.j.c.div(this.getFullElName('item'));
        if (inTheRight) {
            wrapper.classList.add(this.getFullElName('item-right'));
        }
        wrapper.appendChild(child);
        (_this_container = this.container) === null || _this_container === void 0 ? void 0 : _this_container.appendChild(wrapper);
        if (this.j.o.statusbar) {
            this.show();
        }
        this.j.e.fire('resize');
    }
    destruct() {
        if (this.isInDestruct) {
            return;
        }
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_2__.STATUSES.beforeDestruct);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.safeRemove(this.container);
        super.destruct();
    }
    constructor(jodit, target){
        super(jodit), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "target", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "container", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "mods", void 0), this.target = target, this.mods = {};
        this.container = jodit.c.div('jodit-status-bar');
        target.appendChild(this.container);
        this.hide();
    }
}
StatusBar = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.component,
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.derive)(jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_6__.Mods, jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_5__.Elms)
], StatusBar);


/***/ }),

/***/ 29434:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Icon: function() { return /* binding */ Icon; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80991);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui
 */ 



class Icon {
    static getIcon(name) {
        if (/<svg/i.test(name)) {
            return name;
        }
        const icon = Icon.icons[name] || Icon.icons[name.replace(/-/g, '_')] || Icon.icons[name.replace(/_/g, '-')] || Icon.icons[(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.camelCase)(name)] || Icon.icons[(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.kebabCase)(name)] || Icon.icons[name.toLowerCase()];
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD && !icon) {
            console.warn(`Icon "${name}" not found`);
        }
        return icon;
    }
    /**
	 * Check if icon exist in store
	 */ static exists(name) {
        return this.getIcon(name) !== undefined;
    }
    /**
	 * Return SVG icon
	 */ static get(name, defaultValue = '<span></span>') {
        return this.getIcon(name) || defaultValue;
    }
    /**
	 * Set SVG in store
	 */ static set(name, value) {
        this.icons[name.replace('_', '-')] = value;
        return this;
    }
    /**
	 * Make icon html element
	 */ static makeIcon(jodit, icon) {
        if (!icon) {
            return;
        }
        let iconElement;
        const { name, iconURL, fill } = icon;
        const clearName = name.replace(/[^a-zA-Z0-9]/g, '_');
        let iconFromEvent;
        if (!/<svg/.test(name)) {
            var _jodit_o_getIcon, _jodit_o;
            iconFromEvent = (_jodit_o_getIcon = (_jodit_o = jodit.o).getIcon) === null || _jodit_o_getIcon === void 0 ? void 0 : _jodit_o_getIcon.call(_jodit_o, name, clearName);
        }
        const cacheKey = `${name}${iconURL}${fill}${iconFromEvent !== null && iconFromEvent !== void 0 ? iconFromEvent : ''}`;
        if (jodit.o.cache && this.__cache.has(cacheKey)) {
            var _this___cache_get;
            return (_this___cache_get = this.__cache.get(cacheKey)) === null || _this___cache_get === void 0 ? void 0 : _this___cache_get.cloneNode(true);
        }
        if (iconURL) {
            iconElement = jodit.c.span();
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__.css)(iconElement, 'backgroundImage', 'url(' + iconURL.replace('{basePath}', (jodit === null || jodit === void 0 ? void 0 : jodit.basePath) || '') + ')');
        } else {
            var _jodit_o_extraIcons;
            const svg = iconFromEvent || Icon.get(name, '') || ((_jodit_o_extraIcons = jodit.o.extraIcons) === null || _jodit_o_extraIcons === void 0 ? void 0 : _jodit_o_extraIcons[name]);
            if (svg) {
                iconElement = jodit.c.fromHTML(svg.trim());
                if (!/^<svg/i.test(name)) {
                    iconElement.classList.add('jodit-icon_' + clearName);
                }
            }
        }
        if (iconElement) {
            iconElement.classList.add('jodit-icon');
            iconElement.style.fill = fill;
            jodit.o.cache && this.__cache.set(cacheKey, iconElement.cloneNode(true));
        }
        return iconElement;
    }
}
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(Icon, "icons", {});
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(Icon, "__cache", new Map());


/***/ }),

/***/ 29596:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UIImageMainTab: function() { return /* binding */ UIImageMainTab; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(91672);
/* harmony import */ var jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29200);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68616);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(63468);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 







class UIImageMainTab extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_7__.UIGroup {
    className() {
        return 'UIImageMainTab';
    }
    appendChildToContainer() {
    // Do nothing
    }
    render() {
        return `<div class="jodit-form__group &__editSrc">
			<label>~Src~</label>
			<div class="jodit-input_group">
				<input class="jodit-input &__imageSrc" type="text"/>
				<div class="jodit-input_group-buttons &__fixImage">
						<a class="jodit-button &__changeImage">*image*</a>
						<a class="jodit-button &__editImage">*crop*</a>
				</div>
			</div>
		</div>
		<div class="jodit-form__group &__editTitle">
			<label>~Title~</label>
			<input type="text" class="jodit-input &__imageTitle"/>
		</div>
		<div class="jodit-form__group &__editAlt">
			<label>~Alternative~</label>
			<input type="text" class="jodit-input &__imageAlt"/>
		</div>
		<div class="jodit-form__group &__editLink">
			<label>~Link~</label>
			<input type="text" class="jodit-input &__imageLink"/>
		</div>
		<div class="jodit-form__group &__editLinkTarget">
			<label class="jodit_vertical_middle">
				<input type="checkbox" class="jodit-checkbox &__imageLinkOpenInNewTab"/>
				<span>~Open link in new tab~</span>
			</label>
		</div>`;
    }
    onStateImageSrcChange() {
        return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
            const imageSrc = this.getElm('imageSrc');
            imageSrc.value = this.state.values.imageSrc;
        }).call(this);
    }
    onImageSrcChange() {
        this.state.values.imageSrc = this.getElm('imageSrc').value;
    }
    /**
	 * Open image editor
	 */ onEditImageClick(e) {
        this.handlers.openImageEditor();
        e.stopPropagation();
    }
    /**
	 * Open popup with filebrowser/uploader buttons for image
	 */ onChangeImageClick(e) {
        this.handlers.openImagePopup(this.getElm('changeImage'));
        e.stopPropagation();
    }
    onStateTitleChange() {
        const title = this.getElm('imageTitle');
        title.value = this.state.values.imageTitle;
    }
    onTitleChange() {
        this.state.values.imageTitle = this.getElm('imageTitle').value;
    }
    onStateAltChange() {
        const alt = this.getElm('imageAlt');
        alt.value = this.state.values.imageAlt;
    }
    onAltChange() {
        this.state.values.imageAlt = this.getElm('imageAlt').value;
    }
    onStateImageLinkChange() {
        const imageLink = this.getElm('imageLink');
        imageLink.value = this.state.values.imageLink;
    }
    onImageLinkChange() {
        this.state.values.imageLink = this.getElm('imageLink').value;
    }
    onStateImageLinkOpenInNewTabChange() {
        const imageLinkOpenInNewTab = this.getElm('imageLinkOpenInNewTab');
        imageLinkOpenInNewTab.checked = this.state.values.imageLinkOpenInNewTab;
    }
    onImageLinkOpenInNewTabChange() {
        this.state.values.imageLinkOpenInNewTab = this.getElm('imageLinkOpenInNewTab').checked;
    }
    hideFieldByOptions() {
        const o = this.j.o;
        const opt = o.image;
        [
            [
                'editSrc',
                'editSrc'
            ],
            [
                'editTitle',
                'editTitle'
            ],
            [
                'editAlt',
                'editAlt'
            ],
            [
                'editLink',
                'editLink'
            ],
            [
                'editLink',
                'editLinkTarget'
            ],
            [
                'useImageEditor',
                'editImage'
            ]
        ].forEach(([optKey, elmKey])=>{
            const elm = this.getElm(elmKey);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.css)(elm, 'display', opt[optKey] ? null : 'none');
        });
        const changeImage = this.getElm('changeImage');
        const needShowChangeImage = Boolean(o.filebrowser.ajax.url || o.uploader.url);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.css)(changeImage, 'display', needShowChangeImage ? null : 'none');
        const editImage = this.getElm('editImage');
        const needShowEditImage = Boolean(o.filebrowser.ajax.url) && opt.useImageEditor;
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.css)(editImage, 'display', needShowEditImage ? null : 'none');
        const fixImage = this.getElm('fixImage');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_6__.css)(fixImage, 'display', needShowChangeImage || needShowEditImage ? null : 'none');
    }
    constructor(view, state, handlers){
        super(view), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "state", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "handlers", void 0), this.state = state, this.handlers = handlers;
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('state.values.imageSrc')
], UIImageMainTab.prototype, "onStateImageSrcChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('imageSrc:change')
], UIImageMainTab.prototype, "onImageSrcChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('editImage:click')
], UIImageMainTab.prototype, "onEditImageClick", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('changeImage:click')
], UIImageMainTab.prototype, "onChangeImageClick", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('state.values.imageTitle')
], UIImageMainTab.prototype, "onStateTitleChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('imageTitle:change')
], UIImageMainTab.prototype, "onTitleChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('state.values.imageAlt')
], UIImageMainTab.prototype, "onStateAltChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('imageAlt:change')
], UIImageMainTab.prototype, "onAltChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('state.values.imageLink')
], UIImageMainTab.prototype, "onStateImageLinkChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('imageLink:change')
], UIImageMainTab.prototype, "onImageLinkChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('state.values.imageLinkOpenInNewTab')
], UIImageMainTab.prototype, "onStateImageLinkOpenInNewTabChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('imageLinkOpenInNewTab:change')
], UIImageMainTab.prototype, "onImageLinkOpenInNewTabChange", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_4__.hook)('ready')
], UIImageMainTab.prototype, "hideFieldByOptions", null);
UIImageMainTab = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__.component
], UIImageMainTab);


/***/ }),

/***/ 29953:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConnectionError: function() { return /* reexport safe */ _connection_error__WEBPACK_IMPORTED_MODULE_1__.ConnectionError; },
/* harmony export */   OptionsError: function() { return /* reexport safe */ _options_error__WEBPACK_IMPORTED_MODULE_2__.OptionsError; },
/* harmony export */   abort: function() { return /* reexport safe */ _abort_error__WEBPACK_IMPORTED_MODULE_0__.abort; },
/* harmony export */   isAbort: function() { return /* reexport safe */ _abort_error__WEBPACK_IMPORTED_MODULE_0__.isAbort; }
/* harmony export */ });
/* harmony import */ var _abort_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14228);
/* harmony import */ var _connection_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58250);
/* harmony import */ var _options_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11080);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 




/***/ }),

/***/ 30062:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export copyFormat */
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80991);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5266);
/* harmony import */ var _copy_format_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3843);
/* harmony import */ var _copy_format_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_copy_format_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _langs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38639);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/copy-format/README.md]]
 * @packageDocumentation
 * @module plugins/clipboard
 */ 






const pluginKey = 'copy-format';
/**
 * Plug-in copy and paste formatting from one element to another
 */ const copyStyles = [
    'lineHeight',
    'fontWeight',
    'fontStyle',
    'fontSize',
    'fontFamily',
    'color',
    'margin',
    'padding',
    'borderWidth',
    'borderStyle',
    'borderColor',
    'borderRadius',
    'backgroundColor',
    'textDecorationLine'
];
const getStyle = (editor, key, box, defaultStyles)=>{
    let result = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__.css)(box, key);
    if (result === defaultStyles[key]) {
        if (box.parentNode && box !== editor.editor && box.parentNode !== editor.editor) {
            result = getStyle(editor, key, box.parentNode, defaultStyles);
        } else {
            result = undefined;
        }
    }
    return result;
};
const getStyles = (editor, box, defaultStyles)=>{
    const result = {};
    if (box) {
        copyStyles.forEach((key)=>{
            result[key] = getStyle(editor, key, box, defaultStyles);
            if (key.match(/border(Style|Color)/) && !result.borderWidth) {
                result[key] = undefined;
            }
        });
    }
    return result;
};
jodit_config__WEBPACK_IMPORTED_MODULE_4__.Config.prototype.controls.copyformat = {
    exec: (editor, current, { button })=>{
        if (!current) {
            return;
        }
        if (editor.buffer.exists(pluginKey)) {
            editor.buffer.delete(pluginKey);
            editor.e.off(editor.editor, 'mouseup.' + pluginKey);
        } else {
            const defaultStyles = {}, box = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.up(current, (elm)=>elm && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isText(elm), editor.editor) || editor.editor;
            const ideal = editor.createInside.span();
            editor.editor.appendChild(ideal);
            copyStyles.forEach((key)=>{
                defaultStyles[key] = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__.css)(ideal, key);
            });
            if (ideal !== editor.editor) {
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(ideal);
            }
            const format = getStyles(editor, box, defaultStyles);
            const onMouseUp = ()=>{
                editor.buffer.delete(pluginKey);
                const currentNode = editor.s.current();
                if (currentNode) {
                    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(currentNode, 'img')) {
                        (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__.css)(currentNode, format);
                    } else {
                        editor.s.commitStyle({
                            attributes: {
                                style: format
                            }
                        });
                    }
                }
                editor.e.off(editor.editor, 'mouseup.' + pluginKey);
            };
            editor.e.on(editor.editor, 'mouseup.' + pluginKey, onMouseUp);
            editor.buffer.set(pluginKey, true);
        }
        button.update();
    },
    isActive: (editor)=>editor.buffer.exists(pluginKey),
    tooltip: 'Paint format'
};
function copyFormat(editor) {
    editor.registerButton({
        name: 'copyformat',
        group: 'clipboard'
    });
    (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_1__.extendLang)(_langs__WEBPACK_IMPORTED_MODULE_6__);
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__.pluginSystem.add('copyformat', copyFormat);
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__.Icon.set('copyformat', (_copy_format_svg__WEBPACK_IMPORTED_MODULE_5___default()));


/***/ }),

/***/ 30110:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export tableKeyboardNavigation */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65946);
/* harmony import */ var jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98803);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/table-keyboard-navigation/README.md]]
 * @packageDocumentation
 * @module plugins/table-keyboard-navigation
 */ 




const WORK_KEYS = new Set([
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN
]);
/**
 * Process navigates key pressing in table cell
 */ function tableKeyboardNavigation(editor) {
    editor.e.off('.tableKeyboardNavigation').on('keydown.tableKeyboardNavigation', (event)=>{
        const { key } = event;
        const cell = findCell(editor, key);
        if (!cell) {
            return;
        }
        const tableModule = editor.getInstance(jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_4__.Table, editor.o);
        const table = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.closest(cell, 'table', editor.editor);
        let next = null;
        const isPrev = key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT || event.shiftKey;
        const getNextCell = ()=>(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)(isPrev ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.prev : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.next, cell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isCell, table);
        switch(key){
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB:
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT:
                {
                    next = getNextCell();
                    if (!next) {
                        tableModule.appendRow(table, !isPrev ? false : table.querySelector('tr'), !isPrev);
                        next = getNextCell();
                    }
                    break;
                }
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP:
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN:
                {
                    const matrix = tableModule.formalMatrix(table);
                    const [row, column] = tableModule.formalCoordinate(table, cell);
                    if (key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP) {
                        if (matrix[row - 1] !== undefined) {
                            next = matrix[row - 1][column];
                        }
                    } else {
                        if (matrix[row + 1] !== undefined) {
                            next = matrix[row + 1][column];
                        }
                    }
                }
                break;
        }
        if (!next) {
            return;
        }
        editor.e.fire('hidePopup hideResizer');
        if (!next.firstChild) {
            const first = editor.createInside.element('br');
            next.appendChild(first);
            editor.s.setCursorBefore(first);
        } else {
            if (key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB) {
                editor.s.select(next, true);
            } else {
                editor.s.setCursorIn(next, key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT || key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN);
            }
        }
        editor.synchronizeValues();
        return false;
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__.pluginSystem.add('tableKeyboardNavigation', tableKeyboardNavigation);
function findCell(editor, key) {
    if (!WORK_KEYS.has(key)) {
        return;
    }
    const current = editor.s.current();
    if (!current) {
        return;
    }
    const cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.up(current, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isCell, editor.editor);
    if (!cell) {
        return;
    }
    const { range } = editor.s;
    if (key !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB && current !== cell) {
        const isNextDirection = key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT || key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN;
        const hasNext = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)(!isNextDirection ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.prev : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.next, current, (elm)=>key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP || key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(elm, 'br') : Boolean(elm), cell);
        if (!isNextDirection && (hasNext || key !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(current) && range.startOffset !== 0) || isNextDirection && (hasNext || key !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(current) && current.nodeValue && range.startOffset !== current.nodeValue.length)) {
            return;
        }
    }
    return cell;
}


/***/ }),

/***/ 30893:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyStyles: function() { return /* binding */ applyStyles; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4040);
/* harmony import */ var jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28723);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/html
 */ 



function normalizeCSS(s) {
    return s.replace(/mso-[a-z-]+:[\s]*[^;]+;/gi, '').replace(/mso-[a-z-]+:[\s]*[^";']+$/gi, '').replace(/border[a-z-]*:[\s]*[^;]+;/gi, '').replace(/([0-9.]+)(pt|cm)/gi, (match, units, metrics)=>{
        switch(metrics.toLowerCase()){
            case 'pt':
                return (parseFloat(units) * 1.328).toFixed(0) + 'px';
            case 'cm':
                return (parseFloat(units) * 0.02645833).toFixed(0) + 'px';
        }
        return match;
    });
}
/**
 * If the HTML has CSS rules with selectors,
 * it applies them to the selectors in the HTML itself
 * and then removes the selector styles, leaving only the inline ones.
 */ function applyStyles(html) {
    if (html.indexOf('<html ') === -1) {
        return html;
    }
    html = html.substring(html.indexOf('<html '), html.length);
    html = html.substring(0, html.lastIndexOf('</html>') + '</html>'.length);
    const iframe = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('iframe');
    iframe.style.display = 'none';
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.body.appendChild(iframe);
    let convertedString = '', collection = [];
    try {
        const iframeDoc = iframe.contentDocument || (iframe.contentWindow ? iframe.contentWindow.document : null);
        if (iframeDoc) {
            iframeDoc.open();
            iframeDoc.write(html);
            iframeDoc.close();
            try {
                for(let i = 0; i < iframeDoc.styleSheets.length; i += 1){
                    const rules = iframeDoc.styleSheets[i].cssRules;
                    for(let idx = 0; idx < rules.length; idx += 1){
                        if (rules[idx].selectorText === '') {
                            continue;
                        }
                        collection = (0,jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_3__.$$)(rules[idx].selectorText, iframeDoc.body);
                        collection.forEach((elm)=>{
                            elm.style.cssText = normalizeCSS(rules[idx].style.cssText + ';' + elm.style.cssText);
                        });
                    }
                }
            } catch (e) {
                if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                    throw e;
                }
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.each(iframeDoc.body, (node)=>{
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isElement(node)) {
                    const elm = node;
                    const css = elm.getAttribute('style');
                    if (css) {
                        elm.style.cssText = normalizeCSS(css);
                    }
                    if (elm.hasAttribute('style') && !elm.getAttribute('style')) {
                        elm.removeAttribute('style');
                    }
                }
            });
            convertedString = iframeDoc.firstChild ? (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__.trim)(iframeDoc.body.innerHTML) : '';
        }
    } catch (e) {} finally{
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(iframe);
    }
    if (convertedString) {
        html = convertedString;
    }
    return (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__.trim)(html.replace(/<(\/)?(html|colgroup|col|o:p)[^>]*>/g, '').replace(/<!--[^>]*>/g, ''));
}


/***/ }),

/***/ 31125:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   elementsMap: function() { return /* binding */ elementsMap; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ const map = new WeakMap();
/**
 * Returns a map of the file's key correspondence to its DOM element in the file browser
 * @private
 */ const elementsMap = (view)=>{
    let result = map.get(view);
    if (!result) {
        result = {};
        map.set(view, result);
    }
    return result;
};


/***/ }),

/***/ 31230:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 24 24\"> <g transform=\"translate(-251.000000, -443.000000)\"> <g transform=\"translate(215.000000, 119.000000)\"/> <path d=\"M252,448 L256,448 L256,444 L252,444 L252,448 Z M257,448 L269,448 L269,446 L257,446 L257,448 Z M257,464 L269,464 L269,462 L257,462 L257,464 Z M270,444 L270,448 L274,448 L274,444 L270,444 Z M252,462 L252,466 L256,466 L256,462 L252,462 Z M270,462 L270,466 L274,466 L274,462 L270,462 Z M254,461 L256,461 L256,449 L254,449 L254,461 Z M270,461 L272,461 L272,449 L270,449 L270,461 Z\"/> </g> </svg>"

/***/ }),

/***/ 31365:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 32 32\"> <path d=\"M27 4l-15 15-7-7-5 5 12 12 20-20z\"/> </svg>"

/***/ }),

/***/ 31371:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    'copy-format': 'Kopyalama Biçimi'
};


/***/ }),

/***/ 31534:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isViewObject: function() { return /* binding */ isViewObject; }
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91565);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ 
/**
 * Check if an element is instance of View
 */ function isViewObject(jodit) {
    return Boolean(jodit && jodit instanceof Object && (0,_is_function__WEBPACK_IMPORTED_MODULE_0__.isFunction)(jodit.constructor) && jodit.isView);
}


/***/ }),

/***/ 31635:
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __decorate: function() { return /* binding */ __decorate; }
/* harmony export */ });
/* unused harmony exports __extends, __assign, __rest, __param, __esDecorate, __runInitializers, __propKey, __setFunctionName, __metadata, __awaiter, __generator, __createBinding, __exportStar, __values, __read, __spread, __spreadArrays, __spreadArray, __await, __asyncGenerator, __asyncDelegator, __asyncValues, __makeTemplateObject, __importStar, __importDefault, __classPrivateFieldGet, __classPrivateFieldSet, __classPrivateFieldIn, __addDisposableResource, __disposeResources, __rewriteRelativeImportExtension */
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol, Iterator */

var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf ||
      ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
      function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
  return extendStatics(d, b);
};

function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
      throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
  __assign = Object.assign || function __assign(t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
      return t;
  }
  return __assign.apply(this, arguments);
}

function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
              t[p[i]] = s[p[i]];
      }
  return t;
}

function __decorate(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
  else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
  return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
      var context = {};
      for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
      for (var p in contextIn.access) context.access[p] = contextIn.access[p];
      context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
      var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
      if (kind === "accessor") {
          if (result === void 0) continue;
          if (result === null || typeof result !== "object") throw new TypeError("Object expected");
          if (_ = accept(result.get)) descriptor.get = _;
          if (_ = accept(result.set)) descriptor.set = _;
          if (_ = accept(result.init)) initializers.unshift(_);
      }
      else if (_ = accept(result)) {
          if (kind === "field") initializers.unshift(_);
          else descriptor[key] = _;
      }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};

function __runInitializers(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
      value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};

function __propKey(x) {
  return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
  if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
  return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
  return new (P || (P = Promise))(function (resolve, reject) {
      function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
      function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
      function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}

function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
  return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
  function verb(n) { return function (v) { return step([n, v]); }; }
  function step(op) {
      if (f) throw new TypeError("Generator is already executing.");
      while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
              case 0: case 1: t = op; break;
              case 4: _.label++; return { value: op[1], done: false };
              case 5: _.label++; y = op[1]; op = [0]; continue;
              case 7: op = _.ops.pop(); _.trys.pop(); continue;
              default:
                  if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                  if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                  if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                  if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                  if (t[2]) _.ops.pop();
                  _.trys.pop(); continue;
          }
          op = body.call(thisArg, _);
      } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
      if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
  }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
  }
  Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});

function __exportStar(m, o) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
  if (m) return m.call(o);
  if (o && typeof o.length === "number") return {
      next: function () {
          if (o && i >= o.length) o = void 0;
          return { value: o && o[i++], done: !o };
      }
  };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o), r, ar = [], e;
  try {
      while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  }
  catch (error) { e = { error: error }; }
  finally {
      try {
          if (r && !r.done && (m = i["return"])) m.call(i);
      }
      finally { if (e) throw e.error; }
  }
  return ar;
}

/** @deprecated */
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++)
      ar = ar.concat(__read(arguments[i]));
  return ar;
}

/** @deprecated */
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
      for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
          r[k] = a[j];
  return r;
}

function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
      if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
      }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
  function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
  function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
  function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
  function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
  function fulfill(value) { resume("next", value); }
  function reject(value) { resume("throw", value); }
  function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
  function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator], i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
  function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
  function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
  return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
  Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
  o["default"] = v;
};

var ownKeys = function(o) {
  ownKeys = Object.getOwnPropertyNames || function (o) {
    var ar = [];
    for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
    return ar;
  };
  return ownKeys(o);
};

function __importStar(mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
  __setModuleDefault(result, mod);
  return result;
}

function __importDefault(mod) {
  return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
  if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
  return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
  if (value !== null && value !== void 0) {
    if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
    var dispose, inner;
    if (async) {
      if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
      dispose = value[Symbol.asyncDispose];
    }
    if (dispose === void 0) {
      if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
      dispose = value[Symbol.dispose];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
    if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
    env.stack.push({ value: value, dispose: dispose, async: async });
  }
  else if (async) {
    env.stack.push({ async: true });
  }
  return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
  function fail(e) {
    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
    env.hasError = true;
  }
  var r, s = 0;
  function next() {
    while (r = env.stack.pop()) {
      try {
        if (!r.async && s === 1) return s = 0, env.stack.push(r), Promise.resolve().then(next);
        if (r.dispose) {
          var result = r.dispose.call(r.value);
          if (r.async) return s |= 2, Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
        }
        else s |= 1;
      }
      catch (e) {
        fail(e);
      }
    }
    if (s === 1) return env.hasError ? Promise.reject(env.error) : Promise.resolve();
    if (env.hasError) throw env.error;
  }
  return next();
}

function __rewriteRelativeImportExtension(path, preserveJsx) {
  if (typeof path === "string" && /^\.\.?\//.test(path)) {
      return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function (m, tsx, d, ext, cm) {
          return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : (d + ext + "." + cm.toLowerCase() + "js");
      });
  }
  return path;
}

/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ({
  __extends,
  __assign,
  __rest,
  __decorate,
  __param,
  __esDecorate,
  __runInitializers,
  __propKey,
  __setFunctionName,
  __metadata,
  __awaiter,
  __generator,
  __createBinding,
  __exportStar,
  __values,
  __read,
  __spread,
  __spreadArrays,
  __spreadArray,
  __await,
  __asyncGenerator,
  __asyncDelegator,
  __asyncValues,
  __makeTemplateObject,
  __importStar,
  __importDefault,
  __classPrivateFieldGet,
  __classPrivateFieldSet,
  __classPrivateFieldIn,
  __addDisposableResource,
  __disposeResources,
  __rewriteRelativeImportExtension,
});


/***/ }),

/***/ 31927:
/***/ (function(module) {

module.exports["default"] = ["Scrivi qualcosa...","A proposito di Jodit","Jodit Editor","Guida utente di Jodit","contiene una guida dettagliata per l'uso.","Per informazioni sulla licenza, si prega di visitare il nostro sito web:","Acquista la versione completa","Copyright © XDSoft.net - Chupurnov Valeriy. Tutti i diritti riservati.","Link","Apri in una nuova scheda","Apri l'editor a schermo intero","Pulisci Formattazione","Colore di sfondo o del testo","Ripristina","Annulla","Grassetto","Corsivo","Inserisci lista non ordinata","Inserisci lista ordinata","Allinea al centro","Allineamento Giustificato","Allinea a Sinistra","Allinea a Destra","Inserisci una linea orizzontale","Inserisci immagine","Inserisci un file","Inserisci video Youtube/Vimeo","Inserisci link","Dimensione carattere","Tipo di font","Inserisci blocco","Normale","Intestazione 1","Intestazione 2","Intestazione 3","Intestazione 4","Citazione","Codice","Inserisci","Inserisci tabella","Riduci il rientro","Aumenta il rientro","Seleziona un carattere speciale","Inserisci un carattere speciale","Copia formato","Cambia modalita'","Margini","su","destra","giù","sinistra","Stili CSS","Classi CSS","Allinea","Destra","Centro","Sinistra","--Non Impostato--","Fonte","Titolo","Testo Alternativo","Link","Apri il link in una nuova scheda","Immagine","Archivio","Avanzato","Proprietà dell'immagine","Annulla","Accetta","Cerca file","Errore durante il caricamento dell'elenco","Errore durante il caricamento delle cartelle","Sei sicuro?","Inserisci il nome della cartella","Crea cartella","Digita il nome","Cancella immagine","Cancella file","o clicca","Testo alternativo","Carica","Sfoglia","Sfondo","Testo","Su","Centro","Sotto","Inserisci la colonna prima","Inserisci la colonna dopo","Inserisci la riga sopra","Inserisci la riga sotto","Elimina tabella","Elimina riga","Elimina colonna","Cella vuota","Caratteri: %d","Parole: %d","Barrato","Sottolineato","indice","pedice","Taglia selezione","Seleziona tutto","Pausa","Cerca per","Sostituisci con","Sostituisci","Incolla","Seleziona il contenuto da incollare","risorsa","Grassetto","Corsivo","Pennello","Link","Annulla","Ripristina","Tabella","Immagine","Gomma","Paragrafo","Dimensione del carattere","Video","Font","Approposito di","Stampa","Sottolineato","Barrato","aumenta rientro","riduci rientro","espandi","comprimi","linea orizzontale","lista non ordinata","lista ordinata","Taglia","Seleziona tutto","Includi codice","Apri link","Modifica link","Non seguire","Rimuovi link","Aggiorna","Per modificare","Recensione"," URL","Modifica","Allineamento orizzontale","Filtro","Ordina per data di modifica","Ordina per nome","Ordina per dimensione","Aggiungi cartella","Reset","Salva","Salva con nome...","Ridimensiona","Ritaglia","Larghezza","Altezza","Mantieni le proporzioni","Si","No","Rimuovi","Seleziona","Seleziona: %s","Allineamento verticala","Dividi","Fondi","Aggiungi colonna","Aggiungi riga","Licenza: %s","Cancella","Dividi verticalmente","Dividi orizzontale","Bordo","Il codice è simile all'HTML. Mantieni come HTML?","Incolla come HTML","Mantieni","Inserisci come testo","Inserisci solo il testo","Puoi modificare solo le tue immagini. Vuoi scaricare questa immagine dal server?","L'immagine è stata caricata correttamente sul server!","tavolozza","Non ci sono file in questa directory.","Rinomina","Inserisci un nuovo nome","anteprima","Scarica","Incolla dagli appunti","Il tuo browser non supporta l'accesso diretto agli appunti.","Copia selezione","copia","Border radius","Mostra tutti","Applica","Si prega di compilare questo campo","Si prega di inserire un indirizzo web","Default","Cerchio","Punto","Quadrato","Trova","Trova Precedente","Trova Successivo","Il contenuto incollato proviene da un documento Microsoft Word / Excel. Vuoi mantenere il formato o pulirlo?","Incolla testo da Word rilevato","Pulisci","Inserisci il nome della classe","Premere Alt per il ridimensionamento personalizzato",null,null,null,"Tutto"]

/***/ }),

/***/ 32013:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1472 930v318q0 119-84.5 203.5t-203.5 84.5h-832q-119 0-203.5-84.5t-84.5-203.5v-832q0-119 84.5-203.5t203.5-84.5h832q63 0 117 25 15 7 18 23 3 17-9 29l-49 49q-10 10-23 10-3 0-9-2-23-6-45-6h-832q-66 0-113 47t-47 113v832q0 66 47 113t113 47h832q66 0 113-47t47-113v-254q0-13 9-22l64-64q10-10 23-10 6 0 12 3 20 8 20 29zm231-489l-814 814q-24 24-57 24t-57-24l-430-430q-24-24-24-57t24-57l110-110q24-24 57-24t57 24l263 263 647-647q24-24 57-24t57 24l110 110q24 24 24 57t-24 57z\"/> </svg>"

/***/ }),

/***/ 32328:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   splitArray: function() { return /* binding */ splitArray; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/array
 */ /**
 * Return an array from string or array
 * ```javascript
 * Jodit.modules.Helpers.splitArray('1,2,3') // ['1', '2', '3']
 * Jodit.modules.Helpers.splitArray(['1', '2', '3']) // ['1', '2', '3']
 * ```
 */ function splitArray(a) {
    return Array.isArray(a) ? a : a.split(/[,\s]+/);
}


/***/ }),

/***/ 32855:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Response: function() { return /* binding */ Response; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25045);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module request
 */ 

class Response {
    get url() {
        return this.request.url;
    }
    json() {
        return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
            return JSON.parse(this.body);
        }).call(this);
    }
    text() {
        return Promise.resolve(this.body);
    }
    blob() {
        return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
            return this.body;
        }).call(this);
    }
    constructor(request, status, statusText, body){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "status", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "statusText", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "request", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_1__._)(this, "body", void 0);
        this.request = request;
        this.status = status;
        this.statusText = statusText;
        this.body = body;
    }
}


/***/ }),

/***/ 33201:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConnectionError: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.ConnectionError; },
/* harmony export */   OptionsError: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.OptionsError; },
/* harmony export */   abort: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.abort; },
/* harmony export */   connection: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_0__.connection; },
/* harmony export */   error: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_0__.error; },
/* harmony export */   isAbort: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.isAbort; },
/* harmony export */   options: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_0__.options; }
/* harmony export */ });
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38027);
/* harmony import */ var _errors___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29953);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 



/***/ }),

/***/ 33433:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    symbols: 'symbol'
};


/***/ }),

/***/ 33511:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Stack: function() { return /* binding */ Stack; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/history
 */ 
class Stack {
    get length() {
        return this.commands.length;
    }
    clearRedo() {
        this.commands.length = this.stackPosition + 1;
    }
    clear() {
        this.commands.length = 0;
        this.stackPosition = -1;
    }
    push(command) {
        this.clearRedo();
        this.commands.push(command);
        this.stackPosition += 1;
        if (this.commands.length > this.size) {
            this.commands.shift();
            this.stackPosition -= 1;
        }
    }
    replace(command) {
        this.commands[this.stackPosition] = command;
    }
    current() {
        return this.commands[this.stackPosition];
    }
    undo() {
        if (this.canUndo()) {
            if (this.commands[this.stackPosition]) {
                this.commands[this.stackPosition].undo();
            }
            this.stackPosition -= 1;
            return true;
        }
        return false;
    }
    redo() {
        if (this.canRedo()) {
            this.stackPosition += 1;
            if (this.commands[this.stackPosition]) {
                this.commands[this.stackPosition].redo();
            }
            return true;
        }
        return false;
    }
    canUndo() {
        return this.stackPosition >= 0;
    }
    canRedo() {
        return this.stackPosition < this.commands.length - 1;
    }
    constructor(size){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "size", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "commands", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "stackPosition", void 0);
        this.size = size;
        this.commands = [];
        this.stackPosition = -1;
    }
}


/***/ }),

/***/ 33831:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/backspace
 */ 
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.delete = {
    hotkeys: {
        delete: [
            'delete',
            'cmd+backspace'
        ],
        deleteWord: [
            'ctrl+delete',
            'cmd+alt+backspace',
            'ctrl+alt+backspace'
        ],
        deleteSentence: [
            'ctrl+shift+delete',
            'cmd+shift+delete'
        ],
        backspace: [
            'backspace'
        ],
        backspaceWord: [
            'ctrl+backspace'
        ],
        backspaceSentence: [
            'ctrl+shift+backspace',
            'cmd+shift+backspace'
        ]
    }
};


/***/ }),

/***/ 34027:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getScrollParent: function() { return /* binding */ getScrollParent; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(93640);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/size
 */ 


function getScrollParent(node) {
    if (!node) {
        return null;
    }
    const isElement = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isHTMLElement(node);
    const overflowY = isElement && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.css)(node, 'overflowY');
    const isScrollable = isElement && overflowY !== 'visible' && overflowY !== 'hidden';
    if (isScrollable && node.scrollHeight >= node.clientHeight) {
        return node;
    }
    return getScrollParent(node.parentNode) || jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.scrollingElement || jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.body;
}


/***/ }),

/***/ 34045:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1664 256v448q0 26-19 45t-45 19h-448q-42 0-59-40-17-39 14-69l138-138q-148-137-349-137-104 0-198.5 40.5t-163.5 109.5-109.5 163.5-40.5 198.5 40.5 198.5 109.5 163.5 163.5 109.5 198.5 40.5q119 0 225-52t179-147q7-10 23-12 14 0 25 9l137 138q9 8 9.5 20.5t-7.5 22.5q-109 132-264 204.5t-327 72.5q-156 0-298-61t-245-164-164-245-61-298 61-298 164-245 245-164 298-61q147 0 284.5 55.5t244.5 156.5l130-129q29-31 70-14 39 17 39 59z\"/> </svg>"

/***/ }),

/***/ 34142:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28077);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48899);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/video/README.md]]
 * @packageDocumentation
 * @module plugins/video
 */ 

function video(editor) {
    editor.registerButton({
        name: 'video',
        group: 'media'
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__.pluginSystem.add('video', video);


/***/ }),

/***/ 34269:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   elementToItem: function() { return /* binding */ elementToItem; },
/* harmony export */   getItem: function() { return /* binding */ getItem; },
/* harmony export */   nativeListeners: function() { return /* binding */ nativeListeners; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65946);
/* harmony import */ var jodit_modules_file_browser_builders_context_menu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61334);
/* harmony import */ var jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31125);
/* harmony import */ var jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53202);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ 




/**
 * @private
 */ const getItem = (node, root, tag = 'a')=>jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(node, (elm)=>jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(elm, tag), root);
/**
 * @private
 */ const elementToItem = (elm, elementsMap)=>{
    const { key } = elm.dataset, { item } = elementsMap[key || ''];
    return item;
};
/**
 * @private
 */ function nativeListeners() {
    let dragElement = false;
    const elmMap = (0,jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_3__.elementsMap)(this);
    const self = this;
    self.e.on(self.tree.container, 'dragstart', (e)=>{
        const a = getItem(e.target, self.container);
        if (!a) {
            return;
        }
        if (self.o.moveFolder) {
            dragElement = a;
        }
    }).on(self.tree.container, 'drop', (e)=>{
        if ((self.o.moveFile || self.o.moveFolder) && dragElement) {
            let path = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(dragElement, '-path') || '';
            // move folder
            if (!self.o.moveFolder && dragElement.classList.contains(this.tree.getFullElName('item'))) {
                return false;
            }
            // move file
            if (dragElement.classList.contains(this.files.getFullElName('item'))) {
                path += (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(dragElement, '-name');
                if (!self.o.moveFile) {
                    return false;
                }
            }
            const a = getItem(e.target, self.container);
            if (!a) {
                return;
            }
            self.dataProvider.move(path, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(a, '-path') || '', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(a, '-source') || '', dragElement.classList.contains(this.files.getFullElName('item'))).then(()=>(0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_4__.loadTree)(this)).catch(self.status);
            dragElement = false;
        }
    }).on(self.files.container, 'contextmenu', (0,jodit_modules_file_browser_builders_context_menu__WEBPACK_IMPORTED_MODULE_2__["default"])(self)).on(self.files.container, 'click', (e)=>{
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.ctrlKey)(e)) {
            this.state.activeElements = [];
        }
    }).on(self.files.container, 'click', (e)=>{
        const a = getItem(e.target, self.container);
        if (!a) {
            return;
        }
        const item = elementToItem(a, elmMap);
        if (!item) {
            return;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.ctrlKey)(e)) {
            self.state.activeElements = [
                item
            ];
        } else {
            self.state.activeElements = [
                ...self.state.activeElements,
                item
            ];
        }
        e.stopPropagation();
        return false;
    }).on(self.files.container, 'dragstart', (e)=>{
        if (self.o.moveFile) {
            const a = getItem(e.target, self.container);
            if (!a) {
                return;
            }
            dragElement = a;
        }
    }).on(self.container, 'drop', (e)=>e.preventDefault());
}


/***/ }),

/***/ 34287:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkBR: function() { return /* binding */ checkBR; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60898);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/enter
 */ 


/**
 * Checks the possibility and necessity of inserting a BR instead of a block
 * @private
 */ function checkBR(fake, jodit, shiftKeyPressed) {
    const isMultiLineBlock = Boolean(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.closest(fake, [
        'pre',
        'blockquote'
    ], jodit.editor));
    const isCell = !isMultiLineBlock && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.closest(fake, [
        'td',
        'th'
    ], jodit.editor);
    const isBRMode = jodit.o.enter.toLowerCase() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.BR.toLowerCase();
    // if you use <br> defaultTag for break line or when was entered SHIFt key or in <td> or <th> or <blockquote>
    if (isBRMode || isCell || shiftKeyPressed && !isMultiLineBlock || !shiftKeyPressed && isMultiLineBlock) {
        // 2 BR before
        if (isMultiLineBlock && checkSeveralBR(fake)) {
            return false;
        }
        const br = jodit.createInside.element('br');
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.before(fake, br);
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.findNotEmptySibling(br, false)) {
            const clone = br.cloneNode();
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.after(br, clone);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.before(clone, fake);
        }
        (0,jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_2__.scrollIntoViewIfNeeded)(br, jodit.editor, jodit.ed);
        return true;
    }
    return false;
}
function checkSeveralBR(fake) {
    // 2 BR before
    const preBr = brBefore(brBefore(fake));
    if (preBr) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(brBefore(fake));
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(preBr);
        return true;
    }
    return false;
}
function brBefore(start) {
    if (!start) {
        return false;
    }
    const prev = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.findSibling(start, true);
    if (!prev || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(prev, 'br')) {
        return false;
    }
    return prev;
}


/***/ }),

/***/ 34396:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ProgressBar: function() { return /* binding */ ProgressBar; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(96007);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/ui/progress-bar/README.md]]
 * @packageDocumentation
 * @module ui/progress-bar
 */ 


class ProgressBar extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_1__.UIElement {
    /** @override */ className() {
        return 'ProgressBar';
    }
    /** @override */ render() {
        return '<div><div></div></div>';
    }
    /**
	 * Show progress bar
	 */ show() {
        const container = this.j.workplace || this.j.container;
        container.appendChild(this.container);
        return this;
    }
    hide() {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(this.container);
        return this;
    }
    progress(percentage) {
        this.container.style.width = percentage.toFixed(2) + '%';
        return this;
    }
    destruct() {
        this.hide();
        return super.destruct();
    }
}


/***/ }),

/***/ 34582:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   toggleOrderedList: function() { return /* binding */ toggleOrderedList; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jodit_core_selection_style_api_extract__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17481);
/* harmony import */ var jodit_core_selection_style_api_toggle_attributes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82794);
/* harmony import */ var jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98394);
/* harmony import */ var _wrap_list__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(97110);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 





/**
 * Replaces `ul->ol` or `ol->ul`, apply styles to the list, or remove a list item from it
 * @private
 */ function toggleOrderedList(commitStyle, li, jodit, mode) {
    if (!li) {
        return mode;
    }
    const list = li.parentElement;
    if (!list) {
        return mode;
    }
    const result = jodit.e.fire(`${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__._PREFIX}BeforeToggleList`, mode, commitStyle, list);
    if (result !== undefined) {
        return result;
    }
    const hook = jodit.e.fire.bind(jodit.e, `${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__._PREFIX}AfterToggleList`);
    if (mode !== jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__.UNWRAP) {
        const isChangeMode = (0,jodit_core_selection_style_api_toggle_attributes__WEBPACK_IMPORTED_MODULE_3__.toggleAttributes)(commitStyle, li.parentElement, jodit, jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__.INITIAL, true) === jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__.CHANGE;
        // ul => ol, ol => ul or ul => ul.class1
        if (mode === jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__.REPLACE || isChangeMode || list.tagName.toLowerCase() !== commitStyle.element) {
            const wrapper = unwrapList(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__.REPLACE, list, li, jodit, commitStyle);
            const newList = (0,_wrap_list__WEBPACK_IMPORTED_MODULE_5__.wrapList)(commitStyle, wrapper, jodit);
            hook(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__.REPLACE, newList, commitStyle);
            return jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__.REPLACE;
        }
    }
    const wrapper = unwrapList(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__.UNWRAP, list, li, jodit, commitStyle);
    hook(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__.UNWRAP, wrapper, commitStyle);
    return jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__.UNWRAP;
}
function unwrapList(mode, list, li, jodit, cs) {
    const result = jodit.e.fire(`${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__._PREFIX}BeforeUnwrapList`, mode, list, cs);
    if (result) {
        (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__.assert)(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isHTMLElement(result), `${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_4__._PREFIX}BeforeUnwrapList hook must return HTMLElement`);
        return result;
    }
    (0,jodit_core_selection_style_api_extract__WEBPACK_IMPORTED_MODULE_2__.extractSelectedPart)(list, li, jodit);
    (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__.assert)(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isHTMLElement(li.parentElement), 'Element should be inside the list');
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.unwrap(li.parentElement);
    return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.replace(li, jodit.o.enter.toLowerCase() !== 'br' ? jodit.o.enter : jodit.createInside.fragment(), jodit.createInside);
}


/***/ }),

/***/ 34672:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   processEmptyLILeaf: function() { return /* binding */ processEmptyLILeaf; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28723);
/* harmony import */ var _insert_paragraph__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65710);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/enter
 */ 


/**
 * Handles pressing the Enter key inside an empty LI inside a list
 * @private
 */ function processEmptyLILeaf(fake, jodit, li) {
    const list = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(li, [
        'ol',
        'ul'
    ], jodit.editor);
    if (!list) {
        return;
    }
    const parentLi = list.parentElement, listInsideLeaf = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isLeaf(parentLi);
    const container = listInsideLeaf ? parentLi : list;
    // Empty element in the middle of the list
    const leftRange = jodit.s.createRange();
    leftRange.setStartAfter(li);
    leftRange.setEndAfter(list);
    const rightPart = leftRange.extractContents();
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(container, fake);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(li);
    if (!(0,jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_1__.$$)('li', list).length) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(list);
    }
    const newLi = (0,_insert_paragraph__WEBPACK_IMPORTED_MODULE_2__.insertParagraph)(fake, jodit, listInsideLeaf ? 'li' : jodit.o.enter);
    if (!rightPart.querySelector('li')) {
        return;
    }
    if (listInsideLeaf) {
        newLi.appendChild(rightPart);
    } else {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(newLi, rightPart);
    }
}


/***/ }),

/***/ 34689:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.image = {
    dialogWidth: 600,
    openOnDblClick: true,
    editSrc: true,
    useImageEditor: true,
    editTitle: true,
    editAlt: true,
    editLink: true,
    editSize: true,
    editBorderRadius: true,
    editMargins: true,
    editClass: true,
    availableClasses: [],
    editStyle: true,
    editId: true,
    editAlign: true,
    showPreview: true,
    selectImageAfterClose: true
};


/***/ }),

/***/ 35099:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   View: function() { return /* binding */ View; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16964);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80251);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(69364);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_create_create__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(76517);
/* harmony import */ var jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(51676);
/* harmony import */ var jodit_core_decorators_derive_derive__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(24968);
/* harmony import */ var jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(29200);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(1496);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_storage_storage__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(24475);
/* harmony import */ var jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(23183);
/* harmony import */ var jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(81987);
/* harmony import */ var jodit_core_ui_progress_bar_progress_bar__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(34396);
/* harmony import */ var jodit_modules_messages_messages__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(10081);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/view/README.md]]
 * @packageDocumentation
 * @module view
 */ 


















class View extends jodit_core_component_component__WEBPACK_IMPORTED_MODULE_3__.Component {
    /**
	 * Get a path for loading extra staff
	 */ get basePath() {
        if (this.o.basePath) {
            return this.o.basePath;
        }
        return jodit_core_constants__WEBPACK_IMPORTED_MODULE_5__.BASE_PATH;
    }
    /**
	 * Plugin autoloader should load minified version of the file
	 */ get minified() {
        if (this.o.minified !== undefined) {
            return this.o.minified;
        }
        return jodit_core_constants__WEBPACK_IMPORTED_MODULE_5__.BASE_PATH_IS_MIN;
    }
    /**
	 * Return a default timeout period in milliseconds for some debounce or throttle functions.
	 * By default, `{history.timeout}` options
	 */ get defaultTimeout() {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__.isVoid)(this.o.defaultTimeout) ? 100 : this.o.defaultTimeout;
    }
    /**
	 * Some extra data inside editor
	 * @see copyformat plugin
	 */ get buffer() {
        return jodit_core_storage_storage__WEBPACK_IMPORTED_MODULE_14__.Storage.makeStorage();
    }
    get message() {
        return this.getMessageModule(this.container);
    }
    getMessageModule(container) {
        return new jodit_modules_messages_messages__WEBPACK_IMPORTED_MODULE_18__.UIMessages(this, container);
    }
    /**
	 * Container for persistent set/get value
	 */ get storage() {
        return jodit_core_storage_storage__WEBPACK_IMPORTED_MODULE_14__.Storage.makeStorage(true, this.id);
    }
    /**
	 * Short alias for `create`
	 */ get c() {
        return this.create;
    }
    get container() {
        return this.__container;
    }
    set container(container) {
        this.__container = container;
    }
    /**
	 * Short alias for `events`
	 */ get e() {
        return this.events;
    }
    /**
	 * progress_bar Progress bar
	 */ get progressbar() {
        return new jodit_core_ui_progress_bar_progress_bar__WEBPACK_IMPORTED_MODULE_17__.ProgressBar(this);
    }
    get options() {
        return this.__options;
    }
    set options(options) {
        this.__options = options;
    }
    /**
	 * Short alias for options
	 */ get o() {
        return this.options;
    }
    /**
	 * Internationalization method. Uses Jodit.lang object
	 */ i18n(text, ...params) {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__.i18n)(text, params, this.options);
    }
    toggleFullSize(isFullSize) {
        if (isFullSize === undefined) {
            isFullSize = !this.__isFullSize;
        }
        if (isFullSize === this.__isFullSize) {
            return;
        }
        this.__isFullSize = isFullSize;
        this.e.fire('toggleFullSize', isFullSize);
    }
    /**
	 * View is locked
	 */ get isLocked() {
        return this.__whoLocked !== '';
    }
    /**
	 * Disable selecting
	 */ lock(name = 'any') {
        if (!this.isLocked) {
            this.__whoLocked = name;
            return true;
        }
        return false;
    }
    /**
	 * Enable selecting
	 */ unlock() {
        if (this.isLocked) {
            this.__whoLocked = '';
            return true;
        }
        return false;
    }
    /**
	 * View is in fullSize
	 */ get isFullSize() {
        return this.__isFullSize;
    }
    /**
	 * Return current version
	 */ getVersion() {
        return View.version;
    }
    static getVersion() {
        return View.version;
    }
    /** @override */ initOptions(options) {
        this.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__.ConfigProto)(options || {}, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__.ConfigProto)(this.options || {}, View.defaultOptions));
    }
    /**
	 * Can change ownerWindow here
	 */ initOwners() {
        var _this_o_ownerWindow;
        this.ownerWindow = (_this_o_ownerWindow = this.o.ownerWindow) !== null && _this_o_ownerWindow !== void 0 ? _this_o_ownerWindow : window;
    }
    /**
	 * Add option's event handlers in emitter
	 */ attachEvents(options) {
        if (!options) {
            return;
        }
        const e = options === null || options === void 0 ? void 0 : options.events;
        e && Object.keys(e).forEach((key)=>this.e.on(key, e[key]));
    }
    getInstance(moduleNameOrConstructor, options) {
        const moduleName = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__.isFunction)(moduleNameOrConstructor) ? moduleNameOrConstructor.prototype.className() : moduleNameOrConstructor;
        const instance = this.e.fire((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__.camelCase)('getInstance_' + moduleName), options);
        if (instance) {
            return instance;
        }
        const module = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__.isFunction)(moduleNameOrConstructor) ? moduleNameOrConstructor : jodit_core_global__WEBPACK_IMPORTED_MODULE_12__.modules[moduleName], mi = this.__modulesInstances;
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__.isFunction)(module)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__.error)('Need real module name');
        }
        if (!mi.has(moduleName)) {
            const instance = module.prototype instanceof jodit_core_component__WEBPACK_IMPORTED_MODULE_2__.ViewComponent ? new module(this, options) : new module(options);
            this.components.add(instance);
            mi.set(moduleName, instance);
        }
        return mi.get(moduleName);
    }
    /** Add some element to box */ addDisclaimer(elm) {
        this.container.appendChild(elm);
    }
    /**
	 * Call before destruct
	 */ beforeDestruct() {
        this.e.fire(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_4__.STATUSES.beforeDestruct, this);
        this.components.forEach((component)=>{
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_13__.isDestructable)(component) && !component.isInDestruct) {
                component.destruct();
            }
        });
        this.components.clear();
    }
    /** @override */ destruct() {
        var _cached, _cached1, _cached2;
        if (this.isDestructed) {
            return;
        }
        (_cached = (0,jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_7__.cached)(this, 'progressbar')) === null || _cached === void 0 ? void 0 : _cached.destruct();
        (_cached1 = (0,jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_7__.cached)(this, 'message')) === null || _cached1 === void 0 ? void 0 : _cached1.destruct();
        if (this.events) {
            this.events.destruct();
            // @ts-ignore
            this.events = undefined;
        }
        (_cached2 = (0,jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_7__.cached)(this, 'buffer')) === null || _cached2 === void 0 ? void 0 : _cached2.clear();
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_10__.Dom.safeRemove(this.container);
        super.destruct();
    }
    constructor(options, isJodit = false){
        super(), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "isJodit", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "isView", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "parent", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "mods", void 0), /**
	 * ID attribute for a source element, id add `{id}_editor` it's editor's id
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "id", void 0), /**
	 * All created ViewComponent inside this view
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "components", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "create", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__container", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "events", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "OPTIONS", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__options", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__isFullSize", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__whoLocked", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "isLockedNotBy", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__modulesInstances", void 0), this.isJodit = isJodit, this.isView = true, this.parent = null, this.mods = {}, this.components = new Set(), this.OPTIONS = View.defaultOptions, this.__isFullSize = false, this.__whoLocked = '', this.isLockedNotBy = (name)=>this.isLocked && this.__whoLocked !== name, this.__modulesInstances = new Map();
        this.id = new Date().getTime().toString();
        this.initOptions(options);
        this.initOwners();
        this.events = new jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_11__.EventEmitter(this.od);
        this.create = new jodit_core_create_create__WEBPACK_IMPORTED_MODULE_6__.Create(this.od);
        this.__container = this.c.div(`jodit ${this.componentName}`);
    }
}
// from webpack.config.ts
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(View, "ES", jodit_core_constants__WEBPACK_IMPORTED_MODULE_5__.ES);
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(View, "version", jodit_core_constants__WEBPACK_IMPORTED_MODULE_5__.APP_VERSION);
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(View, "esNext", jodit_core_constants__WEBPACK_IMPORTED_MODULE_5__.IS_ES_NEXT); // from webpack.config.ts
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(View, "esModern", jodit_core_constants__WEBPACK_IMPORTED_MODULE_5__.IS_ES_MODERN); // from webpack.config.ts
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(View, "defaultOptions", void 0);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_7__.cache
], View.prototype, "buffer", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_7__.cache
], View.prototype, "message", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_7__.cache
], View.prototype, "storage", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_7__.cache
], View.prototype, "c", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_7__.cache
], View.prototype, "e", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_7__.cache
], View.prototype, "progressbar", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_9__.hook)(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_4__.STATUSES.beforeDestruct)
], View.prototype, "beforeDestruct", null);
View = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_derive_derive__WEBPACK_IMPORTED_MODULE_8__.derive)(jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_16__.Mods, jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_15__.Elms)
], View);
View.defaultOptions = {
    extraButtons: [],
    cache: true,
    textIcons: false,
    namespace: '',
    removeButtons: [],
    zIndex: 100002,
    defaultTimeout: 100,
    fullsize: false,
    showTooltip: true,
    useNativeTooltip: false,
    buttons: [],
    globalFullSize: true,
    language: 'auto'
};


/***/ }),

/***/ 35104:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   replaceOldTags: function() { return /* binding */ replaceOldTags; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/clean-html
 */ 
/**
 * @private
 */ function replaceOldTags(jodit, nodeElm, hadEffect) {
    const newNodeElm = replaceIfMatched(jodit, nodeElm, jodit.o.cleanHTML.replaceOldTags);
    if (nodeElm !== newNodeElm) {
        nodeElm = newNodeElm;
        return true;
    }
    return hadEffect;
}
/**
 * Replaces an element with a newer one if specified in the configuration match
 * @private
 */ function replaceIfMatched(jodit, oldParent, list) {
    if (!list || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isHTMLElement(oldParent)) {
        return oldParent;
    }
    const tagName = list[oldParent.nodeName.toLowerCase()] || list[oldParent.nodeName];
    if (tagName) {
        return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.replace(oldParent, tagName, jodit.createInside, true, false);
    }
    return oldParent;
}


/***/ }),

/***/ 35109:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    'copy-format': 'format kopii'
};


/***/ }),

/***/ 35676:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UISeparator: function() { return /* binding */ UISeparator; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91672);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(96007);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/group
 */ 


class UISeparator extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_2__.UIElement {
    className() {
        return 'UISeparator';
    }
}
UISeparator = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_0__.__decorate)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_1__.component
], UISeparator);


/***/ }),

/***/ 35718:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   idle: function() { return /* binding */ idle; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16964);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91565);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33201);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/decorators/idle/README.md]]
 * @packageDocumentation
 * @module decorators/idle
 */ 


function idle() {
    return (target, propertyKey)=>{
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__.isFunction)(target[propertyKey])) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_2__.error)('Handler must be a Function');
        }
        target.hookStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.STATUSES.ready, (component)=>{
            const { async } = component;
            const originalMethod = component[propertyKey];
            component[propertyKey] = (...args)=>async.requestIdleCallback(originalMethod.bind(component, ...args));
        });
    };
}


/***/ }),

/***/ 36310:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseQuery: function() { return /* binding */ parseQuery; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ /**
 * Parse query string
 */ const parseQuery = (queryString)=>{
    const query = {}, a = queryString.substring(1).split('&');
    for(let i = 0; i < a.length; i += 1){
        const keyValue = a[i].split('=');
        query[decodeURIComponent(keyValue[0])] = decodeURIComponent(keyValue[1] || '');
    }
    return query;
};


/***/ }),

/***/ 36327:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"><path d=\"M1600 736v192q0 40-28 68t-68 28h-416v416q0 40-28 68t-68 28h-192q-40 0-68-28t-28-68v-416h-416q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h416v-416q0-40 28-68t68-28h192q40 0 68 28t28 68v416h416q40 0 68 28t28 68z\"/></svg>"

/***/ }),

/***/ 36339:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1792 352v1088q0 42-39 59-13 5-25 5-27 0-45-19l-403-403v166q0 119-84.5 203.5t-203.5 84.5h-704q-119 0-203.5-84.5t-84.5-203.5v-704q0-119 84.5-203.5t203.5-84.5h704q119 0 203.5 84.5t84.5 203.5v165l403-402q18-19 45-19 12 0 25 5 39 17 39 59z\"/> </svg>"

/***/ }),

/***/ 36400:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dataBind: function() { return /* binding */ dataBind; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31534);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 
const store = new WeakMap();
const dataBind = (elm, key, value)=>{
    let itemStore = store.get(elm);
    if (!itemStore) {
        itemStore = {};
        store.set(elm, itemStore);
        let e = null;
        if ((0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_0__.isViewObject)(elm.j)) {
            e = elm.j.e;
        }
        if ((0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_0__.isViewObject)(elm)) {
            e = elm.e;
        }
        e && e.on('beforeDestruct', ()=>{
            store.delete(elm);
        });
    }
    if (value === undefined) {
        return itemStore[key];
    }
    itemStore[key] = value;
    return value;
};


/***/ }),

/***/ 36664:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   selfListeners: function() { return /* binding */ selfListeners; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28686);
/* harmony import */ var jodit_modules_file_browser_data_provider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17780);
/* harmony import */ var jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1305);
/* harmony import */ var jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1488);
/* harmony import */ var jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(53202);
/* harmony import */ var jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(43271);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ 






/**
 * @private
 */ function selfListeners() {
    const state = this.state, dp = this.dataProvider, self = this;
    self.e.on('view.filebrowser', (view)=>{
        if (view !== state.view) {
            state.view = view;
        }
    }).on('sort.filebrowser', (value)=>{
        if (value !== state.sortBy) {
            state.sortBy = value;
            (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_4__.loadItems)(self);
        }
    }).on('filter.filebrowser', (value)=>{
        if (value !== state.filterWord) {
            state.filterWord = value;
            (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_4__.loadItems)(self);
        }
    }).on('openFolder.filebrowser', (data)=>{
        let path;
        if (data.name === '..') {
            path = data.path.split('/').filter((p)=>p.length).slice(0, -1).join('/');
        } else {
            path = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(data.path, data.name);
        }
        self.state.currentPath = path;
        self.state.currentSource = data.name === '.' ? jodit_modules_file_browser_data_provider__WEBPACK_IMPORTED_MODULE_2__.DEFAULT_SOURCE_NAME : data.source;
    }).on('removeFolder.filebrowser', (data)=>{
        self.confirm('Are you sure?', 'Delete', (yes)=>{
            if (yes) {
                dp.folderRemove(data.path, data.name, data.source).then((message)=>{
                    self.status(message, true);
                    return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_5__.loadTree)(self);
                }).catch(self.status);
            }
        });
    }).on('renameFolder.filebrowser', (data)=>{
        self.prompt('Enter new name', 'Rename', (newName)=>{
            if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__.isValidName)(newName)) {
                self.status(self.i18n('Enter new name'));
                return false;
            }
            dp.folderRename(data.path, data.name, newName, data.source).then((message)=>{
                self.state.activeElements = [];
                self.status(message, true);
                return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_5__.loadTree)(self);
            }).catch(self.status);
            return;
        }, 'type name', data.name);
    }).on('addFolder.filebrowser', (data)=>{
        self.prompt('Enter Directory name', 'Create directory', (name)=>{
            dp.createFolder(name, data.path, data.source).then(()=>(0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_5__.loadTree)(self)).catch(self.status);
        }, 'type name');
    }).on('fileRemove.filebrowser', ()=>{
        if (self.state.activeElements.length) {
            self.confirm('Are you sure?', '', (yes)=>{
                if (yes) {
                    const promises = [];
                    self.state.activeElements.forEach((item)=>{
                        promises.push((0,jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_3__.deleteFile)(self, item.file || item.name || '', item.sourceName));
                    });
                    self.state.activeElements = [];
                    Promise.all(promises).then(()=>(0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_5__.loadTree)(self).catch(self.status), self.status);
                }
            });
        }
    }).on('edit.filebrowser', ()=>{
        if (self.state.activeElements.length === 1) {
            const [file] = this.state.activeElements;
            jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_6__.openImageEditor.call(self, file.fileURL, file.file || '', file.path, file.sourceName);
        }
    }).on('fileRename.filebrowser', (name, path, source)=>{
        if (self.state.activeElements.length === 1) {
            self.prompt('Enter new name', 'Rename', (newName)=>{
                if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__.isValidName)(newName)) {
                    self.status(self.i18n('Enter new name'));
                    return false;
                }
                dp.fileRename(path, name, newName, source).then((message)=>{
                    self.state.activeElements = [];
                    self.status(message, true);
                    (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_4__.loadItems)(self);
                }).catch(self.status);
                return;
            }, 'type name', name);
        }
    }).on('update.filebrowser', ()=>{
        (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_5__.loadTree)(this).then(this.status, this.status);
    });
}


/***/ }),

/***/ 36833:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   buildQuery: function() { return /* binding */ buildQuery; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 
/**
 * Build query string
 */ const buildQuery = (data, prefix)=>{
    const str = [];
    const enc = encodeURIComponent;
    for(const dataKey in data){
        if (Object.prototype.hasOwnProperty.call(data, dataKey)) {
            const k = prefix ? prefix + '[' + dataKey + ']' : dataKey;
            const v = data[dataKey];
            str.push((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(v) ? buildQuery(v, k) : enc(k) + '=' + enc(v));
        }
    }
    return str.join('&');
};


/***/ }),

/***/ 37102:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module request
 */ 
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.defaultAjaxOptions = {
    successStatuses: [
        200,
        201,
        202
    ],
    method: 'GET',
    url: '',
    data: null,
    contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
    headers: {
        'X-REQUESTED-WITH': 'XMLHttpRequest' // compatible with jQuery
    },
    withCredentials: false,
    xhr () {
        return new XMLHttpRequest();
    }
};


/***/ }),

/***/ 37333:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Alert: function() { return /* reexport safe */ _alert__WEBPACK_IMPORTED_MODULE_0__.Alert; },
/* harmony export */   Confirm: function() { return /* reexport safe */ _confirm__WEBPACK_IMPORTED_MODULE_1__.Confirm; },
/* harmony export */   Dialog: function() { return /* reexport safe */ _dialog__WEBPACK_IMPORTED_MODULE_2__.Dialog; },
/* harmony export */   Prompt: function() { return /* reexport safe */ _prompt__WEBPACK_IMPORTED_MODULE_3__.Prompt; }
/* harmony export */ });
/* harmony import */ var _alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91535);
/* harmony import */ var _confirm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88329);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(76841);
/* harmony import */ var _prompt__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74103);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/dialog/README.md]]
 * @packageDocumentation
 * @module modules/dialog
 */ 





/***/ }),

/***/ 37427:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   humanSizeToBytes: function() { return /* binding */ humanSizeToBytes; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ /**
 * Converts from human readable file size (kb,mb,gb,tb) to bytes
 * @param human - readable file size. Example 1gb or 11.2mb
 */ const humanSizeToBytes = (human)=>{
    if (/^[0-9.]+$/.test(human.toString())) {
        return parseFloat(human);
    }
    const format = human.substr(-2, 2).toUpperCase(), formats = [
        'KB',
        'MB',
        'GB',
        'TB'
    ], number = parseFloat(human.substr(0, human.length - 2));
    return formats.indexOf(format) !== -1 ? number * Math.pow(1024, formats.indexOf(format) + 1) : parseInt(human, 10);
};


/***/ }),

/***/ 37431:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isInlineBlock: function() { return /* binding */ isInlineBlock; },
/* harmony export */   removeFormatForCollapsedSelection: function() { return /* binding */ removeFormatForCollapsedSelection; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/clean-html
 */ 

/**
 * For collapsed selection move cursor outside or split inline block
 * @private
 */ function removeFormatForCollapsedSelection(jodit, fake) {
    const { s } = jodit;
    let fakeNode = fake;
    if (!fakeNode) {
        fakeNode = jodit.createInside.fake();
        const { range } = s;
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeInsertNode(range, fakeNode);
        range.collapse();
    }
    const mainInline = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.furthest(fakeNode, isInlineBlock, jodit.editor);
    if (mainInline) {
        if (s.cursorOnTheLeft(mainInline)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.before(mainInline, fakeNode);
        } else if (s.cursorOnTheRight(mainInline)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.after(mainInline, fakeNode);
        } else {
            const leftHand = s.splitSelection(mainInline);
            leftHand && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.after(leftHand, fakeNode);
        }
    }
    if (!fake) {
        s.setCursorBefore(fakeNode);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(fakeNode);
    }
}
/**
 * Element has inline display mode
 * @private
 */ function isInlineBlock(node) {
    return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isInlineBlock(node) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(node, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS);
}


/***/ }),

/***/ 38027:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   connection: function() { return /* binding */ connection; },
/* harmony export */   error: function() { return /* binding */ error; },
/* harmony export */   options: function() { return /* binding */ options; }
/* harmony export */ });
/* harmony import */ var _errors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29953);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 
/**
 * Helper for create Error object
 */ function error(message) {
    return new TypeError(message);
}
function connection(message) {
    return new _errors__WEBPACK_IMPORTED_MODULE_0__.ConnectionError(message);
}
function options(message) {
    return new _errors__WEBPACK_IMPORTED_MODULE_0__.OptionsError(message);
}


/***/ }),

/***/ 38187:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5266);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(54308);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/paste
 */ 



jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.askBeforePasteHTML = true;
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.processPasteHTML = true;
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.scrollToPastedContent = true;
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.pasteExcludeStripTags = [
    'br',
    'hr'
];
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.pasteHTMLActionList = [
    {
        value: jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.INSERT_AS_HTML,
        text: 'Keep'
    },
    {
        value: jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.INSERT_AS_TEXT,
        text: 'Insert as Text'
    },
    {
        value: jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.INSERT_ONLY_TEXT,
        text: 'Insert only Text'
    }
];
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.memorizeChoiceWhenPasteFragment = false;
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.nl2brInPlainText = true;
const psKey = 'pasteStorage';
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.controls.paste = {
    tooltip: 'Paste from clipboard',
    exec (_0, _1, _2) {
        return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*(editor, _, { control }) {
            if (control.name === psKey) {
                editor.execCommand('showPasteStorage');
                return;
            }
            editor.s.focus();
            let text = '', error = true;
            if (navigator.clipboard) {
                try {
                    const items = yield navigator.clipboard.read();
                    if (items && items.length) {
                        const textBlob = yield items[0].getType(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.TEXT_PLAIN);
                        text = yield new Response(textBlob).text();
                    }
                    error = false;
                } catch (e) {
                    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                        // eslint-disable-next-line no-console
                        console.log(e);
                    }
                }
                if (error) {
                    try {
                        text = yield navigator.clipboard.readText();
                        error = false;
                    } catch (e) {
                        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                            // eslint-disable-next-line no-console
                            console.log(e);
                        }
                    }
                }
            }
            if (error) {
                text = editor.buffer.get(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.CLIPBOARD_ID) || '';
                error = text.length === 0;
            }
            const value = editor.value;
            if (error) {
                editor.ed.execCommand('paste');
                error = value === editor.value;
                !error && editor.e.fire('afterPaste');
            } else if (text.length) {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_3__.pasteInsertHtml)(null, editor, text);
                editor.e.fire('afterPaste');
            } else {
                if (error) {
                    editor.alert("Your browser doesn't support direct access to the clipboard.", ()=>void editor.s.focus());
                }
            }
        }).apply(this, arguments);
    },
    list: {
        [psKey]: 'Paste Storage'
    },
    isChildDisabled (j) {
        return j.e.fire('pasteStorageList') < 2;
    }
};


/***/ }),

/***/ 38639:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ar: function() { return /* reexport default from dynamic */ _ar_js__WEBPACK_IMPORTED_MODULE_0___default.a; },
/* harmony export */   cs_cz: function() { return /* reexport default from dynamic */ _cs_cz_js__WEBPACK_IMPORTED_MODULE_1___default.a; },
/* harmony export */   de: function() { return /* reexport default from dynamic */ _de_js__WEBPACK_IMPORTED_MODULE_2___default.a; },
/* harmony export */   es: function() { return /* reexport default from dynamic */ _es_js__WEBPACK_IMPORTED_MODULE_3___default.a; },
/* harmony export */   fa: function() { return /* reexport default from dynamic */ _ar_js__WEBPACK_IMPORTED_MODULE_0___default.a; },
/* harmony export */   fi: function() { return /* reexport default from dynamic */ _ar_js__WEBPACK_IMPORTED_MODULE_0___default.a; },
/* harmony export */   fr: function() { return /* reexport default from dynamic */ _fr_js__WEBPACK_IMPORTED_MODULE_4___default.a; },
/* harmony export */   he: function() { return /* reexport default from dynamic */ _ar_js__WEBPACK_IMPORTED_MODULE_0___default.a; },
/* harmony export */   hu: function() { return /* reexport default from dynamic */ _hu_js__WEBPACK_IMPORTED_MODULE_5___default.a; },
/* harmony export */   id: function() { return /* reexport default from dynamic */ _ar_js__WEBPACK_IMPORTED_MODULE_0___default.a; },
/* harmony export */   it: function() { return /* reexport default from dynamic */ _it_js__WEBPACK_IMPORTED_MODULE_6___default.a; },
/* harmony export */   ja: function() { return /* reexport default from dynamic */ _ja_js__WEBPACK_IMPORTED_MODULE_7___default.a; },
/* harmony export */   ko: function() { return /* reexport default from dynamic */ _ar_js__WEBPACK_IMPORTED_MODULE_0___default.a; },
/* harmony export */   mn: function() { return /* reexport default from dynamic */ _ar_js__WEBPACK_IMPORTED_MODULE_0___default.a; },
/* harmony export */   nl: function() { return /* reexport default from dynamic */ _nl_js__WEBPACK_IMPORTED_MODULE_8___default.a; },
/* harmony export */   pl: function() { return /* reexport default from dynamic */ _pl_js__WEBPACK_IMPORTED_MODULE_9___default.a; },
/* harmony export */   pt_br: function() { return /* reexport default from dynamic */ _pt_br_js__WEBPACK_IMPORTED_MODULE_10___default.a; },
/* harmony export */   ru: function() { return /* reexport default from dynamic */ _ar_js__WEBPACK_IMPORTED_MODULE_0___default.a; },
/* harmony export */   tr: function() { return /* reexport default from dynamic */ _tr_js__WEBPACK_IMPORTED_MODULE_11___default.a; },
/* harmony export */   zh_cn: function() { return /* reexport default from dynamic */ _zh_cn_js__WEBPACK_IMPORTED_MODULE_12___default.a; },
/* harmony export */   zh_tw: function() { return /* reexport default from dynamic */ _zh_tw_js__WEBPACK_IMPORTED_MODULE_13___default.a; }
/* harmony export */ });
/* harmony import */ var _ar_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41324);
/* harmony import */ var _ar_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_ar_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _cs_cz_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3787);
/* harmony import */ var _cs_cz_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_cs_cz_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _de_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83778);
/* harmony import */ var _de_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_de_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _es_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(70577);
/* harmony import */ var _es_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_es_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _fr_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(21513);
/* harmony import */ var _fr_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_fr_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _hu_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22998);
/* harmony import */ var _hu_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_hu_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _it_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(66568);
/* harmony import */ var _it_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_it_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _ja_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(83708);
/* harmony import */ var _ja_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_ja_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _nl_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(58067);
/* harmony import */ var _nl_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_nl_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _pl_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(35109);
/* harmony import */ var _pl_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_pl_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _pt_br_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(22380);
/* harmony import */ var _pt_br_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_pt_br_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _tr_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(31371);
/* harmony import */ var _tr_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_tr_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _zh_cn_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(41599);
/* harmony import */ var _zh_cn_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_zh_cn_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _zh_tw_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(15223);
/* harmony import */ var _zh_tw_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_zh_tw_js__WEBPACK_IMPORTED_MODULE_13__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 























/***/ }),

/***/ 38681:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 18.151 18.151\" xmlns=\"http://www.w3.org/2000/svg\"> <g> <path stroke-width=\"0\" d=\"M6.237,16.546H3.649V1.604h5.916v5.728c0.474-0.122,0.968-0.194,1.479-0.194 c0.042,0,0.083,0.006,0.125,0.006V0H2.044v18.15h5.934C7.295,17.736,6.704,17.19,6.237,16.546z\"/> <path stroke-width=\"0\" d=\"M11.169,8.275c-2.723,0-4.938,2.215-4.938,4.938s2.215,4.938,4.938,4.938s4.938-2.215,4.938-4.938 S13.892,8.275,11.169,8.275z M11.169,16.81c-1.983,0-3.598-1.612-3.598-3.598c0-1.983,1.614-3.597,3.598-3.597 s3.597,1.613,3.597,3.597C14.766,15.198,13.153,16.81,11.169,16.81z\"/> <polygon stroke-width=\"0\" points=\"11.792,11.073 10.502,11.073 10.502,12.578 9.03,12.578 9.03,13.868 10.502,13.868 10.502,15.352 11.792,15.352 11.792,13.868 13.309,13.868 13.309,12.578 11.792,12.578 \"/> </g> </svg>"

/***/ }),

/***/ 39000:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export indent */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(93640);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(42360);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11917);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/indent/README.md]]
 * @packageDocumentation
 * @module plugins/indent
 */ 





const applyIndentToBox = (processedElements, currentBox, editor, command)=>{
    if (!currentBox) {
        return;
    }
    if (processedElements.has(currentBox)) {
        return;
    }
    const key = (0,_helpers__WEBPACK_IMPORTED_MODULE_5__.getKey)(editor.o.direction, currentBox);
    processedElements.add(currentBox);
    let value = currentBox.style[key] ? parseInt(currentBox.style[key], 10) : 0;
    value += editor.o.indentMargin * (command === 'outdent' ? -1 : 1);
    currentBox.style[key] = value > 0 ? value + 'px' : '';
    if (!(0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(currentBox, 'style')) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(currentBox, 'style', null);
    }
};
/**
 * Indents the line containing the selection or insertion point.
 */ function indent(editor) {
    editor.registerButton({
        name: 'indent',
        group: 'indent'
    }).registerButton({
        name: 'outdent',
        group: 'indent'
    });
    const indentCommand = (command)=>{
        const processedElements = new Set();
        const { enter, enterBlock } = editor.o;
        const isBrMode = enter.toLowerCase() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.BR;
        const current = editor.s.current();
        if (isBrMode && editor.s.isCollapsed()) {
            if (current) {
                const box = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.wrapNextInline(current, enterBlock, editor);
                applyIndentToBox(processedElements, box, editor, command);
                return false;
            }
        }
        editor.s.eachSelection((current)=>{
            editor.s.save();
            let currentBox = current ? jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.up(current, jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isBlock, editor.editor) : false;
            if (!currentBox && current) {
                currentBox = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.call)(!isBrMode ? jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.wrapInline : jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.wrapNextInline, current, !isBrMode ? enter.toLowerCase() : enterBlock, editor);
            }
            if (!currentBox) {
                editor.s.restore();
                return false;
            }
            applyIndentToBox(processedElements, currentBox, editor, command);
            editor.s.restore();
        });
        editor.synchronizeValues();
        return false;
    };
    editor.registerCommand('indent', {
        exec: indentCommand,
        hotkeys: [
            'ctrl+]',
            'cmd+]'
        ]
    });
    editor.registerCommand('outdent', {
        exec: indentCommand,
        hotkeys: [
            'ctrl+[',
            'cmd+['
        ]
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__.pluginSystem.add('indent', indent);


/***/ }),

/***/ 39188:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fillEmptyParagraph: function() { return /* binding */ fillEmptyParagraph; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/clean-html
 */ 

const TABLE_CONTAINER_TAGS = new Set([
    'table',
    'tbody',
    'thead',
    'tfoot',
    'tr'
]);
/**
 * @private
 */ function fillEmptyParagraph(jodit, nodeElm, hadEffect) {
    if (jodit.o.cleanHTML.fillEmptyParagraph && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isBlock(nodeElm) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isEmpty(nodeElm, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(nodeElm, TABLE_CONTAINER_TAGS)) {
        const br = jodit.createInside.element('br');
        nodeElm.appendChild(br);
        return true;
    }
    return hadEffect;
}


/***/ }),

/***/ 39199:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1664 896q0 156-61 298t-164 245-245 164-298 61q-172 0-327-72.5t-264-204.5q-7-10-6.5-22.5t8.5-20.5l137-138q10-9 25-9 16 2 23 12 73 95 179 147t225 52q104 0 198.5-40.5t163.5-109.5 109.5-163.5 40.5-198.5-40.5-198.5-109.5-163.5-163.5-109.5-198.5-40.5q-98 0-188 35.5t-160 101.5l137 138q31 30 14 69-17 40-59 40h-448q-26 0-45-19t-19-45v-448q0-42 40-59 39-17 69 14l130 129q107-101 244.5-156.5t284.5-55.5q156 0 298 61t245 164 164 245 61 298z\"/> </svg>"

/***/ }),

/***/ 39386:
/***/ (function(module) {

module.exports["default"] = ["Escriba algo...","Acerca de Jodit","Jodit Editor","Guía de usuario Jodit","contiene ayuda detallada para el uso.","Para información sobre la licencia, por favor visite nuestro sitio:","Compre la versión completa","Copyright © XDSoft.net - Chupurnov Valeriy. Todos los derechos reservados.","Anclar","Abrir en nueva pestaña","Abrir editor en pantalla completa","Limpiar formato","Color de relleno o de letra","Rehacer","Deshacer","Negrita","Cursiva","Insertar lista no ordenada","Insertar lista ordenada","Alinear Centrado","Alinear Justificado","Alinear Izquierda","Alinear Derecha","Insertar línea horizontal","Insertar imagen","Insertar archivo","Insertar video de Youtube/vimeo","Insertar vínculo","Tamaño de letra","Familia de letra","Insertar bloque","Normal","Encabezado 1","Encabezado 2","Encabezado 3","Encabezado 4","Cita","Código","Insertar","Insertar tabla","Disminuir sangría","Aumentar sangría","Seleccionar caracter especial","Insertar caracter especial","Copiar formato","Cambiar modo","Márgenes","arriba","derecha","abajo","izquierda","Estilos CSS","Clases CSS","Alinear","Derecha","Centrado","Izquierda","--No Establecido--","Fuente","Título","Texto Alternativo","Vínculo","Abrir vínculo en nueva pestaña","Imagen","Archivo","Avanzado","Propiedades de imagen","Cancelar","Aceptar","Buscar archivo","Error al cargar la lista","Error al cargar las carpetas","¿Está seguro?","Entre nombre de carpeta","Crear carpeta","Entre el nombre","Soltar imagen","Soltar archivo","o click","Texto alternativo","Subir","Buscar","Fondo","Texto","Arriba","Centro","Abajo","Insertar columna antes","Interar columna después","Insertar fila arriba","Insertar fila debajo","Borrar tabla","Borrar fila","Borrar columna","Vaciar celda","Caracteres: %d","Palabras: %d","Tachado","Subrayado","superíndice","subíndice","Cortar selección","Seleccionar todo","Pausa","Buscar","Reemplazar con","Reemplazar","Pegar","Seleccionar contenido para pegar","HTML","negrita","cursiva","Brocha","Vínculo","deshacer","rehacer","Tabla","Imagen","Borrar","Párrafo","Tamaño de letra","Video","Letra","Acerca de","Imprimir","subrayar","tachar","sangría","quitar sangría","Tamaño completo","encoger","línea horizontal","lista sin ordenar","lista ordenada","Cortar","Seleccionar todo","Incluir código","Abrir vínculo","Editar vínculo","No seguir","Desvincular","Actualizar","Para editar","Ver","URL","Editar","Alineación horizontal","Filtrar","Ordenar por fecha modificación","Ordenar por nombre","Ordenar por tamaño","Agregar carpeta","Resetear","Guardar","Guardar como...","Redimensionar","Recortar","Ancho","Alto","Mantener relación de aspecto","Si","No","Quitar","Seleccionar","Seleccionar: %s","Alineación vertical","Dividir","Mezclar","Agregar columna","Agregar fila","Licencia: %s","Borrar","Dividir vertical","Dividir horizontal","Borde","El código es similar a HTML. ¿Mantener como HTML?","Pegar como HTML?","Mantener","Insertar como texto","Insertar solo texto","Solo puedes editar tus propias imágenes. ¿Descargar esta imagen en el servidor?","¡La imagen se ha subido correctamente al servidor!","paleta","No hay archivos en este directorio.","renombrar","Ingresa un nuevo nombre","avance","Descargar","Pegar desde el portapapeles","Su navegador no soporta el acceso directo en el portapapeles.","Selección de copia","copia","Radio frontera","Mostrar todos los","Aplicar","Por favor, rellene este campo","Por favor, introduzca una dirección web","Predeterminado","Círculo","Punto","Cuadro","Encontrar","Buscar Anterior","Buscar Siguiente","El contenido pegado proviene de un documento de Microsoft Word/Excel. ¿Desea mantener el formato o limpiarlo?","Pegado desde Word detectado","Limpiar","Insertar nombre de clase","Presione Alt para cambiar el tamaño personalizado",null,null,null,"Todo"]

/***/ }),

/***/ 39608:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isInsideInvisibleElement: function() { return /* binding */ isInsideInvisibleElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 
/**
 * Check if FONT inside STYLE or SCRIPT element
 * @private
 */ function isInsideInvisibleElement(font, root) {
    return Boolean(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(font, [
        'style',
        'script'
    ], root));
}


/***/ }),

/***/ 39709:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToolbarButton: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.ToolbarButton; },
/* harmony export */   ToolbarContent: function() { return /* reexport safe */ _content__WEBPACK_IMPORTED_MODULE_1__.ToolbarContent; },
/* harmony export */   ToolbarSelect: function() { return /* reexport safe */ _select_select__WEBPACK_IMPORTED_MODULE_2__.ToolbarSelect; }
/* harmony export */ });
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22533);
/* harmony import */ var _content__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5772);
/* harmony import */ var _select_select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61764);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/toolbar/button
 */ 




/***/ }),

/***/ 39858:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M704 1376v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm-544-992h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z\"/> </svg>"

/***/ }),

/***/ 39978:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export imageProcessor */
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(91206);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(51034);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/image-processor/README.md]]
 * @packageDocumentation
 * @module plugins/image-processor
 */ 







const JODIT_IMAGE_PROCESSOR_BINDED = '__jodit_imageprocessor_binded';
const JODIT_IMAGE_BLOB_ID = JODIT_IMAGE_PROCESSOR_BINDED + 'blob-id';
/**
 * Change editor's size after load all images
 */ class imageProcessor extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_6__.Plugin {
    afterInit(jodit) {}
    beforeDestruct(jodit) {
        const buffer = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.cached)(jodit, 'buffer');
        const list = buffer === null || buffer === void 0 ? void 0 : buffer.get(JODIT_IMAGE_BLOB_ID);
        if (buffer && list) {
            const keys = Object.keys(list);
            for (const uri of keys){
                URL.revokeObjectURL(uri);
            }
            buffer.delete(JODIT_IMAGE_BLOB_ID);
        }
    }
    onAfterGetValueFromEditor(data, consumer) {
        if (consumer !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.SOURCE_CONSUMER) {
            return this.onBeforeSetElementValue(data);
        }
    }
    onBeforeSetElementValue(data) {
        const { jodit: editor } = this;
        if (!editor.o.imageProcessor.replaceDataURIToBlobIdInView) {
            return;
        }
        const list = editor.buffer.get(JODIT_IMAGE_BLOB_ID);
        if (list) {
            const keys = Object.keys(list);
            for (const uri of keys){
                while(data.value.includes(uri)){
                    data.value = data.value.replace(uri, list[uri]);
                }
            }
        }
    }
    afterChange(data) {
        return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
            const { jodit: editor } = this;
            if (!editor.editor) {
                return;
            }
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.$$)('img', editor.editor).forEach((elm)=>{
                if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.dataBind)(elm, JODIT_IMAGE_PROCESSOR_BINDED)) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.dataBind)(elm, JODIT_IMAGE_PROCESSOR_BINDED, true);
                    if (!elm.complete) {
                        editor.e.on(elm, 'load', function ElementOnLoad() {
                            var _editor_e;
                            !editor.isInDestruct && ((_editor_e = editor.e) === null || _editor_e === void 0 ? void 0 : _editor_e.fire('resize'));
                            editor.e.off(elm, 'load', ElementOnLoad);
                        });
                    }
                    if (elm.src && /^data:/.test(elm.src)) {
                        replaceDataURIToBlobUUID(editor, elm);
                    }
                    editor.e.on(elm, 'mousedown touchstart', ()=>{
                        editor.s.select(elm);
                    });
                }
            });
        }).call(this);
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)(':afterGetValueFromEditor')
], imageProcessor.prototype, "onAfterGetValueFromEditor", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)(':beforeSetElementValue')
], imageProcessor.prototype, "onBeforeSetElementValue", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)([
        ':change',
        ':afterInit',
        ':changePlace'
    ]),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.debounce)()
], imageProcessor.prototype, "afterChange", null);
function replaceDataURIToBlobUUID(editor, elm) {
    if (!editor.o.imageProcessor.replaceDataURIToBlobIdInView) {
        return;
    }
    if (typeof ArrayBuffer === 'undefined' || typeof URL === 'undefined') {
        return;
    }
    const dataUri = elm.src, blob = dataURItoBlob(dataUri);
    elm.src = URL.createObjectURL(blob);
    editor.e.fire('internalUpdate');
    const { buffer } = editor;
    const list = buffer.get(JODIT_IMAGE_BLOB_ID) || {};
    list[elm.src] = dataUri;
    editor.buffer.set(JODIT_IMAGE_BLOB_ID, list);
}
// https://stackoverflow.com/a/12300351
function dataURItoBlob(dataURI) {
    // convert base64 to raw binary data held in a string
    // doesn't handle URLEncoded DataURIs - see SO answer #6850276 for code that does this
    const byteString = atob(dataURI.split(',')[1]);
    // separate out the mime component
    const mimeString = dataURI.split(',')[0].split(':')[1].split(';')[0];
    // write the bytes of the string to an ArrayBuffer
    const ab = new ArrayBuffer(byteString.length);
    // create a view into the buffer
    const ia = new Uint8Array(ab);
    // set the bytes of the buffer to the correct values
    for(let i = 0; i < byteString.length; i++){
        ia[i] = byteString.charCodeAt(i);
    }
    // write the ArrayBuffer to a blob, and you're done
    return new Blob([
        ab
    ], {
        type: mimeString
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_4__.pluginSystem.add('imageProcessor', imageProcessor);


/***/ }),

/***/ 40013:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17312);
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(24497);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/uploader
 */ 


/**
 * Module for processing download documents and images by Drag and Drop
 * Drag and Drop files
 */ jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.enableDragAndDropFileToEditor = true;
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.uploader = {
    url: '',
    insertImageAsBase64URI: false,
    imagesExtensions: [
        'jpg',
        'png',
        'jpeg',
        'gif'
    ],
    headers: null,
    data: null,
    filesVariableName (i) {
        return `files[${i}]`;
    },
    withCredentials: false,
    pathVariableName: 'path',
    format: 'json',
    method: 'POST',
    prepareData (formData) {
        return formData;
    },
    isSuccess (resp) {
        return resp.success;
    },
    getMessage (resp) {
        return resp.data.messages !== undefined && (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__.isArray)(resp.data.messages) ? resp.data.messages.join(' ') : '';
    },
    /**
	 * @see [[IUploader.processFileName]]
	 */ processFileName (key, file, name) {
        return [
            key,
            file,
            name
        ];
    },
    process (resp) {
        return resp.data;
    },
    error (e) {
        this.j.message.error(e.message, 4000);
    },
    getDisplayName (baseurl, filename) {
        return baseurl + filename;
    },
    defaultHandlerSuccess (resp) {
        const j = this.j || this;
        if (!(0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_1__.isJoditObject)(j)) {
            return;
        }
        if (resp.files && resp.files.length) {
            resp.files.forEach((filename, index)=>{
                const [tagName, attr] = resp.isImages && resp.isImages[index] ? [
                    'img',
                    'src'
                ] : [
                    'a',
                    'href'
                ];
                const elm = j.createInside.element(tagName);
                elm.setAttribute(attr, resp.baseurl + filename);
                if (tagName === 'a') {
                    elm.textContent = j.o.uploader.getDisplayName.call(this, resp.baseurl, filename);
                }
                if (tagName === 'img') {
                    j.s.insertImage(elm, null, j.o.imageDefaultWidth);
                } else {
                    j.s.insertNode(elm);
                }
            });
        }
    },
    defaultHandlerError (e) {
        this.j.message.error(e.message);
    },
    contentType (requestData) {
        return this.ow.FormData !== undefined && typeof requestData !== 'string' ? false : 'application/x-www-form-urlencoded; charset=UTF-8';
    }
};


/***/ }),

/***/ 40037:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path stroke-width=\"0\" d=\"M381 1620q0 80-54.5 126t-135.5 46q-106 0-172-66l57-88q49 45 106 45 29 0 50.5-14.5t21.5-42.5q0-64-105-56l-26-56q8-10 32.5-43.5t42.5-54 37-38.5v-1q-16 0-48.5 1t-48.5 1v53h-106v-152h333v88l-95 115q51 12 81 49t30 88zm2-627v159h-362q-6-36-6-54 0-51 23.5-93t56.5-68 66-47.5 56.5-43.5 23.5-45q0-25-14.5-38.5t-39.5-13.5q-46 0-81 58l-85-59q24-51 71.5-79.5t105.5-28.5q73 0 123 41.5t50 112.5q0 50-34 91.5t-75 64.5-75.5 50.5-35.5 52.5h127v-60h105zm1409 319v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-14 9-23t23-9h1216q13 0 22.5 9.5t9.5 22.5zm-1408-899v99h-335v-99h107q0-41 .5-122t.5-121v-12h-2q-8 17-50 54l-71-76 136-127h106v404h108zm1408 387v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-14 9-23t23-9h1216q13 0 22.5 9.5t9.5 22.5zm0-512v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1216q13 0 22.5 9.5t9.5 22.5z\"/> </svg>"

/***/ }),

/***/ 40253:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStrongControlTypes: function() { return /* binding */ getStrongControlTypes; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17312);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93640);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5266);
/* harmony import */ var _get_control_type__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15982);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui
 */ 



/**
 * @private
 */ function getStrongControlTypes(items, controls) {
    const elements = (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__.isArray)(items) ? items : (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.keys)(items, false).map((key)=>{
        const value = items[key] || {};
        return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.ConfigProto)({
            name: key
        }, value);
    });
    return elements.map((item)=>(0,_get_control_type__WEBPACK_IMPORTED_MODULE_3__.getControlType)(item, controls || jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.defaultOptions.controls));
}


/***/ }),

/***/ 40291:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/bold
 */ 
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.controls.subscript = {
    tags: [
        'sub'
    ],
    tooltip: 'subscript'
};
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.controls.superscript = {
    tags: [
        'sup'
    ],
    tooltip: 'superscript'
};
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.controls.bold = {
    tagRegExp: /^(strong|b)$/i,
    tags: [
        'strong',
        'b'
    ],
    css: {
        'font-weight': [
            'bold',
            '700'
        ]
    },
    tooltip: 'Bold'
};
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.controls.italic = {
    tagRegExp: /^(em|i)$/i,
    tags: [
        'em',
        'i'
    ],
    css: {
        'font-style': 'italic'
    },
    tooltip: 'Italic'
};
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.controls.underline = {
    tagRegExp: /^(u)$/i,
    tags: [
        'u'
    ],
    css: {
        'text-decoration-line': 'underline'
    },
    tooltip: 'Underline'
};
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.controls.strikethrough = {
    tagRegExp: /^(s)$/i,
    tags: [
        's'
    ],
    css: {
        'text-decoration-line': 'line-through'
    },
    tooltip: 'Strike through'
};


/***/ }),

/***/ 41111:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M384 1662l17-85q6-2 81.5-21.5t111.5-37.5q28-35 41-101 1-7 62-289t114-543.5 52-296.5v-25q-24-13-54.5-18.5t-69.5-8-58-5.5l19-103q33 2 120 6.5t149.5 7 120.5 2.5q48 0 98.5-2.5t121-7 98.5-6.5q-5 39-19 89-30 10-101.5 28.5t-108.5 33.5q-8 19-14 42.5t-9 40-7.5 45.5-6.5 42q-27 148-87.5 419.5t-77.5 355.5q-2 9-13 58t-20 90-16 83.5-6 57.5l1 18q17 4 185 31-3 44-16 99-11 0-32.5 1.5t-32.5 1.5q-29 0-87-10t-86-10q-138-2-206-2-51 0-143 9t-121 11z\"/> </svg>"

/***/ }),

/***/ 41324:
/***/ (function(module) {

"use strict";
module.exports = __WEBPACK_EXTERNAL_MODULE__41324__;

/***/ }),

/***/ 41360:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   nonenumerable: function() { return /* binding */ nonenumerable; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/decorators/nonenumerable/README.md]]
 * @packageDocumentation
 * @module decorators/nonenumerable
 */ const nonenumerable = (target, propertyKey)=>{
    const descriptor = Object.getOwnPropertyDescriptor(target, propertyKey) || {};
    if (descriptor.enumerable !== false) {
        Object.defineProperty(target, propertyKey, {
            enumerable: false,
            set (value) {
                Object.defineProperty(this, propertyKey, {
                    enumerable: false,
                    writable: true,
                    value
                });
            }
        });
    }
};


/***/ }),

/***/ 41411:
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ _object_spread; }
/* harmony export */ });
/* harmony import */ var _define_property_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);

function _object_spread(target) {
    for(var i = 1; i < arguments.length; i++){
        var source = arguments[i] != null ? arguments[i] : {};
        var ownKeys = Object.keys(source);
        if (typeof Object.getOwnPropertySymbols === "function") {
            ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym) {
                return Object.getOwnPropertyDescriptor(source, sym).enumerable;
            }));
        }
        ownKeys.forEach(function(key) {
            (0,_define_property_js__WEBPACK_IMPORTED_MODULE_0__._)(target, key, source[key]);
        });
    }
    return target;
}



/***/ }),

/***/ 41599:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    'copy-format': '复制格式'
};


/***/ }),

/***/ 42259:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cursorInTheEdgeOfString: function() { return /* binding */ cursorInTheEdgeOfString; },
/* harmony export */   findCorrectCurrentNode: function() { return /* binding */ findCorrectCurrentNode; },
/* harmony export */   moveNodeInsideStart: function() { return /* reexport safe */ _move_node_inside_start__WEBPACK_IMPORTED_MODULE_2__.moveNodeInsideStart; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var _move_node_inside_start__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(89817);
/* harmony import */ var _move_the_node_along_the_edge_outward__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7470);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module selection
 */ 



/**
 * Check if the cursor is at the edge of the string
 * @private
 */ function cursorInTheEdgeOfString(container, offset, start, end) {
    var _container_nodeValue;
    const text = ((_container_nodeValue = container.nodeValue) === null || _container_nodeValue === void 0 ? void 0 : _container_nodeValue.length) ? container.nodeValue : '';
    if (end && text.replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_END)(), '').length > offset) {
        return true;
    }
    const inv = (0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_START)().exec(text);
    return start && (inv && inv[0].length < offset || !inv && offset > 0);
}
function findCorrectCurrentNode(node, range, rightMode, isCollapsed, checkChild, child) {
    node = range.startContainer.childNodes[range.startOffset];
    if (!node) {
        node = range.startContainer.childNodes[range.startOffset - 1];
        rightMode = true;
    }
    if (node && isCollapsed && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(node)) {
        // test Current method - Cursor in the left of some SPAN
        if (!rightMode && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(node.previousSibling)) {
            node = node.previousSibling;
        } else if (checkChild) {
            let current = child(node);
            while(current){
                if (current && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(current)) {
                    node = current;
                    break;
                }
                current = child(current);
            }
        }
    }
    if (node && !isCollapsed && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(node)) {
        let leftChild = node, rightChild = node;
        do {
            leftChild = leftChild.firstChild;
            rightChild = rightChild.lastChild;
        }while (leftChild && rightChild && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(leftChild))
        if (leftChild === rightChild && leftChild && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(leftChild)) {
            node = leftChild;
        }
    }
    return {
        node,
        rightMode
    };
}


/***/ }),

/***/ 42360:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5266);
/* harmony import */ var _icons_indent_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(67176);
/* harmony import */ var _icons_indent_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_icons_indent_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _icons_outdent_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(14017);
/* harmony import */ var _icons_outdent_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_icons_outdent_svg__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11917);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/indent
 */ 





jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__.Icon.set('indent', (_icons_indent_svg__WEBPACK_IMPORTED_MODULE_3___default())).set('outdent', (_icons_outdent_svg__WEBPACK_IMPORTED_MODULE_4___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.controls.indent = {
    tooltip: 'Increase Indent'
};
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.controls.outdent = {
    isDisabled: (editor)=>{
        const current = editor.s.current();
        if (current) {
            const currentBox = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(current, jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock, editor.editor);
            if (currentBox) {
                const arrow = (0,_helpers__WEBPACK_IMPORTED_MODULE_5__.getKey)(editor.o.direction, currentBox);
                return !currentBox.style[arrow] || parseInt(currentBox.style[arrow], 10) <= 0;
            }
        }
        return true;
    },
    tooltip: 'Decrease Indent'
};
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.indentMargin = 10;


/***/ }),

/***/ 42412:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    symbols: 'Szimbólum'
};


/***/ }),

/***/ 42462:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export color */
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65946);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8071);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/color/README.md]]
 * @packageDocumentation
 * @module plugins/color
 */ 


/**
 * Process commands `background` and `forecolor`
 */ function color(editor) {
    editor.registerButton({
        name: 'brush',
        group: 'color'
    });
    const callback = (command, second, third)=>{
        const colorHEX = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.normalizeColor)(third);
        switch(command){
            case 'background':
                editor.s.commitStyle({
                    attributes: {
                        style: {
                            backgroundColor: !colorHEX ? '' : colorHEX
                        }
                    }
                });
                break;
            case 'forecolor':
                editor.s.commitStyle({
                    attributes: {
                        style: {
                            color: !colorHEX ? '' : colorHEX
                        }
                    }
                });
                break;
        }
        editor.synchronizeValues();
        return false;
    };
    editor.registerCommand('forecolor', callback).registerCommand('background', callback);
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__.pluginSystem.add('color', color);


/***/ }),

/***/ 42573:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToolbarCollection: function() { return /* binding */ ToolbarCollection; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_helpers_utils_error_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38027);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4099);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/toolbar/collection/README.md]]
 * @packageDocumentation
 * @module modules/toolbar/collection
 */ 






class ToolbarCollection extends jodit_core_ui__WEBPACK_IMPORTED_MODULE_4__.UIList {
    /** @override */ className() {
        return 'ToolbarCollection';
    }
    /**
	 * First button in a list
	 */ get firstButton() {
        const [button] = this.buttons;
        return button || null;
    }
    makeButton(control, target = null) {
        return (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_5__.makeButton)(this.j, control, target);
    }
    makeSelect(control, target = null) {
        return (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_5__.makeSelect)(this.j, control, target);
    }
    /**
	 * Button should be active
	 */ shouldBeActive(button) {
        return undefined;
    }
    /**
	 * The Button should be disabled
	 */ shouldBeDisabled(button) {
        return undefined;
    }
    /**
	 * Returns current target for button
	 */ getTarget(button) {
        return button.target || null;
    }
    __immediateUpdate() {
        if (this.isDestructed || this.j.isLocked) {
            return;
        }
        super.update();
        this.j.e.fire('afterUpdateToolbar', this);
    }
    update() {
        this.__immediateUpdate();
    }
    /**
	 * Set direction
	 */ setDirection(direction) {
        this.container.style.direction = direction;
        this.container.setAttribute('dir', direction);
    }
    __initEvents() {
        this.j.e.on(this.__listenEvents, this.update).on('afterSetMode focus', this.__immediateUpdate);
    }
    hide() {
        this.container.remove();
    }
    show() {
        this.appendTo(this.j.toolbarContainer);
    }
    showInline(bound) {
        throw (0,jodit_core_helpers_utils_error_error__WEBPACK_IMPORTED_MODULE_3__.error)('The method is not implemented for this class.');
    }
    /** @override **/ build(items, target = null) {
        const itemsWithGroupps = this.j.e.fire('beforeToolbarBuild', items);
        if (itemsWithGroupps) {
            items = itemsWithGroupps;
        }
        super.build(items, target);
        return this;
    }
    /** @override **/ destruct() {
        if (this.isDestructed) {
            return;
        }
        this.j.e.off(this.__listenEvents, this.update).off('afterSetMode focus', this.__immediateUpdate);
        super.destruct();
    }
    constructor(jodit){
        super(jodit), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__listenEvents", 'updatePlugins updateToolbar changeStack mousedown mouseup keydown change afterInit readonly afterResize ' + 'selectionchange changeSelection focus afterSetMode touchstart focus blur');
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], ToolbarCollection.prototype, "__immediateUpdate", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.debounce)((ctx)=>ctx.j.defaultTimeout, true)
], ToolbarCollection.prototype, "update", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.hook)('ready')
], ToolbarCollection.prototype, "__initEvents", null);
ToolbarCollection = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.component
], ToolbarCollection);


/***/ }),

/***/ 42766:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export addNewLine */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65946);
/* harmony import */ var jodit_modules__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(60936);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10685);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/add-new-line/README.md]]
 * @packageDocumentation
 * @module plugins/add-new-line
 */ 







const ns = 'addnewline';
/**
 * Create helper for adding new paragraph(Jodit.defaultOptions.enter tag) before iframe, table or image
 */ class addNewLine extends jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Plugin {
    __show() {
        if (this.j.o.readonly || this.j.isLocked) {
            return;
        }
        this.j.async.clearTimeout(this.__timeout);
        if (this.__isShown) {
            return;
        }
        this.__isShown = true;
        this.j.container.appendChild(this.__line);
        this.__line.style.width = this.j.container.clientWidth + 'px';
    }
    onLock(isLocked) {
        if (isLocked && this.__isShown) {
            this.__hideForce();
        }
    }
    __hide() {
        if (!this.__isShown || this.__lineInFocus) {
            return;
        }
        this.__timeout = this.j.async.setTimeout(this.__hideForce, {
            timeout: 500,
            label: 'add-new-line-hide'
        });
    }
    afterInit(editor) {
        if (!editor.o.addNewLine) {
            return;
        }
        editor.e.on(this.__line, 'mousemove', (e)=>{
            e.stopPropagation();
        }).on(this.__line, 'mousedown touchstart', this.__onClickLine).on('change', this.__hideForce).on(this.__line, 'mouseenter', ()=>{
            this.j.async.clearTimeout(this.__timeout);
            this.__lineInFocus = true;
        }).on(this.__line, 'mouseleave', ()=>{
            this.__lineInFocus = false;
        }).on('changePlace', this.__addEventListeners.bind(this));
        this.__addEventListeners();
    }
    __addEventListeners() {
        const editor = this.j;
        editor.e.off(editor.editor, '.' + ns).off(editor.container, '.' + ns).off('.' + ns).on([
            editor.ow,
            editor.ew,
            editor.editor
        ], 'scroll' + '.' + ns, this.__hideForce).on('finishedCleanHTMLWorker' + '.' + ns, this.__hideForce).on(editor.editor, 'click' + '.' + ns, this.__hide).on(editor.container, 'mouseleave' + '.' + ns, this.__hide).on(editor.editor, 'mousemove' + '.' + ns, this.__onMouseMove);
    }
    onDblClickEditor(e) {
        const editor = this.j;
        if (!editor.o.readonly && editor.o.addNewLineOnDBLClick && e.target === editor.editor && editor.s.isCollapsed()) {
            const editorBound = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)(editor.editor, editor, editor.ed);
            const top = e.pageY - editor.ew.scrollX;
            const p = editor.createInside.element(editor.o.enter);
            if (Math.abs(top - editorBound.top) < Math.abs(top - (editorBound.height + editorBound.top)) && editor.editor.firstChild) {
                editor.editor.insertBefore(p, editor.editor.firstChild);
            } else {
                editor.editor.appendChild(p);
            }
            editor.s.setCursorIn(p);
            editor.synchronizeValues();
            this.__hideForce();
            e.preventDefault();
        }
    }
    __onMouseMove(e) {
        const editor = this.j;
        let currentElement = editor.ed.elementFromPoint(e.clientX, e.clientY);
        if (!jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.isHTMLElement(currentElement) || !jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.isOrContains(editor.editor, currentElement)) {
            return;
        }
        if (editor.editor !== currentElement && !this.__isMatchedTag(currentElement)) {
            currentElement = jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.closest(currentElement, this.__isMatchedTag, editor.editor);
        }
        if (!currentElement) {
            this.__hide();
            return;
        }
        if (this.__isMatchedTag(currentElement)) {
            const parentBox = jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.up(currentElement, jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.isBlock, editor.editor);
            if (parentBox && parentBox !== editor.editor) {
                currentElement = parentBox;
            }
        }
        const pos = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.position)(currentElement, this.j);
        let top = false;
        let { clientY, clientX } = e;
        if (this.j.iframe) {
            const { top, left } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.position)(this.j.iframe, this.j, true);
            clientY += top;
            clientX += left;
        }
        const delta = this.j.o.addNewLineDeltaShow;
        if (Math.abs(clientY - pos.top) <= delta) {
            top = pos.top;
            this.__isBeforeContent = true;
        } else if (Math.abs(clientY - (pos.top + pos.height)) <= delta) {
            top = pos.top + pos.height;
            this.__isBeforeContent = false;
        }
        const isEditor = editor.editor === currentElement;
        if (top !== false && (isEditor && !this.__isBeforeContent || !isEditor && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.call)(this.__isBeforeContent ? jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.prev : jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.next, currentElement, this.__canGetFocus, editor.editor))) {
            this.__line.style.top = top + 'px';
            this.__current = currentElement;
            this.__show();
            this.__line.style.setProperty('--jd-anl-handle-offset', clientX - pos.left - 10 + 'px');
        } else {
            this.__current = false;
            this.__hide();
        }
    }
    /** @override */ beforeDestruct() {
        this.j.async.clearTimeout(this.__timeout);
        this.j.e.off(this.__line).off('changePlace', this.__addEventListeners);
        jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.safeRemove(this.__line);
        this.j.e.off([
            this.j.ow,
            this.j.ew,
            this.j.editor
        ], '.' + ns).off(this.j.container, '.' + ns).off('.' + ns);
    }
    constructor(...args){
        super(...args), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__line", this.j.c.fromHTML(`<div role="button" tabindex="-1" title="${this.j.i18n('Break')}" class="jodit-add-new-line"><span>${jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Icon.get('enter')}</span></div>`)), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__isMatchedTag", (node)=>Boolean(node && this.j.o.addNewLineTagsTriggers.includes(node.nodeName.toLowerCase()))), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__timeout", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__isBeforeContent", false), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__current", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__lineInFocus", false), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__isShown", false), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__hideForce", ()=>{
            if (!this.__isShown) {
                return;
            }
            this.__isShown = false;
            this.j.async.clearTimeout(this.__timeout);
            this.__lineInFocus = false;
            jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.safeRemove(this.__line);
            this.__line.style.setProperty('--jd-anl-handle-offset', '0');
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__canGetFocus", (elm)=>{
            return elm != null && jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.isBlock(elm) && !/^(img|table|iframe|hr)$/i.test(elm.nodeName);
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__onClickLine", (e)=>{
            const editor = this.j;
            const p = editor.createInside.element(editor.o.enter);
            if (this.__isBeforeContent && this.__current && this.__current.parentNode) {
                if (this.__current === editor.editor) {
                    jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Dom.prepend(editor.editor, p);
                } else {
                    this.__current.parentNode.insertBefore(p, this.__current);
                }
            } else {
                editor.editor.appendChild(p);
            }
            editor.s.setCursorIn(p);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.scrollIntoViewIfNeeded)(p, editor.editor, editor.ed);
            editor.synchronizeValues();
            this.__hideForce();
            e.preventDefault();
        });
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)(':lock')
], addNewLine.prototype, "onLock", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], addNewLine.prototype, "__hide", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.watch)(':dblclick')
], addNewLine.prototype, "onDblClickEditor", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.throttle)((ctx)=>ctx.defaultTimeout)
], addNewLine.prototype, "__onMouseMove", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_3__.pluginSystem.add('addNewLine', addNewLine);


/***/ }),

/***/ 42820:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LimitedStack: function() { return /* binding */ LimitedStack; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 
class LimitedStack {
    push(item) {
        this.stack.push(item);
        if (this.stack.length > this.limit) {
            this.stack.shift();
        }
        return this;
    }
    pop() {
        return this.stack.pop();
    }
    find(clb) {
        return this.stack.find(clb);
    }
    constructor(limit){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "limit", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "stack", void 0);
        this.limit = limit;
        this.stack = [];
    }
}


/***/ }),

/***/ 43218:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M512 1248v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm-640-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm-640-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68z\"/> </svg>"

/***/ }),

/***/ 43271:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ImageEditor: function() { return /* binding */ ImageEditor; },
/* harmony export */   openImageEditor: function() { return /* binding */ openImageEditor; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16964);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(59400);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(5266);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(54500);
/* harmony import */ var _templates_form__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(8908);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/image-editor/README.md]]
 * @packageDocumentation
 * @module modules/image-editor
 */ 










const jie = 'jodit-image-editor';
const TABS = {
    resize: 'resize',
    crop: 'crop'
};
class ImageEditor extends jodit_core_component__WEBPACK_IMPORTED_MODULE_2__.ViewComponent {
    /** @override */ className() {
        return 'ImageEditor';
    }
    get o() {
        return this.options;
    }
    /**
	 * Hide image editor
	 */ hide() {
        this._dialog.close();
    }
    /**
	 * Open image editor
	 * @example
	 * ```javascript
	 * const jodit = Jodit.make('.editor', {
	 *		 imageeditor: {
	 *				 crop: false,
	 *				 closeAfterSave: true,
	 *				 width: 500
	 *		 }
	 * });
	 * jodit.imageeditor.open('https://xdsoft.net/jodit/images/test.png', function (name, data, success, failed) {
	 *		 var img = jodit.node.c('img');
	 *		 img.setAttribute('src', 'https://xdsoft.net/jodit/images/test.png');
	 *		 if (box.action !== 'resize') {
	 *					return failed('Sorry it is work only in resize mode. For croping use FileBrowser');
	 *		 }
	 *		 img.style.width = data.w;
	 *		 img.style.height = data.h;
	 *		 jodit.s.insertNode(img);
	 *		 success();
	 * });
	 * ```
	 */ open(url, save) {
        return this.j.async.promise((resolve)=>{
            const timestamp = new Date().getTime();
            this.image = this.j.c.element('img');
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.$$)('img,.jodit-icon_loader', this.resize_box).forEach(jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.safeRemove);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.$$)('img,.jodit-icon_loader', this.crop_box).forEach(jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.safeRemove);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(this.cropHandler, 'background', 'transparent');
            this.onSave = save;
            this.resize_box.appendChild(this.j.c.element('i', {
                class: 'jodit-icon_loader'
            }));
            this.crop_box.appendChild(this.j.c.element('i', {
                class: 'jodit-icon_loader'
            }));
            if (/\?/.test(url)) {
                url += '&_tst=' + timestamp;
            } else {
                url += '?_tst=' + timestamp;
            }
            this.image.setAttribute('src', url);
            this._dialog.open();
            const { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.refs)(this.editor);
            const onload = ()=>{
                if (this.isDestructed) {
                    return;
                }
                this.image.removeEventListener('load', onload);
                this.naturalWidth = this.image.naturalWidth;
                this.naturalHeight = this.image.naturalHeight;
                widthInput.value = this.naturalWidth.toString();
                heightInput.value = this.naturalHeight.toString();
                this.ratio = this.naturalWidth / this.naturalHeight;
                this.resize_box.appendChild(this.image);
                this.cropImage = this.image.cloneNode(true);
                this.crop_box.appendChild(this.cropImage);
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.safeRemove.apply(null, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.$$)('.jodit-icon_loader', this.editor));
                if (this.activeTab === TABS.crop) {
                    this.showCrop();
                }
                this.j.e.fire(this.resizeHandler, 'updatesize');
                this.j.e.fire(this.cropHandler, 'updatesize');
                this._dialog.setPosition();
                this.j.e.fire('afterImageEditor');
                resolve(this._dialog);
            };
            this.image.addEventListener('load', onload);
            if (this.image.complete) {
                onload();
            }
        });
    }
    onTitleModeClick(e) {
        const self = this, title = e.target;
        const slide = title === null || title === void 0 ? void 0 : title.parentElement;
        if (!slide) {
            return;
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.$$)(`.${jie}__slider,.${jie}__area`, self.editor).forEach((elm)=>elm.classList.remove(`${jie}_active`));
        slide.classList.add(`${jie}_active`);
        this.activeTab = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.attr)(slide, '-area') || TABS.resize;
        const tab = self.editor.querySelector(`.${jie}__area.${jie}__area_` + self.activeTab);
        if (tab) {
            tab.classList.add(`${jie}_active`);
        }
        if (self.activeTab === TABS.crop) {
            self.showCrop();
        }
    }
    onChangeSizeInput(e) {
        const self = this, input = e.target, { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.refs)(this.editor), isWidth = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.attr)(input, 'data-ref') === 'widthInput', x = parseInt(input.value, 10), minX = isWidth ? self.o.min_width : self.o.min_height, minY = !isWidth ? self.o.min_width : self.o.min_height;
        let y;
        if (x > minX) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.image, isWidth ? 'width' : 'height', x);
            if (self.resizeUseRatio) {
                y = isWidth ? Math.round(x / self.ratio) : Math.round(x * self.ratio);
                if (y > minY) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.image, !isWidth ? 'width' : 'height', y);
                    if (isWidth) {
                        heightInput.value = y.toString();
                    } else {
                        widthInput.value = y.toString();
                    }
                }
            }
        }
        this.j.e.fire(self.resizeHandler, 'updatesize');
    }
    onResizeHandleMouseDown(e) {
        const self = this;
        self.target = e.target;
        e.preventDefault();
        e.stopImmediatePropagation();
        self.clicked = true;
        self.start_x = e.clientX;
        self.start_y = e.clientY;
        if (self.activeTab === TABS.crop) {
            self.top_x = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.cropHandler, 'left');
            self.top_y = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.cropHandler, 'top');
            self.width = self.cropHandler.offsetWidth;
            self.height = self.cropHandler.offsetHeight;
        } else {
            self.width = self.image.offsetWidth;
            self.height = self.image.offsetHeight;
        }
        self.j.e.on(this.j.ow, 'mousemove', this.onGlobalMouseMove).one(this.j.ow, 'mouseup', this.onGlobalMouseUp);
    }
    onGlobalMouseUp(e) {
        if (this.clicked) {
            this.clicked = false;
            e.stopImmediatePropagation();
            this.j.e.off(this.j.ow, 'mousemove', this.onGlobalMouseMove);
        }
    }
    onGlobalMouseMove(e) {
        const self = this;
        if (!self.clicked) {
            return;
        }
        const { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.refs)(this.editor);
        self.diff_x = e.clientX - self.start_x;
        self.diff_y = e.clientY - self.start_y;
        if (self.activeTab === TABS.resize && self.resizeUseRatio || self.activeTab === TABS.crop && self.cropUseRatio) {
            if (self.diff_x) {
                self.new_w = self.width + self.diff_x;
                self.new_h = Math.round(self.new_w / self.ratio);
            } else {
                self.new_h = self.height + self.diff_y;
                self.new_w = Math.round(self.new_h * self.ratio);
            }
        } else {
            self.new_w = self.width + self.diff_x;
            self.new_h = self.height + self.diff_y;
        }
        if (self.activeTab === TABS.resize) {
            if (self.new_w > self.o.resizeMinWidth) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.image, 'width', self.new_w + 'px');
                widthInput.value = self.new_w.toString();
            }
            if (self.new_h > self.o.resizeMinHeight) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.image, 'height', self.new_h + 'px');
                heightInput.value = self.new_h.toString();
            }
            this.j.e.fire(self.resizeHandler, 'updatesize');
        } else {
            if (self.target !== self.cropHandler) {
                if (self.top_x + self.new_w > self.cropImage.offsetWidth) {
                    self.new_w = self.cropImage.offsetWidth - self.top_x;
                }
                if (self.top_y + self.new_h > self.cropImage.offsetHeight) {
                    self.new_h = self.cropImage.offsetHeight - self.top_y;
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.cropHandler, {
                    width: self.new_w,
                    height: self.new_h
                });
            } else {
                if (self.top_x + self.diff_x + self.cropHandler.offsetWidth > self.cropImage.offsetWidth) {
                    self.diff_x = self.cropImage.offsetWidth - self.top_x - self.cropHandler.offsetWidth;
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.cropHandler, 'left', self.top_x + self.diff_x);
                if (self.top_y + self.diff_y + self.cropHandler.offsetHeight > self.cropImage.offsetHeight) {
                    self.diff_y = self.cropImage.offsetHeight - self.top_y - self.cropHandler.offsetHeight;
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.cropHandler, 'top', self.top_y + self.diff_y);
            }
            this.j.e.fire(self.cropHandler, 'updatesize');
        }
    }
    /** @override */ destruct() {
        if (this.isDestructed) {
            return;
        }
        if (this._dialog && !this._dialog.isInDestruct) {
            this._dialog.destruct();
        }
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.safeRemove(this.editor);
        if (this.j.e) {
            this.j.e.off(this.j.ow, 'mousemove', this.onGlobalMouseMove).off(this.j.ow, 'mouseup', this.onGlobalMouseUp).off(this.ow, `.${jie}`).off(`.${jie}`);
        }
        super.destruct();
    }
    constructor(editor){
        super(editor), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "options", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "onSave", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "resizeUseRatio", true), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "cropUseRatio", true), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "_dialog", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "image", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "cropImage", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "clicked", false), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "target", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "start_x", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "start_y", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "top_x", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "top_y", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "width", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "height", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "activeTab", TABS.resize), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "naturalWidth", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "naturalHeight", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "ratio", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "new_h", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "new_w", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "diff_x", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "diff_y", 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "buttons", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "editor", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "resize_box", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "crop_box", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "sizes", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "resizeHandler", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "cropHandler", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "cropBox", {
            x: 0,
            y: 0,
            w: 0,
            h: 0
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "resizeBox", {
            w: 0,
            h: 0
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "calcCropBox", ()=>{
            const node = this.crop_box.parentNode, w = node.offsetWidth * 0.8, h = node.offsetHeight * 0.8;
            let wn = w, hn = h;
            const { naturalWidth: nw, naturalHeight: nh } = this;
            if (w > nw && h > nh) {
                wn = nw;
                hn = nh;
            } else if (this.ratio > w / h) {
                wn = w;
                hn = nh * (w / nw);
            } else {
                wn = nw * (h / nh);
                hn = h;
            }
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(this.crop_box, {
                width: wn,
                height: hn
            });
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "showCrop", ()=>{
            if (!this.cropImage) {
                return;
            }
            this.calcCropBox();
            const w = this.cropImage.offsetWidth || this.image.offsetWidth || this.image.naturalWidth;
            this.new_w = ImageEditor.calcValueByPercent(w, this.o.cropDefaultWidth);
            const h = this.cropImage.offsetHeight || this.image.offsetHeight || this.image.naturalHeight;
            if (this.cropUseRatio) {
                this.new_h = this.new_w / this.ratio;
            } else {
                this.new_h = ImageEditor.calcValueByPercent(h, this.o.cropDefaultHeight);
            }
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(this.cropHandler, {
                backgroundImage: 'url(' + (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.attr)(this.cropImage, 'src') + ')',
                width: this.new_w,
                height: this.new_h,
                left: w / 2 - this.new_w / 2,
                top: h / 2 - this.new_h / 2
            });
            this.j.e.fire(this.cropHandler, 'updatesize');
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "updateCropBox", ()=>{
            if (!this.cropImage) {
                return;
            }
            const ratioX = this.cropImage.offsetWidth / this.naturalWidth, ratioY = this.cropImage.offsetHeight / this.naturalHeight;
            this.cropBox.x = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(this.cropHandler, 'left') / ratioX;
            this.cropBox.y = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(this.cropHandler, 'top') / ratioY;
            this.cropBox.w = this.cropHandler.offsetWidth / ratioX;
            this.cropBox.h = this.cropHandler.offsetHeight / ratioY;
            this.sizes.textContent = this.cropBox.w.toFixed(0) + 'x' + this.cropBox.h.toFixed(0);
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "updateResizeBox", ()=>{
            this.resizeBox.w = this.image.offsetWidth || this.naturalWidth;
            this.resizeBox.h = this.image.offsetHeight || this.naturalHeight;
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "setHandlers", ()=>{
            const self = this;
            const { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.refs)(this.editor);
            self.j.e.on([
                self.editor.querySelector('.jodit_bottomright'),
                self.cropHandler
            ], `mousedown.${jie}`, this.onResizeHandleMouseDown).on(this.j.ow, `resize.${jie}`, ()=>{
                this.j.e.fire(self.resizeHandler, 'updatesize');
                self.showCrop();
                this.j.e.fire(self.cropHandler, 'updatesize');
            });
            self.j.e.on((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.toArray)(this.editor.querySelectorAll(`.${jie}__slider-title`)), 'click', this.onTitleModeClick).on([
                widthInput,
                heightInput
            ], 'input', this.onChangeSizeInput);
            const { keepAspectRatioResize, keepAspectRatioCrop } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.refs)(this.editor);
            if (keepAspectRatioResize) {
                keepAspectRatioResize.addEventListener('change', ()=>{
                    this.resizeUseRatio = keepAspectRatioResize.checked;
                });
            }
            if (keepAspectRatioCrop) {
                keepAspectRatioCrop.addEventListener('change', ()=>{
                    this.cropUseRatio = keepAspectRatioCrop.checked;
                });
            }
            self.j.e.on(self.resizeHandler, 'updatesize', ()=>{
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.resizeHandler, {
                    top: 0,
                    left: 0,
                    width: self.image.offsetWidth || self.naturalWidth,
                    height: self.image.offsetHeight || self.naturalHeight
                });
                this.updateResizeBox();
            }).on(self.cropHandler, 'updatesize', ()=>{
                if (!self.cropImage) {
                    return;
                }
                let new_x = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.cropHandler, 'left'), new_y = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.cropHandler, 'top'), new_width = self.cropHandler.offsetWidth, new_height = self.cropHandler.offsetHeight;
                if (new_x < 0) {
                    new_x = 0;
                }
                if (new_y < 0) {
                    new_y = 0;
                }
                if (new_x + new_width > self.cropImage.offsetWidth) {
                    new_width = self.cropImage.offsetWidth - new_x;
                    if (self.cropUseRatio) {
                        new_height = new_width / self.ratio;
                    }
                }
                if (new_y + new_height > self.cropImage.offsetHeight) {
                    new_height = self.cropImage.offsetHeight - new_y;
                    if (self.cropUseRatio) {
                        new_width = new_height * self.ratio;
                    }
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.cropHandler, {
                    width: new_width,
                    height: new_height,
                    left: new_x,
                    top: new_y,
                    backgroundPosition: -new_x - 1 + 'px ' + (-new_y - 1) + 'px',
                    backgroundSize: self.cropImage.offsetWidth + 'px ' + self.cropImage.offsetHeight + 'px'
                });
                self.updateCropBox();
            });
            Object.values(self.buttons).forEach((button)=>{
                button.onAction(()=>{
                    const data = {
                        action: self.activeTab,
                        box: self.activeTab === TABS.resize ? self.resizeBox : self.cropBox
                    };
                    switch(button){
                        case self.buttons.saveas:
                            self.j.prompt('Enter new name', 'Save in new file', (name)=>{
                                if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.trim)(name)) {
                                    self.j.alert('The name should not be empty');
                                    return false;
                                }
                                self.onSave(name, data, self.hide, (e)=>{
                                    self.j.alert(e.message);
                                });
                            });
                            break;
                        case self.buttons.save:
                            self.onSave(undefined, data, self.hide, (e)=>{
                                self.j.alert(e.message);
                            });
                            break;
                        case self.buttons.reset:
                            if (self.activeTab === TABS.resize) {
                                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.css)(self.image, {
                                    width: null,
                                    height: null
                                });
                                widthInput.value = self.naturalWidth.toString();
                                heightInput.value = self.naturalHeight.toString();
                                self.j.e.fire(self.resizeHandler, 'updatesize');
                            } else {
                                self.showCrop();
                            }
                            break;
                    }
                });
            });
        });
        this.options = editor && editor.o && editor.o.imageeditor ? editor.o.imageeditor : jodit_config__WEBPACK_IMPORTED_MODULE_7__.Config.defaultOptions.imageeditor;
        const o = this.options;
        this.resizeUseRatio = o.resizeUseRatio;
        this.cropUseRatio = o.cropUseRatio;
        this.buttons = {
            reset: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_6__.Button)(this.j, 'update', 'Reset'),
            save: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_6__.Button)(this.j, 'save', 'Save'),
            saveas: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_6__.Button)(this.j, 'save', 'Save as ...')
        };
        this.activeTab = o.resize ? TABS.resize : TABS.crop;
        this.editor = (0,_templates_form__WEBPACK_IMPORTED_MODULE_9__.form)(this.j, this.options);
        const { resizeBox, cropBox } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.refs)(this.editor);
        this.resize_box = resizeBox;
        this.crop_box = cropBox;
        this.sizes = this.editor.querySelector(`.${jie}__area.${jie}__area_crop .jodit-image-editor__sizes`);
        this.resizeHandler = this.editor.querySelector(`.${jie}__resizer`);
        this.cropHandler = this.editor.querySelector(`.${jie}__croper`);
        this._dialog = this.j.dlg({
            buttons: [
                'fullsize',
                'dialog.close'
            ]
        });
        this._dialog.setContent(this.editor);
        this._dialog.setSize(this.o.width, this.o.height);
        this._dialog.setHeader([
            this.buttons.reset,
            this.buttons.save,
            this.buttons.saveas
        ]);
        this.setHandlers();
    }
}
(0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(ImageEditor, "calcValueByPercent", (value, percent)=>{
    const percentStr = percent.toString();
    const valueNbr = parseFloat(value.toString());
    let match;
    match = /^[-+]?[0-9]+(px)?$/.exec(percentStr);
    if (match) {
        return parseInt(percentStr, 10);
    }
    match = /^([-+]?[0-9.]+)%$/.exec(percentStr);
    if (match) {
        return Math.round(valueNbr * (parseFloat(match[1]) / 100));
    }
    return valueNbr || 0;
});
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], ImageEditor.prototype, "hide", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], ImageEditor.prototype, "open", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], ImageEditor.prototype, "onTitleModeClick", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.debounce)(),
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], ImageEditor.prototype, "onChangeSizeInput", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], ImageEditor.prototype, "onResizeHandleMouseDown", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.autobind
], ImageEditor.prototype, "onGlobalMouseUp", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.throttle)(10)
], ImageEditor.prototype, "onGlobalMouseMove", null);
ImageEditor = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.component
], ImageEditor);
/**
 * Open Image Editor
 */ function openImageEditor(href, name, path, source, onSuccess, onFailed) {
    return this.getInstance('ImageEditor', this.o).open(href, (newname, box, success, failed)=>(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.call)(box.action === 'resize' ? this.dataProvider.resize : this.dataProvider.crop, path, source, name, newname, box.box).then((ok)=>{
            if (ok) {
                success();
                if (onSuccess) {
                    onSuccess();
                }
            }
        }).catch((error)=>{
            failed(error);
            if (onFailed) {
                onFailed(error);
            }
        }));
}


/***/ }),

/***/ 43379:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   reset: function() { return /* binding */ reset; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91565);
/* harmony import */ var _get__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(89308);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 


const map = {};
/**
 * Reset Vanilla JS native function
 * @example
 * ```js
 * reset('Array.from')(Set([1,2,3])) // [1, 2, 3]
 * ```
 * You must use the function derived from the method immediately as its iframe is being removed
 */ function reset(key) {
    if (!(key in map)) {
        const iframe = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('iframe');
        try {
            iframe.src = 'about:blank';
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.body.appendChild(iframe);
            if (!iframe.contentWindow) {
                return null;
            }
            const func = (0,_get__WEBPACK_IMPORTED_MODULE_2__.get)(key, iframe.contentWindow), bind = (0,_get__WEBPACK_IMPORTED_MODULE_2__.get)(key.split('.').slice(0, -1).join('.'), iframe.contentWindow);
            if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__.isFunction)(func)) {
                map[key] = func.bind(bind);
            }
        } catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                throw e;
            }
        } finally{
            var _iframe_parentNode;
            (_iframe_parentNode = iframe.parentNode) === null || _iframe_parentNode === void 0 ? void 0 : _iframe_parentNode.removeChild(iframe);
        }
    }
    var _map_key;
    return (_map_key = map[key]) !== null && _map_key !== void 0 ? _map_key : null;
}


/***/ }),

/***/ 44636:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"><path d=\"M491 1536l91-91-235-235-91 91v107h128v128h107zm523-928q0-22-22-22-10 0-17 7l-542 542q-7 7-7 17 0 22 22 22 10 0 17-7l542-542q7-7 7-17zm-54-192l416 416-832 832h-416v-416zm683 96q0 53-37 90l-166 166-416-416 166-165q36-38 90-38 53 0 91 38l235 234q37 39 37 91z\"/></svg>"

/***/ }),

/***/ 44906:
/***/ (function(module) {

module.exports["default"] = ["輸入一些內容","關於Jodit","Jodit Editor","開發者指南","使用幫助","相關授權條款資訊，請造訪我們的網站：","購買完整版本","Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.","錨點","在新分頁開啟","全螢幕編輯","清除樣式","顏色","取消復原","復原","粗體","斜體","項目符號清單","編號清單","置中","文字對齊","靠左","靠右","分割線","圖片","檔案","插入 youtube/vimeo 影片","插入連結","文字大小","字型","格式化區塊","內文","標題1","標題2","標題3","標題4","引文","程式碼","插入","表格","減少縮排","增加縮排","選擇特殊符號","特殊符號","格式複製","檢視原始碼","邊距","上","右","下","左","樣式","Classes","對齊方式","靠右","置中","靠左","無","Src","Title","替代","Link","在新分頁開啟連結","圖片","檔案","進階","圖片屬性","取消","確定","檔案瀏覽","清單載入錯誤","資料夾載入錯誤","您確定嗎？","輸入路徑","創建路徑","type name","拖曳圖片至此","拖曳檔案至此","或點擊","替代文字","上傳","瀏覽","背景色","文字","頂部","中間","底部","插入左方欄","插入右方欄","插入上方列","插入下方列","刪除表格","刪除整列","刪除整欄","清除內容","字元數: %d","單字數: %d","刪除線","底線","上標","下標","剪下","全選","斷行","尋找","取代為","取代","貼上","選擇內容並貼上","原始碼","粗體","斜體","顏色","連結","復原","取消復原","表格","圖片","橡皮擦","段落","文字大小","影片","字型","關於","列印","底線","刪除線","增加縮排","減少縮排","全螢幕","縮減","分隔線","項目符號清單","編號清單","剪下","全選","嵌入程式碼","打開連結","編輯連結","No follow","取消連結","更新","鉛筆","查看","URL","編輯","水平對齊","篩選","修改時間排序","名稱排序","大小排序","新增資料夾","重設","儲存","另存為...","調整大小","裁切","寬","高","維持長寬比","是","否","移除","選擇","選擇: %s","垂直對齊","分割","合併","新增欄","新增列","許可證: %s","刪除","垂直分割","水平分割","邊框","您的程式碼與 HTML 類似，是否貼上 HTML 格式？","貼上 HTML","保留原始格式","以純文字貼上","僅貼上內文","您只能編輯您自己的圖片。是否下載此圖片?","圖片上傳成功","調色盤","沒有檔案","重新命名","輸入新名稱","預覽","下載","從剪貼簿貼上","瀏覽器無法存取剪貼簿。","複製已選取項目","複製","邊框圓角","顯示全部","應用","請輸入此欄位","請輸入網址","預設","圓圈","點","方形","尋找","尋找上一個","尋找下一個","正在貼上 Word/Excel 文件的內容，是否保留原始格式？","貼上 Word 格式","清除格式","插入 class 名稱","按住 Alt 以調整自訂大小",null,null,null,"全部"]

/***/ }),

/***/ 44998:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isLicense: function() { return /* binding */ isLicense; }
/* harmony export */ });
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85932);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ 
const isLicense = (license)=>(0,_is_string__WEBPACK_IMPORTED_MODULE_0__.isString)(license) && license.length === 23 && /^[a-z0-9]{5}-[a-z0-9]{5}-[a-z0-9]{5}-[a-z0-9]{5}$/i.test(license);


/***/ }),

/***/ 45062:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1025 1369v167h-248l-159-252-24-42q-8-9-11-21h-3l-9 21q-10 20-25 44l-155 250h-258v-167h128l197-291-185-272h-137v-168h276l139 228q2 4 23 42 8 9 11 21h3q3-9 11-21l25-42 140-228h257v168h-125l-184 267 204 296h109zm639 217v206h-514l-4-27q-3-45-3-46 0-64 26-117t65-86.5 84-65 84-54.5 65-54 26-64q0-38-29.5-62.5t-70.5-24.5q-51 0-97 39-14 11-36 38l-105-92q26-37 63-66 80-65 188-65 110 0 178 59.5t68 158.5q0 66-34.5 118.5t-84 86-99.5 62.5-87 63-41 73h232v-80h126z\"/> </svg>"

/***/ }),

/***/ 45219:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   visitNodeWalker: function() { return /* binding */ visitNodeWalker; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var _filters__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91560);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/clean-html
 */ 

const keys = Object.keys(_filters__WEBPACK_IMPORTED_MODULE_1__);
/**
 * @private
 */ function visitNodeWalker(jodit, nodeElm, allowTags, denyTags, currentSelectionNode) {
    let hadEffect = false;
    const dcf = jodit.o.cleanHTML.disableCleanFilter;
    for (const key of keys){
        if (dcf && dcf.has(key)) {
            continue;
        }
        const filter = _filters__WEBPACK_IMPORTED_MODULE_1__[key];
        const tmp = hadEffect;
        hadEffect = filter(jodit, nodeElm, hadEffect, allowTags, denyTags, currentSelectionNode);
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && !tmp && hadEffect) {
            console.warn(`CleanHTML: Effect "${key}"`);
        }
        if (!nodeElm.isConnected) {
            return true;
        }
    }
    return hadEffect;
}


/***/ }),

/***/ 45244:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1639 1056q0 5-1 7-64 268-268 434.5t-478 166.5q-146 0-282.5-55t-243.5-157l-129 129q-19 19-45 19t-45-19-19-45v-448q0-26 19-45t45-19h448q26 0 45 19t19 45-19 45l-137 137q71 66 161 102t187 36q134 0 250-65t186-179q11-17 53-117 8-23 30-23h192q13 0 22.5 9.5t9.5 22.5zm25-800v448q0 26-19 45t-45 19h-448q-26 0-45-19t-19-45 19-45l138-138q-148-137-349-137-134 0-250 65t-186 179q-11 17-53 117-8 23-30 23h-199q-13 0-22.5-9.5t-9.5-22.5v-7q65-268 270-434.5t480-166.5q146 0 284 55.5t245 156.5l130-129q19-19 45-19t45 19 19 45z\"/> </svg>"

/***/ }),

/***/ 45512:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 10 10\"> <path d=\"M.941 4.523a.75.75 0 1 1 1.06-1.06l3.006 3.005 3.005-3.005a.75.75 0 1 1 1.06 1.06l-3.549 3.55a.75.75 0 0 1-1.168-.136L.941 4.523z\"/> </svg>"

/***/ }),

/***/ 45664:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   asArray: function() { return /* reexport safe */ _as_array__WEBPACK_IMPORTED_MODULE_0__.asArray; },
/* harmony export */   splitArray: function() { return /* reexport safe */ _split_array__WEBPACK_IMPORTED_MODULE_1__.splitArray; },
/* harmony export */   toArray: function() { return /* reexport safe */ _to_array__WEBPACK_IMPORTED_MODULE_2__.toArray; }
/* harmony export */ });
/* harmony import */ var _as_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(78982);
/* harmony import */ var _split_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32328);
/* harmony import */ var _to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88475);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/array
 */ 




/***/ }),

/***/ 45674:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M896 1152q0-36-20-69-1-1-15.5-22.5t-25.5-38-25-44-21-50.5q-4-16-21-16t-21 16q-7 23-21 50.5t-25 44-25.5 38-15.5 22.5q-20 33-20 69 0 53 37.5 90.5t90.5 37.5 90.5-37.5 37.5-90.5zm512-128q0 212-150 362t-362 150-362-150-150-362q0-145 81-275 6-9 62.5-90.5t101-151 99.5-178 83-201.5q9-30 34-47t51-17 51.5 17 33.5 47q28 93 83 201.5t99.5 178 101 151 62.5 90.5q81 127 81 275z\"/> </svg>"

/***/ }),

/***/ 45778:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formTemplate: function() { return /* binding */ formTemplate; }
/* harmony export */ });
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59400);
/* harmony import */ var jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5658);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/link
 */ 

const formTemplate = (editor)=>{
    const { openInNewTabCheckbox, noFollowCheckbox, modeClassName, selectSizeClassName, selectMultipleClassName, selectOptionsClassName } = editor.o.link;
    return new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UIForm(editor, [
        new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UIBlock(editor, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UIInput(editor, {
                name: 'url',
                type: 'text',
                ref: 'url_input',
                label: 'URL',
                placeholder: 'http://',
                required: true
            })
        ]),
        new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UIBlock(editor, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UIInput(editor, {
                name: 'content',
                ref: 'content_input',
                label: 'Text'
            })
        ], {
            ref: 'content_input_box'
        }),
        modeClassName ? new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UIBlock(editor, [
            (()=>{
                if (modeClassName === 'input') {
                    return new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UIInput(editor, {
                        name: 'className',
                        ref: 'className_input',
                        label: 'Class name'
                    });
                }
                if (modeClassName === 'select') {
                    return new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UISelect(editor, {
                        name: 'className',
                        ref: 'className_select',
                        label: 'Class name',
                        size: selectSizeClassName,
                        multiple: selectMultipleClassName,
                        options: selectOptionsClassName
                    });
                }
                return null;
            })()
        ]) : null,
        openInNewTabCheckbox ? new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UICheckbox(editor, {
            name: 'target',
            ref: 'target_checkbox',
            label: 'Open in new tab'
        }) : null,
        noFollowCheckbox ? new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UICheckbox(editor, {
            name: 'nofollow',
            ref: 'nofollow_checkbox',
            label: 'No follow'
        }) : null,
        new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__.UIBlock(editor, [
            new jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_0__.UIButton(editor, {
                name: 'unlink',
                variant: 'default',
                text: 'Unlink'
            }),
            new jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_0__.UIButton(editor, {
                name: 'insert',
                type: 'submit',
                variant: 'primary',
                text: 'Insert'
            })
        ], {
            align: 'full'
        })
    ]);
};


/***/ }),

/***/ 45844:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextAreaEditor: function() { return /* binding */ TextAreaEditor; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80991);
/* harmony import */ var jodit_plugins_source_editor_sourceEditor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(94193);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/source
 */ 



class TextAreaEditor extends jodit_plugins_source_editor_sourceEditor__WEBPACK_IMPORTED_MODULE_3__.SourceEditor {
    init(editor) {
        this.instance = editor.c.element('textarea', {
            class: 'jodit-source__mirror',
            dir: editor.o.direction === 'rtl' ? 'rtl' : undefined
        });
        this.container.appendChild(this.instance);
        editor.e.on(this.instance, 'mousedown keydown touchstart input', editor.async.debounce(this.toWYSIWYG, editor.defaultTimeout)).on('setMinHeight.source', (minHeightD)=>{
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__.css)(this.instance, 'minHeight', minHeightD);
        }).on(this.instance, 'change keydown mousedown touchstart input', this.autosize).on('afterSetMode.source', this.autosize).on(this.instance, 'mousedown focus', (e)=>{
            editor.e.fire(e.type, e);
        });
        this.autosize();
        this.onReady();
    }
    destruct() {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(this.instance);
    }
    getValue() {
        return this.instance.value;
    }
    setValue(raw) {
        this.instance.value = raw;
    }
    insertRaw(raw) {
        const value = this.getValue();
        if (this.getSelectionStart() >= 0) {
            const startPos = this.getSelectionStart(), endPos = this.getSelectionEnd();
            this.setValue(value.substring(0, startPos) + raw + value.substring(endPos, value.length));
        } else {
            this.setValue(value + raw);
        }
    }
    getSelectionStart() {
        return this.instance.selectionStart;
    }
    getSelectionEnd() {
        return this.instance.selectionEnd;
    }
    setSelectionRange(start, end = start) {
        this.instance.setSelectionRange(start, end);
    }
    get isFocused() {
        return this.instance === this.j.od.activeElement;
    }
    focus() {
        this.instance.focus();
    }
    blur() {
        this.instance.blur();
    }
    setPlaceHolder(title) {
        this.instance.setAttribute('placeholder', title);
    }
    setReadOnly(isReadOnly) {
        if (isReadOnly) {
            this.instance.setAttribute('readonly', 'true');
        } else {
            this.instance.removeAttribute('readonly');
        }
    }
    selectAll() {
        this.instance.select();
    }
    replaceUndoManager() {
        const { history } = this.jodit;
        this.j.e.on(this.instance, 'keydown', (e)=>{
            if ((e.ctrlKey || e.metaKey) && e.key === 'z') {
                if (e.shiftKey) {
                    history.redo();
                } else {
                    history.undo();
                }
                this.setSelectionRange(this.getValue().length);
                return false;
            }
        });
    }
    constructor(...args){
        super(...args), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "autosize", this.j.async.debounce(()=>{
            this.instance.style.height = 'auto';
            this.instance.style.height = this.instance.scrollHeight + 'px';
        }, this.j.defaultTimeout));
    }
}


/***/ }),

/***/ 46248:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isHTML: function() { return /* binding */ isHTML; }
/* harmony export */ });
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85932);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ 
/**
 * Check if a string is html or not
 */ const isHTML = (str)=>(0,_is_string__WEBPACK_IMPORTED_MODULE_0__.isString)(str) && /<([A-Za-z][A-Za-z0-9]*)\b[^>]*>(.*?)<\/\1>/m.test(str.replace(/[\r\n]/g, ''));


/***/ }),

/***/ 46303:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   splitFragment: function() { return /* binding */ splitFragment; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60898);
/* harmony import */ var _insert_paragraph__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65710);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/enter
 */ 


/**
 * Splits a block element into two parts
 * and adds a new default block in the middle/start/end
 * @private
 */ function splitFragment(fake, jodit, block) {
    const sel = jodit.s, { enter } = jodit.o;
    const defaultTag = enter.toLowerCase();
    const isLi = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isLeaf(block);
    const canSplit = block.tagName.toLowerCase() === defaultTag || isLi;
    const cursorOnTheRight = sel.cursorOnTheRight(block, fake);
    const cursorOnTheLeft = sel.cursorOnTheLeft(block, fake);
    if (!canSplit && (cursorOnTheRight || cursorOnTheLeft)) {
        if (cursorOnTheRight) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(block, fake);
        } else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.before(block, fake);
        }
        (0,_insert_paragraph__WEBPACK_IMPORTED_MODULE_2__.insertParagraph)(fake, jodit, defaultTag);
        if (cursorOnTheLeft && !cursorOnTheRight) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.prepend(block, fake);
        }
        return;
    }
    const newP = sel.splitSelection(block, fake);
    (0,jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_1__.scrollIntoViewIfNeeded)(newP, jodit.editor, jodit.ed);
}


/***/ }),

/***/ 46363:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Snapshot: function() { return /* binding */ Snapshot; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16964);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/history
 */ 



/**
 * Module for creating snapshot of editor which includes html content and the current selection
 */ class Snapshot extends jodit_core_component__WEBPACK_IMPORTED_MODULE_1__.ViewComponent {
    /** @override */ className() {
        return 'Snapshot';
    }
    /**
	 * Compare two snapshotes, if and htmls and selections match, then return true
	 *
	 * @param first - the first snapshote
	 * @param second - second shot
	 */ static equal(first, second) {
        return first.html === second.html && JSON.stringify(first.range) === JSON.stringify(second.range);
    }
    /**
	 * Calc count element before some node in parentNode. All text nodes are joined
	 */ static countNodesBeforeInParent(elm) {
        if (!elm.parentNode) {
            return 0;
        }
        const elms = elm.parentNode.childNodes;
        let count = 0, previous = null;
        for(let j = 0; j < elms.length; j += 1){
            if (previous && !this.isIgnoredNode(elms[j]) && !(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.isText(previous) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.isText(elms[j]))) {
                count += 1;
            }
            if (elms[j] === elm) {
                return count;
            }
            previous = elms[j];
        }
        return 0;
    }
    /**
	 * Calc normal offset in joined text nodes
	 */ static strokeOffset(elm, offset) {
        while(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.isText(elm)){
            elm = elm.previousSibling;
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.isText(elm) && elm.nodeValue) {
                offset += elm.nodeValue.length;
            }
        }
        return offset;
    }
    /**
	 * Calc whole hierarchy path before some element in editor's tree
	 */ calcHierarchyLadder(elm) {
        const counts = [];
        if (!elm || !elm.parentNode || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.isOrContains(this.j.editor, elm)) {
            return [];
        }
        while(elm && elm !== this.j.editor){
            if (elm && !Snapshot.isIgnoredNode(elm)) {
                counts.push(Snapshot.countNodesBeforeInParent(elm));
            }
            elm = elm.parentNode;
        }
        return counts.reverse();
    }
    getElementByLadder(ladder) {
        let n = this.j.editor, i;
        for(i = 0; n && i < ladder.length; i += 1){
            n = n.childNodes[ladder[i]];
        }
        return n;
    }
    get isBlocked() {
        return this.__isBlocked;
    }
    __block(enable) {
        this.__isBlocked = enable;
    }
    transaction(changes) {
        this.__block(true);
        this.__levelOfTransaction += 1;
        try {
            changes();
        } catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.IS_PROD) {
                throw e;
            }
        } finally{
            this.__levelOfTransaction -= 1;
            if (this.__levelOfTransaction === 0) {
                this.__block(false);
            }
        }
    }
    /**
	 * Creates object a snapshot of editor: html and the current selection. Current selection calculate by
	 * offset by start document
	 * \{html: string, range: \{startContainer: int, startOffset: int, endContainer: int, endOffset: int\}\} or
	 * \{html: string\} without selection
	 */ make() {
        const snapshot = {
            html: '',
            range: {
                startContainer: [],
                startOffset: 0,
                endContainer: [],
                endOffset: 0
            }
        };
        snapshot.html = this.__getCleanedEditorValue(this.j.editor);
        const sel = this.j.s.sel;
        if (sel && sel.rangeCount) {
            const range = sel.getRangeAt(0);
            const startContainer = this.calcHierarchyLadder(range.startContainer);
            const endContainer = this.calcHierarchyLadder(range.endContainer);
            let startOffset = Snapshot.strokeOffset(range.startContainer, range.startOffset), endOffset = Snapshot.strokeOffset(range.endContainer, range.endOffset);
            if (!startContainer.length && range.startContainer !== this.j.editor) {
                startOffset = 0;
            }
            if (!endContainer.length && range.endContainer !== this.j.editor) {
                endOffset = 0;
            }
            snapshot.range = {
                startContainer,
                startOffset,
                endContainer,
                endOffset
            };
        }
        return snapshot;
    }
    /**
	 * Restores the state of the editor of the snapshot. Rebounding is not only html but selected text
	 *
	 * @param snapshot - snapshot of editor resulting from the `[[Snapshot.make]]` method
	 * @see make
	 */ restore(snapshot) {
        this.transaction(()=>{
            const scroll = this.storeScrollState();
            const html = this.__getCleanedEditorValue(this.j.editor);
            if (html !== snapshot.html) {
                this.j.value = snapshot.html;
            }
            this.restoreOnlySelection(snapshot);
            this.restoreScrollState(scroll);
        });
    }
    storeScrollState() {
        return [
            this.j.ow.scrollY,
            this.j.editor.scrollTop
        ];
    }
    restoreScrollState(scrolls) {
        const { j } = this, { ow } = j;
        ow.scrollTo(ow.scrollX, scrolls[0]);
        j.editor.scrollTop = scrolls[1];
    }
    /**
	 * Restore selection from snapshot
	 *
	 * @param snapshot - snapshot of editor resulting from the [[Snapshot.make]] method
	 * @see make
	 */ restoreOnlySelection(snapshot) {
        try {
            if (snapshot.range) {
                const range = this.j.ed.createRange();
                range.setStart(this.getElementByLadder(snapshot.range.startContainer), snapshot.range.startOffset);
                range.setEnd(this.getElementByLadder(snapshot.range.endContainer), snapshot.range.endOffset);
                this.j.s.selectRange(range);
            }
        } catch (__ignore) {
            this.j.editor.lastChild && this.j.s.setCursorAfter(this.j.editor.lastChild);
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_2__.IS_PROD) {
                // tslint:disable-next-line:no-console
                console.warn('Broken snapshot', __ignore);
            }
        }
    }
    destruct() {
        this.__block(false);
        super.destruct();
    }
    static isIgnoredNode(node) {
        return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.isText(node) && !node.nodeValue || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.isTemporary(node);
    }
    __getCleanedEditorValue(node) {
        const clone = node.cloneNode(true);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.temporaryList(clone).forEach(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__.Dom.unwrap);
        return clone.innerHTML;
    }
    constructor(...args){
        super(...args), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__isBlocked", false), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__levelOfTransaction", 0);
    }
}


/***/ }),

/***/ 46533:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sendFiles: function() { return /* binding */ sendFiles; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65946);
/* harmony import */ var jodit_modules_uploader_helpers_send__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(77911);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/uploader
 */ 

/**
 * Send files to server
 */ function sendFiles(uploader, files, handlerSuccess, handlerError, process) {
    if (!files) {
        return Promise.reject((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.error)('Need files'));
    }
    const { o } = uploader;
    let fileList = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.toArray)(files);
    if (!fileList.length) {
        return Promise.reject((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.error)('Need files'));
    }
    const promises = [];
    if (o.insertImageAsBase64URI) {
        readImagesWithReader(fileList, o.imagesExtensions, promises, uploader, handlerSuccess, o.defaultHandlerSuccess);
    }
    fileList = fileList.filter((a)=>a);
    if (fileList.length) {
        const form = new FormData();
        form.append(o.pathVariableName, uploader.path);
        form.append('source', uploader.source);
        let file;
        for(let i = 0; i < fileList.length; i += 1){
            file = fileList[i];
            if (file) {
                const hasRealExtension = /\.\w+$/.test(file.name);
                const mime = file.type.match(/\/([a-z0-9]+)/i);
                const extension = mime && mime[1] ? mime[1].toLowerCase() : '';
                let newName = fileList[i].name || Math.random().toString().replace('.', '');
                if (!hasRealExtension && extension) {
                    let extForReg = extension;
                    if ([
                        'jpeg',
                        'jpg'
                    ].includes(extForReg)) {
                        extForReg = 'jpeg|jpg';
                    }
                    const reEnd = new RegExp('.(' + extForReg + ')$', 'i');
                    if (!reEnd.test(newName)) {
                        newName += '.' + extension;
                    }
                }
                const [key, iFile, name] = o.processFileName.call(uploader, o.filesVariableName(i), fileList[i], newName);
                form.append(key, iFile, name);
            }
        }
        if (process) {
            process(form);
        }
        if (o.data && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(o.data)) {
            Object.keys(o.data).forEach((key)=>{
                form.append(key, o.data[key]);
            });
        }
        o.prepareData.call(uploader, form);
        promises.push((0,jodit_modules_uploader_helpers_send__WEBPACK_IMPORTED_MODULE_1__.send)(uploader, form).then((resp)=>{
            if (o.isSuccess.call(uploader, resp)) {
                const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(handlerSuccess) ? handlerSuccess : o.defaultHandlerSuccess;
                handler.call(uploader, o.process.call(uploader, resp));
                return resp;
            }
            const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(handlerError) ? handlerError : o.defaultHandlerError;
            handler.call(uploader, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.error)(o.getMessage.call(uploader, resp)));
            return resp;
        }).then(()=>{
            uploader.j.events && uploader.j.e.fire('filesWereUploaded');
        }));
    }
    return Promise.all(promises);
}
function readImagesWithReader(fileList, imagesExtensions, promises, uploader, handlerSuccess, defaultHandlerSuccess) {
    let file, i;
    for(i = 0; i < fileList.length; i += 1){
        file = fileList[i];
        if (file && file.type) {
            const mime = file.type.match(/\/([a-z0-9]+)/i);
            const extension = mime[1] ? mime[1].toLowerCase() : '';
            if (!imagesExtensions.includes(extension)) {
                continue;
            }
            const reader = new FileReader();
            promises.push(uploader.j.async.promise((resolve, reject)=>{
                reader.onerror = reject;
                reader.onloadend = ()=>{
                    const resp = {
                        baseurl: '',
                        files: [
                            reader.result
                        ],
                        isImages: [
                            true
                        ]
                    };
                    const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(handlerSuccess) ? handlerSuccess : defaultHandlerSuccess;
                    handler.call(uploader, resp);
                    resolve(resp);
                };
                reader.readAsDataURL(file);
            }));
            fileList[i] = null;
        }
    }
}


/***/ }),

/***/ 47670:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/select
 */ 
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.select = {
    normalizeSelectionBeforeCutAndCopy: false,
    normalizeTripleClick: true
};


/***/ }),

/***/ 47744:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   readValuesFromImage: function() { return /* binding */ readValuesFromImage; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7909);
/* harmony import */ var _align__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26633);
/* harmony import */ var _link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(79310);
/* harmony import */ var _margin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(18380);
/* harmony import */ var _size__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57339);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 





/**
 * Read values from image and set it to state
 * @private
 */ function readValuesFromImage(j, state) {
    return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
        const { sourceImage: image, values } = state;
        (0,_align__WEBPACK_IMPORTED_MODULE_2__.readAlign)(image, values);
        // Border radius
        values.borderRadius = parseInt(image.style.borderRadius || '0', 10) || 0;
        // Id
        values.id = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'id') || '';
        // Title
        values.imageTitle = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'title') || '';
        // Alt
        values.imageAlt = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'alt') || '';
        // Style
        values.style = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'style') || '';
        // Classes
        values.classes = ((0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'class') || '').replace(/jodit_focused_image[\s]*/, '');
        // Margins
        (0,_margin__WEBPACK_IMPORTED_MODULE_4__.readMargins)(image, values, state);
        // Link
        (0,_link__WEBPACK_IMPORTED_MODULE_3__.readLink)(state, j, values);
        // Src
        values.imageSrc = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'src') || '';
        // Image size
        return (0,_size__WEBPACK_IMPORTED_MODULE_5__.readSizes)(image, values, state);
    })();
}


/***/ }),

/***/ 47760:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   alreadyLoadedList: function() { return /* binding */ alreadyLoadedList; },
/* harmony export */   appendScriptAsync: function() { return /* binding */ appendScriptAsync; },
/* harmony export */   appendStyleAsync: function() { return /* binding */ appendStyleAsync; },
/* harmony export */   loadNext: function() { return /* binding */ loadNext; },
/* harmony export */   loadNextStyle: function() { return /* binding */ loadNextStyle; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85932);
/* harmony import */ var _complete_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91321);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 

const alreadyLoadedList = new Map();
const cacheLoaders = (loader)=>{
    return (jodit, url)=>{
        if (alreadyLoadedList.has(url)) {
            return alreadyLoadedList.get(url);
        }
        const promise = loader(jodit, url);
        alreadyLoadedList.set(url, promise);
        return promise;
    };
};
/**
 * Load script and return promise
 */ const appendScriptAsync = cacheLoaders((jodit, url)=>{
    return jodit.async.promise((resolve, reject)=>{
        if (jodit.isInDestruct) {
            return reject();
        }
        const script = jodit.c.element('script', {
            type: 'text/javascript',
            crossorigin: 'anonymous',
            referrerpolicy: 'no-referrer',
            async: true,
            src: (0,_complete_url__WEBPACK_IMPORTED_MODULE_1__.completeUrl)(url)
        });
        jodit.e.one(script, 'error', reject).one(script, 'load', resolve);
        jodit.od.body.appendChild(script);
    });
});
/**
 * Download CSS style script
 */ const appendStyleAsync = cacheLoaders((jodit, url)=>{
    return jodit.async.promise((resolve, reject)=>{
        if (jodit.isInDestruct) {
            return reject();
        }
        const link = jodit.c.element('link');
        link.rel = 'stylesheet';
        link.media = 'all';
        link.crossOrigin = 'anonymous';
        const callback = ()=>resolve(link);
        !jodit.isInDestruct && jodit.e.on(link, 'load', callback).on(link, 'error', reject);
        link.href = (0,_complete_url__WEBPACK_IMPORTED_MODULE_1__.completeUrl)(url);
        if (jodit.o.shadowRoot) {
            jodit.o.shadowRoot.appendChild(link);
        } else {
            jodit.od.body.appendChild(link);
        }
    });
});
function loadNext(jodit, urls, i = 0) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__.isString)(urls[i])) {
        return Promise.resolve();
    }
    return appendScriptAsync(jodit, urls[i]).then(()=>loadNext(jodit, urls, i + 1));
}
function loadNextStyle(jodit, urls, i = 0) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__.isString)(urls[i])) {
        return Promise.resolve();
    }
    return appendStyleAsync(jodit, urls[i]).then(()=>loadNextStyle(jodit, urls, i + 1));
}


/***/ }),

/***/ 47919:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   moveCursorOutFromSpecialTags: function() { return /* binding */ moveCursorOutFromSpecialTags; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/enter
 */ 
/**
 * Checks if the cursor is on the edge of a special tag and exits if so
 * @private
 */ function moveCursorOutFromSpecialTags(jodit, fake, tags) {
    const { s } = jodit;
    const link = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(fake, tags, jodit.editor);
    if (link) {
        if (s.cursorOnTheRight(link, fake)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(link, fake);
        } else if (s.cursorOnTheLeft(link, fake)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.before(link, fake);
        }
    }
}


/***/ }),

/***/ 48007:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M512 1248v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm1280 512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68zm-1280-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm1280 512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68z\"/> </svg>"

/***/ }),

/***/ 48009:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalizeUrl: function() { return /* binding */ normalizeUrl; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/normalize
 */ const normalizeUrl = (...urls)=>{
    return urls.filter((url)=>url.length).map((url)=>url.replace(/\/$/, '')).join('/').replace(/([^:])[\\/]+/g, '$1/');
};


/***/ }),

/***/ 48155:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safeHTML: function() { return /* binding */ safeHTML; },
/* harmony export */   sanitizeHTMLElement: function() { return /* binding */ sanitizeHTMLElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93640);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/html
 */ 

/**
 * Removes dangerous constructs from HTML
 */ function safeHTML(box, options) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement(box) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isFragment(box)) {
        return;
    }
    if (options.removeOnError) {
        sanitizeHTMLElement(box);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.$$)('[onerror]', box).forEach((elm)=>sanitizeHTMLElement(elm, options));
    }
    if (options.safeJavaScriptLink) {
        sanitizeHTMLElement(box);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.$$)('a[href^="javascript"]', box).forEach((elm)=>sanitizeHTMLElement(elm, options));
    }
}
function sanitizeHTMLElement(elm, { safeJavaScriptLink, removeOnError } = {
    safeJavaScriptLink: true,
    removeOnError: true
}) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement(elm)) {
        return false;
    }
    let effected = false;
    if (removeOnError && elm.hasAttribute('onerror')) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'onerror', null);
        effected = true;
    }
    const href = elm.getAttribute('href');
    if (safeJavaScriptLink && href && href.trim().indexOf('javascript') === 0) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'href', location.protocol + '//' + href);
        effected = true;
    }
    return effected;
}


/***/ }),

/***/ 48290:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(93640);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5266);
/* harmony import */ var _table_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(67447);
/* harmony import */ var _table_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_table_svg__WEBPACK_IMPORTED_MODULE_5__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/table
 */ 





jodit_config__WEBPACK_IMPORTED_MODULE_4__.Config.prototype.table = {
    splitBlockOnInsertTable: true,
    selectionCellStyle: 'border: 1px double #1e88e5 !important;',
    useExtraClassesOptions: false
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__.Icon.set('table', (_table_svg__WEBPACK_IMPORTED_MODULE_5___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_4__.Config.prototype.controls.table = {
    data: {
        cols: 10,
        rows: 10,
        classList: {
            'table table-bordered': 'Bootstrap Bordered',
            'table table-striped': 'Bootstrap Striped',
            'table table-dark': 'Bootstrap Dark'
        }
    },
    popup: (editor, current, close, button)=>{
        editor.editor.normalize();
        const snapshot = editor.history.snapshot.make();
        const control = button.control;
        const default_rows_count = control.data && control.data.rows ? control.data.rows : 10, default_cols_count = control.data && control.data.cols ? control.data.cols : 10;
        const generateExtraClasses = ()=>{
            if (!editor.o.table.useExtraClassesOptions) {
                return '';
            }
            const out = [];
            if (control.data) {
                const classList = control.data.classList;
                Object.keys(classList).forEach((classes)=>{
                    out.push(`<label class="jodit_vertical_middle"><input class="jodit-checkbox" value="${classes}" type="checkbox"/>${classList[classes]}</label>`);
                });
            }
            return out.join('');
        };
        const form = editor.c.fromHTML('<form class="jodit-form jodit-form__inserter">' + '<div class="jodit-form__table-creator-box">' + '<div class="jodit-form__container"></div>' + '<div class="jodit-form__options">' + generateExtraClasses() + '</div>' + '</div>' + '<label class="jodit-form__center">' + '<span>1</span> &times; <span>1</span>' + '</label>' + '</form>'), rows = form.querySelectorAll('span')[0], cols = form.querySelectorAll('span')[1], blocksContainer = form.querySelector('.jodit-form__container'), options = form.querySelector('.jodit-form__options'), cells = [];
        const cnt = default_rows_count * default_cols_count;
        for(let i = 0; i < cnt; i += 1){
            if (!cells[i]) {
                cells.push(editor.c.element('span', {
                    dataIndex: i
                }));
            }
        }
        const mouseenter = (e, index)=>{
            const dv = e.target;
            if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(dv, 'span')) {
                return;
            }
            const k = index === undefined || isNaN(index) ? parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.attr)(dv, '-index') || '0', 10) : index || 0;
            const rows_count = Math.ceil((k + 1) / default_cols_count), cols_count = k % default_cols_count + 1;
            for(let i = 0; i < cells.length; i += 1){
                if (cols_count >= i % default_cols_count + 1 && rows_count >= Math.ceil((i + 1) / default_cols_count)) {
                    cells[i].className = 'jodit_hovered';
                } else {
                    cells[i].className = '';
                }
            }
            cols.textContent = cols_count.toString();
            rows.textContent = rows_count.toString();
        };
        editor.e.on(blocksContainer, 'mousemove', mouseenter).on(blocksContainer, 'touchstart mousedown', (e)=>{
            const dv = e.target;
            e.preventDefault();
            e.stopImmediatePropagation();
            if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(dv, 'span')) {
                return;
            }
            const k = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.attr)(dv, '-index') || '0', 10);
            const rows_count = Math.ceil((k + 1) / default_cols_count), cols_count = k % default_cols_count + 1;
            const crt = editor.createInside, tbody = crt.element('tbody'), table = crt.element('table');
            table.appendChild(tbody);
            let first_td = null, tr, td;
            for(let i = 1; i <= rows_count; i += 1){
                tr = crt.element('tr');
                for(let j = 1; j <= cols_count; j += 1){
                    td = crt.element('td');
                    if (!first_td) {
                        first_td = td;
                    }
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.css)(td, 'width', (100 / cols_count).toFixed(4) + '%');
                    td.appendChild(crt.element('br'));
                    tr.appendChild(crt.text('\n'));
                    tr.appendChild(crt.text('\t'));
                    tr.appendChild(td);
                }
                tbody.appendChild(crt.text('\n'));
                tbody.appendChild(tr);
            }
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.$$)('input[type=checkbox]:checked', options).forEach((input)=>{
                input.value.split(/[\s]+/).forEach((className)=>{
                    table.classList.add(className);
                });
            });
            editor.s.restore();
            editor.s.removeMarkers();
            editor.editor.normalize();
            editor.history.snapshot.restore(snapshot);
            const block = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.furthest(editor.s.current(), jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock, editor.editor);
            if (block && jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isEmpty(block)) {
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.replace(block, table, undefined, false, true);
            } else {
                if (block) {
                    const fake = crt.text('\n');
                    if (!editor.o.table.splitBlockOnInsertTable) {
                        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(block, fake);
                        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(fake, table);
                    } else {
                        const range = editor.s.range;
                        range.collapse(false);
                        range.insertNode(fake);
                        range.collapse(false);
                        editor.s.selectRange(range);
                        const firstPart = editor.s.splitSelection(block, fake);
                        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.after(firstPart, table);
                    }
                } else {
                    editor.s.insertNode(table, false);
                }
            }
            if (first_td) {
                editor.s.setCursorIn(first_td);
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.scrollIntoViewIfNeeded)(first_td, editor.editor, editor.ed);
            }
            close();
        });
        if (button && button.parentElement) {
            for(let i = 0; i < default_rows_count; i += 1){
                const row = editor.c.div();
                for(let j = 0; j < default_cols_count; j += 1){
                    row.appendChild(cells[i * default_cols_count + j]);
                }
                blocksContainer.appendChild(row);
            }
            if (cells[0]) {
                cells[0].className = 'hovered';
            }
        }
        return form;
    },
    tooltip: 'Insert table'
};


/***/ }),

/***/ 48729:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FiniteStateMachine: function() { return /* binding */ FiniteStateMachine; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 



/**
 * A state machine implementation for applying styles.
 */ class FiniteStateMachine {
    setState(state) {
        (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__.assert)(!this.__previewsStates.has(state), 'Circled states');
        this.__previewsStates.add(state);
        this.__state = state;
    }
    getState() {
        return this.__state;
    }
    disableSilent() {
        this.silent = false;
    }
    dispatch(actionName, value) {
        const action = this.transitions[this.getState()][actionName];
        if (action) {
            const res = action.call(this, value);
            (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__.assert)(res && res !== value, 'Action should return new value');
            (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__.assert)((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__.isString)(res.next), 'Value should contain the next state');
            (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__.assert)(res.next !== this.getState(), 'The new state should not be equal to the old one.');
            this.setState(res.next);
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD && !this.silent) {
                // eslint-disable-next-line no-console
                console.log(`State: ${this.getState()}`);
            }
            return res;
        }
        throw new Error(`invalid action: ${this.getState()}.${actionName.toString()}`);
    }
    constructor(state, transitions){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "transitions", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__state", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "silent", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__previewsStates", void 0);
        this.transitions = transitions;
        this.silent = true;
        this.__previewsStates = new Set();
        this.setState(state);
    }
}


/***/ }),

/***/ 48776:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   required: function() { return /* binding */ required; },
/* harmony export */   url: function() { return /* binding */ url; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91764);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4040);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/form
 */ 

/**
 * Input is required
 */ const required = function(input) {
    if (!(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__.trim)(input.value).length) {
        input.error = 'Please fill out this field';
        return false;
    }
    return true;
};
/**
 * Input value should be valid URL
 */ const url = function(input) {
    if (!(0,jodit_core_helpers_checker_is_url__WEBPACK_IMPORTED_MODULE_0__.isURL)((0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__.trim)(input.value))) {
        input.error = 'Please enter a web address';
        return false;
    }
    return true;
};


/***/ }),

/***/ 48838:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   nl2br: function() { return /* binding */ nl2br; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/html
 */ /**
 *  Inserts HTML line breaks before all newlines in a string
 */ function nl2br(html) {
    return html.replace(/\r\n|\r|\n/g, '<br/>');
}


/***/ }),

/***/ 48842:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M789 559l-170 450q33 0 136.5 2t160.5 2q19 0 57-2-87-253-184-452zm-725 1105l2-79q23-7 56-12.5t57-10.5 49.5-14.5 44.5-29 31-50.5l237-616 280-724h128q8 14 11 21l205 480q33 78 106 257.5t114 274.5q15 34 58 144.5t72 168.5q20 45 35 57 19 15 88 29.5t84 20.5q6 38 6 57 0 4-.5 13t-.5 13q-63 0-190-8t-191-8q-76 0-215 7t-178 8q0-43 4-78l131-28q1 0 12.5-2.5t15.5-3.5 14.5-4.5 15-6.5 11-8 9-11 2.5-14q0-16-31-96.5t-72-177.5-42-100l-450-2q-26 58-76.5 195.5t-50.5 162.5q0 22 14 37.5t43.5 24.5 48.5 13.5 57 8.5 41 4q1 19 1 58 0 9-2 27-58 0-174.5-10t-174.5-10q-8 0-26.5 4t-21.5 4q-80 14-188 14z\"/> </svg>"

/***/ }),

/***/ 48899:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59400);
/* harmony import */ var jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5658);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5266);
/* harmony import */ var jodit_modules_widget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15753);
/* harmony import */ var _video_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36339);
/* harmony import */ var _video_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_video_svg__WEBPACK_IMPORTED_MODULE_6__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/video
 */ 






jodit_config__WEBPACK_IMPORTED_MODULE_4__.Config.prototype.video = {
    parseUrlToVideoEmbed: jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.convertMediaUrlToVideoEmbed,
    defaultWidth: 400,
    defaultHeight: 345
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__.Icon.set('video', (_video_svg__WEBPACK_IMPORTED_MODULE_6___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_4__.Config.prototype.controls.video = {
    popup: (jodit, current, close)=>{
        const formLink = new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__.UIForm(jodit, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__.UIBlock(jodit, [
                new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__.UIInput(jodit, {
                    name: 'url',
                    required: true,
                    label: 'URL',
                    placeholder: 'https://',
                    validators: [
                        'url'
                    ]
                })
            ]),
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__.UIBlock(jodit, [
                (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_1__.Button)(jodit, '', 'Insert', 'primary').onAction(()=>formLink.submit())
            ])
        ]), formCode = new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__.UIForm(jodit, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__.UIBlock(jodit, [
                new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__.UITextArea(jodit, {
                    name: 'code',
                    required: true,
                    label: 'Embed code'
                })
            ]),
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__.UIBlock(jodit, [
                (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_1__.Button)(jodit, '', 'Insert', 'primary').onAction(()=>formCode.submit())
            ])
        ]), tabs = [], insertCode = (code)=>{
            jodit.s.restore();
            jodit.s.insertHTML(code);
            close();
        };
        jodit.s.save();
        tabs.push({
            icon: 'link',
            name: 'Link',
            content: formLink.container
        }, {
            icon: 'source',
            name: 'Code',
            content: formCode.container
        });
        formLink.onSubmit((data)=>{
            var _jodit_o_video, _jodit_o_video1, _jodit_o_video2;
            var _jodit_o_video_parseUrlToVideoEmbed;
            insertCode((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.call)((_jodit_o_video_parseUrlToVideoEmbed = (_jodit_o_video = jodit.o.video) === null || _jodit_o_video === void 0 ? void 0 : _jodit_o_video.parseUrlToVideoEmbed) !== null && _jodit_o_video_parseUrlToVideoEmbed !== void 0 ? _jodit_o_video_parseUrlToVideoEmbed : jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.convertMediaUrlToVideoEmbed, data.url, {
                width: (_jodit_o_video1 = jodit.o.video) === null || _jodit_o_video1 === void 0 ? void 0 : _jodit_o_video1.defaultWidth,
                height: (_jodit_o_video2 = jodit.o.video) === null || _jodit_o_video2 === void 0 ? void 0 : _jodit_o_video2.defaultHeight
            }));
        });
        formCode.onSubmit((data)=>{
            insertCode(data.code);
        });
        return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_5__.TabsWidget)(jodit, tabs);
    },
    tags: [
        'iframe'
    ],
    tooltip: 'Insert youtube/vimeo video'
};


/***/ }),

/***/ 49147:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applySize: function() { return /* binding */ applySize; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(70222);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7909);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80991);
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10808);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 



/** @private */ function applySize(image, imageWidth, imageHeight, sizeIsLocked) {
    // Size
    if (imageWidth !== image.offsetWidth || imageHeight !== image.offsetHeight) {
        const updatedWidth = imageWidth ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_3__.normalSizeToString)(imageWidth) : null;
        let updatedHeight = imageHeight ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_3__.normalSizeToString)(imageHeight) : null;
        (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__.css)(image, {
            width: updatedWidth,
            height: updatedWidth && sizeIsLocked ? null : updatedHeight
        });
        (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'width', updatedWidth && (0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_0__.isNumeric)(imageWidth) && (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'width') ? updatedWidth : null);
        if (!(0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'width') || sizeIsLocked) {
            updatedHeight = null;
        }
        (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'height', updatedHeight);
    }
}


/***/ }),

/***/ 49376:
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ _async_to_generator; }
/* harmony export */ });
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) resolve(value);
    else Promise.resolve(value).then(_next, _throw);
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}



/***/ }),

/***/ 49385:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cns: function() { return /* binding */ cns; },
/* harmony export */   markDeprecated: function() { return /* binding */ markDeprecated; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ /**
 * By default, terser will remove all `console.*` but
 * if you use this object it will not be
 */ const cns = console;
/**
 * Mark function as deprecated
 */ function markDeprecated(method, names = [
    ''
], ctx = null) {
    return (...args)=>{
        cns.warn(`Method "${names[0]}" deprecated.` + (names[1] ? ` Use "${names[1]}" instead` : ''));
        return method.call(ctx, ...args);
    };
}


/***/ }),

/***/ 49422:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyLink: function() { return /* binding */ applyLink; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7909);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 

/** @private */ function applyLink(j, image, imageLink, imageLinkOpenInNewTab) {
    // Link
    let link = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(image, 'a', j.editor);
    if (imageLink) {
        if (!link) {
            link = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.wrap(image, 'a', j.createInside);
        }
        (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(link, 'href', imageLink);
        (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__.attr)(link, 'target', imageLinkOpenInNewTab ? '_blank' : null);
    } else {
        if (link && link.parentNode) {
            link.parentNode.replaceChild(image, link);
        }
    }
}


/***/ }),

/***/ 49574:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   autobind: function() { return /* binding */ autobind; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91565);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 
/**
 * [[include:core/decorators/autobind/README.md]]
 * @packageDocumentation
 * @module decorators/autobind
 */ /**
 * Decorator that automatically binds a method to its class instance.
 * This is useful when passing methods as callbacks to preserve the correct `this` context.
 *
 * @example
 * ```typescript
 * class MyComponent {
 *   @autobind
 *   handleClick() {
 *     console.log(this); // Always refers to MyComponent instance
 *   }
 * }
 *
 * const component = new MyComponent();
 * const button = document.createElement('button');
 * button.addEventListener('click', component.handleClick); // `this` is correctly bound
 * ```
 */ function autobind(_target, propertyKey, descriptor) {
    if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__.isFunction)(descriptor.value)) {
        throw new TypeError(`@autobind can only be applied to methods, but "${propertyKey}" is not a function`);
    }
    const originalMethod = descriptor.value;
    return {
        configurable: true,
        get () {
            // Create a bound version of the method and cache it on the instance
            const boundMethod = originalMethod.bind(this);
            // Define the bound method as a property on the instance
            // This ensures the same bound function is returned on subsequent accesses
            Object.defineProperty(this, propertyKey, {
                value: boundMethod,
                configurable: true,
                writable: true
            });
            return boundMethod;
        }
    };
}


/***/ }),

/***/ 49663:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalizeLicense: function() { return /* binding */ normalizeLicense; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/normalize
 */ const normalizeLicense = (license, count = 8)=>{
    const parts = [];
    while(license.length){
        parts.push(license.substr(0, count));
        license = license.substr(count);
    }
    parts[1] = parts[1].replace(/./g, '*');
    parts[2] = parts[2].replace(/./g, '*');
    return parts.join('-');
};


/***/ }),

/***/ 49972:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1760 896q14 0 23 9t9 23v64q0 14-9 23t-23 9h-1728q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h1728zm-1277-64q-28-35-51-80-48-97-48-188 0-181 134-309 133-127 393-127 50 0 167 19 66 12 177 48 10 38 21 118 14 123 14 183 0 18-5 45l-12 3-84-6-14-2q-50-149-103-205-88-91-210-91-114 0-182 59-67 58-67 146 0 73 66 140t279 129q69 20 173 66 58 28 95 52h-743zm507 256h411q7 39 7 92 0 111-41 212-23 55-71 104-37 35-109 81-80 48-153 66-80 21-203 21-114 0-195-23l-140-40q-57-16-72-28-8-8-8-22v-13q0-108-2-156-1-30 0-68l2-37v-44l102-2q15 34 30 71t22.5 56 12.5 27q35 57 80 94 43 36 105 57 59 22 132 22 64 0 139-27 77-26 122-86 47-61 47-129 0-84-81-157-34-29-137-71z\"/> </svg>"

/***/ }),

/***/ 49983:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1728 608v704q0 92-66 158t-158 66h-1216q-92 0-158-66t-66-158v-960q0-92 66-158t158-66h320q92 0 158 66t66 158v32h672q92 0 158 66t66 158z\"/> </svg>"

/***/ }),

/***/ 49999:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UISelect: function() { return /* binding */ UISelect; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41411);
/* harmony import */ var _swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15366);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91672);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(7909);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65273);
/* harmony import */ var jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(81488);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/form
 */ 








class UISelect extends jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_6__.UIInput {
    /** @override */ className() {
        return 'UISelect';
    }
    /** @override **/ createContainer(state) {
        var _state_options;
        const container = super.createContainer(state);
        const { j } = this, { nativeInput } = this;
        const opt = ()=>j.create.element('option');
        if (state.placeholder !== undefined) {
            const option = opt();
            option.value = '';
            option.text = j.i18n(state.placeholder);
            nativeInput.add(option);
        }
        (_state_options = state.options) === null || _state_options === void 0 ? void 0 : _state_options.forEach((element)=>{
            const option = opt();
            option.value = element.value.toString();
            option.text = j.i18n(element.text);
            nativeInput.add(option);
        });
        if (state.size && state.size > 0) {
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_5__.attr)(nativeInput, 'size', state.size);
        }
        if (state.multiple) {
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_5__.attr)(nativeInput, 'multiple', '');
        }
        return container;
    }
    /** @override **/ createNativeInput() {
        return this.j.create.element('select');
    }
    /** @override **/ updateValidators() {
        super.updateValidators();
        if (this.state.required) {
            this.validators.delete(jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_7__.inputValidators.required);
            this.validators.add(jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_7__.selectValidators.required);
        }
    }
    constructor(jodit, state){
        super(jodit, state), /** @override */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "state", (0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({}, UISelect.defaultState));
        Object.assign(this.state, state);
    }
}
/** @override */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(UISelect, "defaultState", (0,_swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__._)((0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_6__.UIInput.defaultState), {
    options: [],
    size: 1,
    multiple: false
}));
UISelect = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__.component
], UISelect);


/***/ }),

/***/ 50083:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidName: function() { return /* binding */ isValidName; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ /**
 * Check if name has a normal format
 */ function isValidName(name) {
    if (!name.length) {
        return false;
    }
    return !/[^0-9A-Za-zа-яА-ЯЁё\w\-_. ]/.test(name) && name.trim().length > 0;
}


/***/ }),

/***/ 50294:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export font */
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65946);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7433);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/font/README.md]]
 * @packageDocumentation
 * @module plugins/font
 */ 


/**
 * Process commands `fontsize` and `fontname`
 */ function font(editor) {
    editor.registerButton({
        name: 'font',
        group: 'font'
    }).registerButton({
        name: 'fontsize',
        group: 'font'
    });
    const callback = (command, second, third)=>{
        switch(command){
            case 'fontsize':
                editor.s.commitStyle({
                    attributes: {
                        style: {
                            fontSize: (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.normalizeSize)(third, editor.o.defaultFontSizePoints)
                        }
                    }
                });
                break;
            case 'fontname':
                editor.s.commitStyle({
                    attributes: {
                        style: {
                            fontFamily: third
                        }
                    }
                });
                break;
        }
        editor.synchronizeValues();
        return false;
    };
    editor.registerCommand('fontsize', callback).registerCommand('fontname', callback);
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__.pluginSystem.add('font', font);


/***/ }),

/***/ 50982:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export hotkeys */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91206);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(14907);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/hotkeys/README.md]]
 * @packageDocumentation
 * @module plugins/hotkeys
 */ 





/**
 * Allow set hotkey for command or button
 */ class hotkeys extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__.Plugin {
    /** @override */ afterInit(editor) {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.keys)(editor.o.commandToHotkeys, false).forEach((commandName)=>{
            const shortcuts = editor.o.commandToHotkeys[commandName];
            if (shortcuts && ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(shortcuts) || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(shortcuts))) {
                editor.registerHotkeyToCommand(shortcuts, commandName);
            }
        });
        let itIsHotkey = false;
        editor.e.off('.hotkeys').on([
            editor.ow,
            editor.ew
        ], 'keydown.hotkeys', (e)=>{
            if (e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_ESC) {
                return this.j.e.fire('escape', e);
            }
        }).on('keydown.hotkeys', (event)=>{
            const shortcut = this.onKeyPress(event);
            const stop = {
                shouldStop: true
            };
            const resultOfFire = this.j.e.fire(shortcut + '.hotkey', event.type, stop);
            if (resultOfFire === false) {
                if (stop.shouldStop) {
                    itIsHotkey = true;
                    editor.e.stopPropagation('keydown');
                    return false;
                } else {
                    event.preventDefault();
                }
            }
        }, {
            top: true
        }).on('keyup.hotkeys', ()=>{
            if (itIsHotkey) {
                itIsHotkey = false;
                editor.e.stopPropagation('keyup');
                return false;
            }
        }, {
            top: true
        });
    }
    /** @override */ beforeDestruct(jodit) {
        if (jodit.events) {
            jodit.e.off('.hotkeys');
        }
    }
    constructor(...args){
        super(...args), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "onKeyPress", (event)=>{
            const special = this.specialKeys[event.which];
            const character = (event.key || String.fromCharCode(event.which)).toLowerCase();
            const modif = [
                special || character
            ];
            [
                'alt',
                'ctrl',
                'shift',
                'meta'
            ].forEach((specialKey)=>{
                if (event[specialKey + 'Key'] && special !== specialKey) {
                    modif.push(specialKey);
                }
            });
            return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.normalizeKeyAliases)(modif.join('+'));
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "specialKeys", {
            8: 'backspace',
            9: 'tab',
            10: 'return',
            13: 'return',
            16: 'shift',
            17: 'ctrl',
            18: 'alt',
            19: 'pause',
            20: 'capslock',
            27: 'esc',
            32: 'space',
            33: 'pageup',
            34: 'pagedown',
            35: 'end',
            36: 'home',
            37: 'left',
            38: 'up',
            39: 'right',
            40: 'down',
            45: 'insert',
            46: 'del',
            59: ';',
            61: '=',
            91: 'meta',
            96: '0',
            97: '1',
            98: '2',
            99: '3',
            100: '4',
            101: '5',
            102: '6',
            103: '7',
            104: '8',
            105: '9',
            106: '*',
            107: '+',
            109: '-',
            110: '.',
            111: '/',
            112: 'f1',
            113: 'f2',
            114: 'f3',
            115: 'f4',
            116: 'f5',
            117: 'f6',
            118: 'f7',
            119: 'f8',
            120: 'f9',
            121: 'f10',
            122: 'f11',
            123: 'f12',
            144: 'numlock',
            145: 'scroll',
            173: '-',
            186: ';',
            187: '=',
            188: ',',
            189: '-',
            190: '.',
            191: '/',
            192: '`',
            219: '[',
            220: '\\',
            221: ']',
            222: "'"
        });
    }
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__.pluginSystem.add('hotkeys', hotkeys);


/***/ }),

/***/ 51034:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-processor
 */ 
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.imageProcessor = {
    replaceDataURIToBlobIdInView: true
};


/***/ }),

/***/ 51116:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Popup: function() { return /* binding */ Popup; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41411);
/* harmony import */ var _swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15366);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(80251);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(96007);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(63468);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/ui/popup/README.md]]
 * @packageDocumentation
 * @module ui/popup
 */ 












const EVENTS_FOR_AUTOCLOSE = [
    'escape',
    'cut',
    'delete',
    'backSpaceAfterDelete',
    'beforeCommandDelete'
];
class Popup extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_11__.UIGroup {
    className() {
        return 'Popup';
    }
    appendChildToContainer(childContainer) {
        const content = this.getElm('content');
        (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_9__.assert)(content, 'Content element should exist');
        content.appendChild(childContainer);
    }
    updateParentElement(target) {
        if (target !== this && jodit_core_component_component__WEBPACK_IMPORTED_MODULE_4__.Component.isInstanceOf(target, Popup)) {
            this.__childrenPopups.forEach((popup)=>{
                if (!target.closest(popup) && popup.isOpened) {
                    popup.close();
                }
            });
            if (!this.__childrenPopups.has(target)) {
                this.j.e.on(target, 'beforeClose', ()=>{
                    this.__childrenPopups.delete(target);
                });
            }
            this.__childrenPopups.add(target);
        }
        return super.updateParentElement(target);
    }
    /**
	 * Set popup content
	 */ setContent(content) {
        if (this.allChildren.length) {
            throw new Error('Remove children');
        }
        if (jodit_core_component_component__WEBPACK_IMPORTED_MODULE_4__.Component.isInstanceOf(content, jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_10__.UIElement)) {
            this.append(content);
        } else {
            const elm = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__.isString)(content) ? this.j.c.fromHTML(content) : content;
            this.appendChildToContainer(elm);
        }
        this.updatePosition();
        return this;
    }
    /**
	 * Open popup near with some bound
	 */ open(getBound, keepPosition = false, parentContainer) {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__.markOwner)(this.jodit, this.container);
        this.container.classList.add(`jodit_theme_${this.jodit.o.theme}`);
        this.__calculateZIndex();
        this.isOpened = true;
        this.__addGlobalListeners();
        this.__targetBound = !keepPosition ? getBound : this.getKeepBound(getBound);
        if (parentContainer) {
            parentContainer.appendChild(this.container);
        } else {
            const popupContainer = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_7__.getContainer)(this.jodit, Popup);
            if (parentContainer !== this.container.parentElement) {
                popupContainer.appendChild(this.container);
            }
        }
        this.updatePosition();
        this.j.e.fire(this, 'afterOpen');
        this.j.e.fire('afterOpenPopup', this);
        return this;
    }
    __calculateZIndex() {
        if (this.container.style.zIndex) {
            return;
        }
        const checkView = (view)=>{
            const zIndex = view.container.style.zIndex || view.o.zIndex;
            if (zIndex) {
                this.setZIndex(1 + parseInt(zIndex.toString(), 10));
                return true;
            }
            return false;
        };
        const { j } = this;
        if (checkView(j)) {
            return;
        }
        let pe = this.parentElement;
        while(pe){
            if (checkView(pe.j)) {
                return;
            }
            if (pe.container.style.zIndex) {
                this.setZIndex(1 + parseInt(pe.container.style.zIndex.toString(), 10));
                return;
            }
            if (!pe.parentElement && pe.container.parentElement) {
                const elm = jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_10__.UIElement.closestElement(pe.container.parentElement, jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_10__.UIElement);
                if (elm) {
                    pe = elm;
                    continue;
                }
            }
            pe = pe.parentElement;
        }
    }
    /**
	 * Calculate static bound for point
	 */ getKeepBound(getBound) {
        const oldBound = getBound();
        const elmUnderCursor = this.od.elementFromPoint(oldBound.left, oldBound.top);
        if (!elmUnderCursor) {
            return getBound;
        }
        const element = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_6__.Dom.isHTMLElement(elmUnderCursor) ? elmUnderCursor : elmUnderCursor.parentElement;
        const oldPos = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__.position)(element, this.j);
        return ()=>{
            const bound = getBound();
            const newPos = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__.position)(element, this.j);
            return (0,_swc_helpers_object_spread_props__WEBPACK_IMPORTED_MODULE_2__._)((0,_swc_helpers_object_spread__WEBPACK_IMPORTED_MODULE_1__._)({}, bound), {
                top: bound.top + (newPos.top - oldPos.top),
                left: bound.left + (newPos.left - oldPos.left)
            });
        };
    }
    /**
	 * Update container position
	 */ updatePosition() {
        if (!this.isOpened) {
            return this;
        }
        const [pos, strategy] = this.__calculatePosition(this.__targetBound(), this.viewBound(), (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__.position)(this.container, this.j));
        this.setMod('strategy', strategy);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__.css)(this.container, {
            left: pos.left,
            top: pos.top
        });
        this.__childrenPopups.forEach((popup)=>popup.updatePosition());
        return this;
    }
    __throttleUpdatePosition() {
        this.updatePosition();
    }
    /**
	 * Calculate start point
	 */ __calculatePosition(target, view, container, defaultStrategy = this.strategy) {
        const x = {
            left: target.left,
            right: target.left - (container.width - target.width)
        }, y = {
            bottom: target.top + target.height,
            top: target.top - container.height
        };
        const list = Object.keys(x).reduce((keys, xKey)=>keys.concat(Object.keys(y).map((yKey)=>`${xKey}${(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__.ucfirst)(yKey)}`)), []);
        const getPointByStrategy = (strategy)=>{
            const [xKey, yKey] = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__.kebabCase)(strategy).split('-');
            return {
                left: x[xKey],
                top: y[yKey],
                width: container.width,
                height: container.height
            };
        };
        const getMatchStrategy = (inBox)=>{
            let strategy = null;
            if (Popup.boxInView(getPointByStrategy(defaultStrategy), inBox)) {
                strategy = defaultStrategy;
            } else {
                strategy = list.find((key)=>{
                    if (Popup.boxInView(getPointByStrategy(key), inBox)) {
                        return key;
                    }
                    return;
                }) || null;
            }
            return strategy;
        };
        // Try to find match position inside Jodit.container
        let strategy = getMatchStrategy((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__.position)(this.j.container, this.j));
        // If not found or is not inside window view
        if (!strategy || !Popup.boxInView(getPointByStrategy(strategy), view)) {
            // Find match strategy inside window view
            strategy = getMatchStrategy(view) || strategy || defaultStrategy;
        }
        return [
            getPointByStrategy(strategy),
            strategy
        ];
    }
    /**
	 * Check if one box is inside second
	 */ static boxInView(box, view) {
        const accuracy = 2;
        return box.top - view.top >= -accuracy && box.left - view.left >= -accuracy && view.top + view.height - (box.top + box.height) >= -accuracy && view.left + view.width - (box.left + box.width) >= -accuracy;
    }
    /**
	 * Close popup
	 */ close() {
        if (!this.isOpened) {
            return this;
        }
        this.isOpened = false;
        this.__childrenPopups.forEach((popup)=>popup.close());
        this.j.e.fire(this, 'beforeClose');
        this.j.e.fire('beforePopupClose', this);
        this.__removeGlobalListeners();
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_6__.Dom.safeRemove(this.container);
        return this;
    }
    /**
	 * Close popup if click was in outside
	 */ __closeOnOutsideClick(e) {
        if (!this.isOpened || this.isOwnClick(e)) {
            return;
        }
        this.close();
    }
    isOwnClick(e) {
        if (!e.target) {
            return false;
        }
        const box = jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_10__.UIElement.closestElement(e.target, Popup);
        return Boolean(box && (this === box || box.closest(this)));
    }
    __addGlobalListeners() {
        const up = this.__throttleUpdatePosition, ow = this.ow;
        jodit_core_global__WEBPACK_IMPORTED_MODULE_7__.eventEmitter.on('closeAllPopups', this.close);
        if (this.smart) {
            this.j.e.on(EVENTS_FOR_AUTOCLOSE, this.close).on('mousedown touchstart', this.__closeOnOutsideClick).on(ow, 'mousedown touchstart', this.__closeOnOutsideClick);
        }
        this.j.e.on('closeAllPopups', this.close).on('resize', up).on(this.container, 'scroll mousewheel', up).on(ow, 'scroll', up).on(ow, 'resize', up);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_6__.Dom.up(this.j.container, (box)=>{
            box && this.j.e.on(box, 'scroll mousewheel', up);
        });
    }
    __removeGlobalListeners() {
        const up = this.__throttleUpdatePosition, ow = this.ow;
        jodit_core_global__WEBPACK_IMPORTED_MODULE_7__.eventEmitter.off('closeAllPopups', this.close);
        if (this.smart) {
            this.j.e.off(EVENTS_FOR_AUTOCLOSE, this.close).off('mousedown touchstart', this.__closeOnOutsideClick).off(ow, 'mousedown touchstart', this.__closeOnOutsideClick);
        }
        this.j.e.off('closeAllPopups', this.close).off('resize', up).off(this.container, 'scroll mousewheel', up).off(ow, 'scroll', up).off(ow, 'resize', up);
        if (this.j.container.isConnected) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_6__.Dom.up(this.j.container, (box)=>{
                box && this.j.e.off(box, 'scroll mousewheel', up);
            });
        }
    }
    /**
	 * Set ZIndex
	 */ setZIndex(index) {
        this.container.style.zIndex = index.toString();
    }
    render() {
        return `<div>
			<div class="&__content"></div>
		</div>`;
    }
    /** @override **/ destruct() {
        this.close();
        return super.destruct();
    }
    constructor(jodit, smart = true){
        super(jodit), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "smart", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "isOpened", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "strategy", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "viewBound", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__targetBound", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__childrenPopups", void 0), this.smart = smart, this.isOpened = false, this.strategy = 'leftBottom', this.viewBound = ()=>({
                left: 0,
                top: 0,
                width: this.ow.innerWidth,
                height: this.ow.innerHeight
            }), this.__childrenPopups = new Set();
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_8__.attr)(this.container, 'role', 'popup');
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.autobind
], Popup.prototype, "updatePosition", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.throttle)(10),
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.autobind
], Popup.prototype, "__throttleUpdatePosition", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.autobind
], Popup.prototype, "close", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_5__.autobind
], Popup.prototype, "__closeOnOutsideClick", null);


/***/ }),

/***/ 51640:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FiniteStateMachine: function() { return /* reexport safe */ _finite_state_machine__WEBPACK_IMPORTED_MODULE_1__.FiniteStateMachine; },
/* harmony export */   elementsEqualAttributes: function() { return /* reexport safe */ _is_same_attributes__WEBPACK_IMPORTED_MODULE_7__.elementsEqualAttributes; },
/* harmony export */   extractSelectedPart: function() { return /* reexport safe */ _extract__WEBPACK_IMPORTED_MODULE_0__.extractSelectedPart; },
/* harmony export */   getSuitChild: function() { return /* reexport safe */ _get_suit_child__WEBPACK_IMPORTED_MODULE_2__.getSuitChild; },
/* harmony export */   getSuitParent: function() { return /* reexport safe */ _get_suit_parent__WEBPACK_IMPORTED_MODULE_3__.getSuitParent; },
/* harmony export */   isInsideInvisibleElement: function() { return /* reexport safe */ _is_inside_invisible_element__WEBPACK_IMPORTED_MODULE_5__.isInsideInvisibleElement; },
/* harmony export */   isSameAttributes: function() { return /* reexport safe */ _is_same_attributes__WEBPACK_IMPORTED_MODULE_7__.isSameAttributes; },
/* harmony export */   suitableClosest: function() { return /* reexport safe */ _is_suit_element__WEBPACK_IMPORTED_MODULE_8__.suitableClosest; },
/* harmony export */   toggleAttributes: function() { return /* reexport safe */ _toggle_attributes__WEBPACK_IMPORTED_MODULE_11__.toggleAttributes; },
/* harmony export */   toggleOrderedList: function() { return /* reexport safe */ _list_toggle_ordered_list__WEBPACK_IMPORTED_MODULE_9__.toggleOrderedList; },
/* harmony export */   unwrapChildren: function() { return /* reexport safe */ _unwrap_children__WEBPACK_IMPORTED_MODULE_12__.unwrapChildren; },
/* harmony export */   wrap: function() { return /* reexport safe */ _wrap__WEBPACK_IMPORTED_MODULE_13__.wrap; }
/* harmony export */ });
/* harmony import */ var _extract__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17481);
/* harmony import */ var _finite_state_machine__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48729);
/* harmony import */ var _get_suit_child__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(10171);
/* harmony import */ var _get_suit_parent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19549);
/* harmony import */ var _has_same_style__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9703);
/* harmony import */ var _is_inside_invisible_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(39608);
/* harmony import */ var _is_normal_node__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(83653);
/* harmony import */ var _is_same_attributes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(95971);
/* harmony import */ var _is_suit_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(73019);
/* harmony import */ var _list_toggle_ordered_list__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(34582);
/* harmony import */ var _list_wrap_list__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(97110);
/* harmony import */ var _toggle_attributes__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(82794);
/* harmony import */ var _unwrap_children__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(89081);
/* harmony import */ var _wrap__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(73154);
/* harmony import */ var _wrap_unwrapped_text__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(83335);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 
















/***/ }),

/***/ 51676:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cache: function() { return /* binding */ cache; },
/* harmony export */   cacheHTML: function() { return /* binding */ cacheHTML; },
/* harmony export */   cached: function() { return /* binding */ cached; }
/* harmony export */ });
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69364);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28686);
/* harmony import */ var jodit_core_helpers_utils_error_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38027);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/decorators/cache/README.md]]
 * @packageDocumentation
 * @module decorators/cache
 */ 




/**
 * Retrieves a cached property value from an object if it exists; otherwise, returns `null`.
 *
 * This utility is particularly useful when working with properties that are lazily initialized
 * or dynamically created, such as getters or cached computations. It ensures you can safely
 * access the value without triggering initialization or creating a new instance.
 *
 * ### Usage Example:
 * ```typescript
 * import type { IUIElement } from "jodit";
 *
 * const { component, cache, cached } = Jodit.decorators;
 * const { UIElement } = Jodit.modules;
 *
 * @component
 * class SomeComponent extends UIElement {
 *   @cache
 *   get someElement(): IUIElement {
 *     return new UIElement(this.jodit);
 *   }
 *
 *   destruct() {
 *     // Use the cached utility to clean up only if the property is initialized
 *     cached(this, 'someElement')?.destruct();
 *     super.destruct();
 *   }
 * }
 * ```
 *
 * @param object - The object containing the property to check.
 * @param property - The name of the property to retrieve from the cache.
 * @returns The cached value of the property if it exists; otherwise, `null`.
 *
 * ### Notes:
 * - If the property is defined as a getter, the function will return `null`
 *   instead of invoking the getter.
 * - This function is non-destructive and does not alter the object's state.
 */ function cached(object, property) {
    const descriptor = Object.getOwnPropertyDescriptor(object, property);
    if (!descriptor || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_3__.isFunction)(descriptor.get)) {
        return null;
    }
    return descriptor.value;
}
/**
 * A decorator that caches the result of a getter method. Once the getter is accessed for the first time,
 * its computed value is stored as a property of the object. Subsequent accesses return the cached value
 * without recalculating it, improving performance and avoiding redundant computations.
 *
 * ### Key Features:
 * - **Lazy Initialization**: The original getter is invoked only once, the first time the property is accessed.
 * - **Immutability**: After caching, the value is stored as a non-writable, non-configurable property, preventing accidental modifications.
 * - **Conditional Caching**: If the returned value has a property `noCache` set to `true`, the caching mechanism is bypassed, and the getter is invoked each time.
 *
 * ### Usage Example 1: Basic Caching
 * ```typescript
 * import { cache } from './decorators';
 *
 * class Example {
 *   private counter = 0;
 *
 *   @cache
 *   get expensiveComputation(): number {
 *     console.log('Calculating...');
 *     return ++this.counter;
 *   }
 * }
 *
 * const instance = new Example();
 * console.log(instance.expensiveComputation); // Logs "Calculating..." and returns 1
 * console.log(instance.expensiveComputation); // Returns 1 (cached value, no calculation)
 * ```
 *
 * ### Usage Example 2: Integration with Cached Utilities
 * ```typescript
 * import { cache, cached } from './decorators';
 * import type { IUIElement } from "jodit";
 *
 * const { component } = Jodit.decorators;
 * const { UIElement } = Jodit.modules;
 *
 * @component
 * class SomeComponent extends UIElement {
 *   @cache
 *   get someElement(): IUIElement {
 *     return new UIElement(this.jodit);
 *   }
 *
 *   destruct() {
 *     // Use the cached utility to clean up only if the property is initialized
 *     cached(this, 'someElement')?.destruct();
 *     super.destruct();
 *   }
 * }
 * ```
 *
 * @param _ - The target object (not used directly).
 * @param name - The name of the property to decorate.
 * @param descriptor - The property descriptor, which must include a getter method.
 * @throws Will throw an error if the descriptor does not include a getter.
 *
 * ### Notes:
 * - **Performance**: Ideal for properties that are computationally expensive and do not change after the initial computation.
 * - **Flexibility**: Supports conditional caching via the `noCache` property in the returned value.
 * - **Compatibility**: Designed to work seamlessly with objects and classes in TypeScript or JavaScript.
 */ function cache(_, name, descriptor) {
    const getter = descriptor.get;
    if (!getter) {
        throw (0,jodit_core_helpers_utils_error_error__WEBPACK_IMPORTED_MODULE_4__.error)('Getter property descriptor expected');
    }
    descriptor.get = function() {
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
            if (this.isInDestruct) {
                console.error('Trying to access property in destructed component');
            }
        }
        const value = getter.call(this);
        if (value && value.noCache === true) {
            return value;
        }
        Object.defineProperty(this, name, {
            configurable: descriptor.configurable,
            enumerable: descriptor.enumerable,
            writable: false,
            value
        });
        return value;
    };
}
function cacheHTML(target, _, descriptor) {
    const fn = descriptor.value;
    if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_3__.isFunction)(fn)) {
        throw (0,jodit_core_helpers_utils_error_error__WEBPACK_IMPORTED_MODULE_4__.error)('Handler must be a Function');
    }
    let useCache = true;
    const cached = new WeakMap();
    descriptor.value = function(...attrs) {
        if (useCache && cached.has(this.constructor)) {
            var _cached_get;
            return (_cached_get = cached.get(this.constructor)) === null || _cached_get === void 0 ? void 0 : _cached_get.cloneNode(true);
        }
        const value = fn.apply(this, attrs);
        if (useCache && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__.Dom.isElement(value)) {
            cached.set(this.constructor, value);
        }
        return useCache ? value.cloneNode(true) : value;
    };
    target.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__.STATUSES.ready, (component)=>{
        const view = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_3__.isViewObject)(component) ? component : component.jodit;
        useCache = Boolean(view.options.cache);
    });
}


/***/ }),

/***/ 51822:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5266);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/resize-cells
 */ 
jodit_config__WEBPACK_IMPORTED_MODULE_0__.Config.prototype.tableAllowCellResize = true;


/***/ }),

/***/ 51957:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 48 48\"> <path d=\"M6 42h4v-4h-4v4zm4-28h-4v4h4v-4zm-4 20h4v-4h-4v4zm8 8h4v-4h-4v4zm-4-36h-4v4h4v-4zm8 0h-4v4h4v-4zm16 0h-4v4h4v-4zm-8 8h-4v4h4v-4zm0-8h-4v4h4v-4zm12 28h4v-4h-4v4zm-16 8h4v-4h-4v4zm-16-16h36v-4h-36v4zm32-20v4h4v-4h-4zm0 12h4v-4h-4v4zm-16 16h4v-4h-4v4zm8 8h4v-4h-4v4zm8 0h4v-4h-4v4z\"/> <path d=\"M0 0h48v48h-48z\" fill=\"none\"/> </svg>"

/***/ }),

/***/ 52100:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isPromise: function() { return /* binding */ isPromise; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ function isPromise(val) {
    return val && typeof val.then === 'function';
}


/***/ }),

/***/ 52144:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   set: function() { return /* binding */ set; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17312);
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(70222);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(62101);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85932);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 



/**
 * Safe access in tree object
 *
 * @example
 * ```js
 * const a = {}, b = {};
 * Jodit.modules.Helpers.set('a.b.c.d.e', 1, a);
 * console.log(a);// {a: {b: {c: {d: {e: 1}}}}}
 *
 * Jodit.modules.Helpers.set('a.0.e', 1, b);
 * console.log(b);// {a: [{e: 1}]}
 * ```
 */ function set(chain, value, obj) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__.isString)(chain) || !chain.length) {
        return;
    }
    const parts = chain.split('.');
    let result = obj, key = parts[0];
    for(let i = 0; i < parts.length - 1; i += 1){
        key = parts[i];
        if (!(0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__.isArray)(result[key]) && !(0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_2__.isPlainObject)(result[key])) {
            result[key] = (0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_1__.isNumeric)(parts[i + 1]) ? [] : {};
        }
        result = result[key];
    }
    if (result) {
        result[parts[parts.length - 1]] = value;
    }
}


/***/ }),

/***/ 52433:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasContainer: function() { return /* binding */ hasContainer; },
/* harmony export */   isDestructable: function() { return /* binding */ isDestructable; },
/* harmony export */   isInitable: function() { return /* binding */ isInitable; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91565);
/* harmony import */ var _is_void__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18303);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ 


/**
 * Check value has method init
 */ function isInitable(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_2__.isVoid)(value) && (0,_is_function__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value.init);
}
/**
 * Check value has method destruct
 */ function isDestructable(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_2__.isVoid)(value) && (0,_is_function__WEBPACK_IMPORTED_MODULE_1__.isFunction)(value.destruct);
}
/**
 * Check value is instant that implements IContainer
 */ function hasContainer(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_2__.isVoid)(value) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement(value.container);
}


/***/ }),

/***/ 52450:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M747 1521q74 32 140 32 376 0 376-335 0-114-41-180-27-44-61.5-74t-67.5-46.5-80.5-25-84-10.5-94.5-2q-73 0-101 10 0 53-.5 159t-.5 158q0 8-1 67.5t-.5 96.5 4.5 83.5 12 66.5zm-14-746q42 7 109 7 82 0 143-13t110-44.5 74.5-89.5 25.5-142q0-70-29-122.5t-79-82-108-43.5-124-14q-50 0-130 13 0 50 4 151t4 152q0 27-.5 80t-.5 79q0 46 1 69zm-541 889l2-94q15-4 85-16t106-27q7-12 12.5-27t8.5-33.5 5.5-32.5 3-37.5.5-34v-65.5q0-982-22-1025-4-8-22-14.5t-44.5-11-49.5-7-48.5-4.5-30.5-3l-4-83q98-2 340-11.5t373-9.5q23 0 68.5.5t67.5.5q70 0 136.5 13t128.5 42 108 71 74 104.5 28 137.5q0 52-16.5 95.5t-39 72-64.5 57.5-73 45-84 40q154 35 256.5 134t102.5 248q0 100-35 179.5t-93.5 130.5-138 85.5-163.5 48.5-176 14q-44 0-132-3t-132-3q-106 0-307 11t-231 12z\"/> </svg>"

/***/ }),

/***/ 52938:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   wrapText: function() { return /* binding */ wrapText; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/enter
 */ 
/**
 * If there is no container outside,
 * then we wrap all the nearest inline nodes in a container
 * @private
 */ function wrapText(fake, jodit) {
    let needWrap = fake;
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.up(needWrap, (node)=>{
        if (node && node.hasChildNodes() && node !== jodit.editor) {
            needWrap = node;
        }
    }, jodit.editor);
    const currentBox = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.wrapInline(needWrap, jodit.o.enter, jodit);
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isEmpty(currentBox)) {
        const br = jodit.createInside.element('br');
        currentBox.appendChild(br);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.before(br, fake);
    }
    return currentBox;
}


/***/ }),

/***/ 53202:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   loadTree: function() { return /* binding */ loadTree; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27795);
/* harmony import */ var jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1488);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ 


/**
 * Loads a list of directories
 * @private
 */ function loadTree(fb) {
    return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
        fb.tree.setMod('active', true);
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.detach(fb.tree.container);
        const items = (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_2__.loadItems)(fb);
        if (fb.o.showFoldersPanel) {
            fb.tree.setMod('loading', true);
            const tree = fb.dataProvider.tree(fb.state.currentPath, fb.state.currentSource).then((resp)=>{
                fb.state.sources = resp;
            }).catch(fb.status).finally(()=>fb.tree.setMod('loading', false));
            return Promise.all([
                tree,
                items
            ]);
        }
        fb.tree.setMod('active', false);
        return items;
    })();
}


/***/ }),

/***/ 53328:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 13 13\" xmlns=\"http://www.w3.org/2000/svg\"> <path d=\"M5.9814 11.8049C5.59087 11.4144 5.59087 10.7812 5.9814 10.3907L10.224 6.14806C10.6146 5.75754 11.2477 5.75754 11.6383 6.14806C12.0288 6.53859 12.0288 7.17175 11.6383 7.56228L7.39561 11.8049C7.00509 12.1954 6.37192 12.1954 5.9814 11.8049Z\"/> <path d=\"M0.707107 12.0208C0.316582 11.6303 0.316582 10.9971 0.707107 10.6066L10.6066 0.707121C10.9971 0.316597 11.6303 0.316596 12.0208 0.707121C12.4113 1.09764 12.4113 1.73081 12.0208 2.12133L2.12132 12.0208C1.7308 12.4114 1.09763 12.4114 0.707107 12.0208Z\"/> </svg>"

/***/ }),

/***/ 53390:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export formatBlock */
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28077);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(96863);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/format-block/README.md]]
 * @packageDocumentation
 * @module plugins/format-block
 */ 

/**
 * Process command - `formatblock`
 */ function formatBlock(editor) {
    editor.registerButton({
        name: 'paragraph',
        group: 'font'
    });
    editor.registerCommand('formatblock', (command, second, third)=>{
        editor.s.commitStyle({
            element: third
        });
        editor.synchronizeValues();
        return false;
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__.pluginSystem.add('formatBlock', formatBlock);


/***/ }),

/***/ 53414:
/***/ (function(module) {

module.exports["default"] = ["Type something","About Jodit","Jodit Editor","Jodit User's Guide","contains detailed help for using","For information about the license, please go to our website:","Buy full version","Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.","Anchor","Open in new tab","Open in fullsize","Clear Formatting","Fill color or set the text color","Redo","Undo","Bold","Italic","Insert Unordered List","Insert Ordered List","Align Center","Align Justify","Align Left","Align Right","Insert Horizontal Line","Insert Image","Insert file","Insert youtube/vimeo video","Insert link","Font size","Font family","Insert format block","Normal","Heading 1","Heading 2","Heading 3","Heading 4","Quote","Code","Insert","Insert table","Decrease Indent","Increase Indent","Select Special Character","Insert Special Character","Paint format","Change mode","Margins","top","right","bottom","left","Styles","Classes","Align","Right","Center","Left","--Not Set--","Src","Title","Alternative","Link","Open link in new tab","Image","file","Advanced","Image properties","Cancel","Ok","File Browser","Error on load list","Error on load folders","Are you sure?","Enter Directory name","Create directory","type name","Drop image","Drop file","or click","Alternative text","Upload","Browse","Background","Text","Top","Middle","Bottom","Insert column before","Insert column after","Insert row above","Insert row below","Delete table","Delete row","Delete column","Empty cell","Chars: %d","Words: %d","Strike through","Underline","superscript","subscript","Cut selection","Select all","Break","Search for","Replace with","Replace","Paste","Choose Content to Paste","source","bold","italic","brush","link","undo","redo","table","image","eraser","paragraph","fontsize","video","font","about","print","underline","strikethrough","indent","outdent","fullsize","shrink","hr","ul","ol","cut","selectall","Embed code","Open link","Edit link","No follow","Unlink","Update","pencil","Eye"," URL","Edit","Horizontal align","Filter","Sort by changed","Sort by name","Sort by size","Add folder","Reset","Save","Save as ...","Resize","Crop","Width","Height","Keep Aspect Ratio","Yes","No","Remove","Select","Select %s","Vertical align","Split","Merge","Add column","Add row","License: %s","Delete","Split vertical","Split horizontal","Border","Your code is similar to HTML. Keep as HTML?","Paste as HTML","Keep","Insert as Text","Insert only Text","You can only edit your own images. Download this image on the host?","The image has been successfully uploaded to the host!","palette","There are no files","Rename","Enter new name","preview","download","Paste from clipboard","Your browser doesn't support direct access to the clipboard.","Copy selection","copy","Border radius","Show all","Apply","Please fill out this field","Please enter a web address","Default","Circle","Dot","Quadrate","Find","Find Previous","Find Next","The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?","Word Paste Detected","Clean","Insert className","Press Alt for custom resizing","Line height","spellcheck","Speech Recognize","All"]

/***/ }),

/***/ 53514:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   removeInvTextNodes: function() { return /* binding */ removeInvTextNodes; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/clean-html
 */ 

/**
 * @private
 */ function removeInvTextNodes(jodit, node, hadEffect, arg, argi, currentNode) {
    if (currentNode === node || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(node) || node.nodeValue == null) {
        return hadEffect;
    }
    if (!(0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP)().test(node.nodeValue)) {
        return hadEffect;
    }
    const focusBox = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.furthest(currentNode, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isBlock, jodit.editor);
    if (!focusBox || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isOrContains(focusBox, node)) {
        return hadEffect;
    }
    node.nodeValue = node.nodeValue.replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP)(), '');
    if (node === currentNode && jodit.s.isCollapsed()) {
        jodit.s.setCursorAfter(node);
    }
    if (!node.nodeValue) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(node);
    }
    return true;
}


/***/ }),

/***/ 53681:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Button: function() { return /* binding */ Button; },
/* harmony export */   UIButton: function() { return /* binding */ UIButton; },
/* harmony export */   UIButtonState: function() { return /* binding */ UIButtonState; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69364);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91565);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85932);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(93640);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(96007);
/* harmony import */ var jodit_core_ui_group_list__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(97959);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(29434);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/button
 */ 











const UIButtonState = ()=>({
        size: 'middle',
        type: 'button',
        role: 'button',
        name: '',
        value: '',
        variant: 'initial',
        disabled: false,
        activated: false,
        icon: {
            name: 'empty',
            fill: '',
            iconURL: ''
        },
        tooltip: '',
        text: '',
        tabIndex: undefined
    });
class UIButton extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_8__.UIElement {
    /** @override */ className() {
        return 'UIButton';
    }
    /**
	 * Set state
	 */ setState(state) {
        Object.assign(this.state, state);
        return this;
    }
    /**
	 * DOM container for text content
	 */ get text() {
        const text = this.getElm('text');
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.assert)(text, 'Text element not found');
        return text;
    }
    /**
	 * DOM container for icon
	 */ get icon() {
        const icon = this.getElm('icon');
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.assert)(icon, 'Icon element not found');
        return icon;
    }
    onChangeSize() {
        this.setMod('size', this.state.size);
    }
    onChangeType() {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(this.container, 'type', this.state.type);
    }
    onChangeRole() {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(this.container, 'role', this.state.role);
    }
    /**
	 * Set size from a parent list
	 */ updateSize() {
        const pe = this.closest(jodit_core_ui_group_list__WEBPACK_IMPORTED_MODULE_9__.UIList);
        if (pe) {
            this.state.size = pe.buttonSize;
            return;
        }
    }
    onChangeStatus() {
        this.setMod('variant', this.state.variant);
    }
    onChangeText() {
        this.text.textContent = this.jodit.i18n(this.state.text);
    }
    onChangeTextSetMode() {
        this.setMod('text-icons', Boolean(this.state.text.trim().length));
    }
    onChangeDisabled() {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(this.container, 'disabled', this.state.disabled || null);
    }
    onChangeActivated() {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(this.container, 'aria-pressed', this.state.activated);
    }
    onChangeName() {
        this.container.classList.add(`${this.componentName}_${this.clearName(this.state.name)}`);
        this.name = this.state.name;
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(this.container, 'data-ref', this.state.name);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(this.container, 'ref', this.state.name);
    }
    onChangeTooltip() {
        if (this.get('j.o.useNativeTooltip')) {
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(this.container, 'title', this.state.tooltip);
        }
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(this.container, 'aria-label', this.state.tooltip);
    }
    onChangeTabIndex() {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(this.container, 'tabindex', this.state.tabIndex);
    }
    onChangeIcon() {
        const textIcons = this.get('j.o.textIcons');
        if (textIcons === true || (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__.isFunction)(textIcons) && textIcons(this.state.name)) {
            return;
        }
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.detach(this.icon);
        const iconElement = jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_10__.Icon.makeIcon(this.j, this.state.icon);
        iconElement && this.icon.appendChild(iconElement);
    }
    /**
	 * Set focus on an element
	 */ focus() {
        this.container.focus();
    }
    /**
	 * Element has focus
	 */ isFocused() {
        const { activeElement } = this.od;
        return Boolean(activeElement && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.isOrContains(this.container, activeElement));
    }
    /** @override */ createContainer() {
        const cn = this.componentName;
        const button = this.j.c.element('button', {
            class: cn,
            type: 'button',
            role: 'button',
            ariaPressed: false
        });
        const icon = this.j.c.span(cn + '__icon');
        const text = this.j.c.span(cn + '__text');
        button.appendChild(icon);
        button.appendChild(text);
        return button;
    }
    destruct() {
        this.j.e.off(this.container);
        return super.destruct();
    }
    /**
	 * Add action handler
	 */ onAction(callback) {
        this.actionHandlers.push(callback);
        return this;
    }
    /**
	 * Fire all click handlers
	 */ __onActionFire(e) {
        e.buffer = {
            actionTrigger: this
        };
        this.actionHandlers.forEach((callback)=>callback.call(this, e));
    }
    constructor(jodit, state){
        super(jodit), /**
	 * Marker for buttons
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "isButton", true), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "state", UIButtonState()), /**
	 * DOM container for button
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "button", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "actionHandlers", []);
        this.button = this.container;
        this.updateSize();
        this.onChangeSize();
        this.onChangeStatus();
        if (state) {
            this.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_2__.STATUSES.ready, ()=>{
                this.setState(state);
            });
        }
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.cache
], UIButton.prototype, "text", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.cache
], UIButton.prototype, "icon", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.size', {
        immediately: false
    })
], UIButton.prototype, "onChangeSize", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.type', {
        immediately: false
    })
], UIButton.prototype, "onChangeType", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.role', {
        immediately: false
    })
], UIButton.prototype, "onChangeRole", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('parentElement')
], UIButton.prototype, "updateSize", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.variant', {
        immediately: false
    })
], UIButton.prototype, "onChangeStatus", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.text', {
        immediately: false
    })
], UIButton.prototype, "onChangeText", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.text', {
        immediately: false
    })
], UIButton.prototype, "onChangeTextSetMode", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.disabled')
], UIButton.prototype, "onChangeDisabled", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.activated')
], UIButton.prototype, "onChangeActivated", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.name', {
        immediately: false
    })
], UIButton.prototype, "onChangeName", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.tooltip', {
        immediately: false
    })
], UIButton.prototype, "onChangeTooltip", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.tabIndex', {
        immediately: false
    })
], UIButton.prototype, "onChangeTabIndex", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('state.icon', {
        immediately: false
    })
], UIButton.prototype, "onChangeIcon", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.cacheHTML
], UIButton.prototype, "createContainer", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('button:click')
], UIButton.prototype, "__onActionFire", null);
UIButton = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.component
], UIButton);
function Button(jodit, stateOrText, text, variant) {
    const button = new UIButton(jodit);
    button.state.tabIndex = jodit.o.allowTabNavigation ? 0 : -1;
    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_6__.isString)(stateOrText)) {
        button.state.icon.name = stateOrText;
        button.state.name = stateOrText;
        if (variant) {
            button.state.variant = variant;
        }
        if (text) {
            button.state.text = text;
        }
    } else {
        button.setState(stateOrText);
    }
    return button;
}


/***/ }),

/***/ 53808:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M512 1536h768v-384h-768v384zm896 0h128v-896q0-14-10-38.5t-20-34.5l-281-281q-10-10-34-20t-39-10v416q0 40-28 68t-68 28h-576q-40 0-68-28t-28-68v-416h-128v1280h128v-416q0-40 28-68t68-28h832q40 0 68 28t28 68v416zm-384-928v-320q0-13-9.5-22.5t-22.5-9.5h-192q-13 0-22.5 9.5t-9.5 22.5v320q0 13 9.5 22.5t22.5 9.5h192q13 0 22.5-9.5t9.5-22.5zm640 32v928q0 40-28 68t-68 28h-1344q-40 0-68-28t-28-68v-1344q0-40 28-68t68-28h928q40 0 88 20t76 48l280 280q28 28 48 76t20 88z\"/> </svg>"

/***/ }),

/***/ 53855:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   History: function() { return /* binding */ History; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16964);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5266);
/* harmony import */ var _command__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8838);
/* harmony import */ var _snapshot__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(46363);
/* harmony import */ var _stack__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(33511);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/history/README.md]]
 * @packageDocumentation
 * @module modules/history
 */ 







jodit_config__WEBPACK_IMPORTED_MODULE_4__.Config.prototype.history = {
    enable: true,
    maxHistoryLength: Infinity,
    timeout: 1000
};
/**
 * The module monitors the status of the editor and creates / deletes the required number of Undo / Redo shots .
 */ class History extends jodit_core_component__WEBPACK_IMPORTED_MODULE_2__.ViewComponent {
    /** @override */ className() {
        return 'History';
    }
    /**
	 * Return state of the WYSIWYG editor to step back
	 */ redo() {
        if (this.__stack.redo()) {
            this.startValue = this.snapshot.make();
            this.fireChangeStack();
        }
    }
    canRedo() {
        return this.__stack.canRedo();
    }
    /**
	 * Return the state of the WYSIWYG editor to step forward
	 */ undo() {
        if (this.__stack.undo()) {
            this.startValue = this.snapshot.make();
            this.fireChangeStack();
        }
    }
    canUndo() {
        return this.__stack.canUndo();
    }
    clear() {
        this.startValue = this.snapshot.make();
        this.__stack.clear();
        this.fireChangeStack();
    }
    get length() {
        return this.__stack.length;
    }
    get startValue() {
        return this.__startValue;
    }
    set startValue(value) {
        this.__startValue = value;
    }
    /**
	 * Update change counter
	 * @internal
	 */ __upTick() {
        this.updateTick += 1;
    }
    /**
	 * Push new command in stack on some changes
	 */ onChange() {
        this.__processChanges();
    }
    /**
	 * @internal
	 */ __processChanges() {
        if (this.snapshot.isBlocked || !this.j.o.history.enable) {
            return;
        }
        this.updateStack();
    }
    /**
	 * Update history stack
	 */ updateStack(replace = false) {
        const newValue = this.snapshot.make();
        if (!_snapshot__WEBPACK_IMPORTED_MODULE_6__.Snapshot.equal(newValue, this.startValue)) {
            const newCommand = new _command__WEBPACK_IMPORTED_MODULE_5__.Command(this.startValue, newValue, this, this.updateTick);
            if (replace) {
                const command = this.__stack.current();
                if (command && this.updateTick === command.tick) {
                    this.__stack.replace(newCommand);
                }
            } else {
                this.__stack.push(newCommand);
            }
            this.startValue = newValue;
            this.fireChangeStack();
        }
    }
    fireChangeStack() {
        var _this_j_events;
        this.j && !this.j.isInDestruct && ((_this_j_events = this.j.events) === null || _this_j_events === void 0 ? void 0 : _this_j_events.fire('changeStack'));
    }
    destruct() {
        if (this.isInDestruct) {
            return;
        }
        if (this.j.events) {
            this.j.e.off('.history');
        }
        this.snapshot.destruct();
        super.destruct();
    }
    constructor(editor, stack = new _stack__WEBPACK_IMPORTED_MODULE_7__.Stack(editor.o.history.maxHistoryLength), snapshot = new _snapshot__WEBPACK_IMPORTED_MODULE_6__.Snapshot(editor)){
        super(editor), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__startValue", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__stack", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "snapshot", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "updateTick", 0);
        this.__stack = stack;
        this.snapshot = snapshot;
        if (editor.o.history.enable) {
            editor.e.on('afterAddPlace.history', ()=>{
                if (this.isInDestruct) {
                    return;
                }
                this.startValue = this.snapshot.make();
                editor.events// save selection
                .on('internalChange internalUpdate', ()=>{
                    this.startValue = this.snapshot.make();
                }).on(editor.editor, [
                    'changeSelection',
                    'selectionstart',
                    'selectionchange',
                    'mousedown',
                    'mouseup',
                    'keydown',
                    'keyup'
                ].map((f)=>f + '.history').join(' '), ()=>{
                    if (this.startValue.html === this.j.getNativeEditorValue()) {
                        this.startValue = this.snapshot.make();
                    }
                }).on(this, 'change.history', this.onChange);
            });
        }
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.debounce)()
], History.prototype, "onChange", null);


/***/ }),

/***/ 54053:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getHash: function() { return /* reexport safe */ _get_hash__WEBPACK_IMPORTED_MODULE_0__.getHash; },
/* harmony export */   removeFormatForCollapsedSelection: function() { return /* reexport safe */ _remove_format_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_1__.removeFormatForCollapsedSelection; },
/* harmony export */   removeFormatForSelection: function() { return /* reexport safe */ _remove_format_remove_format_for_selection__WEBPACK_IMPORTED_MODULE_2__.removeFormatForSelection; },
/* harmony export */   visitNodeWalker: function() { return /* reexport safe */ _visitor_visit_node_walker__WEBPACK_IMPORTED_MODULE_3__.visitNodeWalker; }
/* harmony export */ });
/* harmony import */ var _get_hash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5650);
/* harmony import */ var _remove_format_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37431);
/* harmony import */ var _remove_format_remove_format_for_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(70195);
/* harmony import */ var _visitor_visit_node_walker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45219);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/clean-html
 */ 





/***/ }),

/***/ 54055:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    symbols: 'caractère'
};


/***/ }),

/***/ 54308:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   askInsertTypeDialog: function() { return /* binding */ askInsertTypeDialog; },
/* harmony export */   getAllTypes: function() { return /* binding */ getAllTypes; },
/* harmony export */   pasteInsertHtml: function() { return /* binding */ pasteInsertHtml; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28686);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53681);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/paste
 */ 



/**
 * Remove special HTML comments
 * @private
 */ function removeExtraFragments(html) {
    html = html.replace(/<meta[^>]+?>/g, '');
    const start = html.search(/<!--StartFragment-->/i);
    if (start !== -1) {
        html = html.substring(start + 20);
    }
    const end = html.search(/<!--EndFragment-->/i);
    if (end !== -1) {
        html = html.substring(0, end);
    }
    return html;
}
/**
 * @private
 */ function isDragEvent(e) {
    return Boolean(e && e.type === 'drop');
}
/**
 * One insert point for clipboard plugins
 * @private
 */ function pasteInsertHtml(e, editor, html) {
    if (editor.isInDestruct) {
        return;
    }
    if (isDragEvent(e)) {
        editor.s.insertCursorAtPoint(e.clientX, e.clientY);
    }
    const result = editor.e.fire('beforePasteInsert', html);
    if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isVoid)(result) && ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isString)(result) || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isNumber)(result) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isNode(result))) {
        html = result;
    }
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isString)(html)) {
        html = removeExtraFragments(html);
    }
    editor.s.insertHTML(html);
}
/**
 * Return all available data types in event
 * @private
 */ function getAllTypes(dt) {
    const types = dt.types;
    let types_str = '';
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isArray)(types) || ({}).toString.call(types) === '[object DOMStringList]') {
        for(let i = 0; i < types.length; i += 1){
            types_str += types[i] + ';';
        }
    } else {
        types_str = (types || jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_PLAIN).toString() + ';';
    }
    return types_str;
}
/**
 * Make command dialog
 * @private
 */ function askInsertTypeDialog(jodit, msg, title, callback, buttonList) {
    if (jodit.e.fire('beforeOpenPasteDialog', msg, title, callback, buttonList) === false) {
        return;
    }
    const dialog = jodit.confirm(`<div style="word-break: normal; white-space: normal">${jodit.i18n(msg)}</div>`, jodit.i18n(title));
    const buttons = buttonList.map(({ text, value })=>(0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_3__.Button)(jodit, {
            text,
            name: text.toLowerCase(),
            tabIndex: 0
        }).onAction(()=>{
            dialog.close();
            callback(value);
        }));
    dialog.e.one(dialog, 'afterClose', ()=>{
        if (!jodit.s.isFocused()) {
            jodit.s.focus();
        }
    });
    const cancel = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_3__.Button)(jodit, {
        text: 'Cancel',
        tabIndex: 0
    }).onAction(()=>{
        dialog.close();
    });
    dialog.setFooter([
        ...buttons,
        cancel
    ]);
    buttons[0].focus();
    buttons[0].state.variant = 'primary';
    jodit.e.fire('afterOpenPasteDialog', dialog, msg, title, callback, buttonList);
    return dialog;
}


/***/ }),

/***/ 54447:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getContentWidth: function() { return /* binding */ getContentWidth; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/size
 */ const getContentWidth = (element, win)=>{
    const pi = (value)=>parseInt(value, 10), style = win.getComputedStyle(element), width = element.offsetWidth, paddingLeft = pi(style.getPropertyValue('padding-left') || '0'), paddingRight = pi(style.getPropertyValue('padding-right') || '0');
    return width - paddingLeft - paddingRight;
};


/***/ }),

/***/ 54500:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5266);
/* harmony import */ var _icons_crop_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(928);
/* harmony import */ var _icons_crop_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_icons_crop_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _icons_resize_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31230);
/* harmony import */ var _icons_resize_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_icons_resize_svg__WEBPACK_IMPORTED_MODULE_3__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/image-editor
 */ 



jodit_config__WEBPACK_IMPORTED_MODULE_1__.Config.prototype.imageeditor = {
    min_width: 20,
    min_height: 20,
    closeAfterSave: false,
    width: '85%',
    height: '85%',
    crop: true,
    resize: true,
    resizeUseRatio: true,
    resizeMinWidth: 20,
    resizeMinHeight: 20,
    cropUseRatio: true,
    cropDefaultWidth: '70%',
    cropDefaultHeight: '70%'
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__.Icon.set('crop', (_icons_crop_svg__WEBPACK_IMPORTED_MODULE_2___default())).set('resize', (_icons_resize_svg__WEBPACK_IMPORTED_MODULE_3___default()));


/***/ }),

/***/ 54522:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' x=\"0px\" y=\"0px\" viewBox=\"0 0 459 459\"> <g> <path d=\"M229.5,0C102,0,0,102,0,229.5S102,459,229.5,459c20.4,0,38.25-17.85,38.25-38.25c0-10.2-2.55-17.85-10.2-25.5 c-5.1-7.65-10.2-15.3-10.2-25.5c0-20.4,17.851-38.25,38.25-38.25h45.9c71.4,0,127.5-56.1,127.5-127.5C459,91.8,357,0,229.5,0z M89.25,229.5c-20.4,0-38.25-17.85-38.25-38.25S68.85,153,89.25,153s38.25,17.85,38.25,38.25S109.65,229.5,89.25,229.5z M165.75,127.5c-20.4,0-38.25-17.85-38.25-38.25S145.35,51,165.75,51S204,68.85,204,89.25S186.15,127.5,165.75,127.5z M293.25,127.5c-20.4,0-38.25-17.85-38.25-38.25S272.85,51,293.25,51s38.25,17.85,38.25,38.25S313.65,127.5,293.25,127.5z M369.75,229.5c-20.4,0-38.25-17.85-38.25-38.25S349.35,153,369.75,153S408,170.85,408,191.25S390.15,229.5,369.75,229.5z\" /> </g> </svg>"

/***/ }),

/***/ 54794:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fastClone: function() { return /* binding */ fastClone; },
/* harmony export */   isAtom: function() { return /* binding */ isAtom; },
/* harmony export */   markAsAtomic: function() { return /* binding */ markAsAtomic; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_stringify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3347);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 
function isAtom(obj) {
    return obj && obj.isAtom;
}
function markAsAtomic(obj) {
    Object.defineProperty(obj, 'isAtom', {
        enumerable: false,
        value: true,
        configurable: false
    });
    return obj;
}
function fastClone(object) {
    return JSON.parse((0,jodit_core_helpers_string_stringify__WEBPACK_IMPORTED_MODULE_0__.stringify)(object));
}


/***/ }),

/***/ 55184:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   debounce: function() { return /* binding */ debounce; },
/* harmony export */   throttle: function() { return /* binding */ throttle; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16964);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28686);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33201);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/decorators/debounce/README.md]]
 * @packageDocumentation
 * @module decorators/debounce
 */ 



function debounce(timeout, firstCallImmediately = false, method = 'debounce') {
    return (target, propertyKey)=>{
        const fn = target[propertyKey];
        if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__.isFunction)(fn)) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__.error)('Handler must be a Function');
        }
        target.hookStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.STATUSES.ready, (component)=>{
            const { async } = component;
            (0,jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__.assert)(async != null, `Component ${component.componentName || component.constructor.name} should have "async:IAsync" field`);
            const propTimeout = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__.isFunction)(timeout) ? timeout(component) : timeout;
            const realTimout = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__.isNumber)(propTimeout) || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(propTimeout) ? propTimeout : component.defaultTimeout;
            Object.defineProperty(component, propertyKey, {
                configurable: true,
                value: async[method](component[propertyKey].bind(component), realTimout, firstCallImmediately)
            });
        });
        return {
            configurable: true,
            get () {
                return fn.bind(this);
            }
        };
    };
}
/**
 * Wrap function in throttle wrapper
 */ function throttle(timeout, firstCallImmediately = false) {
    return debounce(timeout, firstCallImmediately, 'throttle');
}


/***/ }),

/***/ 55376:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileBrowserTree: function() { return /* binding */ FileBrowserTree; }
/* harmony export */ });
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4099);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ 

class FileBrowserTree extends jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__.UIGroup {
    className() {
        return 'FileBrowserTree';
    }
}


/***/ }),

/***/ 55810:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   init: function() { return /* binding */ init; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28686);
/* harmony import */ var _load__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3050);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugin
 */ 



/**
 * Init plugin if it has no dependencies, in another case wait requires plugins will be init
 * @private
 */ function init(jodit, pluginName, plugin, instance, doneList, waitingList) {
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__.isInitable)(instance)) {
        try {
            instance.init(jodit);
        } catch (e) {
            console.error(e);
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                throw e;
            }
        }
    }
    doneList.set(pluginName, instance);
    waitingList.delete(pluginName);
    if (instance.hasStyle) {
        (0,_load__WEBPACK_IMPORTED_MODULE_3__.loadStyle)(jodit, pluginName).catch((e)=>{
            !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && console.error(e);
        });
    }
    if (instance.styles) {
        const style = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_1__.getContainer)(jodit, pluginName, 'style');
        style.innerHTML = instance.styles;
    }
}


/***/ }),

/***/ 56014:
/***/ (function(module) {

module.exports["default"] = ["Napiš něco","O Jodit","Editor Jodit","Jodit Uživatelská příručka","obsahuje detailní nápovědu","Pro informace o licenci, prosím, přejděte na naši stránku:","Koupit plnou verzi","Copyright © XDSoft.net - Chupurnov Valeriy. Všechna práva vyhrazena.","Anchor","Otevřít v nové záložce","Otevřít v celoobrazovkovém režimu","Vyčistit formátování","Barva výplně a písma","Vpřed","Zpět","Tučné","Kurzíva","Odrážky","Číslovaný seznam","Zarovnat na střed","Zarovnat do bloku","Zarovnat vlevo","Zarovnat vpravo","Vložit horizontální linku","Vložit obrázek","Vložit soubor","Vložit video (YT/Vimeo)","Vložit odkaz","Velikost písma","Typ písma","Formátovat blok","Normální text","Nadpis 1","Nadpis 2","Nadpis 3","Nadpis 4","Citát","Kód","Vložit","Vložit tabulku","Zmenšit odsazení","Zvětšit odsazení","Vybrat speciální symbol","Vložit speciální symbol","Použít formát","Změnit mód","Okraje","horní","pravý","spodní","levý","Styly","Třídy","Zarovnání","Vpravo","Na střed","Vlevo","--nenastaveno--","src","Titulek","Alternativní text (alt)","Link","Otevřít link v nové záložce","Obrázek","soubor","Rozšířené","Vlastnosti obrázku","Zpět","Ok","Prohlížeč souborů","Chyba při načítání seznamu souborů","Chyba při načítání složek","Jste si jistý(á)?","Název složky","Vytvořit složku","název","Přetáhněte sem obrázek","Přetáhněte sem soubor","nebo klikněte","Alternativní text","Nahrát","Server","Pozadí","Text","Nahoru","Na střed","Dolu","Vložit sloupec před","Vložit sloupec za","Vložit řádek nad","Vložit řádek pod","Vymazat tabulku","Vymazat řádku","Vymazat sloupec","Vyčistit buňku","Znaky: %d","Slova: %d","Přeškrtnuto","Podtrženo","Horní index","Dolní index","Vyjmout označené","Označit vše","Zalomení","Najdi","Nahradit za","Vyměňte","Vložit","Vyber obsah pro vložení","HTML","tučně","kurzíva","štětec","odkaz","zpět","vpřed","tabulka","obrázek","guma","odstavec","velikost písma","video","písmo","о editoru","tisk","podtrženo","přeškrtnuto","zvětšit odsazení","zmenšit odsazení","celoobrazovkový režim","smrsknout","Linka","Odrážka","Číslovaný seznam","Vyjmout","Označit vše","Kód","Otevřít odkaz","Upravit odkaz","Atribut no-follow","Odstranit odkaz","Aktualizovat","Chcete-li upravit","Zobrazit","URL","Editovat","Horizontální zarovnání","Filtr","Dle poslední změny","Dle názvu","Dle velikosti","Přidat složku","Reset","Uložit","Uložit jako...","Změnit rozměr","Ořezat","Šířka","Výška","Ponechat poměr","Ano","Ne","Vyjmout","Označit","Označit %s","Vertikální zarovnání","Rozdělit","Spojit","Přidat sloupec","Přidat řádek","Licence: %s","Vymazat","Rozdělit vertikálně","Rozdělit horizontálně","Okraj","Váš text se podobá HTML. Vložit ho jako HTML?","Vložit jako HTML","Ponechat originál","Vložit jako TEXT","Vložit pouze TEXT","Můžete upravovat pouze své obrázky. Načíst obrázek?","Obrázek byl úspěšně nahrán!","paleta","V tomto adresáři nejsou žádné soubory.","přejmenovat","Zadejte nový název","náhled","Stažení","Vložit ze schránky","Váš prohlížeč nepodporuje přímý přístup do schránky.","Kopírovat výběr","kopírování","Border radius","Zobrazit všechny","Platí","Prosím, vyplňte toto pole","Prosím, zadejte webovou adresu","Výchozí","Kruh","Dot","Quadrate","Najít","Najít Předchozí","Najít Další","Obsah, který vkládáte, je pravděpodobně z Microsoft Word / Excel. Chcete ponechat formát nebo vložit pouze text?","Detekován fragment z Wordu nebo Excelu","Vyčistit","Vložte název třídy","Stiskněte Alt pro vlastní změnu velikosti",null,null,null,"Vše"]

/***/ }),

/***/ 56490:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Popup: function() { return /* reexport safe */ _popup__WEBPACK_IMPORTED_MODULE_0__.Popup; }
/* harmony export */ });
/* harmony import */ var _popup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(51116);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/popup
 */ 


/***/ }),

/***/ 57075:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   previewBox: function() { return /* binding */ previewBox; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85932);
/* harmony import */ var _attr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7909);
/* harmony import */ var _css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80991);
/* harmony import */ var _selector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28723);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 




/**
 * Fixes image sizes and sets absolute paths to images
 */ function fixedAssetsSizeAndAbsoluteLinks(editor, points) {
    const restoreAttributes = [];
    try {
        (0,_selector__WEBPACK_IMPORTED_MODULE_4__.$$)('img', editor.editor).forEach((item)=>{
            const previousAttrs = [
                (0,_attr__WEBPACK_IMPORTED_MODULE_2__.attr)(item, 'width'),
                (0,_attr__WEBPACK_IMPORTED_MODULE_2__.attr)(item, 'height'),
                item.src
            ];
            (0,_attr__WEBPACK_IMPORTED_MODULE_2__.attr)(item, {
                width: item.offsetWidth + points,
                height: item.offsetHeight + points
            });
            const a = editor.createInside.a();
            editor.ed.body.appendChild(a);
            a.href = item.src;
            item.src = a.href;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.safeRemove(a);
            restoreAttributes.push(()=>{
                var _previousAttrs_;
                item.src = (_previousAttrs_ = previousAttrs[2]) !== null && _previousAttrs_ !== void 0 ? _previousAttrs_ : '';
                (0,_attr__WEBPACK_IMPORTED_MODULE_2__.attr)(item, {
                    width: previousAttrs[0] || null,
                    height: previousAttrs[1] || null
                });
            });
        });
    } catch (e) {
        restoreAttributes.forEach((c)=>c());
        restoreAttributes.length = 0;
        throw e;
    }
    return restoreAttributes;
}
/**
 * Generates a copy of an HTML document, resizes images, executes JS
 *
 * @event beforePreviewBox(string | undefined, 'pt' | 'px' | '')
 * @event afterPreviewBox(HTMLElement)
 */ function previewBox(editor, defaultValue, points = 'px', container = null) {
    const onDestruct = [];
    const restoreAttributes = fixedAssetsSizeAndAbsoluteLinks(editor, points);
    try {
        const res = editor.e.fire('beforePreviewBox', defaultValue, points);
        if (res != null) {
            return res;
        }
        let div = editor.c.div('jodit__preview-box jodit-context');
        if (container) {
            container.appendChild(div);
        }
        (0,_css__WEBPACK_IMPORTED_MODULE_3__.css)(div, {
            position: 'relative',
            padding: 16
        });
        const value = editor.value || `<div style='position: absolute;left:50%;top:50%;transform: translateX(-50%) translateY(-50%);color:#ccc;'>${editor.i18n('Empty')}</div>`;
        if (editor.iframe) {
            const iframe = editor.create.element('iframe');
            (0,_css__WEBPACK_IMPORTED_MODULE_3__.css)(iframe, {
                minWidth: 800,
                minHeight: 600,
                border: 0
            });
            div.appendChild(iframe);
            const myWindow = iframe.contentWindow;
            if (myWindow) {
                editor.e.fire('generateDocumentStructure.iframe', myWindow.document, editor);
                div = myWindow.document.body;
                if (typeof ResizeObserver === 'function') {
                    let destructed = false;
                    const elm = myWindow.document.body;
                    const resizeObserver = new ResizeObserver(editor.async.debounce(()=>{
                        resizeObserver.unobserve(elm);
                        iframe.style.height = `${elm.offsetHeight + 20}px`;
                        editor.async.requestAnimationFrame(()=>{
                            !destructed && resizeObserver.observe(elm);
                        });
                    }, 100));
                    const beforeDestruct = ()=>{
                        destructed = true;
                        resizeObserver.unobserve(elm);
                        resizeObserver.disconnect();
                        editor.e.off('beforeDestruct', beforeDestruct);
                    };
                    onDestruct.push(beforeDestruct);
                    editor.e.on('beforeDestruct', beforeDestruct);
                }
            }
        } else {
            (0,_css__WEBPACK_IMPORTED_MODULE_3__.css)(div, {
                minWidth: 1024,
                minHeight: 600,
                border: 0
            });
        }
        const setHTML = (box, value)=>{
            const dv = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__.isString)(value) ? editor.c.div() : value;
            if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__.isString)(value)) {
                dv.innerHTML = value;
            }
            for(let i = 0; i < dv.childNodes.length; i += 1){
                const c = dv.childNodes[i];
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isElement(c)) {
                    const newNode = box.ownerDocument.createElement(c.nodeName);
                    for(let j = 0; j < c.attributes.length; j += 1){
                        (0,_attr__WEBPACK_IMPORTED_MODULE_2__.attr)(newNode, c.attributes[j].nodeName, c.attributes[j].nodeValue);
                    }
                    if (c.childNodes.length === 0 || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isTag(c, 'table')) {
                        switch(c.nodeName){
                            case 'SCRIPT':
                                if (c.textContent) {
                                    newNode.textContent = c.textContent;
                                }
                                break;
                            default:
                                if (c.innerHTML) {
                                    newNode.innerHTML = c.innerHTML;
                                }
                                break;
                        }
                    } else {
                        setHTML(newNode, c);
                    }
                    try {
                        box.appendChild(newNode);
                    } catch (e) {}
                } else {
                    try {
                        box.appendChild(c.cloneNode(true));
                    } catch (e) {}
                }
            }
        };
        setHTML(div, value);
        editor.e.fire('afterPreviewBox', div);
        return [
            div,
            ()=>{
                onDestruct.forEach((cb)=>cb());
            }
        ];
    } finally{
        restoreAttributes.forEach((clb)=>clb());
    }
}


/***/ }),

/***/ 57339:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   readSizes: function() { return /* binding */ readSizes; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(70222);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7909);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80991);
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(10808);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/image-properties
 */ 




/** @private */ function readSizes(image, values, state) {
    return (0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
        yield image.decode();
        const width = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__.css)(image, 'width', true) || (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__.attr)(image, 'width') || false;
        const height = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__.css)(image, 'height', true) || (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__.attr)(image, 'height') || false;
        values.imageWidth = width !== false ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_4__.normalSizeFromString)(width) : image.offsetWidth || image.naturalWidth;
        if ((0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_1__.isNumeric)(values.imageWidth)) {
            values.imageHeight = height !== false ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_4__.normalSizeFromString)(height) : image.offsetHeight || image.naturalHeight;
        } else {
            values.imageHeight = height || '';
        }
        const { imageWidth, imageHeight } = values;
        const w = parseFloat(imageWidth.toString());
        if (!(0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_1__.isNumeric)(imageWidth) || !(0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_1__.isNumeric)(imageHeight)) {
            state.sizeIsLocked = false;
            return;
        }
        if (height === false) {
            values.imageHeight = Math.round(w / state.ratio);
            state.sizeIsLocked = true;
            return;
        }
        const h = parseFloat(imageHeight.toString());
        state.sizeIsLocked = Math.abs(w - h * state.ratio) < 1;
    })();
}


/***/ }),

/***/ 57456:
/***/ (function(module) {

module.exports["default"] = ["Напишіть щось","Про Jodit","Редактор Jodit","Jodit інструкція користувача","містить детальну інформацію щодо користування","Щоб дізнатись більше про ліцензію , будь ласка, перейдіть на наш сайт:","Купити повну версію","Авторські права © XDSoft.net - Чупурнов Валерій. Всі права захищені.","Анкор","Відкрити у новій вкладці","Відкрити редактор в повному розмірі","Очистити форматування","Колір заливки або колір текста","Повторити","Відмінити","Жирний","Курсів","Вставити невпорядкований список","Вставити нумерованний список","Вирівняти по центру","Вирівняти по ширині","Вирівняти по лівому краю","Вирівняти по правому краю","Вставити горизонтальну лінію","Вставити зображення","Вставити файл","Вставити відео","Вставити посилання","Розмір шрифту","Шрифт","Вставити блочний елемент","Нормальний текст","Заголовок 1","Заголовок 2","Заголовок 3","Заголовок 4","Цитата","Код","Вставити","Вставити таблицю","Збільшити відступ","Зменшити відступ","Оберіть спеціальный символ","Вставити спеціальный символ","Формат краски","Джерело","Відступи","зверху","справа","знизу","зліва","Стилі","Класи","Вирівнювання","По правому краю","По центру","По лівому краю","--не встановлено--","src","Заголовок","Альтернативний текст (alt)","Посилання","Відкрити посилання в новій вкладці",null,"Файл","Розширені","Властивості зображення","Відміна","Ок","Браузер файлів","Помилка при завантаженні списку зображень","Помилка при завантаженні списку папок","Ви впевнені?","Введіть назву папки","Створити папку","введіть назву","Перетягніть зображення сюди","Перетягніть файл сюди","або клікніть","Альтернативный текст","Завантаження","Сервер","Фон","Текст"," Вгору","По центру","Донизу","Вставити стовпець до","Вставити стовпець після","Вставити рядок вище","Вставити рядок нижче","Видалити таблицю","Видалити рядок","Видалити стовпчик","Очистити кліинку","Символів: %d","Слів: %d","Закреслений","Підкреслений","верхній індекс","індекс","Обрізати вибране","Вибрати все","Межа","Шукати","Замінити на","Замінити","Вставити","Обрати контент для вставки","HTML","жирний","курсів","заливка","посилання","відмінити","повторити","таблиця","зображення","видалення","параграф","розмір шрифту","відео","шрифт","про редактор","друк","підкреслений","закреслений","відступ","заступ","на весь екран","звичайний розмір","лінія","Список","Нумерований список","Вирізати","Виділити все","Код","Відкрити посилання","Редагувати посилання","Атрибут nofollow","Видалити посилання","Оновити","Редагування","Перегляд","URL","Редагувати","Горизонтальне вирівнювання","Фільтр","Сортувати за зміною","Сортувати за ім'ям","Сортувати за розміром","Додати папку","Відновити","Зберегти","Зберегти як","Змінити розмір","Обрізати розмір","Ширина","Висота","Зберегти пропорції","Так","Ні","Видалити","Вибрати","Вибрати: %s","Вертикальне вирівнювання","Розділити","Об'єднати в одну","Додати стовпчик","Додати рядок","Ліцензія: %s","Видалити","Розділити по вертикалі","Розділити по горизонталі","Рамка","Текст, який Ви намагаєтесь вставити схожий на HTML. Вставити його як HTML?","Вставити його як HTML","Зберегти оригінал","Вставити як текст","Вставити тільки текст","Ви можете редагувати лише власні зображення. Завантажити зображення на ваш сервер?","Зображення успішно завантажено на сервер!","палітра","Файли відсутні","Змінити назву","Введіть нове імя'","Попередній перегляд","Завантажити","Вставити з буфера обміну","Ваш браузер не підтримує доступ до буфера обміну.","Копіювати виділене","копія","Радіус рамки","Показати все","Застосувати","Будь ласка, заповніть це поле","Будь ласка, введіть веб-адресу","За замовченням","Коло","Крапка","Квадрат","Знайти","Знайти попередні","Знайти наступні","Ви вставляєте контент з документа Microsoft Word або Excel. Бажаєте зберегти форматування?","Можливо це фрагмент Word або Excel","Почистити","Вставити клас","Натисніть Alt для зміни розміру",null,null,null,"Вибрати все"]

/***/ }),

/***/ 57626:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fuzzySearchIndex: function() { return /* binding */ fuzzySearchIndex; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/string
 */ 
/**
 * Finds the position of the substring in the string, if any, and returns the length of the found subsequence.
 * Unlike `indexOf` ignores INVISIBLE_SPACE and may fail at `maxDistance` characters
 */ function fuzzySearchIndex(needle, haystack, offset = 0, maxDistance = 1) {
    let i = 0, j = 0, startIndex = -1, len = 0, errorDistance = 0;
    for(j = offset; i < needle.length && j < haystack.length;){
        if (needle[i].toLowerCase() === haystack[j].toLowerCase()) {
            i++;
            len++;
            errorDistance = 0;
            if (startIndex === -1) {
                startIndex = j;
            }
        } else if (i > 0) {
            if (errorDistance >= maxDistance && haystack[j] !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE) {
                i = 0;
                startIndex = -1;
                len = 0;
                errorDistance = 0;
                j--;
            } else {
                errorDistance++;
                len++;
            }
        }
        j++;
    }
    return i === needle.length ? [
        startIndex,
        len
    ] : [
        -1,
        0
    ];
}


/***/ }),

/***/ 57629:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    symbols: '符號'
};


/***/ }),

/***/ 57821:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   camelCase: function() { return /* binding */ camelCase; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/string
 */ /**
 * Convert (kebab-case or snake_case) to camelCase
 */ const camelCase = (key)=>{
    return key.replace(/([-_])(.)/g, (m, code, letter)=>{
        return letter.toUpperCase();
    });
};


/***/ }),

/***/ 58067:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    'copy-format': 'opmaak kopiëren'
};


/***/ }),

/***/ 58250:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConnectionError: function() { return /* binding */ ConnectionError; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ class ConnectionError extends Error {
    constructor(m){
        super(m);
        Object.setPrototypeOf(this, ConnectionError.prototype);
    }
}


/***/ }),

/***/ 58446:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1395 1184q0 13-10 23l-50 50q-10 10-23 10t-23-10l-393-393-393 393q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l466 466q10 10 10 23z\"/> </svg>"

/***/ }),

/***/ 58585:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    symbols: '符号'
};


/***/ }),

/***/ 58664:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileBrowserItem: function() { return /* binding */ FileBrowserItem; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65946);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ 

class FileBrowserItem {
    static create(data) {
        if (data instanceof FileBrowserItem) {
            return data;
        }
        return new FileBrowserItem(data);
    }
    get path() {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.normalizePath)(this.data.source.path ? this.data.source.path + '/' : '/');
    }
    get imageURL() {
        const timestamp = this.time || new Date().getTime().toString(), { thumbIsAbsolute, source, thumb, file } = this.data, path = thumb || file;
        return thumbIsAbsolute && path ? path : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.normalizeUrl)(source.baseurl, source.path, path || '') + '?_tmst=' + encodeURIComponent(timestamp);
    }
    get fileURL() {
        let { name } = this.data;
        const { file, fileIsAbsolute, source } = this.data;
        if (file !== undefined) {
            name = file;
        }
        return fileIsAbsolute && name ? name : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.normalizeUrl)(source.baseurl, source.path, name || '');
    }
    get time() {
        const { changed } = this.data;
        return changed && (typeof changed === 'number' ? new Date(changed).toLocaleString() : changed) || '';
    }
    get uniqueHashKey() {
        const data = this.data;
        let key = [
            data.sourceName,
            data.name,
            data.file,
            this.time,
            data.thumb
        ].join('_');
        key = key.toLowerCase().replace(/[^0-9a-z\-.]/g, '-');
        return key;
    }
    toJSON() {
        return this.data;
    }
    constructor(data){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "data", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "source", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "sourceName", void 0);
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "type", void 0);
        this.data = data;
        // TODO Check with Object.assign
        Object.keys(data).forEach((key)=>{
            this[key] = data[key];
        });
    }
}


/***/ }),

/***/ 58881:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkRemoveChar: function() { return /* binding */ checkRemoveChar; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65946);
/* harmony import */ var jodit_plugins_backspace_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15200);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/backspace
 */ 



/**
 * Check possibility the char can be removed
 *
 * @example
 * ```html
 * te|st
 * ```
 * result
 * ```html
 * t|st
 * ```
 * @private
 */ // eslint-disable-next-line complexity
function checkRemoveChar(jodit, fakeNode, backspace, mode) {
    const step = backspace ? -1 : 1;
    const anotherSibling = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.sibling(fakeNode, !backspace);
    let sibling = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.sibling(fakeNode, backspace);
    let removeNeighbor = null;
    let charRemoved = false;
    let removed;
    if (!sibling) {
        sibling = getNextInlineSibling(fakeNode, backspace, jodit.editor);
    }
    while(sibling && (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(sibling) || jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isInlineBlock(sibling))){
        var _sibling_nodeValue, _sibling_nodeValue1;
        while(jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isInlineBlock(sibling)){
            sibling = backspace ? sibling === null || sibling === void 0 ? void 0 : sibling.lastChild : sibling === null || sibling === void 0 ? void 0 : sibling.firstChild;
        }
        if (!sibling) {
            break;
        }
        if ((_sibling_nodeValue = sibling.nodeValue) === null || _sibling_nodeValue === void 0 ? void 0 : _sibling_nodeValue.length) {
            removed = tryRemoveChar(sibling, backspace, step, anotherSibling);
            if (!sibling.nodeValue.length && jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isInlineBlock(sibling.parentNode)) {
                sibling.nodeValue = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE;
            }
        }
        if (!((_sibling_nodeValue1 = sibling.nodeValue) === null || _sibling_nodeValue1 === void 0 ? void 0 : _sibling_nodeValue1.length)) {
            removeNeighbor = sibling;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isVoid)(removed) && removed !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE) {
            checkRepeatRemoveCharAction(backspace, sibling, fakeNode, mode, removed, jodit);
            charRemoved = true;
            break;
        }
        const nextSibling = getNextInlineSibling(sibling, backspace, jodit.editor);
        if (removeNeighbor) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(removeNeighbor);
            removeNeighbor = null;
        }
        sibling = nextSibling;
    }
    if (removeNeighbor) {
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(removeNeighbor);
        removeNeighbor = null;
    }
    if (charRemoved) {
        removeEmptyForParent(fakeNode, 'a');
        addBRInsideEmptyBlock(jodit, fakeNode);
        jodit.s.setCursorBefore(fakeNode);
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(fakeNode.previousSibling, 'br') && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.findNotEmptySibling(fakeNode, false)) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.after(fakeNode, jodit.createInside.element('br'));
        }
    }
    return charRemoved;
}
function getNextInlineSibling(sibling, backspace, root) {
    let nextSibling = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.sibling(sibling, backspace);
    if (!nextSibling && sibling.parentNode && sibling.parentNode !== root) {
        nextSibling = (0,jodit_plugins_backspace_helpers__WEBPACK_IMPORTED_MODULE_3__.findMostNestedNeighbor)(sibling, !backspace, root, true);
    }
    return nextSibling;
}
/**
 * Helper removes all empty inline parents
 */ function removeEmptyForParent(node, tags) {
    let parent = node.parentElement;
    while(parent && jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isInlineBlock(parent) && jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isTag(parent, tags)){
        const p = parent.parentElement;
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isEmpty(parent)) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.after(parent, node);
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.safeRemove(parent);
        }
        parent = p;
    }
}
/**
 * Helper add BR element inside empty block element
 */ function addBRInsideEmptyBlock(jodit, node) {
    if (node.parentElement !== jodit.editor && jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isBlock(node.parentElement) && jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.each(node.parentElement, jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isEmptyTextNode)) {
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.after(node, jodit.createInside.element('br'));
    }
}
function tryRemoveChar(sibling, backspace, step, anotherSibling) {
    // For Unicode escapes
    let value = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.toArray)(sibling.nodeValue);
    const length = value.length;
    let index = backspace ? length - 1 : 0;
    if (value[index] === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE) {
        while(value[index] === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE){
            index += step;
        }
    }
    const removed = value[index];
    if (value[index + step] === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE) {
        index += step;
        while(value[index] === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE){
            index += step;
        }
        index += backspace ? 1 : -1;
    }
    if (backspace && index < 0) {
        value = [];
    } else {
        value = value.slice(backspace ? 0 : index + 1, backspace ? index : length);
    }
    replaceSpaceOnNBSP(anotherSibling, backspace, value);
    sibling.nodeValue = value.join('');
    return removed;
}
function replaceSpaceOnNBSP(anotherSibling, backspace, value) {
    var _anotherSibling_nodeValue;
    if (!anotherSibling || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.isText(anotherSibling) || (!backspace ? / $/ : /^ /).test((_anotherSibling_nodeValue = anotherSibling.nodeValue) !== null && _anotherSibling_nodeValue !== void 0 ? _anotherSibling_nodeValue : '') || !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.trimInv)(anotherSibling.nodeValue || '').length) {
        for(let i = backspace ? value.length - 1 : 0; backspace ? i >= 0 : i < value.length; i += backspace ? -1 : 1){
            if (value[i] === ' ') {
                value[i] = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NBSP_SPACE;
            } else {
                break;
            }
        }
    }
}
function checkRepeatRemoveCharAction(backspace, sibling, fakeNode, mode, removed, jodit) {
    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.call)(backspace ? jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.after : jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.before, sibling, fakeNode);
    if (mode === 'sentence' || mode === 'word' && removed !== ' ' && removed !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NBSP_SPACE) {
        checkRemoveChar(jodit, fakeNode, backspace, mode);
    }
}


/***/ }),

/***/ 59399:
/***/ (function(__unused_webpack_module, __webpack_exports__) {

"use strict";
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/inline-popup
 */ /* harmony default export */ __webpack_exports__["default"] = ([
    'bold',
    'italic',
    '|',
    'ul',
    'ol',
    'eraser',
    '|',
    'fontsize',
    'brush',
    'paragraph',
    '---',
    'image',
    'table',
    '\n',
    'link',
    '|',
    'align',
    '|',
    'undo',
    'redo',
    '|',
    'copyformat',
    'fullsize',
    '---',
    'dots'
]);


/***/ }),

/***/ 59400:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Button: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.Button; },
/* harmony export */   UIButton: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.UIButton; },
/* harmony export */   UIButtonGroup: function() { return /* reexport safe */ _group_group__WEBPACK_IMPORTED_MODULE_1__.UIButtonGroup; },
/* harmony export */   UIButtonState: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.UIButtonState; },
/* harmony export */   UITooltip: function() { return /* reexport safe */ _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_2__.UITooltip; }
/* harmony export */ });
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(53681);
/* harmony import */ var _group_group__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(15367);
/* harmony import */ var _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95399);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/ui/button/README.md]]
 * @packageDocumentation
 * @module ui/button
 */ 




/***/ }),

/***/ 59488:
/***/ (function(module) {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ module.exports = {
    symbols: 'Symbol'
};


/***/ }),

/***/ 59609:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ViewComponent: function() { return /* binding */ ViewComponent; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80251);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module component
 */ 

class ViewComponent extends _component__WEBPACK_IMPORTED_MODULE_1__.Component {
    /**
	 * Shortcut for `this.jodit`
	 */ get j() {
        return this.jodit;
    }
    get defaultTimeout() {
        return this.j.defaultTimeout;
    }
    i18n(text, ...params) {
        return this.j.i18n(text, ...params);
    }
    /**
	 * Attach component to View
	 */ setParentView(jodit) {
        this.jodit = jodit;
        jodit.components.add(this);
        return this;
    }
    /** @override */ destruct() {
        this.j.components.delete(this);
        return super.destruct();
    }
    constructor(jodit){
        super(), /**
	 * Parent View element
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "jodit", void 0);
        this.setParentView(jodit);
    }
}


/***/ }),

/***/ 59758:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export redoUndo */
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18855);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(5266);
/* harmony import */ var _icons_redo_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(34045);
/* harmony import */ var _icons_redo_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_icons_redo_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _icons_undo_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(39199);
/* harmony import */ var _icons_undo_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_icons_undo_svg__WEBPACK_IMPORTED_MODULE_7__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/redo-undo/README.md]]
 * @packageDocumentation
 * @module plugins/redo-undo
 */ 







jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_4__.Icon.set('redo', (_icons_redo_svg__WEBPACK_IMPORTED_MODULE_6___default())).set('undo', (_icons_undo_svg__WEBPACK_IMPORTED_MODULE_7___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_5__.Config.prototype.controls.redo = {
    mode: jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.MODE_SPLIT,
    isDisabled: (editor)=>!editor.history.canRedo(),
    tooltip: 'Redo'
};
jodit_config__WEBPACK_IMPORTED_MODULE_5__.Config.prototype.controls.undo = {
    mode: jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.MODE_SPLIT,
    isDisabled: (editor)=>!editor.history.canUndo(),
    tooltip: 'Undo'
};
/**
 * Custom process Redo and Undo functionality
 */ class redoUndo extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_3__.Plugin {
    beforeDestruct() {
    // do nothing
    }
    afterInit(editor) {
        const callback = (command)=>{
            editor.history[command]();
            return false;
        };
        editor.registerCommand('redo', {
            exec: callback,
            hotkeys: [
                'ctrl+y',
                'ctrl+shift+z',
                'cmd+y',
                'cmd+shift+z'
            ]
        });
        editor.registerCommand('undo', {
            exec: callback,
            hotkeys: [
                'ctrl+z',
                'cmd+z'
            ]
        });
    }
    constructor(...args){
        super(...args), /** @override */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "buttons", [
            {
                name: 'undo',
                group: 'history'
            },
            {
                name: 'redo',
                group: 'history'
            }
        ]);
    }
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__.pluginSystem.add('redoUndo', redoUndo);


/***/ }),

/***/ 59807:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LocalStorageProvider: function() { return /* binding */ LocalStorageProvider; },
/* harmony export */   canUsePersistentStorage: function() { return /* binding */ canUsePersistentStorage; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module storage
 */ 
/**
 * Check if user disable local storages/cookie etc.
 */ const canUsePersistentStorage = (()=>{
    const canUse = ()=>{
        const tmpKey = '___Jodit___' + Math.random().toString();
        try {
            localStorage.setItem(tmpKey, '1');
            const result = localStorage.getItem(tmpKey) === '1';
            localStorage.removeItem(tmpKey);
            return result;
        } catch (e) {}
        return false;
    };
    let result;
    return ()=>{
        if (result === undefined) {
            result = canUse();
        }
        return result;
    };
})();
/**
 * Persistent storage in localStorage
 */ class LocalStorageProvider {
    set(key, value) {
        try {
            const buffer = localStorage.getItem(this.rootKey);
            const json = buffer ? JSON.parse(buffer) : {};
            json[key] = value;
            localStorage.setItem(this.rootKey, JSON.stringify(json));
        } catch (e) {}
        return this;
    }
    delete(key) {
        try {
            localStorage.removeItem(this.rootKey);
        } catch (e) {}
        return this;
    }
    get(key) {
        try {
            const buffer = localStorage.getItem(this.rootKey);
            const json = buffer ? JSON.parse(buffer) : {};
            return json[key] !== undefined ? json[key] : undefined;
        } catch (e) {}
    }
    exists(key) {
        return this.get(key) != null;
    }
    clear() {
        try {
            localStorage.removeItem(this.rootKey);
        } catch (e) {}
        return this;
    }
    constructor(rootKey){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "rootKey", void 0);
        this.rootKey = rootKey;
    }
}


/***/ }),

/***/ 59841:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CommitStyle: function() { return /* reexport safe */ _style_commit_style__WEBPACK_IMPORTED_MODULE_1__.CommitStyle; },
/* harmony export */   INITIAL: function() { return /* reexport safe */ _style_constants__WEBPACK_IMPORTED_MODULE_2__.INITIAL; },
/* harmony export */   REPLACE: function() { return /* reexport safe */ _style_constants__WEBPACK_IMPORTED_MODULE_2__.REPLACE; },
/* harmony export */   Selection: function() { return /* reexport safe */ _selection__WEBPACK_IMPORTED_MODULE_0__.Selection; },
/* harmony export */   UNSET: function() { return /* reexport safe */ _style_constants__WEBPACK_IMPORTED_MODULE_2__.UNSET; },
/* harmony export */   UNWRAP: function() { return /* reexport safe */ _style_constants__WEBPACK_IMPORTED_MODULE_2__.UNWRAP; },
/* harmony export */   WRAP: function() { return /* reexport safe */ _style_constants__WEBPACK_IMPORTED_MODULE_2__.WRAP; }
/* harmony export */ });
/* harmony import */ var _selection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98595);
/* harmony import */ var _style_commit_style__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84578);
/* harmony import */ var _style_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98394);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module selection
 */ 




/***/ }),

/***/ 60162:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36400);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5266);
/* harmony import */ var _icons_ol_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40037);
/* harmony import */ var _icons_ol_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_icons_ol_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _icons_ul_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(83207);
/* harmony import */ var _icons_ul_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_icons_ul_svg__WEBPACK_IMPORTED_MODULE_4__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module plugins/ordered-list
 */ 




const memoExec = (jodit, _, { control })=>{
    const key = `button${control.command}`;
    var _ref;
    const value = (_ref = control.args && control.args[0]) !== null && _ref !== void 0 ? _ref : (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_0__.dataBind)(jodit, key);
    (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_0__.dataBind)(jodit, key, value);
    jodit.execCommand(control.command, false, value === 'default' ? null : value);
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__.Icon.set('ol', (_icons_ol_svg__WEBPACK_IMPORTED_MODULE_3___default())).set('ul', (_icons_ul_svg__WEBPACK_IMPORTED_MODULE_4___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.controls.ul = {
    command: 'insertUnorderedList',
    tags: [
        'ul'
    ],
    tooltip: 'Insert Unordered List',
    list: {
        default: 'Default',
        circle: 'Circle',
        disc: 'Dot',
        square: 'Quadrate'
    },
    exec: memoExec
};
jodit_config__WEBPACK_IMPORTED_MODULE_2__.Config.prototype.controls.ol = {
    command: 'insertOrderedList',
    tags: [
        'ol'
    ],
    tooltip: 'Insert Ordered List',
    list: {
        default: 'Default',
        'lower-alpha': 'Lower Alpha',
        'lower-greek': 'Lower Greek',
        'lower-roman': 'Lower Roman',
        'upper-alpha': 'Upper Alpha',
        'upper-roman': 'Upper Roman'
    },
    exec: memoExec
};


/***/ }),

/***/ 60216:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Eventify: function() { return /* binding */ Eventify; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module event-emitter
 */ 
/**
 * Class for adding event handling capability
 *
 * ```ts
 * class SomeClass extends Eventify<{ start: (node: Node) => boolean; }> {
 * 	constructor() {
 * 		super();
 * 		setTimeout(() => {
 * 			if (this.emit('start', document.body)) {
 * 				console.log('yes');
 * 			};
 * 		}, 100);
 * 	}
 * }
 *
 * const sm = new SomeClass();
 * sm.on('start', (node) => {
 * 	console.log(node);
 * 	return true;
 * })
 * ```
 */ class Eventify {
    on(name, func) {
        var _this___map_get;
        if (!this.__map.has(name)) {
            this.__map.set(name, new Set());
        }
        (_this___map_get = this.__map.get(name)) === null || _this___map_get === void 0 ? void 0 : _this___map_get.add(func);
        return this;
    }
    off(name, func) {
        if (this.__map.has(name)) {
            var _this___map_get;
            (_this___map_get = this.__map.get(name)) === null || _this___map_get === void 0 ? void 0 : _this___map_get.delete(func);
        }
        return this;
    }
    destruct() {
        this.__map.clear();
    }
    emit(name, ...args) {
        let result;
        if (this.__map.has(name)) {
            var _this___map_get;
            (_this___map_get = this.__map.get(name)) === null || _this___map_get === void 0 ? void 0 : _this___map_get.forEach((cb)=>{
                result = cb(...args);
            });
        }
        return result;
    }
    constructor(){
        (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__map", new Map());
    }
}


/***/ }),

/***/ 60636:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1792 1344v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-896q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h896q26 0 45 19t19 45zm256-384v128q0 26-19 45t-45 19h-1408q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1408q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-640q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h640q26 0 45 19t19 45z\"/> </svg>"

/***/ }),

/***/ 60898:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   inView: function() { return /* binding */ inView; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* binding */ scrollIntoViewIfNeeded; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/utils
 */ 
/**
 * @module helpers/utils
 */ /**
 * Check if element is in view
 */ function inView(elm, root, doc) {
    let rect = elm.getBoundingClientRect(), el = elm;
    const top = rect.top, height = rect.height;
    while(el && el !== root && el.parentNode){
        el = el.parentNode;
        rect = el.getBoundingClientRect();
        if (!(top <= rect.bottom)) {
            return false;
        }
        // Check if the element is out of view due to a container scrolling
        if (top + height <= rect.top) {
            return false;
        }
    }
    // Check it's within the document viewport
    return top <= (doc.documentElement && doc.documentElement.clientHeight || 0);
}
/**
 * Scroll element into view if it is not in view
 */ function scrollIntoViewIfNeeded(elm, root, doc) {
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isHTMLElement(elm) && !inView(elm, root, doc)) {
        if (root.clientHeight !== root.scrollHeight) {
            root.scrollTop = elm.offsetTop;
        }
        if (!inView(elm, root, doc)) {
            elm.scrollIntoView();
        }
    }
}


/***/ }),

/***/ 60936:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ajax: function() { return /* reexport safe */ jodit_core_request__WEBPACK_IMPORTED_MODULE_10__.Ajax; },
/* harmony export */   Alert: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.Alert; },
/* harmony export */   Async: function() { return /* reexport safe */ jodit_core_async__WEBPACK_IMPORTED_MODULE_5__.Async; },
/* harmony export */   Button: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.Button; },
/* harmony export */   CommitStyle: function() { return /* reexport safe */ jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__.CommitStyle; },
/* harmony export */   Component: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.Component; },
/* harmony export */   Confirm: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.Confirm; },
/* harmony export */   ContextMenu: function() { return /* reexport safe */ _context_menu_context_menu__WEBPACK_IMPORTED_MODULE_2__.ContextMenu; },
/* harmony export */   Create: function() { return /* reexport safe */ jodit_core_create__WEBPACK_IMPORTED_MODULE_6__.Create; },
/* harmony export */   Dialog: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.Dialog; },
/* harmony export */   Dom: function() { return /* reexport safe */ jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__.Dom; },
/* harmony export */   EventEmitter: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.EventEmitter; },
/* harmony export */   EventHandlersStore: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.EventHandlersStore; },
/* harmony export */   Eventify: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.Eventify; },
/* harmony export */   FileBrowser: function() { return /* reexport safe */ _file_browser__WEBPACK_IMPORTED_MODULE_4__.FileBrowser; },
/* harmony export */   Helpers: function() { return /* reexport module object */ jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__; },
/* harmony export */   History: function() { return /* reexport safe */ _history_history__WEBPACK_IMPORTED_MODULE_14__.History; },
/* harmony export */   Icon: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.Icon; },
/* harmony export */   ImageEditor: function() { return /* reexport safe */ _image_editor_image_editor__WEBPACK_IMPORTED_MODULE_16__.ImageEditor; },
/* harmony export */   LazyWalker: function() { return /* reexport safe */ jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__.LazyWalker; },
/* harmony export */   Plugin: function() { return /* reexport safe */ jodit_core_plugin__WEBPACK_IMPORTED_MODULE_9__.Plugin; },
/* harmony export */   PluginSystem: function() { return /* reexport safe */ jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_24__.PluginSystem; },
/* harmony export */   Popup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.Popup; },
/* harmony export */   ProgressBar: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.ProgressBar; },
/* harmony export */   Prompt: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.Prompt; },
/* harmony export */   Response: function() { return /* reexport safe */ jodit_core_request__WEBPACK_IMPORTED_MODULE_10__.Response; },
/* harmony export */   STATUSES: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.STATUSES; },
/* harmony export */   Selection: function() { return /* reexport safe */ jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__.Selection; },
/* harmony export */   Snapshot: function() { return /* reexport safe */ _history_snapshot__WEBPACK_IMPORTED_MODULE_15__.Snapshot; },
/* harmony export */   StatusBar: function() { return /* reexport safe */ _status_bar_status_bar__WEBPACK_IMPORTED_MODULE_18__.StatusBar; },
/* harmony export */   Table: function() { return /* reexport safe */ _table_table__WEBPACK_IMPORTED_MODULE_19__.Table; },
/* harmony export */   ToolbarButton: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.ToolbarButton; },
/* harmony export */   ToolbarCollection: function() { return /* reexport safe */ _toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_21__.ToolbarCollection; },
/* harmony export */   ToolbarContent: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.ToolbarContent; },
/* harmony export */   ToolbarEditorCollection: function() { return /* reexport safe */ _toolbar_collection_editor_collection__WEBPACK_IMPORTED_MODULE_22__.ToolbarEditorCollection; },
/* harmony export */   ToolbarSelect: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.ToolbarSelect; },
/* harmony export */   UIBlock: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UIBlock; },
/* harmony export */   UIButton: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UIButton; },
/* harmony export */   UIButtonGroup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UIButtonGroup; },
/* harmony export */   UIButtonState: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UIButtonState; },
/* harmony export */   UICheckbox: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UICheckbox; },
/* harmony export */   UIElement: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UIElement; },
/* harmony export */   UIFileInput: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UIFileInput; },
/* harmony export */   UIForm: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UIForm; },
/* harmony export */   UIGroup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UIGroup; },
/* harmony export */   UIInput: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UIInput; },
/* harmony export */   UIList: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UIList; },
/* harmony export */   UIMessages: function() { return /* reexport safe */ _messages_messages__WEBPACK_IMPORTED_MODULE_17__.UIMessages; },
/* harmony export */   UISelect: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UISelect; },
/* harmony export */   UISeparator: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UISeparator; },
/* harmony export */   UISpacer: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UISpacer; },
/* harmony export */   UITextArea: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UITextArea; },
/* harmony export */   UITooltip: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.UITooltip; },
/* harmony export */   Uploader: function() { return /* reexport safe */ _uploader_uploader__WEBPACK_IMPORTED_MODULE_23__.Uploader; },
/* harmony export */   View: function() { return /* reexport safe */ jodit_core_view_view__WEBPACK_IMPORTED_MODULE_12__.View; },
/* harmony export */   ViewComponent: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.ViewComponent; },
/* harmony export */   ViewWithToolbar: function() { return /* reexport safe */ jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_13__.ViewWithToolbar; },
/* harmony export */   defaultNameSpace: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.defaultNameSpace; },
/* harmony export */   observable: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.observable; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16964);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65946);
/* harmony import */ var _context_menu_context_menu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67399);
/* harmony import */ var _dialog___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37333);
/* harmony import */ var _file_browser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(17610);
/* harmony import */ var jodit_core_async__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91231);
/* harmony import */ var jodit_core_create__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(79821);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(1496);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(91206);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(73714);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(4099);
/* harmony import */ var jodit_core_view_view__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(35099);
/* harmony import */ var jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(2222);
/* harmony import */ var _history_history__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(53855);
/* harmony import */ var _history_snapshot__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(46363);
/* harmony import */ var _image_editor_image_editor__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(43271);
/* harmony import */ var _messages_messages__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(10081);
/* harmony import */ var _status_bar_status_bar__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(29433);
/* harmony import */ var _table_table__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(98803);
/* harmony import */ var _toolbar_button__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(39709);
/* harmony import */ var _toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(42573);
/* harmony import */ var _toolbar_collection_editor_collection__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(6209);
/* harmony import */ var _uploader_uploader__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(94925);
/* harmony import */ var jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(85305);
/* harmony import */ var jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(59841);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:modules/README.md]]
 * @packageDocumentation
 * @module modules
 */ 





























/***/ }),

/***/ 61077:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   clearTimeout: function() { return /* reexport safe */ _set_timeout__WEBPACK_IMPORTED_MODULE_0__.clearTimeout; },
/* harmony export */   setTimeout: function() { return /* reexport safe */ _set_timeout__WEBPACK_IMPORTED_MODULE_0__.setTimeout; }
/* harmony export */ });
/* harmony import */ var _set_timeout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(79947);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/async
 */ 


/***/ }),

/***/ 61334:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49376);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27795);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(93640);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29434);
/* harmony import */ var jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31125);
/* harmony import */ var jodit_modules_file_browser_factories__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(18272);
/* harmony import */ var jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1305);
/* harmony import */ var jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(53202);
/* harmony import */ var jodit_modules_file_browser_listeners_native_listeners__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(34269);
/* harmony import */ var jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(43271);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ 









const CLASS_PREVIEW = 'jodit-file-browser-preview', preview_tpl_next = (next = 'next', right = 'right')=>`<div class="${CLASS_PREVIEW}__navigation ${CLASS_PREVIEW}__navigation_arrow_${next}">` + '' + jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__.Icon.get('angle-' + right) + '</a>';
/* harmony default export */ __webpack_exports__["default"] = ((self)=>{
    if (!self.o.contextMenu) {
        return ()=>{};
    }
    const contextmenu = (0,jodit_modules_file_browser_factories__WEBPACK_IMPORTED_MODULE_5__.makeContextMenu)(self);
    return (e)=>{
        const a = (0,jodit_modules_file_browser_listeners_native_listeners__WEBPACK_IMPORTED_MODULE_8__.getItem)(e.target, self.container);
        if (!a) {
            return;
        }
        let item = a;
        const opt = self.options, ga = (key)=>(0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.attr)(item, key) || '';
        self.async.setTimeout(()=>{
            const selectedItem = (0,jodit_modules_file_browser_listeners_native_listeners__WEBPACK_IMPORTED_MODULE_8__.elementToItem)(a, (0,jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_4__.elementsMap)(self));
            if (!selectedItem) {
                return;
            }
            self.state.activeElements = [
                selectedItem
            ];
            contextmenu.show(e.clientX, e.clientY, [
                ga('data-is-file') !== '1' && opt.editImage && (self.dataProvider.canI('ImageResize') || self.dataProvider.canI('ImageCrop')) ? {
                    icon: 'pencil',
                    title: 'Edit',
                    exec: ()=>jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_9__.openImageEditor.call(self, ga('href'), ga('data-name'), ga('data-path'), ga('data-source'))
                } : false,
                self.dataProvider.canI('FileRename') ? {
                    icon: 'italic',
                    title: 'Rename',
                    exec: ()=>{
                        self.e.fire('fileRename.filebrowser', ga('data-name'), ga('data-path'), ga('data-source'));
                    }
                } : false,
                self.dataProvider.canI('FileRemove') ? {
                    icon: 'bin',
                    title: 'Delete',
                    exec: ()=>(0,_swc_helpers_async_to_generator__WEBPACK_IMPORTED_MODULE_0__._)(function*() {
                            try {
                                yield (0,jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_6__.deleteFile)(self, ga('data-name'), ga('data-source'));
                            } catch (e) {
                                return self.status(e);
                            }
                            self.state.activeElements = [];
                            return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_7__.loadTree)(self).catch(self.status);
                        })()
                } : false,
                opt.preview ? {
                    icon: 'eye',
                    title: 'Preview',
                    exec: ()=>{
                        const preview = self.dlg({
                            buttons: [
                                'fullsize',
                                'dialog.close'
                            ]
                        }), temp_content = self.c.div(CLASS_PREVIEW, '<div class="jodit-icon_loader"></div>'), preview_box = self.c.div(CLASS_PREVIEW + '__box'), next = self.c.fromHTML(preview_tpl_next()), prev = self.c.fromHTML(preview_tpl_next('prev', 'left')), addLoadHandler = (src)=>{
                            const image = self.c.element('img');
                            image.setAttribute('src', src);
                            const onload = ()=>{
                                var _self_events;
                                if (self.isInDestruct) {
                                    return;
                                }
                                self.e.off(image, 'load');
                                jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.detach(temp_content);
                                if (opt.showPreviewNavigation) {
                                    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.prevWithClass(item, self.files.getFullElName('item'))) {
                                        temp_content.appendChild(prev);
                                    }
                                    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.nextWithClass(item, self.files.getFullElName('item'))) {
                                        temp_content.appendChild(next);
                                    }
                                }
                                temp_content.appendChild(preview_box);
                                preview_box.appendChild(image);
                                preview.setPosition();
                                self === null || self === void 0 ? void 0 : (_self_events = self.events) === null || _self_events === void 0 ? void 0 : _self_events.fire('previewOpenedAndLoaded');
                            };
                            self.e.on(image, 'load', onload);
                            if (image.complete) {
                                onload();
                            }
                        };
                        self.e.on([
                            next,
                            prev
                        ], 'click', function() {
                            if (this === next) {
                                item = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.nextWithClass(item, self.files.getFullElName('item'));
                            } else {
                                item = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.prevWithClass(item, self.files.getFullElName('item'));
                            }
                            if (!item) {
                                throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.error)('Need element');
                            }
                            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.detach(temp_content);
                            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__.Dom.detach(preview_box);
                            temp_content.innerHTML = '<div class="jodit-icon_loader"></div>';
                            addLoadHandler(ga('href'));
                        });
                        self.e.on('beforeDestruct', ()=>{
                            preview.destruct();
                        });
                        preview.container.classList.add(CLASS_PREVIEW + '__dialog');
                        preview.setContent(temp_content);
                        preview.setPosition();
                        preview.open();
                        addLoadHandler(ga('href'));
                        self.events.on('beforeDestruct', ()=>{
                            preview.destruct();
                        }).fire('previewOpened');
                    }
                } : false,
                {
                    icon: 'upload',
                    title: 'Download',
                    exec: ()=>{
                        const url = ga('href');
                        if (url) {
                            self.ow.open(url);
                        }
                    }
                }
            ]);
        }, self.defaultTimeout);
        self.e.on('beforeClose', ()=>{
            contextmenu.close();
        }).on('beforeDestruct', ()=>contextmenu.destruct());
        e.stopPropagation();
        e.preventDefault();
        return false;
    };
});


/***/ }),

/***/ 61466:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UIMessage: function() { return /* binding */ UIMessage; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91672);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4099);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/messages
 */ 


class UIMessage extends jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__.UIElement {
    className() {
        return 'UIMessage';
    }
    constructor(jodit, options){
        super(jodit);
        this.setMod('active', true);
        this.setMod('variant', options.variant);
        this.container.textContent = options.text;
    }
}
UIMessage = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_0__.__decorate)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_1__.component
], UIMessage);


/***/ }),

/***/ 61764:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToolbarSelect: function() { return /* binding */ ToolbarSelect; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(62101);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85932);
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(22533);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/toolbar/button
 */ 





class ToolbarSelect extends _button__WEBPACK_IMPORTED_MODULE_4__.ToolbarButton {
    className() {
        return 'ToolbarSelect';
    }
    update() {
        super.update();
        this.state.icon.name = '';
        const { list, data } = this.control;
        if (list) {
            var _this_control_textTemplate, _this_control;
            let key = this.state.value || (data && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__.isString)(data.currentValue) ? data.currentValue : undefined);
            if (!key) {
                const keys = Object.keys(list);
                key = keys[0];
            }
            const text = ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_2__.isPlainObject)(list) ? list[key.toString()] || key : key).toString();
            var _this_control_textTemplate1;
            this.state.text = (_this_control_textTemplate1 = (_this_control_textTemplate = (_this_control = this.control).textTemplate) === null || _this_control_textTemplate === void 0 ? void 0 : _this_control_textTemplate.call(_this_control, this.jodit, text)) !== null && _this_control_textTemplate1 !== void 0 ? _this_control_textTemplate1 : text;
        }
    }
}
ToolbarSelect = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_0__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], ToolbarSelect);


/***/ }),

/***/ 62101:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isPlainObject: function() { return /* binding */ isPlainObject; }
/* harmony export */ });
/* harmony import */ var _is_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3513);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module helpers/checker
 */ 
/**
 * Check if element is simple plaint object
 */ function isPlainObject(obj) {
    if (!obj || typeof obj !== 'object' || obj.nodeType || (0,_is_window__WEBPACK_IMPORTED_MODULE_0__.isWindow)(obj)) {
        return false;
    }
    return !(obj.constructor && !({}).hasOwnProperty.call(obj.constructor.prototype, 'isPrototypeOf'));
}


/***/ }),

/***/ 62623:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileBrowser: function() { return /* binding */ FileBrowser; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16964);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(81937);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68616);
/* harmony import */ var jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1496);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_storage__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(25222);
/* harmony import */ var jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(80512);
/* harmony import */ var jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(2222);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(5266);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(68502);
/* harmony import */ var _fetch_load_items__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(1488);
/* harmony import */ var _fetch_load_tree__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(53202);
/* harmony import */ var _listeners_native_listeners__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(34269);
/* harmony import */ var _listeners_self_listeners__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(36664);
/* harmony import */ var _listeners_state_listeners__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(74833);
/* harmony import */ var _data_provider__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(17780);
/* harmony import */ var _factories__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(18272);
/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(63425);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ 






















class FileBrowser extends jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_10__.ViewWithToolbar {
    /** @override */ className() {
        return 'FileBrowser';
    }
    get dataProvider() {
        return (0,_factories__WEBPACK_IMPORTED_MODULE_19__.makeDataProvider)(this, this.options);
    }
    onSelect(callback) {
        return ()=>{
            if (this.state.activeElements.length) {
                const files = [];
                const isImages = [];
                this.state.activeElements.forEach((elm)=>{
                    const url = elm.fileURL;
                    if (url) {
                        files.push(url);
                        isImages.push(elm.isImage || false);
                    }
                });
                this.close();
                const data = {
                    baseurl: '',
                    files,
                    isImages
                };
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isFunction)(callback)) {
                    callback(data);
                }
                this.close();
            }
            return false;
        };
    }
    get _dialog() {
        var _this_o_headerButtons;
        const dialog = this.dlg({
            minWidth: Math.min(700, screen.width),
            minHeight: 300,
            buttons: (_this_o_headerButtons = this.o.headerButtons) !== null && _this_o_headerButtons !== void 0 ? _this_o_headerButtons : [
                'fullsize',
                'dialog.close'
            ]
        });
        [
            'beforeClose',
            'afterClose',
            'beforeOpen'
        ].forEach((proxyEvent)=>dialog.events.on(dialog, proxyEvent, ()=>this.e.fire(proxyEvent)));
        dialog.setSize(this.o.width, this.o.height);
        return dialog;
    }
    /**
	 * Container for set/get value
	 */ get storage() {
        return jodit_core_storage__WEBPACK_IMPORTED_MODULE_8__.Storage.makeStorage(Boolean(this.o.saveStateInStorage), this.componentName);
    }
    get isOpened() {
        return this._dialog.isOpened && this.browser.style.display !== 'none';
    }
    /**
	 * It displays a message in the status bar of filebrowser
	 *
	 * @param message - The message that will be displayed
	 * @param success - true It will be shown a message light . If no option is specified ,
	 * ßan error will be shown the red
	 * @example
	 * ```javascript
	 * parent.filebrowser.status('There was an error uploading file', false);
	 * ```
	 */ status(message, success) {
        if (!message || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isAbortError)(message)) {
            return;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isString)(message)) {
            message = message.message;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isString)(message) || !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.trim)(message).length) {
            return;
        }
        this.message.message(message, success ? 'success' : 'error', this.o.howLongShowMsg);
    }
    /**
	 * It opens a web browser window
	 *
	 * @param callback - The function that will be called after the file selection in the browser
	 * @param onlyImages - Show only images
	 * @example
	 * ```javascript
	 * var fb = new Jodit.modules.FileBrowser(parent);
	 * fb.open(function (data) {
	 *     var i;
	 *     for (i = 0;i < data.files.length; i += 1) {
	 *         parent.s.insertImage(data.baseurl + data.files[i]);
	 *     }
	 * });
	 * ```
	 */ open(callback = this.o.defaultCallback, onlyImages = false) {
        this.state.onlyImages = onlyImages;
        return this.async.promise((resolve, reject)=>{
            var _this_toolbar;
            if (!this.o.items || !this.o.items.url) {
                throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.error)('Need set options.filebrowser.ajax.url');
            }
            let localTimeout = 0;
            this.e.off(this.files.container, 'dblclick').on(this.files.container, 'dblclick', this.onSelect(callback)).on(this.files.container, 'touchstart', ()=>{
                const now = new Date().getTime();
                if (now - localTimeout < jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__.EMULATE_DBLCLICK_TIMEOUT) {
                    this.onSelect(callback)();
                }
                localTimeout = now;
            }).off('select.filebrowser').on('select.filebrowser', this.onSelect(callback));
            const header = this.c.div();
            (_this_toolbar = this.toolbar) === null || _this_toolbar === void 0 ? void 0 : _this_toolbar.appendTo(header);
            this.__updateToolbarButtons();
            this._dialog.open(this.browser, header);
            this.e.fire('sort.filebrowser', this.state.sortBy);
            (0,_fetch_load_tree__WEBPACK_IMPORTED_MODULE_14__.loadTree)(this).then(resolve, reject).finally(()=>{
                var _this_e, _this;
                if (this.isInDestruct) {
                    return;
                }
                (_this = this) === null || _this === void 0 ? void 0 : (_this_e = _this.e) === null || _this_e === void 0 ? void 0 : _this_e.fire('fileBrowserReady.filebrowser');
            });
        }).catch((e)=>{
            if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isAbortError)(e) && !jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__.IS_PROD) {
                throw e;
            }
        });
    }
    __getButtons() {
        var _this_o_buttons;
        const options = (_this_o_buttons = this.o.buttons) !== null && _this_o_buttons !== void 0 ? _this_o_buttons : [];
        return options.filter((btn)=>{
            if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isString)(btn)) {
                return true;
            }
            switch(btn){
                case 'filebrowser.upload':
                    return this.dataProvider.canI('FileUpload');
                case 'filebrowser.edit':
                    return this.dataProvider.canI('ImageResize') || this.dataProvider.canI('ImageCrop');
                case 'filebrowser.remove':
                    return this.dataProvider.canI('FileRemove');
            }
            return true;
        });
    }
    initUploader(editor) {
        var _editor_options;
        const self = this, options = editor === null || editor === void 0 ? void 0 : (_editor_options = editor.options) === null || _editor_options === void 0 ? void 0 : _editor_options.uploader, uploaderOptions = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_11__.Config.defaultOptions.uploader);
        const uploadHandler = ()=>(0,_fetch_load_items__WEBPACK_IMPORTED_MODULE_13__.loadItems)(this);
        self.uploader = self.getInstance('Uploader', uploaderOptions);
        self.uploader.setPath(self.state.currentPath).setSource(self.state.currentSource).bind(self.browser, uploadHandler, self.errorHandler);
        this.state.on([
            'change.currentPath',
            'change.currentSource'
        ], ()=>{
            this.uploader.setPath(this.state.currentPath).setSource(this.state.currentSource);
        });
        self.e.on('bindUploader.filebrowser', (button)=>{
            self.uploader.bind(button, uploadHandler, self.errorHandler);
        });
    }
    destruct() {
        var _cached;
        if (this.isInDestruct) {
            return;
        }
        (_cached = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.cached)(this, '_dialog')) === null || _cached === void 0 ? void 0 : _cached.destruct();
        super.destruct();
        this.events && this.e.off('.filebrowser');
        this.uploader && this.uploader.destruct();
    }
    __updateToolbarButtons() {
        var _this_toolbar;
        const buttons = this.__getButtons();
        if (isEqualButtonList(this.__prevButtons, buttons)) {
            return;
        }
        this.__prevButtons = buttons;
        (_this_toolbar = this.toolbar) === null || _this_toolbar === void 0 ? void 0 : _this_toolbar.build(buttons);
    }
    constructor(options){
        super(options), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "browser", this.c.div(this.componentName)), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "status_line", this.c.div(this.getFullElName('status'))), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "tree", new _ui__WEBPACK_IMPORTED_MODULE_20__.FileBrowserTree(this)), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "files", new _ui__WEBPACK_IMPORTED_MODULE_20__.FileBrowserFiles(this)), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "state", (0,jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_6__.observable)({
            currentPath: '',
            currentSource: _data_provider__WEBPACK_IMPORTED_MODULE_18__.DEFAULT_SOURCE_NAME,
            currentBaseUrl: '',
            activeElements: [],
            elements: [],
            sources: [],
            view: 'tiles',
            sortBy: 'changed-desc',
            filterWord: '',
            onlyImages: false
        })), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "errorHandler", (resp)=>{
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.isAbortError)(resp)) {
                return;
            }
            if (resp instanceof Error) {
                this.status(this.i18n(resp.message));
            } else {
                this.status(this.dataProvider.getMessage(resp));
            }
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "uploader", void 0), /**
	 * Close dialog
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "close", ()=>{
            this._dialog.close();
        }), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "__prevButtons", []);
        this.attachEvents(options);
        const self = this;
        self.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_11__.Config.defaultOptions.filebrowser);
        self.browser.component = this;
        self.container = self.browser;
        if (self.o.showFoldersPanel) {
            self.browser.appendChild(self.tree.container);
        }
        self.browser.appendChild(self.files.container);
        self.browser.appendChild(self.status_line);
        _listeners_self_listeners__WEBPACK_IMPORTED_MODULE_16__.selfListeners.call(self);
        _listeners_native_listeners__WEBPACK_IMPORTED_MODULE_15__.nativeListeners.call(self);
        _listeners_state_listeners__WEBPACK_IMPORTED_MODULE_17__.stateListeners.call(self);
        const keys = [
            'getLocalFileByUrl',
            'crop',
            'resize',
            'create',
            'fileMove',
            'folderMove',
            'fileRename',
            'folderRename',
            'fileRemove',
            'folderRemove',
            'folder',
            'items',
            'permissions'
        ];
        keys.forEach((key)=>{
            if (this.options[key] != null) {
                this.options[key] = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_7__.ConfigProto)(this.options[key], this.o.ajax);
            }
        });
        const { storeView, storeSortBy, storeLastOpenedFolder } = this.o.saveStateInStorage || {
            storeLastOpenedFolder: false,
            storeView: false,
            storeSortBy: false
        };
        const view = storeView && this.storage.get('view');
        if (view && this.o.view == null) {
            self.state.view = view === 'list' ? 'list' : 'tiles';
        } else {
            self.state.view = self.o.view === 'list' ? 'list' : 'tiles';
        }
        self.files.setMod('view', self.state.view);
        const sortBy = storeSortBy && self.storage.get('sortBy');
        if (sortBy) {
            const parts = sortBy.split('-');
            self.state.sortBy = [
                'changed',
                'name',
                'size'
            ].includes(parts[0]) ? sortBy : 'changed-desc';
        } else {
            self.state.sortBy = self.o.sortBy || 'changed-desc';
        }
        if (storeLastOpenedFolder) {
            const currentPath = self.storage.get('currentPath'), currentSource = self.storage.get('currentSource');
            self.state.currentPath = currentPath !== null && currentPath !== void 0 ? currentPath : '';
            self.state.currentSource = currentSource !== null && currentSource !== void 0 ? currentSource : '';
        }
        self.initUploader(self);
        self.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_2__.STATUSES.ready);
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.cache
], FileBrowser.prototype, "dataProvider", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.cache
], FileBrowser.prototype, "_dialog", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.cache
], FileBrowser.prototype, "storage", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.autobind
], FileBrowser.prototype, "status", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.autobind
], FileBrowser.prototype, "open", null);
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_5__.watch)('dataProvider:changePermissions')
], FileBrowser.prototype, "__updateToolbarButtons", null);
FileBrowser = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_4__.derive)(jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_9__.Dlgs)
], FileBrowser);
function isEqualButtonList(prevButtons, buttons) {
    if (prevButtons.length !== buttons.length) {
        return false;
    }
    for(let i = 0; i < prevButtons.length; i++){
        if (prevButtons[i] !== buttons[i]) {
            return false;
        }
    }
    return true;
}


/***/ }),

/***/ 63425:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileBrowserFiles: function() { return /* reexport safe */ _files_files__WEBPACK_IMPORTED_MODULE_0__.FileBrowserFiles; },
/* harmony export */   FileBrowserTree: function() { return /* reexport safe */ _tree_tree__WEBPACK_IMPORTED_MODULE_1__.FileBrowserTree; }
/* harmony export */ });
/* harmony import */ var _files_files__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(86122);
/* harmony import */ var _tree_tree__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55376);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module modules/file-browser
 */ 



/***/ }),

/***/ 63468:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UIGroup: function() { return /* binding */ UIGroup; }
/* harmony export */ });
/* harmony import */ var _swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25045);
/* harmony import */ var _swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80251);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84839);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(96007);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:core/ui/group/README.md]]
 * @packageDocumentation
 * @module ui/group
 */ 







class UIGroup extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_6__.UIElement {
    className() {
        return 'UIGroup';
    }
    /**
	 * All group children
	 */ get allChildren() {
        const result = [];
        const stack = [
            ...this.elements
        ];
        while(stack.length){
            const elm = stack.shift();
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isArray)(elm)) {
                stack.push(...elm);
            } else if (jodit_core_component_component__WEBPACK_IMPORTED_MODULE_2__.Component.isInstanceOf(elm, UIGroup)) {
                stack.push(...elm.elements);
            } else {
                elm && result.push(elm);
            }
        }
        return result;
    }
    /**
	 * Update all children
	 */ update() {
        this.elements.forEach((elm)=>elm.update());
        this.setMod('size', this.buttonSize);
    }
    append(elms, distElementOrIndex) {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isArray)(elms)) {
            if (typeof distElementOrIndex === 'number') {
                throw new Error('You can not use index when append array of elements');
            }
            elms.forEach((item)=>this.append(item, distElementOrIndex));
            return this;
        }
        const elm = elms;
        let index = undefined;
        if (typeof distElementOrIndex === 'number') {
            index = Math.min(Math.max(0, distElementOrIndex), this.elements.length);
            this.elements.splice(index, 0, elm);
        } else {
            this.elements.push(elm);
        }
        if (elm.name) {
            elm.container.classList.add(this.getFullElName(elm.name));
        }
        if (distElementOrIndex && typeof distElementOrIndex === 'string') {
            const distElm = this.getElm(distElementOrIndex);
            if (distElm == null) {
                throw new Error('Element does not exist');
            }
            distElm.appendChild(elm.container);
        } else {
            this.appendChildToContainer(elm.container, index);
        }
        elm.parentElement = this;
        return this;
    }
    /** @override */ afterSetMod(name, value) {
        if (this.syncMod) {
            this.elements.forEach((elm)=>elm.setMod(name, value));
        }
    }
    /**
	 * Allow set another container for the box of all children
	 */ appendChildToContainer(childContainer, index) {
        if (index === undefined || index < 0 || index > this.elements.length - 1 || this.container.children[index] == null) {
            this.container.appendChild(childContainer);
        } else {
            this.container.insertBefore(childContainer, this.container.children[index]);
        }
    }
    /**
	 * Remove element from group
	 */ remove(elm) {
        const index = this.elements.indexOf(elm);
        if (index !== -1) {
            this.elements.splice(index, 1);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_4__.Dom.safeRemove(elm.container);
            elm.parentElement = null;
        }
        return this;
    }
    /**
	 * Clear group
	 */ clear() {
        this.elements.forEach((elm)=>elm.destruct());
        this.elements.length = 0;
        return this;
    }
    /** @override */ destruct() {
        this.clear();
        return super.destruct();
    }
    /**
	 * @param elements - Items of group
	 */ constructor(jodit, elements, options){
        super(jodit, options), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "options", void 0), /**
	 * Synchronize mods to all children
	 */ (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "syncMod", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "elements", void 0), (0,_swc_helpers_define_property__WEBPACK_IMPORTED_MODULE_0__._)(this, "buttonSize", void 0), this.options = options, this.syncMod = false, this.elements = [], this.buttonSize = 'middle';
        elements === null || elements === void 0 ? void 0 : elements.forEach((elm)=>elm && this.append(elm));
        if (options === null || options === void 0 ? void 0 : options.name) {
            this.name = options.name;
        }
    }
}
(0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.watch)('buttonSize')
], UIGroup.prototype, "update", null);
UIGroup = (0,_swc_helpers_ts_decorate__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_3__.component
], UIGroup);


/***/ }),

/***/ 63837:
/***/ (function(module) {

module.exports["default"] = {"Type something":"Start writing...","pencil":"Edit","Quadrate":"Square"}

/***/ }),

/***/ 64094:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export justify */
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23211);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28077);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65946);
/* harmony import */ var jodit_core_helpers_utils_align__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16849);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(80991);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(5266);
/* harmony import */ var _justify_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80515);
/* harmony import */ var _justify_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_justify_svg__WEBPACK_IMPORTED_MODULE_7__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * [[include:plugins/justify/README.md]]
 * @packageDocumentation
 * @module plugins/justify
 */ 







jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_5__.Icon.set('justify', (_justify_svg__WEBPACK_IMPORTED_MODULE_7___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_6__.Config.prototype.controls.align = {
    name: 'left',
    tooltip: 'Align',
    update (editor, button) {
        const control = button.control, current = editor.s.current();
        if (current) {
            const currentBox = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(current, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock, editor.editor) || editor.editor;
            let currentValue = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_4__.css)(currentBox, 'text-align').toString();
            if (control.defaultValue && control.defaultValue.indexOf(currentValue) !== -1) {
                currentValue = 'left';
            }
            const { list, data } = control;
            if (data && data.currentValue !== currentValue && list && ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isPlainObject)(list) ? list[currentValue] : list.includes(currentValue))) {
                if (editor.o.textIcons || control.component === 'select') {
                    button.state.text = currentValue;
                } else {
                    button.state.icon.name = currentValue;
                }
                data.currentValue = currentValue;
            }
        }
    },
    isActive: (editor, btn)=>{
        const current = editor.s.current();
        if (!current || !btn.control.defaultValue) {
            return false;
        }
        const currentBox = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.closest(current, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock, editor.editor) || editor.editor;
        return btn.control.defaultValue.indexOf((0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_4__.css)(currentBox, 'text-align').toString()) === -1;
    },
    defaultValue: [
        'left',
        'start',
        'inherit'
    ],
    data: {
        currentValue: 'left'
    },
    list: [
        'center',
        'left',
        'right',
        'justify'
    ]
};
jodit_config__WEBPACK_IMPORTED_MODULE_6__.Config.prototype.controls.center = {
    command: 'justifyCenter',
    css: {
        'text-align': 'center'
    },
    tooltip: 'Align Center'
};
jodit_config__WEBPACK_IMPORTED_MODULE_6__.Config.prototype.controls.justify = {
    command: 'justifyFull',
    css: {
        'text-align': 'justify'
    },
    tooltip: 'Align Justify'
};
jodit_config__WEBPACK_IMPORTED_MODULE_6__.Config.prototype.controls.left = {
    command: 'justifyLeft',
    css: {
        'text-align': 'left'
    },
    tooltip: 'Align Left'
};
jodit_config__WEBPACK_IMPORTED_MODULE_6__.Config.prototype.controls.right = {
    command: 'justifyRight',
    css: {
        'text-align': 'right'
    },
    tooltip: 'Align Right'
};
/**
 * Process commands: `justifyfull`, `justifyleft`, `justifyright`, `justifycenter`
 */ function justify(editor) {
    editor.registerButton({
        name: 'align',
        group: 'indent'
    });
    const callback = (command)=>{
        editor.s.focus();
        editor.s.eachSelection((current)=>{
            if (!current) {
                return;
            }
            let currentBox = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.up(current, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.isBlock, editor.editor);
            if (!currentBox) {
                currentBox = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__.Dom.wrapInline(current, editor.o.enterBlock, editor);
            }
            (0,jodit_core_helpers_utils_align__WEBPACK_IMPORTED_MODULE_3__.alignElement)(command, currentBox);
        });
        return false;
    };
    editor.registerCommand('justifyfull', callback);
    editor.registerCommand('justifyright', callback);
    editor.registerCommand('justifyleft', callback);
    editor.registerCommand('justifycenter', callback);
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__.pluginSystem.add('justify', justify);


/***/ }),

/***/ 64637:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 432 432\"> <g> <polygon points=\"203.688,96 0,96 0,144 155.688,144 \"/> <polygon points=\"155.719,288 0,288 0,336 203.719,336 \"/> <path d=\"M97.844,230.125c-3.701-3.703-5.856-8.906-5.856-14.141s2.154-10.438,5.856-14.141l9.844-9.844H0v48h107.719 L97.844,230.125z\"/> <polygon points=\"232,176 232,96 112,216 232,336 232,256 432,256 432,176\"/> </g> </svg>"

/***/ }),

/***/ 64831:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M576 576q0 80-56 136t-136 56-136-56-56-136 56-136 136-56 136 56 56 136zm1024 384v448h-1408v-192l320-320 160 160 512-512zm96-704h-1600q-13 0-22.5 9.5t-9.5 22.5v1216q0 13 9.5 22.5t22.5 9.5h1600q13 0 22.5-9.5t9.5-22.5v-1216q0-13-9.5-22.5t-22.5-9.5zm160 32v1216q0 66-47 113t-113 47h-1600q-66 0-113-47t-47-113v-1216q0-66 47-113t113-47h1600q66 0 113 47t47 113z\"/> </svg>"

/***/ }),

/***/ 64847:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UIGroup: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_0__.UIGroup; },
/* harmony export */   UIList: function() { return /* reexport safe */ _list__WEBPACK_IMPORTED_MODULE_1__.UIList; },
/* harmony export */   UISeparator: function() { return /* reexport safe */ _separator__WEBPACK_IMPORTED_MODULE_2__.UISeparator; },
/* harmony export */   UISpacer: function() { return /* reexport safe */ _spacer__WEBPACK_IMPORTED_MODULE_3__.UISpacer; }
/* harmony export */ });
/* harmony import */ var _group__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(63468);
/* harmony import */ var _list__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97959);
/* harmony import */ var _separator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(35676);
/* harmony import */ var _spacer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27987);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */ /**
 * @module ui/group
 */ 





/***/ }),

/***/ 65015:
/***/ (function(__unused_webpack_module, __webpack_e